/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.List;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.MobyProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.MobyGamesUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowseMobyGamesDialog
extends Dialog {
    private String title;
    private List<MobyProfile> profs = null;
    private Object result;
    private Shell shell;
    private Settings settings = Settings.getInstance();

    public BrowseMobyGamesDialog(Shell parent, int style) {
        super(parent, style);
    }

    public BrowseMobyGamesDialog(Shell parent) {
        this(parent, 0);
    }

    public void setProfilesToBrowse(String title, List<MobyProfile> profs) {
        this.title = title;
        this.profs = profs;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "mobygamesbrowser"));
        this.shell.setText(this.settings.msg("dialog.mobygamesbrowser.title"));
        final Table table = new Table((Composite)this.shell, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        String[] titles = new String[]{this.settings.msg("dialog.profile.title"), this.settings.msg("dialog.profile.year"), this.settings.msg("dialog.mobygamesbrowser.column.platform")};
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
        }
        for (MobyProfile p : this.profs) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, p.getTitle());
            item.setText(1, p.getYear());
            item.setText(2, p.getPlatform());
        }
        for (int i = 0; i < titles.length; ++i) {
            table.getColumn(i).pack();
        }
        int firstMatch = MobyGamesUtils.getEntryFirstMatchIndex(this.title, this.profs);
        table.setSelection(firstMatch == -1 ? 0 : firstMatch);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                BrowseMobyGamesDialog.this.result = table.getSelectionIndex();
                BrowseMobyGamesDialog.this.shell.close();
            }
        });
        Button okButton = new Button((Composite)this.shell, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseMobyGamesDialog.this.result = table.getSelectionIndex();
                BrowseMobyGamesDialog.this.shell.close();
            }
        });
        okButton.setLayoutData((Object)new GridData(80, -1));
        this.shell.setDefaultButton(okButton);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button((Composite)this.shell, 0);
        cancelButton.setLayoutData((Object)new GridData(80, -1));
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseMobyGamesDialog.this.result = null;
                BrowseMobyGamesDialog.this.shell.close();
            }
        });
    }
}

