/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteProfilesDialog
extends Dialog {
    private List<Profile> profs;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;

    public DeleteProfilesDialog(Shell parent) {
        super(parent, 0);
    }

    public void setProfilesToBeDeletes(List<Profile> profs) {
        this.profs = profs;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "profiledeletedialog"));
        this.shell.setText(this.settings.msg("dialog.deleteprofiles.title", new Object[]{this.profs.size()}));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem infoTabItem = new TabItem(tabFolder, 0);
        infoTabItem.setText(this.settings.msg("dialog.deleteprofiles.options"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        infoTabItem.setControl((Control)composite);
        Label deleteRecordLabel = new Label(composite, 0);
        deleteRecordLabel.setText(this.settings.msg("dialog.deleteprofiles.confirm.removedatabaseentry"));
        Button deleteRecord = new Button(composite, 32);
        deleteRecord.setSelection(true);
        deleteRecord.setEnabled(false);
        Label deleteConfsLabel = new Label(composite, 0);
        deleteConfsLabel.setText(this.settings.msg("dialog.deleteprofiles.confirm.removeprofileconf"));
        final Button deleteConfs = new Button(composite, 32);
        deleteConfs.setSelection(true);
        Label deleteCapturesLabel = new Label(composite, 0);
        deleteCapturesLabel.setText(this.settings.msg("dialog.deleteprofiles.confirm.removeprofilecaptures"));
        final Button deleteCaptures = new Button(composite, 32);
        deleteCaptures.setSelection(true);
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new GridLayout(2, true));
        composite_7.setLayoutData((Object)"South");
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        okButton.setLayoutData((Object)gridData);
        okButton.setText(this.settings.msg("button.ok"));
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (GeneralPurposeDialogs.confirmMessage(DeleteProfilesDialog.this.shell, DeleteProfilesDialog.this.settings.msg("dialog.deleteprofiles.confirm.removal", new Object[]{DeleteProfilesDialog.this.profs.size()}))) {
                    for (Profile prof : DeleteProfilesDialog.this.profs) {
                        try {
                            DeleteProfilesDialog.this.dbase.removeProfile(prof.getId());
                            if (deleteConfs.getSelection()) {
                                FileUtils.removeFile(prof.getCanonicalConfFile());
                            }
                            if (!deleteCaptures.getSelection()) continue;
                            FileUtils.removeFilesInDirAndDir(prof.getCanonicalCaptures());
                        }
                        catch (SQLException e) {
                            GeneralPurposeDialogs.warningMessage(DeleteProfilesDialog.this.shell, e.getMessage());
                        }
                    }
                    DeleteProfilesDialog.this.result = DeleteProfilesDialog.this.profs;
                }
                DeleteProfilesDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        cancelButton.setLayoutData((Object)gridData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DeleteProfilesDialog.this.result = null;
                DeleteProfilesDialog.this.shell.close();
            }
        });
    }
}

