/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.Wizard;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.util.ExportThread;
import org.dbgl.util.FileUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDialog
extends Wizard {
    private Text logText;
    private Button settingsOnly;
    private Button fullGames;
    private Button exportCapturesButton;
    private Table profilesTable;
    private Text title;
    private Text notes;
    private Text author;
    private Text filename;
    private Button start;
    private Label profileLabel;
    private List<DosboxVersion> dbversionsList;
    private List<ExpProfile> expProfileList;
    private ExportThread exportThread;

    public ExportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ExportDialog(Shell parent, List<DosboxVersion> dbList, List<ExpProfile> expProfiles) {
        this(parent, 0);
        this.dbversionsList = dbList;
        this.expProfileList = expProfiles;
    }

    public Object open() {
        this.createContents(this.settings.msg("dialog.export.title", new Object[]{this.expProfileList.size()}), "export");
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.exportThread != null && !this.exportThread.isAlive() && !this.finish.getEnabled()) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.export.notice.exportok"));
                this.profileLabel.setText(this.settings.msg("dialog.export.reviewlog"));
                this.profileLabel.pack();
                this.cancel.setEnabled(false);
                this.finish.setEnabled(true);
                this.shell.setDefaultButton(this.finish);
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.exportThread;
    }

    private Control page1() {
        Group group1 = new Group((Composite)this.shell, 0);
        group1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group1.setText(this.settings.msg("dialog.export.step1"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group1.setLayout((Layout)gridLayout);
        Label settingsOnlyLabel = new Label((Composite)group1, 0);
        settingsOnlyLabel.setText(this.settings.msg("dialog.export.export"));
        this.settingsOnly = new Button((Composite)group1, 16);
        this.settingsOnly.setText(this.settings.msg("dialog.export.export.profiles"));
        this.settingsOnly.setSelection(true);
        new Label((Composite)group1, 0);
        this.fullGames = new Button((Composite)group1, 16);
        this.fullGames.setText(this.settings.msg("dialog.export.export.games"));
        new Label((Composite)group1, 0);
        this.exportCapturesButton = new Button((Composite)group1, 32);
        this.exportCapturesButton.setText(this.settings.msg("dialog.template.captures"));
        this.exportCapturesButton.setSelection(true);
        return group1;
    }

    private Control page2() {
        Group reviewDirsGroup = new Group((Composite)this.shell, 0);
        reviewDirsGroup.setText(this.settings.msg("dialog.export.step2"));
        reviewDirsGroup.setLayout((Layout)new GridLayout());
        this.profilesTable = new Table((Composite)reviewDirsGroup, 67584);
        this.profilesTable.setHeaderVisible(true);
        GridData gridData_1 = new GridData(4, 4, true, true, 1, 2);
        gridData_1.heightHint = 80;
        this.profilesTable.setLayoutData((Object)gridData_1);
        this.profilesTable.setLinesVisible(true);
        TableColumn titleColumn = new TableColumn(this.profilesTable, 0);
        titleColumn.setWidth(260);
        titleColumn.setText(this.settings.msg("dialog.main.profiles.column.title"));
        TableColumn subdirColumn = new TableColumn(this.profilesTable, 0);
        subdirColumn.setWidth(120);
        subdirColumn.setText(this.settings.msg("dialog.export.column.gamedir"));
        for (ExpProfile expProfile : this.expProfileList) {
            TableItem item = new TableItem(this.profilesTable, 0);
            item.setText(expProfile.getTitle());
            item.setText(1, expProfile.getGameDir().getPath());
        }
        this.profilesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                int idx = ExportDialog.this.profilesTable.getSelectionIndex();
                ExpProfile prof = (ExpProfile)ExportDialog.this.expProfileList.get(idx);
                DirectoryDialog dialog = new DirectoryDialog(ExportDialog.this.shell);
                dialog.setFilterPath(FileUtils.canonicalToDosroot(prof.getGameDir().getPath()).getPath());
                String result = dialog.open();
                if (result != null) {
                    File newGameDir = FileUtils.makeRelativeToDosroot(new File(result));
                    prof.setGameDir(newGameDir);
                    ExportDialog.this.profilesTable.getSelection()[0].setText(1, newGameDir.getPath());
                }
            }
        });
        return reviewDirsGroup;
    }

    private Control page3() {
        Group settingsGroup = new Group((Composite)this.shell, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        settingsGroup.setLayout((Layout)gridLayout2);
        settingsGroup.setText(this.settings.msg("dialog.export.step3"));
        settingsGroup.setLayoutData((Object)"North");
        Label titleLabel = new Label((Composite)settingsGroup, 0);
        titleLabel.setText(this.settings.msg("dialog.export.exporttitle"));
        this.title = new Text((Composite)settingsGroup, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label authorLabel = new Label((Composite)settingsGroup, 0);
        authorLabel.setText(this.settings.msg("dialog.export.author"));
        this.author = new Text((Composite)settingsGroup, 2048);
        this.author.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label notesLabel = new Label((Composite)settingsGroup, 0);
        notesLabel.setText(this.settings.msg("dialog.export.notes"));
        this.notes = new Text((Composite)settingsGroup, 2882);
        GridData gridData = new GridData(4, 4, true, true, 2, 2);
        gridData.heightHint = 40;
        this.notes.setLayoutData((Object)gridData);
        new Label((Composite)settingsGroup, 0);
        Label fileLabel = new Label((Composite)settingsGroup, 0);
        fileLabel.setText(this.settings.msg("dialog.export.file"));
        this.filename = new Text((Composite)settingsGroup, 2048);
        this.filename.setText(FileUtils.EXPORT_DIR + "games.dbgl.zip");
        this.filename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton((Composite)settingsGroup, 0);
        browseButton.connect(this.shell, this.filename, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DBGLZIP, true, null);
        return settingsGroup;
    }

    private Control page4() {
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setText(this.settings.msg("dialog.export.step4"));
        progressGroup.setLayout((Layout)new GridLayout());
        this.start = new Button((Composite)progressGroup, 0);
        this.shell.setDefaultButton(this.start);
        this.start.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.start.setText(this.settings.msg("dialog.export.start"));
        final ProgressBar progressBar = new ProgressBar((Composite)progressGroup, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.logText = new Text((Composite)progressGroup, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.start.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ExportDialog.this.back.setEnabled(false);
                    ExportDialog.this.start.setEnabled(false);
                    Document doc = XmlUtils.getFullProfilesXML(ExportDialog.this.expProfileList, ExportDialog.this.dbversionsList, ExportDialog.this.title.getText(), ExportDialog.this.notes.getText(), ExportDialog.this.author.getText(), ExportDialog.this.exportCapturesButton.getSelection(), ExportDialog.this.fullGames.getSelection());
                    ExportDialog.this.exportThread = new ExportThread(ExportDialog.this.expProfileList, doc, ExportDialog.this.exportCapturesButton.getSelection(), ExportDialog.this.fullGames.getSelection(), FileUtils.canonicalToData(ExportDialog.this.filename.getText()), ExportDialog.this.logText, progressBar, ExportDialog.this.profileLabel);
                    ExportDialog.this.exportThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(ExportDialog.this.shell, ex.getMessage());
                    ExportDialog.this.exportThread = null;
                }
                catch (ParserConfigurationException ep) {
                    GeneralPurposeDialogs.warningMessage(ExportDialog.this.shell, ep.getMessage());
                }
            }
        });
        return progressGroup;
    }

    @Override
    protected void fillPages() {
        this.addStep(this.page1());
        this.addStep(this.page2());
        this.addStep(this.page3());
        this.addStep(this.page4());
    }

    @Override
    protected int stepSize(boolean up) {
        return (this.stepNr == 0 && up || this.stepNr == 2 && !up) && this.settingsOnly.getSelection() ? 2 : 1;
    }

    @Override
    protected boolean isValid() {
        return !(this.stepNr == 1 ? !this.isValidGameDirs() : this.stepNr == 2 && !this.isValidTargetZip());
    }

    private boolean isValidTargetZip() {
        String f;
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.required.title"), (Control)this.title);
        }
        if ((f = this.filename.getText()).equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.required.filename"), (Control)this.filename);
        } else if (FileUtils.isExistingFile(FileUtils.canonicalToData(f))) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.fileexists", new Object[]{FileUtils.canonicalToData(f)}), (Control)this.filename);
        } else {
            File dir = FileUtils.canonicalToData(f).getParentFile();
            if (dir == null || !dir.exists()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.exportdirmissing", new Object[]{FileUtils.canonicalToData(f)}), (Control)this.filename);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean isValidGameDirs() {
        GeneralPurposeDialogs.initErrorDialog();
        for (ExpProfile prof : this.expProfileList) {
            if (!FileUtils.canonicalToDosroot(prof.getGameDir().getPath()).exists()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.gamedirmissing", new Object[]{prof.getGameDir()}), (Control)this.profilesTable);
            }
            if (prof.getGameDir().isAbsolute()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.gamedirnotrelative", new Object[]{prof.getGameDir()}), (Control)this.profilesTable);
            }
            for (ExpProfile prof2 : this.expProfileList) {
                if (prof == prof2 || !FileUtils.areRelated(prof.getGameDir(), prof2.getGameDir())) continue;
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.gamedirsconflict", new Object[]{prof.getGameDir(), prof.getTitle(), prof2.getGameDir(), prof2.getTitle()}), (Control)this.profilesTable);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

