/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.model.Mount;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public final class GrabButton {
    private final Button button;

    public GrabButton(Composite composite, int style) {
        Settings settings = Settings.getInstance();
        this.button = GeneralPurposeGUI.createIconButton(composite, style, settings, settings.msg("button.grab"), "grab.png");
    }

    public void connect(final Text text, final List source) {
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = source.getSelectionIndex();
                if (index != -1) {
                    try {
                        text.setText(new Mount(source.getItem(index)).getPathAsString() + File.separatorChar);
                        text.selectAll();
                        text.setFocus();
                    }
                    catch (InvalidMountstringException invalidMountstringException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }
}

