/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MixerCommand {
    public static String[] CHANNELS = new String[]{"master", "spkr", "sb", "gus", "fm", "disney", "cdaudio"};
    public static int DEFAULT_VOLUME_LEVEL = 100;
    public static int MAX_VOLUME_LEVEL = 200;
    private List<VolumeSetting> volumes;

    public MixerCommand(String command) {
        this.init();
        String[] elements = StringUtils.split((String)command, (char)' ');
        for (int i = 0; i < elements.length; i += 2) {
            for (VolumeSetting vol : this.volumes) {
                if (!elements[i].equalsIgnoreCase(vol.name) || i + 1 >= elements.length) continue;
                vol.setVolume(elements[i + 1]);
            }
        }
    }

    private void init() {
        this.volumes = new ArrayList<VolumeSetting>();
        for (String channel : CHANNELS) {
            this.volumes.add(new VolumeSetting(channel));
        }
    }

    public VolumeSetting getVolumeFor(String channel) {
        for (VolumeSetting vol : this.volumes) {
            if (!channel.equalsIgnoreCase(vol.name)) continue;
            return vol;
        }
        return null;
    }

    public void setVolumeFor(String channel, int left, int right) {
        for (VolumeSetting vol : this.volumes) {
            if (!channel.equalsIgnoreCase(vol.name)) continue;
            vol.setVolume(left, right);
        }
    }

    public String toString() {
        return StringUtils.join(this.volumes, (char)' ').trim().replaceAll("\\s+", " ");
    }

    public class VolumeSetting {
        private String name;
        private int left;
        private int right;

        public VolumeSetting(String name) {
            this.name = name;
            this.left = DEFAULT_VOLUME_LEVEL;
            this.right = DEFAULT_VOLUME_LEVEL;
        }

        public void setVolume(String command) {
            String[] vols = StringUtils.split((String)command, (char)':');
            int left = DEFAULT_VOLUME_LEVEL;
            int right = DEFAULT_VOLUME_LEVEL;
            try {
                left = Integer.parseInt(vols[0]);
                right = Integer.parseInt(vols[1]);
                this.setVolume(left, right);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }

        private void setVolume(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public String toString() {
            return this.left != DEFAULT_VOLUME_LEVEL || this.right != DEFAULT_VOLUME_LEVEL ? new StringBuffer(this.name).append(' ').append(this.left).append(':').append(this.right).toString() : "";
        }
    }
}

