/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.IOException;
import java.util.ArrayList;
import org.dbgl.model.MobyImageInformation;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.MobyGamesUtils;
import org.eclipse.swt.graphics.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyProfile
implements Comparable<MobyProfile> {
    private String title;
    private String platform;
    private String year;
    private String url;
    private String developerName;
    private String publisherName;
    private String genre;
    private String notes;
    private int rank;
    private String coreGameCoverUrl;
    private MobyImageInformation[] mobygamesImages;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getScreenshotsUrl() {
        return this.url + "/screenshots";
    }

    public String getCoverArtUrl() {
        return this.url + "/cover-art";
    }

    public MobyImageInformation[] getImageDescriptions(int coverArtMax, int screenshotsMax) throws IOException {
        ArrayList<MobyImageInformation> result = new ArrayList<MobyImageInformation>();
        if (coverArtMax > 0) {
            result.addAll(MobyGamesUtils.getEntryCoverArtInformation(this, coverArtMax));
        }
        if (screenshotsMax > 0) {
            result.addAll(MobyGamesUtils.getEntryScreenshotInformation(this, screenshotsMax));
        }
        this.mobygamesImages = result.toArray(new MobyImageInformation[0]);
        return this.mobygamesImages;
    }

    public String getCoreGameCoverUrl() {
        return this.coreGameCoverUrl;
    }

    public void setCoreGameCoverUrl(String coreGameCoverUrl) {
        this.coreGameCoverUrl = coreGameCoverUrl;
    }

    public ImageData getMobygamesImage(int i) throws IOException {
        this.mobygamesImages[i].data = SWTImageManager.getImageData(this.mobygamesImages[i].url);
        return this.mobygamesImages[i].data;
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public void setPublisherName(String publisherName) {
        this.publisherName = publisherName;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public int compareTo(MobyProfile otherProfile) {
        if (otherProfile.platform.equalsIgnoreCase(this.platform)) {
            return this.title.compareToIgnoreCase(otherProfile.title);
        }
        return this.platform.compareToIgnoreCase(otherProfile.platform);
    }
}

