/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.dbgl.model.conf.Section;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionsWrapper {
    private Map<String, Section> sections = new LinkedHashMap<String, Section>();

    SectionsWrapper() {
    }

    public SectionsWrapper(SectionsWrapper sec) {
        this();
        for (String key : sec.sections.keySet()) {
            this.sections.put(key, new Section(sec.sections.get(key)));
        }
    }

    public SectionsWrapper(SectionsWrapper base, SectionsWrapper ext) {
        this();
        for (String sectionName : ext.sections.keySet()) {
            for (String itemName : ext.sections.get((Object)sectionName).items.keySet()) {
                if (base != null && base.hasValue(sectionName, itemName) && base.getValue(sectionName, itemName).equals(ext.getValue(sectionName, itemName))) continue;
                this.setValue(sectionName, itemName, ext.getValue(sectionName, itemName));
            }
        }
    }

    public static SectionsWrapper createCombination(SectionsWrapper s1, SectionsWrapper s2) {
        SectionsWrapper result = new SectionsWrapper();
        for (String sectionName : s1.sections.keySet()) {
            for (String sectionItem : s1.sections.get((Object)sectionName).items.keySet()) {
                String val1 = s1.getValue(sectionName, sectionItem);
                if (!s2.hasValue(sectionName, sectionItem)) continue;
                String val2 = s2.getValue(sectionName, sectionItem);
                if (val1.equals(val2)) {
                    result.setValue(sectionName, sectionItem, val1);
                    continue;
                }
                result.setValue(sectionName, sectionItem, "CONFLICTING_SETTING");
            }
        }
        return result;
    }

    public Set<String> getAllSectionNames() {
        return this.sections.keySet();
    }

    public String[] getAllItemNames(String sectionTitle) {
        return new TreeMap<String, String>(this.sections.get((Object)sectionTitle).items).keySet().toArray(new String[0]);
    }

    public boolean hasValue(String sectionTitle, String sectionItem) {
        return this.sections.containsKey(sectionTitle) && this.sections.get((Object)sectionTitle).items.containsKey(sectionItem);
    }

    public String getValue(String sectionTitle, String sectionItem) {
        String result = null;
        if (this.sections.containsKey(sectionTitle)) {
            result = this.sections.get((Object)sectionTitle).items.get(sectionItem);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean isConflictingValue(String sectionTitle, String sectionItem) {
        return this.hasValue(sectionTitle, sectionItem) && this.getValue(sectionTitle, sectionItem).equals("CONFLICTING_SETTING");
    }

    public String[] getValues(String sectionTitle, String sectionItem) {
        String val = this.getValue(sectionTitle, sectionItem);
        if (val.length() <= 0) {
            return new String[0];
        }
        String[] res = val.split(" ");
        for (int i = 0; i < res.length; ++i) {
            res[i] = res[i].replaceAll("<space>", " ");
        }
        return res;
    }

    public String[] getCommonValues(String sectionTitle, String item1, String item2) {
        ArrayList<String> resultList = new ArrayList<String>();
        String[] a1 = this.getValues(sectionTitle, item1);
        Object[] a2 = this.getValues(sectionTitle, item2);
        for (String s : a1) {
            if (!ArrayUtils.contains((Object[])a2, (Object)s)) continue;
            resultList.add(s);
        }
        return resultList.toArray(new String[0]);
    }

    public String getMultilineValues(String sectionTitle, String sectionItem, String delimiter) {
        return StringUtils.stringArrayToString(this.getValues(sectionTitle, sectionItem), delimiter);
    }

    public int getIntValue(String sectionTitle, String sectionItem) {
        try {
            return Integer.parseInt(this.getValue(sectionTitle, sectionItem));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int[] getIntValues(String sectionTitle, String sectionItem) {
        return StringUtils.stringToIntArray(this.getValue(sectionTitle, sectionItem));
    }

    public boolean getBooleanValue(String sectionTitle, String sectionItem) {
        return Boolean.valueOf(this.getValue(sectionTitle, sectionItem));
    }

    public boolean[] getBooleanValues(String sectionTitle, String sectionItem) {
        return StringUtils.stringToBooleanArray(this.getValue(sectionTitle, sectionItem));
    }

    public void setValue(String sectionTitle, String sectionItem, String value) {
        Section sec = this.createSection(sectionTitle);
        sec.items.put(sectionItem, value);
    }

    public void setMultilineValues(String sectionTitle, String sectionItem, String values, String delimiter) {
        this.setValue(sectionTitle, sectionItem, values.replaceAll(" ", "<space>").replace(delimiter, " ").trim());
    }

    public void setIntValue(String sectionTitle, String sectionItem, int value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setIntValues(String sectionTitle, String sectionItem, int[] values) {
        this.setValue(sectionTitle, sectionItem, StringUtils.intArrayToString(values));
    }

    public void setBooleanValue(String sectionTitle, String sectionItem, boolean value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setBooleanValues(String sectionTitle, String sectionItem, boolean[] values) {
        this.setValue(sectionTitle, sectionItem, StringUtils.booleanArrayToString(values));
    }

    public void updateValue(String sectionTitle, String sectionItem, String value) {
        if (this.hasValue(sectionTitle, sectionItem)) {
            this.sections.get((Object)sectionTitle).items.put(sectionItem, value);
        }
    }

    public void setMissingValue(String sectionTitle, String sectionItem, String value) {
        if (!this.hasValue(sectionTitle, sectionItem)) {
            this.setValue(sectionTitle, sectionItem, value);
        }
    }

    public void removeSection(String sectionTitle) {
        this.sections.remove(sectionTitle);
    }

    public void removeValue(String sectionTitle, String sectionItem) {
        if (this.sections.containsKey(sectionTitle)) {
            Section sec = this.sections.get(sectionTitle);
            sec.items.remove(sectionItem);
            if (sec.items.isEmpty()) {
                this.sections.remove(sectionTitle);
            }
        }
    }

    public void injectValuesFrom(SectionsWrapper sec) {
        for (String sectionTitle : sec.sections.keySet()) {
            for (String sectionItem : sec.sections.get((Object)sectionTitle).items.keySet()) {
                this.setValue(sectionTitle, sectionItem, sec.getValue(sectionTitle, sectionItem));
            }
        }
    }

    public void addMissingValuesFrom(SectionsWrapper sec) {
        for (String sectionTitle : sec.sections.keySet()) {
            for (String sectionItem : sec.sections.get((Object)sectionTitle).items.keySet()) {
                this.setMissingValue(sectionTitle, sectionItem, sec.getValue(sectionTitle, sectionItem));
            }
        }
    }

    public void removeValuesThatAreNotIn(SectionsWrapper sec) {
        SectionsWrapper copy = new SectionsWrapper(this);
        for (String sectionTitle : copy.sections.keySet()) {
            for (String sectionItem : copy.sections.get((Object)sectionTitle).items.keySet()) {
                if (sec.hasValue(sectionTitle, sectionItem)) continue;
                this.removeValue(sectionTitle, sectionItem);
            }
        }
    }

    public int detectDosboxVersionGeneration() {
        if (this.hasValue("cpu", "cputype") && this.hasValue("midi", "mididevice") && this.hasValue("midi", "midiconfig") && this.hasValue("sblaster", "sbmixer") && this.hasValue("sblaster", "oplemu") && this.hasValue("gus", "gusirq") && this.hasValue("gus", "gusdma")) {
            return 3;
        }
        if (this.hasValue("joystick", "joysticktype") && this.hasValue("joystick", "timed") && this.hasValue("joystick", "autofire") && this.hasValue("joystick", "swap34") && this.hasValue("joystick", "buttonwrap") && this.hasValue("dos", "keyboardlayout")) {
            return 2;
        }
        if (this.hasValue("sdl", "windowresolution") && this.hasValue("sdl", "usescancodes") && this.hasValue("sblaster", "sbtype") && this.hasValue("sblaster", "sbbase") && this.hasValue("gus", "gusrate") && this.hasValue("gus", "gusbase") && this.hasValue("speaker", "tandy") && this.hasValue("bios", "joysticktype") && this.hasValue("serial", "serial1") && this.hasValue("dos", "umb")) {
            return 1;
        }
        return 0;
    }

    public void alterToDosboxVersionGeneration(SectionsWrapper dosboxSections) {
        int srcGeneration = this.detectDosboxVersionGeneration();
        int dstGeneration = dosboxSections.detectDosboxVersionGeneration();
        this.alterToDosboxVersionGeneration(dosboxSections, srcGeneration, dstGeneration);
    }

    public void switchToDosboxVersionGeneration(SectionsWrapper orgDosboxSections, SectionsWrapper targetDosboxSections) {
        int srcGeneration = this.detectDosboxVersionGeneration();
        int dstGeneration = targetDosboxSections.detectDosboxVersionGeneration();
        SectionsWrapper substracted = new SectionsWrapper(orgDosboxSections, this);
        this.sections = substracted.sections;
        this.alterToDosboxVersionGeneration(targetDosboxSections, srcGeneration, dstGeneration);
    }

    public void alterToDosboxVersionGeneration(SectionsWrapper dosboxSections, int srcGeneration, int dstGeneration) {
        int i;
        if (srcGeneration > dstGeneration) {
            for (i = 0; i < srcGeneration - dstGeneration; ++i) {
                this.downgradeOneGeneration(srcGeneration - i);
            }
        }
        if (srcGeneration < dstGeneration) {
            for (i = 0; i < dstGeneration - srcGeneration; ++i) {
                this.upgradeOneGeneration(srcGeneration + i);
            }
        }
        this.addMissingValuesFrom(dosboxSections);
        this.removeValuesThatAreNotIn(dosboxSections);
    }

    public String toString(boolean ordered) {
        StringBuffer result = new StringBuffer();
        for (String key : this.sections.keySet()) {
            result.append("[" + key + "]" + PlatformUtils.EOLN);
            result.append(this.sections.get(key).toString(ordered)).append(PlatformUtils.EOLN);
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    private Section createSection(String sectionTitle) {
        if (this.sections.containsKey(sectionTitle)) {
            return this.sections.get(sectionTitle);
        }
        Section newSection = new Section();
        this.sections.put(sectionTitle, newSection);
        return newSection;
    }

    private void upgradeOneGeneration(int baseGeneration) {
        switch (baseGeneration) {
            case 0: {
                boolean intelli;
                boolean mpu = !this.hasValue("midi", "mpu401") || this.getBooleanValue("midi", "mpu401");
                boolean bl = intelli = !this.hasValue("midi", "intelligent") || this.getBooleanValue("midi", "intelligent");
                this.setValue("midi", "mpu401", mpu ? (intelli ? "intelligent" : "uart") : "none");
                this.removeValue("midi", "intelligent");
                this.switchSetting("sblaster", "type", "sblaster", "sbtype");
                this.switchSetting("sblaster", "base", "sblaster", "sbbase");
                this.switchSetting("gus", "rate", "gus", "gusrate");
                this.switchSetting("gus", "base", "gus", "gusbase");
                break;
            }
            case 1: {
                this.switchSetting("bios", "joysticktype", "joystick", "joysticktype");
                break;
            }
            case 2: {
                this.switchSetting("gus", "irq1", "gus", "gusirq");
                this.removeValue("gus", "irq2");
                this.switchSetting("gus", "dma1", "gus", "gusdma");
                this.removeValue("gus", "dma2");
                if (this.getValue("dosbox", "machine").equalsIgnoreCase("vga")) {
                    this.removeValue("dosbox", "machine");
                }
                if (this.getValue("dos", "keyboardlayout").equalsIgnoreCase("none")) {
                    this.removeValue("dos", "keyboardlayout");
                }
                this.switchSetting("midi", "device", "midi", "mididevice");
                this.switchSetting("midi", "config", "midi", "midiconfig");
                this.switchSetting("sblaster", "mixer", "sblaster", "sbmixer");
                break;
            }
        }
    }

    private void downgradeOneGeneration(int baseGeneration) {
        switch (baseGeneration) {
            case 3: {
                String mach;
                this.switchSetting("gus", "gusirq", "gus", "irq1");
                if (this.hasValue("gus", "irq1")) {
                    this.setValue("gus", "irq2", this.getValue("gus", "irq1"));
                }
                this.switchSetting("gus", "gusdma", "gus", "dma1");
                if (this.hasValue("gus", "dma1")) {
                    this.setValue("gus", "dma2", this.getValue("gus", "dma1"));
                }
                if (!((mach = this.getValue("dosbox", "machine")).equalsIgnoreCase("cga") || mach.equalsIgnoreCase("hercules") || mach.equalsIgnoreCase("pcjr") || mach.equalsIgnoreCase("tandy"))) {
                    this.removeValue("dosbox", "machine");
                }
                if (this.getValue("dos", "keyboardlayout").equalsIgnoreCase("auto")) {
                    this.removeValue("dos", "keyboardlayout");
                }
                this.switchSetting("midi", "mididevice", "midi", "device");
                this.switchSetting("midi", "midiconfig", "midi", "config");
                this.switchSetting("sblaster", "sbmixer", "sblaster", "mixer");
                break;
            }
            case 2: {
                this.switchSetting("joystick", "joysticktype", "bios", "joysticktype");
                break;
            }
            case 1: {
                if (this.hasValue("midi", "mpu401")) {
                    String mpu = this.getValue("midi", "mpu401");
                    this.setBooleanValue("midi", "mpu401", !mpu.equalsIgnoreCase("none"));
                    this.setBooleanValue("midi", "intelligent", mpu.equalsIgnoreCase("intelligent"));
                }
                this.switchSetting("sblaster", "sbtype", "sblaster", "type");
                this.switchSetting("sblaster", "sbbase", "sblaster", "base");
                this.switchSetting("gus", "gusrate", "gus", "rate");
                this.switchSetting("gus", "gusbase", "gus", "base");
                break;
            }
        }
    }

    private void switchSetting(String oldSection, String oldItem, String newSection, String newItem) {
        if (this.hasValue(oldSection, oldItem)) {
            this.setValue(newSection, newItem, this.getValue(oldSection, oldItem));
        }
        this.removeValue(oldSection, oldItem);
    }
}

