/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.MobyImageInformation;
import org.dbgl.model.MobyProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.MobyGamesUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MobyGamesThread
extends Thread {
    private List<Configurable> profiles;
    private String title;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private final Display display;
    private final String lineDelimiter;

    public MobyGamesThread(List<Configurable> profs, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.profiles = profs;
        this.log = log;
        this.lineDelimiter = log.getLineDelimiter();
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database dbase = Database.getInstance();
        Settings settings = Settings.getInstance();
        final StringBuffer displayedLog = new StringBuffer();
        final StringBuffer messageLog = new StringBuffer();
        while (true) {
            block21: {
                try {
                    ExpProfile prof;
                    List<Configurable> list = this.profiles;
                    synchronized (list) {
                        prof = (ExpProfile)this.profiles.remove(0);
                    }
                    this.title = prof.getTitle();
                    try {
                        int firstMatch;
                        List<MobyProfile> mobyGamesList = MobyGamesUtils.getEntries(this.title, settings.getSettings().getValues("mobygames", "platform_filter"));
                        if (mobyGamesList.size() > 1 && (firstMatch = MobyGamesUtils.getEntryFirstMatchIndex(this.title, mobyGamesList)) != -1) {
                            mobyGamesList = mobyGamesList.subList(firstMatch, firstMatch + 1);
                        }
                        if (mobyGamesList.size() == 1) {
                            MobyProfile thisGame = MobyGamesUtils.getEntry(mobyGamesList.get(0));
                            MobyGamesThread mobyGamesThread = this;
                            synchronized (mobyGamesThread) {
                                String title = settings.getSettings().getBooleanValue("mobygames", "set_title") ? thisGame.getTitle() : prof.getTitle();
                                String dev = settings.getSettings().getBooleanValue("mobygames", "set_developer") ? thisGame.getDeveloperName() : prof.getDeveloperName();
                                String publ = settings.getSettings().getBooleanValue("mobygames", "set_publisher") ? thisGame.getPublisherName() : prof.getPublisherName();
                                String year = settings.getSettings().getBooleanValue("mobygames", "set_year") ? thisGame.getYear() : prof.getYear();
                                String genre = settings.getSettings().getBooleanValue("mobygames", "set_genre") ? thisGame.getGenre() : prof.getGenre();
                                String link1 = settings.getSettings().getBooleanValue("mobygames", "set_link") ? thisGame.getUrl() : prof.getLink(0);
                                String[] links = new String[]{link1, prof.getLink(1), prof.getLink(2), prof.getLink(3)};
                                String linkTitle1 = settings.getSettings().getBooleanValue("mobygames", "set_link") ? settings.msg("dialog.profile.mobygames.link.maininfo") : prof.getLinkTitle(0);
                                String[] linkTitles = new String[]{linkTitle1, prof.getLinkTitle(1), prof.getLinkTitle(2), prof.getLinkTitle(3)};
                                StringBuffer notes = new StringBuffer(prof.getNotes());
                                String p = thisGame.getNotes().replaceAll("\n", this.lineDelimiter);
                                if (settings.getSettings().getBooleanValue("mobygames", "set_description") && !prof.getNotes().endsWith(p)) {
                                    if (notes.length() > 0) {
                                        notes.append(this.lineDelimiter + this.lineDelimiter);
                                    }
                                    notes.append(p);
                                }
                                int rank = settings.getSettings().getBooleanValue("mobygames", "set_rank") ? thisGame.getRank() : prof.getCustomInt(0);
                                int[] customInts = new int[]{rank, prof.getCustomInt(1)};
                                dbase.addOrEditProfile(title, dev, publ, genre, year, prof.getStatus(), prof.getSetup(), prof.getSetupParameters(), notes.toString(), prof.isDefault(), prof.getDbversionId(), links, prof.getCustomStrings(), customInts, linkTitles, prof.getId());
                                MobyImageInformation[] imageInformation = thisGame.getImageDescriptions(settings.getSettings().getIntValue("mobygames", "multi_max_coverart"), settings.getSettings().getIntValue("mobygames", "multi_max_screenshot"));
                                for (int i = 0; i < imageInformation.length; ++i) {
                                    File file;
                                    String filename;
                                    String description = FileUtils.fileSystemSafeMobyImages(imageInformation[i].description);
                                    if (imageInformation[i].type == MobyImageInformation.MobygamesImageType.CoverArt) {
                                        filename = settings.msg("dialog.profile.mobygames.coverartfilename", new Object[]{i, description});
                                        file = new File(prof.getCanonicalCaptures(), filename + ".jpg");
                                    } else {
                                        filename = settings.msg("dialog.profile.mobygames.screenshotfilename", new Object[]{i, description});
                                        file = new File(prof.getCanonicalCaptures(), filename + ".png");
                                    }
                                    if (!FileUtils.isExistingFile(file)) {
                                        SWTImageManager.save(thisGame.getMobygamesImage(i), file.getPath());
                                        continue;
                                    }
                                    messageLog.append(title).append(": ").append(settings.msg("dialog.profile.error.imagealreadyexists", new String[]{file.getPath()})).append('\n');
                                }
                                break block21;
                            }
                        }
                        if (mobyGamesList.size() == 0) {
                            messageLog.append(this.title).append(": ").append(settings.msg("general.notice.mobygamesnoresults", new String[]{this.title})).append('\n');
                            break block21;
                        }
                        messageLog.append(this.title).append(": ").append(settings.msg("dialog.multiprofile.notice.titlenotunique", new String[]{this.title})).append('\n');
                    }
                    catch (SQLException se) {
                        messageLog.append(se.getMessage()).append('\n');
                    }
                }
                catch (IOException e) {
                    messageLog.append(this.title).append(": ").append(settings.msg("general.error.retrieveinfomobygames", new String[]{this.title, e.toString()})).append('\n');
                }
                catch (IndexOutOfBoundsException iobe) {
                    return;
                }
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    MobyGamesThread.this.profileLabel.setText(Settings.getInstance().msg("dialog.multiprofile.updating", new Object[]{MobyGamesThread.this.title}));
                    MobyGamesThread.this.profileLabel.pack();
                    if (messageLog.length() > displayedLog.length()) {
                        String newOutput = messageLog.substring(displayedLog.length());
                        MobyGamesThread.this.log.append(newOutput);
                        displayedLog.append(newOutput);
                    }
                    MobyGamesThread.this.progressBar.setSelection(MobyGamesThread.this.progressBar.getSelection() + 1);
                }
            });
        }
    }
}

