/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.dbgl.model.MobyImageInformation;
import org.dbgl.model.MobyProfile;
import org.dbgl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyGamesUtils {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTML_HREF_OPEN = " href=\"";
    private static final String HTML_SRC_OPEN = " src=\"";
    private static final String HTML_QUOTE = "\"";
    private static final String HTML_MOBY_OPEN = "</moby ";
    private static final String HTML_MOBY_CLOSE = "</moby>";
    private static final String HTML_SPAN_OPEN = "<span ";
    private static final String HTML_SPAN_CLOSE = "</span>";
    private static final String HTML_ANCHOR_OPEN = "<a ";
    private static final String HTML_ANCHOR_CLOSE = "</a>";
    private static final String HTML_DIV_OPEN = "<div";
    private static final String HTML_DIV_CLOSE = "</div>";
    private static final String HTML_BLOCKQUOTE_OPEN = "<blockquote>";
    private static final String HTML_BLOCKQUOTE_CLOSE = "</blockquote>";
    private static final String HTML_I_OPEN = "<i>";
    private static final String HTML_I_CLOSE = "</i>";
    private static final String HTML_UL_OPEN = "<ul>";
    private static final String HTML_UL_CLOSE = "</ul>";
    private static final String HTML_OL_OPEN = "<ol>";
    private static final String HTML_OL_CLOSE = "</ol>";
    private static final String HTML_LI_OPEN = "<li>";
    private static final String HTML_LI_CLOSE = "</li>";
    private static final String HTML_B_OPEN = "<b>";
    private static final String HTML_B_CLOSE = "</b>";
    private static final String HTML_P_OPEN = "<p>";
    private static final String HTML_PU_OPEN = "<p ";
    private static final String HTML_P_CLOSE = "</p>";
    private static final String HTML_EM_OPEN = "<em>";
    private static final String HTML_EM_CLOSE = "</em>";
    private static final String HTML_BR_UNCLOSED = "<br>";
    private static final String HTML_BR_CLOSED = "<br/>";
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<div class=\"searchSubSection\"><div>Results";
    private static final String HTML_GAME_TITLE_START = "<div class=\"searchTitle\">";
    private static final String HTML_GAME_END_MARKER = "<br clear=\"all\"></div>";
    private static final String MOBY_GAMES_HOST_NAME = "www.mobygames.com";
    private static final int RESULTS_PER_PAGE = 50;

    public static List<MobyProfile> getEntries(String title, String[] platforms) throws IOException {
        int pages = 1;
        ArrayList<MobyProfile> allEntries = new ArrayList<MobyProfile>();
        for (int pageIdx = 0; pageIdx < pages; ++pageIdx) {
            String content = MobyGamesUtils.getResponseContent("http://www.mobygames.com/search/quick?ajax=1&sFilter=1&p=-1&sG=on&q=" + URLEncoder.encode(title.replaceAll("/", " "), "UTF-8") + "&offset=" + pageIdx * 50);
            if (pageIdx == 0) {
                pages = MobyGamesUtils.getPages(content);
            }
            allEntries.addAll(MobyGamesUtils.extractEntries(content));
        }
        ArrayList<MobyProfile> entries = new ArrayList<MobyProfile>();
        for (MobyProfile prof : allEntries) {
            if (!MobyGamesUtils.isAllowed(prof, platforms)) continue;
            entries.add(prof);
        }
        if (entries.isEmpty()) {
            entries = allEntries;
        }
        Collections.sort(entries);
        return entries;
    }

    private static boolean isAllowed(MobyProfile prof, String[] platforms) {
        boolean allowed = platforms.length == 0;
        for (String p : platforms) {
            if (!prof.getPlatform().equalsIgnoreCase(p)) continue;
            return true;
        }
        return allowed;
    }

    private static int getPages(String htmlChunk) {
        int i = htmlChunk.indexOf(123);
        int j = htmlChunk.indexOf(125, i);
        return StringUtils.countCharacters(htmlChunk.substring(i, j), ',');
    }

    private static List<MobyProfile> extractEntries(String mobyGamesHttpResponse) {
        ArrayList<MobyProfile> allEntries = new ArrayList<MobyProfile>();
        int gameMatchEntryIndex = (mobyGamesHttpResponse = mobyGamesHttpResponse.replaceAll("\\\\\"", HTML_QUOTE)).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex += HTML_MULTIPLE_RESULT_MARKER_START.length();
        }
        while (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex = mobyGamesHttpResponse.indexOf(HTML_DIV_OPEN, gameMatchEntryIndex);
            int gameTitleIdx = mobyGamesHttpResponse.indexOf(HTML_GAME_TITLE_START, gameMatchEntryIndex);
            String gameTitleData = MobyGamesUtils.extractNextContent(mobyGamesHttpResponse, gameTitleIdx, HTML_DIV_OPEN, HTML_DIV_CLOSE);
            String gameTitle = MobyGamesUtils.unescapeHtml(MobyGamesUtils.removeAllTags(gameTitleData)).substring(6);
            String url = MobyGamesUtils.extractNextHrefContent(mobyGamesHttpResponse, gameTitleIdx);
            String details = MobyGamesUtils.extractNextContent(mobyGamesHttpResponse, gameTitleIdx + gameTitleData.length(), HTML_DIV_OPEN, HTML_DIV_CLOSE);
            int platformIdx = details.indexOf(HTML_SPAN_OPEN);
            while (platformIdx != -1) {
                String platform = MobyGamesUtils.extractNextContent(details, platformIdx, HTML_SPAN_OPEN, HTML_SPAN_CLOSE);
                if (platform.indexOf(HTML_ANCHOR_OPEN) != -1) {
                    platform = MobyGamesUtils.extractNextContent(details, platformIdx, HTML_ANCHOR_OPEN, HTML_ANCHOR_CLOSE);
                    url = MobyGamesUtils.extractNextHrefContent(details, platformIdx);
                } else {
                    int yrIdx = platform.indexOf(" (");
                    if (yrIdx != -1) {
                        platform = platform.substring(0, yrIdx);
                    }
                }
                if (!url.startsWith(HTTP_PROTOCOL)) {
                    url = "http://www.mobygames.com" + url;
                }
                String year = MobyGamesUtils.extractNextContent(details, platformIdx, HTML_EM_OPEN, HTML_EM_CLOSE);
                MobyProfile gameEntry = new MobyProfile();
                gameEntry.setTitle(gameTitle);
                gameEntry.setUrl(url);
                gameEntry.setPlatform(platform);
                gameEntry.setPublisherName("");
                gameEntry.setYear(year);
                allEntries.add(gameEntry);
                platformIdx = details.indexOf(HTML_SPAN_OPEN, platformIdx + 1);
            }
            int endIdx = mobyGamesHttpResponse.indexOf(HTML_GAME_END_MARKER, gameTitleIdx);
            gameMatchEntryIndex = mobyGamesHttpResponse.indexOf(HTML_DIV_OPEN, endIdx + HTML_GAME_END_MARKER.length());
        }
        return allEntries;
    }

    public static int getEntryFirstMatchIndex(String title, List<MobyProfile> profs) {
        for (int i = 0; i < profs.size(); ++i) {
            if (!title.equalsIgnoreCase(profs.get(i).getTitle())) continue;
            return i;
        }
        return -1;
    }

    public static MobyProfile getEntry(MobyProfile entry) throws UnknownHostException, IOException {
        MobyProfile result = new MobyProfile();
        result.setTitle(entry.getTitle());
        result.setYear(entry.getYear());
        result.setUrl(entry.getUrl());
        String responseEntry = MobyGamesUtils.getResponseContent(entry.getUrl());
        result.setDeveloperName(MobyGamesUtils.extractCategory(responseEntry, ">Developed by</div>"));
        result.setPublisherName(MobyGamesUtils.extractCategory(responseEntry, ">Published by</div>"));
        result.setGenre(MobyGamesUtils.extractCategory(responseEntry, ">Genre</div>"));
        result.setNotes(MobyGamesUtils.extractDescription(responseEntry));
        result.setRank(MobyGamesUtils.extractRank(responseEntry));
        result.setCoreGameCoverUrl(MobyGamesUtils.extractCoreGameCoverUrl(responseEntry));
        return result;
    }

    private static String extractCoreGameCoverUrl(String htmlChunk) {
        String marker = "<div id=\"coreGameCover\">";
        int startIndex = htmlChunk.indexOf(marker) + marker.length();
        return MobyGamesUtils.extractNextHrefContent(htmlChunk, startIndex);
    }

    private static String getResponseContent(String url) throws IOException {
        try {
            String str;
            URL urlConnection = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.openStream(), "UTF-8"));
            StringBuffer result = new StringBuffer(8192);
            while ((str = in.readLine()) != null) {
                result.append(str);
            }
            in.close();
            return result.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String absoluteUrl(String url) {
        return url.startsWith(HTTP_PROTOCOL) ? url : "http://www.mobygames.com" + url;
    }

    private static String extractNextContent(String htmlChunk, int startIndex, String openTag, String closeTag) {
        int divStartIndex = htmlChunk.indexOf(openTag, startIndex);
        divStartIndex = htmlChunk.indexOf(">", divStartIndex) + 1;
        int divEndIndex = htmlChunk.indexOf(closeTag, divStartIndex);
        return htmlChunk.substring(divStartIndex, divEndIndex);
    }

    private static String extractNextHrefContent(String htmlChunk, int startIndex) {
        int aStartIndex = htmlChunk.indexOf(HTML_HREF_OPEN, startIndex) + HTML_HREF_OPEN.length();
        int aEndIndex = htmlChunk.indexOf(HTML_QUOTE, aStartIndex);
        return htmlChunk.substring(aStartIndex, aEndIndex);
    }

    private static String extractNextSrcContent(String htmlChunk, int startIndex) {
        int aStartIndex = htmlChunk.indexOf(HTML_SRC_OPEN, startIndex) + HTML_SRC_OPEN.length();
        int aEndIndex = htmlChunk.indexOf(HTML_QUOTE, aStartIndex);
        return htmlChunk.substring(aStartIndex, aEndIndex);
    }

    private static String extractCategory(String htmlChunk, String marker) {
        int startIndex = htmlChunk.indexOf(marker);
        if (startIndex != -1) {
            int endIndex = htmlChunk.indexOf(HTML_DIV_CLOSE, startIndex + marker.length());
            return MobyGamesUtils.unescapeHtml(MobyGamesUtils.removeAllTags(htmlChunk.substring(startIndex + marker.length(), endIndex + HTML_DIV_CLOSE.length())));
        }
        return "";
    }

    private static String extractDescription(String htmlChunk) {
        String marker = "<h2 class=\"m5\">Description</h2>";
        int startIndex = htmlChunk.indexOf(marker) + marker.length();
        int endIndex = htmlChunk.indexOf(HTML_DIV_OPEN, startIndex);
        return MobyGamesUtils.unescapeHtml(MobyGamesUtils.removeAllTags(htmlChunk.substring(startIndex, endIndex)));
    }

    private static Integer extractRank(String htmlChunk) {
        String header = "scoreBoxBig";
        int startIndex = htmlChunk.indexOf(">", htmlChunk.indexOf(header) + header.length()) + 1;
        int endIndex = htmlChunk.indexOf("<", startIndex);
        try {
            return new Integer(htmlChunk.substring(startIndex, endIndex));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static String removeAllTags(String htmlChunk) {
        String result = MobyGamesUtils.removeSpecificTag(HTML_DIV_OPEN, HTML_DIV_CLOSE, htmlChunk);
        result = MobyGamesUtils.removeSpecificTag(HTML_ANCHOR_OPEN, HTML_ANCHOR_CLOSE, result);
        result = MobyGamesUtils.removeSpecificTag(HTML_MOBY_OPEN, HTML_MOBY_CLOSE, result);
        result = result.replace(HTML_I_OPEN, "").replace(HTML_I_CLOSE, "");
        result = result.replace(HTML_B_OPEN, "").replace(HTML_B_CLOSE, "");
        result = result.replace(HTML_LI_OPEN, "").replace(HTML_LI_CLOSE, "\n");
        result = result.replace(HTML_EM_OPEN, "").replace(HTML_EM_CLOSE, "");
        result = result.replace(HTML_UL_OPEN, "\n\n").replace(HTML_UL_CLOSE, "\n");
        result = result.replace(HTML_OL_OPEN, "\n\n").replace(HTML_OL_CLOSE, "\n");
        result = result.replace(HTML_BLOCKQUOTE_OPEN, "\n\n").replace(HTML_BLOCKQUOTE_CLOSE, "\n");
        result = result.replace(HTML_P_OPEN, "\n").replace(HTML_P_CLOSE, "");
        return result;
    }

    private static String removeSpecificTag(String openTag, String closeTag, String htmlChunk) {
        StringBuffer result = new StringBuffer(htmlChunk);
        int openingIndex = result.indexOf(openTag);
        while (openingIndex != -1) {
            result.delete(openingIndex, result.indexOf(">", openingIndex + openTag.length()) + 1);
            int closingIndex = result.indexOf(closeTag);
            result.delete(closingIndex, closingIndex + closeTag.length());
            openingIndex = result.indexOf(openTag);
        }
        return result.toString();
    }

    private static String unescapeHtml(String htmlChunk) {
        return StringEscapeUtils.unescapeHtml((String)htmlChunk.replace(HTML_BR_UNCLOSED, "\n").replace(HTML_BR_CLOSED, "\n").replace("&nbsp;", " "));
    }

    public static List<MobyImageInformation> getEntryScreenshotInformation(MobyProfile entry, int max) throws IOException {
        String endMarker;
        int endIndex;
        String marker;
        ArrayList<MobyImageInformation> result = new ArrayList<MobyImageInformation>();
        String htmlChunk = MobyGamesUtils.getResponseContent(entry.getScreenshotsUrl());
        int startIndex = htmlChunk.indexOf(marker = "<div class=\"thumbnailContainer\">");
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf(endMarker = "<br class=\"clearBoth\">", startIndex)) != -1) {
            htmlChunk = htmlChunk.substring(startIndex, endIndex);
            startIndex = htmlChunk.indexOf(HTML_SRC_OPEN);
            int found = 0;
            while (found < max && startIndex != -1) {
                String imgUrl = MobyGamesUtils.extractNextSrcContent(htmlChunk, startIndex);
                imgUrl = MobyGamesUtils.absoluteUrl(imgUrl.replaceAll("/images/shots/s/", "/images/shots/l/"));
                String imgDescription = MobyGamesUtils.extractNextContent(htmlChunk, startIndex, HTML_PU_OPEN, HTML_P_CLOSE);
                result.add(new MobyImageInformation(MobyImageInformation.MobygamesImageType.Screenshot, imgUrl, imgDescription));
                startIndex = htmlChunk.indexOf(HTML_SRC_OPEN, startIndex + 1);
            }
        }
        return result;
    }

    public static List<MobyImageInformation> getEntryCoverArtInformation(MobyProfile entry, int max) throws IOException {
        String endMarker;
        int endIndex;
        String marker;
        ArrayList<MobyImageInformation> result = new ArrayList<MobyImageInformation>();
        String htmlChunk = MobyGamesUtils.getResponseContent(entry.getCoverArtUrl());
        int startIndex = htmlChunk.indexOf(marker = entry.getCoreGameCoverUrl());
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf(endMarker = "<br class=\"clearBoth\">", startIndex)) != -1) {
            htmlChunk = htmlChunk.substring(startIndex - HTML_HREF_OPEN.length(), endIndex);
            startIndex = htmlChunk.indexOf(HTML_SRC_OPEN);
            for (int found = 0; found < max && startIndex != -1; ++found) {
                String imgUrl = MobyGamesUtils.extractNextSrcContent(htmlChunk, startIndex);
                imgUrl = MobyGamesUtils.absoluteUrl(imgUrl.replaceAll("/images/covers/small/", "/images/covers/large/"));
                String imgDescription = MobyGamesUtils.extractNextContent(htmlChunk, startIndex, HTML_PU_OPEN, HTML_P_CLOSE);
                result.add(new MobyImageInformation(MobyImageInformation.MobygamesImageType.CoverArt, imgUrl, imgDescription));
                startIndex = htmlChunk.indexOf(HTML_SRC_OPEN, startIndex + 1);
            }
        }
        return result;
    }
}

