/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class GeneralPurposeGUI {
    public static Button createIconButton(Composite composite, int style, Settings settings, String title, String img) {
        Button button = new Button(composite, style);
        GeneralPurposeGUI.updateIcon(button, settings, title, img);
        return button;
    }

    public static void updateIcon(Button button, Settings settings, String title, String img) {
        int displaySelection = settings.getSettings().getIntValue("gui", "buttondisplay");
        if (displaySelection != 1) {
            button.setImage(SWTImageManager.getResourceImage(button.getDisplay(), img));
        }
        if (displaySelection == 2) {
            button.setToolTipText(title);
        } else {
            button.setText(title);
        }
    }

    public static ToolItem createIconToolItem(ToolBar toolBar, Settings settings, String title, String img, SelectionListener listener) {
        ToolItem button = new ToolItem(toolBar, 2056);
        int displaySelection = settings.getSettings().getIntValue("gui", "buttondisplay");
        if (displaySelection != 1) {
            button.setImage(SWTImageManager.getResourceImage(button.getDisplay(), img));
        }
        if (displaySelection == 2) {
            button.setToolTipText(title);
        } else {
            button.setText(title);
        }
        button.addSelectionListener(listener);
        return button;
    }

    public static MenuItem createIconMenuItem(Menu menu, int style, Settings settings, String title, String img, SelectionListener listener) {
        MenuItem menuItem = new MenuItem(menu, style);
        menuItem.setText(title);
        if (img != null && settings.getSettings().getIntValue("gui", "buttondisplay") != 1) {
            menuItem.setImage(SWTImageManager.getResourceImage(menu.getDisplay(), img));
        }
        if (listener != null) {
            menuItem.addSelectionListener(listener);
        }
        return menuItem;
    }

    public static Font stringToFont(Device device, Font defaultFont, String[] font) {
        try {
            return new Font(device, font[0], Integer.parseInt(font[1]), Integer.parseInt(font[2]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultFont;
        }
    }

    public static String fontToString(Device device, Font font) {
        FontData data = font.getFontData()[0];
        return data.getName() + '|' + data.getHeight() + '|' + data.getStyle();
    }
}

