/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.List;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpProfile
extends Profile
implements Configurable {
    private Conf conf;
    private File baseDir;
    private File gameDir;
    private String importedFullConfig;
    private String importedIncrConfig;
    private int importedId;

    public ExpProfile(Conf conf) {
        super(null, false);
        this.conf = conf;
        this.baseDir = null;
        this.gameDir = null;
    }

    public ExpProfile(int id, Conf conf, File gDir, Profile prof) {
        super(id, prof.getConfPathAndFile(), prof.getCaptures(), prof);
        this.conf = conf;
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = gDir;
    }

    public ExpProfile(Element n, int dbversionIndex) {
        super(XmlUtils.getTextValue(n, "title"), Boolean.valueOf(XmlUtils.getTextValue(XmlUtils.getNode(n, "meta-info"), "favorite")));
        this.importedId = Integer.valueOf(XmlUtils.getTextValue(n, "id"));
        this.confPathAndFile = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(n, "config-file"), "raw"));
        this.captures = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(n, "captures"), "raw"));
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = new File(PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(n, "game-dir"), "raw")));
        this.setup = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(n, "setup"));
        this.setupParams = XmlUtils.getTextValue(n, "setup-parameters");
        Element metainfo = XmlUtils.getNode(n, "meta-info");
        this.developerName = XmlUtils.getTextValue(metainfo, "developer");
        this.publisherName = XmlUtils.getTextValue(metainfo, "publisher");
        this.year = XmlUtils.getTextValue(metainfo, "year");
        this.genre = XmlUtils.getTextValue(metainfo, "genre");
        this.status = XmlUtils.getTextValue(metainfo, "status");
        this.notes = XmlUtils.getTextValue(metainfo, "notes");
        this.customString = new String[]{XmlUtils.getTextValue(metainfo, "custom1"), XmlUtils.getTextValue(metainfo, "custom2"), XmlUtils.getTextValue(metainfo, "custom3"), XmlUtils.getTextValue(metainfo, "custom4"), XmlUtils.getTextValue(metainfo, "custom5"), XmlUtils.getTextValue(metainfo, "custom6"), XmlUtils.getTextValue(metainfo, "custom7"), XmlUtils.getTextValue(metainfo, "custom8")};
        this.customInt = new int[]{Integer.valueOf(XmlUtils.getTextValue(metainfo, "custom9")), Integer.valueOf(XmlUtils.getTextValue(metainfo, "custom10"))};
        Element link1 = XmlUtils.getNode(metainfo, "link1");
        Element link2 = XmlUtils.getNode(metainfo, "link2");
        Element link3 = XmlUtils.getNode(metainfo, "link3");
        Element link4 = XmlUtils.getNode(metainfo, "link4");
        this.link = new String[]{PlatformUtils.pathToNativePath(XmlUtils.getTextValue(link1, "raw")), PlatformUtils.pathToNativePath(XmlUtils.getTextValue(link2, "raw")), PlatformUtils.pathToNativePath(XmlUtils.getTextValue(link3, "raw")), PlatformUtils.pathToNativePath(XmlUtils.getTextValue(link4, "raw"))};
        this.linkTitle = new String[]{XmlUtils.getTextValue(link1, "title"), XmlUtils.getTextValue(link2, "title"), XmlUtils.getTextValue(link3, "title"), XmlUtils.getTextValue(link4, "title")};
        this.importedFullConfig = XmlUtils.getTextValue(n, "full-configuration");
        this.importedIncrConfig = XmlUtils.getTextValue(n, "incremental-configuration");
        this.dbversionId = dbversionIndex;
    }

    public ExpProfile(ExpProfile p1, ExpProfile p2, Conf conf) {
        super(p1, p2);
        this.conf = conf;
    }

    public ExpProfile(ExpProfile p1, Profile p2) {
        super(p1, p2, false);
        this.conf = p1.conf;
    }

    public void setDbversionId(int id) {
        this.dbversionId = id;
    }

    public int getImportedId() {
        return this.importedId;
    }

    public void setImportedId(int importedId) {
        this.importedId = importedId;
    }

    public String getCapturesExport() {
        return FileUtils.constructCapturesDir(this.getId());
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setGameDir(File gameDir) {
        this.gameDir = gameDir;
    }

    public String getImportedFullConfig() {
        return this.importedFullConfig;
    }

    public String getImportedIncrConfig() {
        return this.importedIncrConfig;
    }

    @Override
    public Conf getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Conf conf) {
        this.conf = conf;
    }

    public Element getXml(Document xmldoc, List<DosboxVersion> dbversionsList) {
        int i;
        boolean listExport = this.conf == null;
        Element profEmt = xmldoc.createElement("profile");
        XmlUtils.addCDataElement(xmldoc, profEmt, "title", this.getTitle());
        XmlUtils.addElement(xmldoc, profEmt, "id", String.valueOf(this.getId()));
        Element captures = xmldoc.createElement("captures");
        XmlUtils.addElement(xmldoc, captures, "raw", this.getCapturesExport());
        if (listExport) {
            XmlUtils.addElement(xmldoc, captures, "url", this.getCapturesAsUrl());
        }
        profEmt.appendChild(captures);
        Element config = xmldoc.createElement("config-file");
        XmlUtils.addElement(xmldoc, config, "raw", FileUtils.makeRelativeToData(new File(this.getConfPathAndFile())).getPath());
        if (listExport) {
            XmlUtils.addElement(xmldoc, config, "url", this.getConfFileAsUrl());
        }
        profEmt.appendChild(config);
        if (this.gameDir != null) {
            Element gamedir = xmldoc.createElement("game-dir");
            XmlUtils.addElement(xmldoc, gamedir, "raw", PlatformUtils.toDosboxPath(this.gameDir.getPath()));
            profEmt.appendChild(gamedir);
        }
        XmlUtils.addElement(xmldoc, profEmt, "setup", this.getSetup());
        XmlUtils.addElement(xmldoc, profEmt, "setup-parameters", this.getSetupParameters());
        Element meta = xmldoc.createElement("meta-info");
        XmlUtils.addCDataElement(xmldoc, meta, "developer", this.getDeveloperName());
        XmlUtils.addCDataElement(xmldoc, meta, "publisher", this.getPublisherName());
        XmlUtils.addCDataElement(xmldoc, meta, "year", this.getYear());
        XmlUtils.addCDataElement(xmldoc, meta, "genre", this.getGenre());
        XmlUtils.addCDataElement(xmldoc, meta, "status", this.getStatus());
        XmlUtils.addElement(xmldoc, meta, "favorite", String.valueOf(this.isDefault()));
        XmlUtils.addCDataElement(xmldoc, meta, "notes", XmlUtils.cleanEolnForXml(this.getNotes()));
        for (i = 0; i < 8; ++i) {
            XmlUtils.addCDataElement(xmldoc, meta, "custom" + (i + 1), this.getCustomString(i));
        }
        for (i = 0; i < 2; ++i) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 9), String.valueOf(this.getCustomInt(i)));
        }
        for (i = 0; i < 4; ++i) {
            Element link = xmldoc.createElement("link" + (i + 1));
            XmlUtils.addElement(xmldoc, link, "raw", this.getLink(i));
            if (listExport) {
                XmlUtils.addElement(xmldoc, link, "url", this.getLinkAsUrl(i));
            }
            XmlUtils.addCDataElement(xmldoc, link, "title", this.getLinkTitle(i));
            meta.appendChild(link);
        }
        profEmt.appendChild(meta);
        if (this.conf != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "full-configuration", XmlUtils.cleanEolnForXml(this.conf.toFullConfString()));
        }
        if (this.conf != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "incremental-configuration", XmlUtils.cleanEolnForXml(this.conf.toIncrConfString()));
        }
        DosboxVersion dbv = dbversionsList.get(DosboxVersion.findById(dbversionsList, this.getDbversionId()));
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addCDataElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        profEmt.appendChild(dosbox);
        return profEmt;
    }
}

