/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.List;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.conf.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTitleDefault
extends KeyValuePair {
    private Boolean defaultChoice;

    public KeyTitleDefault(int id, String value, Boolean isDefault) {
        super(id, value);
        this.defaultChoice = isDefault;
    }

    public String getTitle() {
        return this.getValue();
    }

    public Boolean isDefault() {
        return this.defaultChoice;
    }

    public String isDefaultString() {
        return this.defaultChoice != false ? Settings.getInstance().msg("general.yes") : Settings.getInstance().msg("general.no");
    }

    public void toggleDefault() {
        this.defaultChoice = this.defaultChoice == false;
    }

    public static <T extends KeyTitleDefault> int findDefault(List<T> list) {
        int result = 0;
        for (KeyTitleDefault element : list) {
            if (element.defaultChoice.booleanValue()) {
                return result;
            }
            ++result;
        }
        return -1;
    }
}

