/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.Mount;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Autoexec {
    List<Mount> mountingpoints;
    Boolean loadfix;
    int loadfixValue;
    String main;
    String img1;
    String img2;
    String img3;
    Boolean exit;
    String params;
    String mixer;
    String keyb;
    String ipxnet;

    Autoexec() {
        this.init();
    }

    Autoexec(Autoexec other) {
        this.mountingpoints = new ArrayList<Mount>();
        for (Mount m : other.mountingpoints) {
            this.mountingpoints.add(new Mount(m));
        }
        this.loadfix = other.loadfix;
        this.loadfixValue = other.loadfixValue;
        this.main = other.main;
        this.img1 = other.img1;
        this.img2 = other.img2;
        this.img3 = other.img3;
        this.exit = other.exit;
        this.params = other.params;
        this.mixer = other.mixer;
        this.keyb = other.keyb;
        this.ipxnet = other.ipxnet;
    }

    void init() {
        this.mountingpoints = new ArrayList<Mount>();
        this.loadfix = false;
        this.loadfixValue = 0;
        this.main = "";
        this.img1 = "";
        this.img2 = "";
        this.img3 = "";
        this.exit = false;
        this.params = "";
        this.mixer = "";
        this.keyb = "";
        this.ipxnet = "";
    }

    static List<Mount> getUniqueMountingpoints(Autoexec base, Autoexec ext) {
        int start;
        ArrayList<Mount> result = new ArrayList<Mount>();
        for (int i = start = base == null ? 0 : base.mountingpoints.size(); i < ext.mountingpoints.size(); ++i) {
            result.add(new Mount(ext.mountingpoints.get(i)));
        }
        return result;
    }

    void parseLines(List<String> orgLines) {
        char driveletter = '\u0000';
        char imgdriveletter1 = '\u0000';
        char imgdriveletter2 = '\u0000';
        char imgdriveletter3 = '\u0000';
        String remainder = "";
        String executable = "";
        String image1 = "";
        String image2 = "";
        String image3 = "";
        int exeIndex = -1;
        ArrayList<String> leftOvers = new ArrayList<String>();
        for (String orgLine : orgLines) {
            String line = orgLine.toLowerCase();
            boolean leftOverCandidate = false;
            if (line.startsWith("mount") || line.startsWith("imgmount")) {
                this.addMount(orgLine);
            } else if (line.endsWith(":") && line.length() == 2) {
                driveletter = line.charAt(0);
            } else if (line.startsWith("cd\\")) {
                remainder = PlatformUtils.toNativePath(orgLine).substring(2);
            } else if (line.startsWith("cd ")) {
                remainder = PlatformUtils.toNativePath(orgLine).substring(3);
            } else if (line.startsWith("keyb ") || line.startsWith("keyb.com ")) {
                this.keyb = orgLine.substring(line.indexOf(32) + 1);
            } else if (line.startsWith("mixer ") || line.startsWith("mixer.com ")) {
                this.mixer = orgLine.substring(line.indexOf(32) + 1);
            } else if (line.startsWith("ipxnet ") || line.startsWith("ipxnet.com ")) {
                this.ipxnet = orgLine.substring(line.indexOf(32) + 1);
            } else {
                exeIndex = line.indexOf(FileUtils.EXECUTABLES[0]);
                if (exeIndex != -1 || (exeIndex = line.indexOf(FileUtils.EXECUTABLES[1])) != -1 || (exeIndex = line.indexOf(FileUtils.EXECUTABLES[2])) != -1) {
                    int spaceAfterIndex;
                    executable = orgLine;
                    int spaceBeforeIndex = executable.lastIndexOf(32, exeIndex);
                    if (spaceBeforeIndex != -1) {
                        executable = executable.substring(spaceBeforeIndex + 1);
                    }
                    if ((spaceAfterIndex = executable.indexOf(32)) != -1) {
                        this.params = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
                        executable = executable.substring(0, spaceAfterIndex);
                    }
                } else if (line.startsWith("boot ")) {
                    int spaceIndex = line.indexOf(32, 5);
                    if (spaceIndex == -1) {
                        spaceIndex = line.length();
                    } else {
                        int secondSpaceIndex = line.indexOf(32, spaceIndex + 2);
                        if (secondSpaceIndex == -1) {
                            secondSpaceIndex = line.length();
                        } else {
                            imgdriveletter3 = line.charAt(secondSpaceIndex + 1);
                            image3 = PlatformUtils.toNativePath(orgLine).substring(secondSpaceIndex + 3);
                        }
                        imgdriveletter2 = line.charAt(spaceIndex + 1);
                        image2 = PlatformUtils.toNativePath(orgLine).substring(spaceIndex + 3, secondSpaceIndex);
                    }
                    imgdriveletter1 = line.charAt(5);
                    image1 = PlatformUtils.toNativePath(orgLine).substring(7, spaceIndex);
                    if (imgdriveletter1 == '\\' && "ile".equals(image1)) {
                        this.img1 = "file";
                    }
                } else if (line.startsWith("exit")) {
                    this.exit = true;
                } else {
                    leftOverCandidate = true;
                }
            }
            if (line.startsWith("loadfix -") && !line.startsWith("loadfix -f")) {
                this.loadfix = true;
                int endIndex = line.indexOf(32, 9);
                if (endIndex == -1) {
                    endIndex = line.length();
                }
                try {
                    this.loadfixValue = Integer.parseInt(line.substring(9, endIndex));
                }
                catch (NumberFormatException e) {
                    this.loadfixValue = 0;
                }
                continue;
            }
            if (!leftOverCandidate) continue;
            leftOvers.add(orgLine);
        }
        if (executable.equals("") && leftOvers.size() == 1) {
            executable = ((String)leftOvers.get(0)).trim();
            int spaceAfterIndex = executable.indexOf(32);
            if (spaceAfterIndex != -1) {
                this.params = executable.substring(spaceAfterIndex + 1);
                executable = executable.substring(0, spaceAfterIndex);
            }
            executable = executable + FileUtils.EXECUTABLES[0];
        }
        for (Mount mount : this.mountingpoints) {
            char mount_drive = mount.getDriveletter();
            String mountPath = mount.getHostPathAsString();
            if (Character.toUpperCase(driveletter) == mount_drive) {
                if (executable.equals("")) continue;
                this.main = FileUtils.sanitizeToDosroot(mountPath + remainder + File.separatorChar + executable);
                continue;
            }
            if (Character.toUpperCase(imgdriveletter1) == mount_drive) {
                this.img1 = FileUtils.sanitizeToDosroot(mountPath + image1);
            }
            if (Character.toUpperCase(imgdriveletter2) == mount_drive) {
                this.img2 = FileUtils.sanitizeToDosroot(mountPath + image2);
            }
            if (Character.toUpperCase(imgdriveletter3) != mount_drive) continue;
            this.img3 = FileUtils.sanitizeToDosroot(mountPath + image3);
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Autoexec base) {
        String[] dosboxLocation;
        StringBuffer result = new StringBuffer();
        if (!("".equals(this.keyb) || base != null && base.keyb.equals(this.keyb))) {
            result.append("keyb.com ").append(this.keyb).append(PlatformUtils.EOLN);
        }
        if (!("".equals(this.ipxnet) || base != null && base.ipxnet.equals(this.ipxnet))) {
            result.append("ipxnet.com ").append(this.ipxnet).append(PlatformUtils.EOLN);
        }
        List<Mount> mnts = null;
        if (base == null) {
            mnts = this.mountingpoints;
        } else {
            mnts = new ArrayList<Mount>();
            for (int i = 0; i < this.mountingpoints.size(); ++i) {
                if (i < base.mountingpoints.size() && this.mountingpoints.get(i).equals(base.mountingpoints.get(i))) continue;
                mnts.add(this.mountingpoints.get(i));
            }
        }
        for (Mount mount : mnts) {
            result.append(mount.toString()).append(PlatformUtils.EOLN);
        }
        if (!("".equals(this.mixer) || base != null && base.mixer.equals(this.mixer))) {
            result.append("mixer.com ").append(this.mixer).append(PlatformUtils.EOLN);
        }
        if (!"".equals(this.main)) {
            dosboxLocation = this.convertToDosboxPath(this.main);
            result.append(dosboxLocation[0] + PlatformUtils.EOLN);
            result.append("cd \\" + dosboxLocation[1] + PlatformUtils.EOLN);
            if (this.loadfix.booleanValue()) {
                result.append("loadfix -").append(this.loadfixValue).append(PlatformUtils.EOLN);
            }
            if (dosboxLocation[2].toLowerCase().endsWith(FileUtils.EXECUTABLES[2])) {
                result.append("call ");
            }
            result.append(dosboxLocation[2]);
            if (!"".equals(this.params)) {
                result.append(' ').append(this.params);
            }
            result.append(PlatformUtils.EOLN);
        } else if (!"".equals(this.img1)) {
            if (this.loadfix.booleanValue()) {
                result.append("loadfix -").append(this.loadfixValue).append(PlatformUtils.EOLN);
            }
            dosboxLocation = this.convertToDosboxPath(this.img1);
            result.append("boot ").append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
            if (!dosboxLocation[1].equals("")) {
                result.append('\\');
            }
            result.append(dosboxLocation[2]);
            if (!"".equals(this.img2)) {
                dosboxLocation = this.convertToDosboxPath(this.img2);
                result.append(' ').append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
                if (!dosboxLocation[1].equals("")) {
                    result.append('\\');
                }
                result.append(dosboxLocation[2]);
            }
            if (!"".equals(this.img3)) {
                dosboxLocation = this.convertToDosboxPath(this.img3);
                result.append(' ').append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
                if (!dosboxLocation[1].equals("")) {
                    result.append('\\');
                }
                result.append(dosboxLocation[2]);
            }
            result.append(PlatformUtils.EOLN);
        }
        if (this.loadfix.booleanValue()) {
            result.append("loadfix -f").append(PlatformUtils.EOLN);
        }
        if (this.exit.booleanValue()) {
            result.append("exit").append(PlatformUtils.EOLN);
        }
        if (result.length() > 0) {
            result.insert(0, "[autoexec]" + PlatformUtils.EOLN);
        }
        return result.toString();
    }

    String[] convertToDosboxPath(String hostFileLocation) {
        File hostFile = new File(hostFileLocation);
        String[] result = new String[]{"", "", hostFile.getName()};
        int maxLengthMount = 0;
        for (Mount mount : this.mountingpoints) {
            File dosboxDir = mount.canBeUsedFor(hostFile);
            if (dosboxDir == null || mount.getPathAsString().length() <= maxLengthMount) continue;
            result[0] = mount.getDriveletter() + ":";
            result[1] = dosboxDir.getParent() == null ? "" : dosboxDir.getParent();
            maxLengthMount = mount.getPathAsString().length();
        }
        result[1] = PlatformUtils.toDosboxPath(result[1]);
        return result;
    }

    void addMount(String mount) {
        block4: {
            try {
                Mount mnt = new Mount(mount);
                if (mnt.isUnmounted()) {
                    for (Mount m : this.mountingpoints) {
                        if (m.getDriveletter() != mnt.getDriveletter()) continue;
                        m.toggleMount();
                        break block4;
                    }
                    break block4;
                }
                this.mountingpoints.add(mnt);
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
    }

    public void setMainExecutable(String main, String params) {
        this.main = main;
        this.params = params;
    }

    public File getCanonicalMainDir() {
        if (this.isBooter()) {
            return FileUtils.getCanMainFile(new File(this.img1)).getParentFile();
        }
        return FileUtils.getCanMainFile(new File(this.main)).getParentFile();
    }

    public void migrateToDosroot(File fromPath) {
        for (Mount mount : this.mountingpoints) {
            mount.migrateToDosroot(fromPath);
        }
        if (this.isBooter()) {
            String newImg3;
            String newImg2;
            String newImg1 = FileUtils.makeRelativeTo(new File(this.img1), fromPath).getPath();
            if (this.convertToDosboxPath(newImg1)[0].length() > 0) {
                this.img1 = newImg1;
            }
            if (this.convertToDosboxPath(newImg2 = FileUtils.makeRelativeTo(new File(this.img2), fromPath).getPath())[0].length() > 0) {
                this.img2 = newImg2;
            }
            if (this.convertToDosboxPath(newImg3 = FileUtils.makeRelativeTo(new File(this.img3), fromPath).getPath())[0].length() > 0) {
                this.img3 = newImg3;
            }
        } else {
            String newMain = FileUtils.makeRelativeTo(new File(this.main), fromPath).getPath();
            if (this.convertToDosboxPath(newMain)[0].length() > 0) {
                this.main = newMain;
            }
        }
    }

    void updateForTargetImportBaseDir(File baseDir) {
        for (Mount mount : this.mountingpoints) {
            mount.updateForTargetImportBaseDir(baseDir);
        }
        if (this.isBooter()) {
            this.img1 = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.img1)).getPath();
            this.img2 = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.img2)).getPath();
            this.img3 = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.img3)).getPath();
        } else {
            this.main = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.main)).getPath();
        }
    }

    void updateMountingPoints(Autoexec base, List<Mount> additionalMounts) {
        this.mountingpoints = new ArrayList<Mount>();
        for (Mount m : base.mountingpoints) {
            this.mountingpoints.add(new Mount(m));
        }
        for (Mount m : additionalMounts) {
            this.mountingpoints.add(new Mount(m));
        }
    }

    public boolean isIncomplete() {
        return this.img1.length() == 0 && this.main.length() == 0;
    }

    public Boolean isExit() {
        return this.exit;
    }

    public boolean isBooter() {
        return this.img1.length() > 0;
    }

    public Boolean isLoadfix() {
        return this.loadfix;
    }

    public int getLoadfixValue() {
        return this.loadfixValue;
    }

    public String getMixer() {
        return this.mixer;
    }

    public String getKeyb() {
        return this.keyb;
    }

    public String getIpxnet() {
        return this.ipxnet;
    }

    public String getImg1() {
        if ("file".equals(this.img1)) {
            return "";
        }
        return this.img1;
    }

    public String getImg2() {
        return this.img2;
    }

    public String getImg3() {
        return this.img3;
    }

    public String getMain() {
        return this.main;
    }

    public String getMainParameters() {
        return this.params;
    }

    public String[] getMountingpoints() {
        String[] result = new String[this.mountingpoints.size()];
        int mountIndex = 0;
        for (Mount mount : this.mountingpoints) {
            result[mountIndex++] = mount.toString(true);
        }
        return result;
    }

    public static Autoexec createCombination(Autoexec a1, Autoexec a2) {
        Autoexec result = new Autoexec();
        result.mountingpoints = new ArrayList<Mount>();
        for (Mount m1 : a1.mountingpoints) {
            for (Mount m2 : a2.mountingpoints) {
                if (!m1.toString(false).equals(m2.toString(false))) continue;
                result.mountingpoints.add(new Mount(m1));
            }
        }
        result.loadfix = a1.loadfix == a2.loadfix ? a1.loadfix : Conf.CONFLICTING_BOOL_SETTING;
        result.loadfixValue = a1.loadfixValue == a2.loadfixValue ? a1.loadfixValue : Integer.MIN_VALUE;
        result.main = a1.main.equals(a2.main) ? a1.main : "CONFLICTING_SETTING";
        result.img1 = a1.img1.equals(a2.img1) ? a1.img1 : "CONFLICTING_SETTING";
        result.img2 = a1.img2.equals(a2.img2) ? a1.img2 : "CONFLICTING_SETTING";
        result.img3 = a1.img3.equals(a2.img3) ? a1.img3 : "CONFLICTING_SETTING";
        result.exit = a1.exit == a2.exit ? a1.exit : Conf.CONFLICTING_BOOL_SETTING;
        result.params = a1.params.equals(a2.params) ? a1.params : "CONFLICTING_SETTING";
        result.mixer = a1.mixer.equals(a2.mixer) ? a1.mixer : "CONFLICTING_SETTING";
        result.keyb = a1.keyb.equals(a2.keyb) ? a1.keyb : "CONFLICTING_SETTING";
        result.ipxnet = a1.ipxnet.equals(a2.ipxnet) ? a1.ipxnet : "CONFLICTING_SETTING";
        return result;
    }

    public void fixMounts(Autoexec dosboxAutoexec) {
        if (dosboxAutoexec.mountingpoints.size() == 0) {
            return;
        }
        ArrayList<Mount> result = new ArrayList<Mount>();
        int nrOfUnmounts = 0;
        for (Mount m : this.mountingpoints) {
            boolean found = false;
            boolean mustBeUnmounted = false;
            for (Mount b : dosboxAutoexec.mountingpoints) {
                if (b.mostlyMatches(m)) {
                    result.add(new Mount(b));
                    found = true;
                    break;
                }
                if (b.getDriveletter() != m.getDriveletter()) continue;
                mustBeUnmounted = true;
            }
            if (found) continue;
            if (mustBeUnmounted) {
                Mount u = new Mount(m);
                u.toggleMount();
                result.add(nrOfUnmounts++, u);
            }
            result.add(new Mount(m));
        }
        this.mountingpoints = result;
    }
}

