/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.swtdesigner;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.dbgl.swtdesigner.GifDecoder;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public final class SWTImageManager {
    private static final Map<String, Image> imageMap = new HashMap<String, Image>();
    public static final String IMG_TB_NEW = "tb_new.png";
    public static final String IMG_TB_EDIT = "tb_edit.png";
    public static final String IMG_TB_DELETE = "tb_delete.png";
    public static final String IMG_TB_RUN = "tb_run.png";
    public static final String IMG_TB_SETUP = "tb_setup.png";
    public static final String IMG_RUN = "run.png";
    public static final String IMG_SETUP = "setup.png";
    public static final String IMG_FOLDER = "folder.png";
    public static final String IMG_ZOOM = "zoom.png";
    public static final String IMG_NEW = "new.png";
    public static final String IMG_EDIT = "edit.png";
    public static final String IMG_DUPLICATE = "duplicate.png";
    public static final String IMG_DELETE = "delete.png";
    public static final String IMG_FAVORITE = "favorite.png";
    public static final String IMG_SHORTCUT = "shortcut.png";
    public static final String IMG_REFRESH = "refresh.png";
    public static final String IMG_HOME = "home.png";
    public static final String IMG_DFEND = "dfend.png";
    public static final String IMG_MIGRATE = "case.png";
    public static final String IMG_TABLEEXPORT = "checkout.png";
    public static final String IMG_IMPORT = "import.png";
    public static final String IMG_CLEAN = "clean.png";
    public static final String IMG_SETTINGS = "settings.png";
    public static final String IMG_EXIT = "stop.png";
    public static final String IMG_GRAB = "grab.png";
    public static final String IMG_MOBYGAMES = "moby.png";
    public static final String IMG_POUET = "pouet.png";

    public static void dispose() {
        for (Image image : imageMap.values()) {
            image.dispose();
        }
        imageMap.clear();
    }

    public static Image getResourceImage(Display display, String path) {
        return new Image((Device)display, imageMap.getClass().getResourceAsStream("/img/" + path));
    }

    public static Image getImage(Display display, String path) {
        try {
            if (path.toLowerCase().endsWith(".ico")) {
                ImageLoader iLoader = new ImageLoader();
                iLoader.load(path);
                int bestWidth = 0;
                int bestDepth = 0;
                int bestIndex = 0;
                for (int i = 0; i < iLoader.data.length; ++i) {
                    if (iLoader.data[i].width < bestWidth || iLoader.data[i].depth < bestDepth) continue;
                    bestWidth = iLoader.data[i].width;
                    bestDepth = iLoader.data[i].depth;
                    bestIndex = i;
                }
                return new Image((Device)display, iLoader.data[bestIndex]);
            }
            return new Image((Device)display, path);
        }
        catch (Exception e) {
            return SWTImageManager.getEmptyImage(display, 10, 10);
        }
    }

    public static ImageData getImageData(String url) throws IOException {
        URL urlConnection;
        try {
            urlConnection = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        try {
            return new ImageData(urlConnection.openStream());
        }
        catch (SWTException e) {
            GifDecoder d = new GifDecoder();
            d.read(urlConnection.openStream());
            BufferedImage bufferedImage = d.getFrame(0);
            int[] data = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
            imageData.setPixels(0, 0, data.length, data, 0);
            return imageData;
        }
    }

    public static Image getEmptyImage(Display display, int width, int height) {
        Image image = new Image((Device)display, width, height);
        GC graphc = new GC((Drawable)image);
        graphc.setBackground(display.getSystemColor(22));
        graphc.fillRectangle(0, 0, width, height);
        graphc.dispose();
        return image;
    }

    public static void save(ImageData imageData, String filename) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        if (filename.toUpperCase().endsWith(".JPG")) {
            loader.save(filename, 4);
        } else {
            loader.save(filename, 5);
        }
    }

    public static Image getWidthLimitedImage(Display display, int width, ImageData data) {
        Image orgImage = new Image((Device)display, data);
        int orgW = orgImage.getBounds().width;
        int orgH = orgImage.getBounds().height;
        double factor = (double)width / (double)orgW;
        int height = (int)((double)orgH * factor);
        Image image = new Image((Device)display, width, height);
        GC graphc = new GC((Drawable)image);
        graphc.setAntialias(1);
        graphc.drawImage(orgImage, 0, 0, orgW, orgH, 0, 0, width, height);
        graphc.dispose();
        orgImage.dispose();
        return image;
    }

    public static Image getResizedImage(Display display, int height, String path, String name) {
        String hash = path + height + name;
        Image image = imageMap.get(hash);
        if (image == null) {
            Image orgImage = SWTImageManager.getImage(display, path);
            int orgW = orgImage.getBounds().width;
            int orgH = orgImage.getBounds().height;
            double factor = (double)height / (double)orgH;
            int width = (int)((double)orgW * factor);
            image = new Image((Device)display, width, height);
            GC graphc = new GC((Drawable)image);
            graphc.setAntialias(1);
            graphc.drawImage(orgImage, 0, 0, orgW, orgH, 0, 0, width, height);
            if (name != null) {
                Point size = graphc.textExtent(name);
                graphc.setBackground(display.getSystemColor(2));
                graphc.setForeground(display.getSystemColor(1));
                graphc.setAlpha(180);
                graphc.drawString(name, width - size.x - 2, height - size.y - 2, false);
            }
            graphc.dispose();
            orgImage.dispose();
            imageMap.put(hash, image);
        }
        return image;
    }
}

