/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.DFendImportThread;
import org.dbgl.util.FileUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.StringUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportThread
extends UIThread
implements ProgressNotifyable {
    private boolean importCaptures;
    private boolean importGameData;
    private boolean importFullSettings;
    private boolean customValues;
    private String[] customFields;
    private boolean useExistingConf;
    private File zipfile;

    public ImportThread(Text log, ProgressBar progressBar, Label status, List<ExpProfile> profs, File zipfile, boolean captures, boolean useExistingConf, boolean gamedata, boolean fullSettings, boolean customValues, String[] customFields) throws IOException, SQLException {
        super(log, progressBar, status);
        this.zipfile = zipfile;
        this.importCaptures = captures;
        this.useExistingConf = useExistingConf;
        this.importGameData = gamedata;
        this.importFullSettings = fullSettings;
        this.customValues = customValues;
        this.customFields = customFields;
        long bytes = 0L;
        for (ExpProfile ep : profs) {
            if (this.importCaptures) {
                bytes += FileUtils.extractZipSizeInBytes(zipfile, new File(ep.getCaptures()));
            }
            if (!this.importGameData) continue;
            bytes += FileUtils.extractZipSizeInBytes(zipfile, new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(ep.getImportedId()), ep.getGameDir().getPath()).getPath()));
        }
        this.objects = profs;
        this.progressBar.setMaximum((int)(bytes / 1024L) + this.objects.size());
        this.extensiveLogging = true;
    }

    @Override
    public void doFancyStuff(Object obj, StringBuffer messageLog) throws IOException, SQLException {
        ExpProfile prof = (ExpProfile)obj;
        this.displayTitle(this.settings.msg("dialog.import.importing", new Object[]{prof.getTitle()}));
        int devId = KeyValuePair.findIdByValue(this.dbase.readDevelopersList(), prof.getDeveloperName());
        int publId = KeyValuePair.findIdByValue(this.dbase.readPublishersList(), prof.getPublisherName());
        int genId = KeyValuePair.findIdByValue(this.dbase.readGenresList(), prof.getGenre());
        int yrId = KeyValuePair.findIdByValue(this.dbase.readYearsList(), prof.getYear());
        int statId = KeyValuePair.findIdByValue(this.dbase.readStatusList(), prof.getStatus());
        String[] customStrings = DFendImportThread.CUST_STRINGS;
        int[] customInts = DFendImportThread.CUST_INTS;
        int[] custIDs = DFendImportThread.CUST_IDS;
        if (this.customValues) {
            customStrings = prof.getCustomStrings();
            customInts = prof.getCustomInts();
            for (int i = 0; i < 4; ++i) {
                custIDs[i] = KeyValuePair.findIdByValue(this.dbase.readCustomList(i), prof.getCustomString(i));
            }
        }
        int profileId = this.dbase.addOrEditProfile(prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(), prof.getStatus(), prof.getSetup(), prof.getSetupParameters(), prof.getNotes(), prof.isDefault(), devId, publId, genId, yrId, statId, prof.getDbversionId(), prof.getLinks(), customStrings, customInts, custIDs, prof.getLinkTitles(), -1);
        String newCapturesString = FileUtils.constructCapturesDir(profileId);
        File relativeCapturesDirInZip = new File(prof.getCaptures());
        File canonicalCapturesDir = FileUtils.canonicalToData(newCapturesString);
        if (!canonicalCapturesDir.exists()) {
            FileUtils.createDir(canonicalCapturesDir);
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{canonicalCapturesDir})).append('\n');
            if (this.importCaptures) {
                try {
                    FileUtils.extractZip(this.zipfile, relativeCapturesDirInZip, canonicalCapturesDir, this);
                    messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.extractedcaptures", new Object[]{canonicalCapturesDir})).append('\n');
                }
                catch (IOException e) {
                    messageLog.append("  - ").append(this.settings.msg("dialog.import.error.capturesextraction", new Object[]{StringUtils.toString(e)})).append('\n');
                }
            }
        } else {
            messageLog.append("  - ").append(this.settings.msg("dialog.import.error.capturesdirexists", new Object[]{canonicalCapturesDir})).append('\n');
        }
        File relativeGameDir = prof.getGameDir();
        File relativeGameDirInZip = new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(prof.getImportedId()), relativeGameDir.getPath()).getPath());
        File canonicalGameDir = FileUtils.canonicalToDosroot(new File(prof.getBaseDir(), prof.getGameDir().getPath()).getPath());
        if (this.importGameData && !canonicalGameDir.exists()) {
            FileUtils.createDir(canonicalGameDir);
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{canonicalGameDir})).append('\n');
            try {
                FileUtils.extractZip(this.zipfile, relativeGameDirInZip, canonicalGameDir, this);
                messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.extractedgamedata", new Object[]{canonicalGameDir})).append('\n');
            }
            catch (IOException e) {
                throw new IOException(this.settings.msg("dialog.import.error.gamedataextraction", new Object[]{StringUtils.toString(e)}), e);
            }
        }
        DosboxVersion assocDBVersion = (DosboxVersion)this.dbversions.get(DosboxVersion.findById(this.dbversions, prof.getDbversionId()));
        String newConfString = null;
        if (this.useExistingConf && FileUtils.areRelated(new File(FileUtils.getDosRoot()), prof.getCanonicalConfFile()) && FileUtils.isExistingFile(prof.getCanonicalConfFile())) {
            newConfString = prof.getCanonicalConfFile().getPath();
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.usingexistingconf", new Object[]{prof.getCanonicalConfFile()})).append('\n');
        } else {
            Conf gameConf = new Conf(prof.getImportedFullConfig(), prof.getImportedIncrConfig(), this.importFullSettings, this.zipfile.getPath(), prof, profileId, assocDBVersion, this.ps);
            newConfString = FileUtils.makeRelativeToData(gameConf.getConfFile()).getPath();
            Profile newProfile = new Profile(profileId, newConfString, newCapturesString, prof);
            if (!canonicalGameDir.exists()) {
                FileUtils.createDir(canonicalGameDir);
                messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{canonicalGameDir})).append('\n');
            }
            String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
            gameConf.getSettings().setValue("dosbox", "captures", dstCapRelative);
            gameConf.save();
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createdconf", new Object[]{newProfile.getCanonicalConfFile()}));
        }
        this.dbase.updateProfileConf(newConfString, newCapturesString, profileId);
        String setup = prof.getSetup();
        if (setup.length() > 0) {
            setup = FileUtils.prefixAndSanitizeToDosroot(prof.getBaseDir(), new File(setup)).getPath();
        }
        String[] links = prof.getLinks();
        for (int i = 0; i < links.length; ++i) {
            if (links[i].equals("") || links[i].contains("://")) continue;
            links[i] = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(links[i])).getPath();
            links[i] = FileUtils.prefixAndSanitizeToDosroot(prof.getBaseDir(), new File(links[i])).getPath();
            if (prof.getBaseDir().isAbsolute()) continue;
            links[i] = FileUtils.DOSROOT_DIR + links[i];
        }
        this.dbase.updateProfileSetupAndLinks(setup, links, profileId);
        messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddbentry", new Object[]{profileId, newConfString, newCapturesString, assocDBVersion.getTitle()})).append('\n');
    }

    @Override
    public String getTitle(Object o) {
        return ((ExpProfile)o).getTitle();
    }

    @Override
    public void preFinish() {
        if (this.customFields != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.customFields[i].equalsIgnoreCase("Custom" + (i + 1))) continue;
                this.settings.getSettings().setValue("gui", "custom" + (i + 1), this.customFields[i]);
            }
        }
    }

    public String[] getCustomFields() {
        return this.customFields;
    }

    @Override
    public void notifyOfProgress(long progress) {
        this.advanceProgress((int)(progress / 1024L));
    }
}

