/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoaderThread
extends UIThread {
    private Conf targetDBConf = null;
    private boolean combine;
    private ExpProfile multiProfileCombined = null;
    private List<ExpProfile> result = new ArrayList<ExpProfile>();
    private int index;

    public LoaderThread(Text log, ProgressBar progressBar, Label status, List<Profile> profs, boolean combine) throws SQLException {
        super(log, progressBar, status);
        this.objects = profs;
        this.combine = combine;
        this.index = 0;
        this.progressBar.setMaximum(this.objects.size());
    }

    @Override
    public void doFancyStuff(Object obj, StringBuffer messageLog) throws IOException {
        Profile profile = (Profile)obj;
        this.displayTitle(this.settings.msg("dialog.profileloader.reading", new Object[]{profile.getTitle()}));
        Conf conf = new Conf(profile, (DosboxVersion)this.dbversions.get(DosboxVersion.findById(this.dbversions, profile.getDbversionId())), this.ps);
        if (conf.getAutoexec().isIncomplete()) {
            throw new IOException(this.settings.msg("dialog.multiprofile.error.profileincomplete"));
        }
        if (this.combine) {
            ExpProfile expProfile = new ExpProfile(profile.getId(), conf, FileUtils.makeRelativeToDosroot(conf.getAutoexec().getCanonicalMainDir()), profile);
            if (this.result.isEmpty()) {
                this.multiProfileCombined = expProfile;
                this.targetDBConf = Conf.extractDBVersionConf(this.multiProfileCombined.getConf());
                this.result.add(expProfile);
            } else {
                Conf c = expProfile.getConf();
                boolean same = true;
                if (this.multiProfileCombined.getDbversionId() != expProfile.getDbversionId()) {
                    c.alterToDosboxVersionGeneration(this.targetDBConf);
                    same = false;
                }
                c = new Conf(this.multiProfileCombined.getConf(), c, same);
                this.multiProfileCombined = new ExpProfile(this.multiProfileCombined, expProfile, c);
                if (this.bos.size() == 0) {
                    this.result.add(expProfile);
                }
            }
        } else {
            this.result.add(new ExpProfile(this.index++, conf, FileUtils.makeRelativeToDosroot(conf.getAutoexec().getCanonicalMainDir()), profile));
        }
    }

    @Override
    public String getTitle(Object obj) {
        return ((Profile)obj).getTitle();
    }

    @Override
    public void preFinish() {
    }

    public List<ExpProfile> getResult() {
        return this.result;
    }

    public ExpProfile getMultiProfileCombined() {
        return this.multiProfileCombined;
    }
}

