/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.StringUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public abstract class UIThread
extends Thread {
    protected static final String PREFIX_OK = "  + ";
    protected static final String PREFIX_ERR = "  - ";
    protected final Settings settings = Settings.getInstance();
    protected List<?> objects;
    protected List<DosboxVersion> dbversions;
    protected ProgressBar progressBar;
    protected ByteArrayOutputStream bos;
    protected PrintStream ps;
    protected Database dbase;
    protected boolean extensiveLogging = false;
    private boolean everythingOk = true;
    private Text log;
    private Label status;
    private Display display;

    public UIThread(Text log, ProgressBar progressBar, Label status) throws SQLException {
        this.log = log;
        this.progressBar = progressBar;
        this.status = status;
        this.display = log.getShell().getDisplay();
        this.bos = new ByteArrayOutputStream();
        this.ps = new PrintStream(this.bos);
        this.dbase = Database.getInstance();
        this.dbversions = this.dbase.readDosboxVersionsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        for (Object o : this.objects) {
            final StringBuffer messageLog = new StringBuffer();
            try {
                if (this.extensiveLogging) {
                    messageLog.append(this.getTitle(o)).append(":\n");
                }
                this.dbase.startTransaction();
                this.doFancyStuff(o, messageLog);
                if (this.bos.size() > 0) {
                    if (!this.extensiveLogging) {
                        messageLog.append(this.getTitle(o));
                    }
                    messageLog.append(PREFIX_ERR).append(this.bos.toString());
                    this.bos.reset();
                }
                this.dbase.commitTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.extensiveLogging) {
                    messageLog.append(this.getTitle(o));
                }
                messageLog.append(PREFIX_ERR).append(StringUtils.toString(e)).append('\n');
                try {
                    this.dbase.rollbackTransaction();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                    if (!this.extensiveLogging) {
                        messageLog.append(this.getTitle(o));
                    }
                    messageLog.append(PREFIX_ERR).append(StringUtils.toString(se)).append('\n');
                }
                this.everythingOk = false;
            }
            finally {
                this.dbase.finishTransaction();
            }
            if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed() || this.status.isDisposed()) break;
            this.display.syncExec(new Runnable(){

                public void run() {
                    if (messageLog.length() > 0) {
                        String newOutput = messageLog.toString();
                        UIThread.this.log.append(newOutput);
                        System.out.print(newOutput);
                    }
                    UIThread.this.advanceProgress(1);
                }
            });
        }
        try {
            this.preFinish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.completeProgress();
    }

    public void displayTitle(final String title) {
        if (!this.display.isDisposed() && !this.status.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.status.setText(title);
                    UIThread.this.status.pack();
                }
            });
        }
    }

    private void completeProgress() {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.progressBar.setSelection(UIThread.this.progressBar.getMaximum());
                }
            });
        }
    }

    public void advanceProgress(final int increment) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.progressBar.setSelection(UIThread.this.progressBar.getSelection() + increment);
                }
            });
        }
    }

    public boolean isEverythingOk() {
        return this.everythingOk;
    }

    public abstract String getTitle(Object var1);

    public abstract void doFancyStuff(Object var1, StringBuffer var2) throws IOException, SQLException;

    public abstract void preFinish() throws IOException;
}

