/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Vector;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.UIThread;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class Wizard
extends Dialog {
    protected String dialogTitle;
    protected String dialog;
    protected int stepNr = 0;
    protected Vector<Control> steps;
    protected UIThread extensiveJobThread;
    protected boolean hasExtensiveJob;
    protected Composite wizardPanel;
    protected StackLayout wizardLayout;
    protected Button back;
    protected Button next;
    protected Button cancel;
    protected Shell shell;
    protected Settings settings = Settings.getInstance();
    protected Object result;

    public Wizard(Shell arg0, int arg1, String dialogTitle, String dialog, boolean hasExtensiveJob) {
        super(arg0, arg1);
        this.steps = new Vector();
        this.hasExtensiveJob = hasExtensiveJob;
        this.dialogTitle = dialogTitle;
        this.dialog = dialog;
    }

    protected final void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText(this.dialogTitle);
        this.shell.setLayout((Layout)new GridLayout(4, false));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, this.dialog));
        this.wizardPanel = new Composite((Composite)this.shell, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        this.wizardPanel.setLayoutData((Object)gd);
        this.wizardLayout = new StackLayout();
        this.wizardPanel.setLayout((Layout)this.wizardLayout);
        this.fillPages();
        this.back = new Button((Composite)this.shell, 8);
        this.back.setText(this.settings.msg("button.back"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.back.setLayoutData((Object)gridData);
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Wizard.this.previousStep();
            }
        });
        this.next = new Button((Composite)this.shell, 8);
        this.next.setText(this.settings.msg("button.next"));
        this.next.setLayoutData((Object)gridData);
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Wizard.this.nextStep();
            }
        });
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.widthHint = 80;
        gridData2.horizontalIndent = 10;
        this.cancel = new Button((Composite)this.shell, 8);
        this.cancel.setText(this.settings.msg("button.cancel"));
        this.cancel.setLayoutData((Object)new GridData());
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Wizard.this.shell.close();
            }
        });
        this.shell.setDefaultButton(this.next);
        this.showCurrentStep();
    }

    protected abstract void fillPages();

    public Object open() {
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (this.extensiveJobThread != null && !this.extensiveJobThread.isAlive() && !this.next.getEnabled()) {
                    this.nextStep();
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        this.onExit();
        return this.result;
    }

    protected boolean init() {
        return true;
    }

    protected void onExit() {
    }

    protected boolean isValidInput() {
        return true;
    }

    protected boolean actionAfterNext() {
        return true;
    }

    protected int stepSize(boolean up) {
        return 1;
    }

    protected final boolean isFinished() {
        if (this.hasExtensiveJob) {
            return this.stepNr >= this.steps.size() + 1 && this.extensiveJobThread != null && !this.extensiveJobThread.isAlive();
        }
        return this.stepNr >= this.steps.size() - 1;
    }

    protected final void nextStep() {
        if (this.isValidInput() && this.actionAfterNext()) {
            if (this.isFinished()) {
                this.shell.close();
            } else {
                this.stepNr += this.stepSize(true);
                this.showCurrentStep();
            }
        }
    }

    protected final void previousStep() {
        this.stepNr -= this.stepSize(false);
        this.showCurrentStep();
    }

    protected final void showCurrentStep() {
        if (this.stepNr < this.steps.size()) {
            this.wizardLayout.topControl = this.steps.get(this.stepNr);
            this.wizardPanel.layout();
        }
        boolean jobReady = this.extensiveJobThread != null;
        boolean jobFinished = this.isFinished();
        this.back.setEnabled(this.stepNr > 0 && !jobReady);
        this.next.setEnabled(!jobReady || jobFinished);
        this.cancel.setEnabled(!jobReady);
        this.next.setText(jobFinished ? this.settings.msg("button.finish") : this.settings.msg("button.next"));
        if (this.stepNr > 0) {
            this.wizardLayout.topControl.setFocus();
        }
        if (jobReady && !jobFinished) {
            this.extensiveJobThread.start();
        }
    }

    protected final void addStep(Control c) {
        c.setParent(this.wizardPanel);
        this.steps.addElement(c);
    }
}

