/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZipEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.ProgressNotifyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SevenzipExtractFilesCallback
implements IArchiveExtractCallback {
    private ProgressNotifyable prog;
    private IInArchive archiveHandler;
    private Map<Integer, File> dstFileMap = new TreeMap<Integer, File>();

    public SevenzipExtractFilesCallback(ProgressNotifyable prog, IInArchive archiveHandler, Map<Integer, File> dstFileMap) {
        this.prog = prog;
        this.archiveHandler = archiveHandler;
        this.dstFileMap = dstFileMap;
    }

    public int SetTotal(long size) {
        return 0;
    }

    public int SetCompleted(long completeValue) {
        this.prog.setProgress((int)(completeValue / 1024L));
        return 0;
    }

    public int PrepareOperation(int askExtractMode) {
        return 0;
    }

    public int SetOperationResult(int operationResult) throws IOException {
        switch (operationResult) {
            case 0: {
                return 0;
            }
            case 1: {
                throw new IOException("Unsupported Method");
            }
            case 3: {
                throw new IOException("CRC Failed");
            }
            case 2: {
                throw new IOException("Data Error");
            }
        }
        throw new IOException("Unknown Error");
    }

    public int GetStream(int index, OutputStream[] outStream, int askExtractMode) throws IOException {
        outStream[0] = null;
        if (askExtractMode == 0) {
            SevenZipEntry entry = this.archiveHandler.getEntry(index);
            File dstFile = this.dstFileMap.get(index);
            if (entry.isDirectory()) {
                if (dstFile.isDirectory()) {
                    return 0;
                }
                if (dstFile.mkdirs()) {
                    return 0;
                }
                return 1;
            }
            File dirAbove = dstFile.getParentFile();
            if (dirAbove != null && !dirAbove.isDirectory() && !dirAbove.mkdirs()) {
                return 1;
            }
            if (dstFile.exists()) {
                throw new IOException(Settings.getInstance().msg("general.error.filetobeextractedexists", new Object[]{dstFile}));
            }
            outStream[0] = new FileOutputStream(dstFile);
        }
        return 0;
    }
}

