/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.nio.ByteBuffer;
import org.dbgl.loopy.util.LittleEndian;
import org.dbgl.waldheinz.fs.fat.ShortName;

public final class FatDirectoryEntry {
    public static final int SIZE = 32;
    private static final int OFFSET_ATTRIBUTES = 11;
    private static final int OFFSET_FILE_SIZE = 28;
    private static final int F_READONLY = 1;
    private static final int F_HIDDEN = 2;
    private static final int F_SYSTEM = 4;
    private static final int F_VOLUME_ID = 8;
    private static final int F_DIRECTORY = 16;
    private static final int F_ARCHIVE = 32;
    public static final int ENTRY_DELETED_MAGIC = 229;
    private final byte[] data;

    FatDirectoryEntry(byte[] data) {
        this.data = data;
    }

    public static FatDirectoryEntry read(ByteBuffer buff) {
        assert (buff.remaining() >= 32);
        if (buff.get(buff.position()) == 0) {
            return null;
        }
        byte[] data = new byte[32];
        buff.get(data);
        return new FatDirectoryEntry(data);
    }

    public boolean isVolumeLabel() {
        if (this.isLfnEntry()) {
            return false;
        }
        return (this.getFlags() & 0x18) == 8;
    }

    public boolean isSystemFlag() {
        return (this.getFlags() & 4) != 0;
    }

    public boolean isArchiveFlag() {
        return (this.getFlags() & 0x20) != 0;
    }

    public boolean isHiddenFlag() {
        return (this.getFlags() & 2) != 0;
    }

    public boolean isReadonlyFlag() {
        return (this.getFlags() & 1) != 0;
    }

    public boolean isVolumeIdFlag() {
        return (this.getFlags() & 8) != 0;
    }

    public boolean isLfnEntry() {
        return this.isReadonlyFlag() && this.isSystemFlag() && this.isHiddenFlag() && this.isVolumeIdFlag();
    }

    private int getFlags() {
        return LittleEndian.getUInt8(this.data, 11);
    }

    public boolean isDirectory() {
        return (this.getFlags() & 0x18) == 16;
    }

    public boolean isDeleted() {
        return LittleEndian.getUInt8(this.data, 0) == 229;
    }

    public long getLength() {
        return LittleEndian.getUInt32(this.data, 28);
    }

    public ShortName getShortName() {
        if (this.data[0] == 0) {
            return null;
        }
        return new ShortName(this.data);
    }

    public boolean isFile() {
        return (this.getFlags() & 0x18) == 0;
    }

    public long getStartCluster() {
        return LittleEndian.getUInt16(this.data, 26);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.getShortName() + "]";
    }

    String getLfnPart() {
        int end;
        char[] unicodechar = new char[]{(char)LittleEndian.getUInt16(this.data, 1), (char)LittleEndian.getUInt16(this.data, 3), (char)LittleEndian.getUInt16(this.data, 5), (char)LittleEndian.getUInt16(this.data, 7), (char)LittleEndian.getUInt16(this.data, 9), (char)LittleEndian.getUInt16(this.data, 14), (char)LittleEndian.getUInt16(this.data, 16), (char)LittleEndian.getUInt16(this.data, 18), (char)LittleEndian.getUInt16(this.data, 20), (char)LittleEndian.getUInt16(this.data, 22), (char)LittleEndian.getUInt16(this.data, 24), (char)LittleEndian.getUInt16(this.data, 28), (char)LittleEndian.getUInt16(this.data, 30)};
        for (end = 0; end < 13 && unicodechar[end] != '\u0000'; ++end) {
        }
        return new String(unicodechar).substring(0, end);
    }
}

