/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import org.dbgl.waldheinz.fs.fat.FatDirectoryEntry;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectory;

public final class FatLfnDirectoryEntry {
    final FatDirectoryEntry realEntry;
    private FatLfnDirectory parent;
    private String fileName;

    FatLfnDirectoryEntry(FatLfnDirectory parent, FatDirectoryEntry realEntry, String fileName) {
        this.parent = parent;
        this.realEntry = realEntry;
        this.fileName = fileName;
    }

    static FatLfnDirectoryEntry extract(FatLfnDirectory dir, int offset, int len) {
        String fileName;
        FatDirectoryEntry realEntry = dir.dir.getEntry(offset + len - 1);
        if (len == 1) {
            fileName = realEntry.getShortName().asSimpleString();
        } else {
            StringBuilder name = new StringBuilder(13 * (len - 1));
            for (int i = len - 2; i >= 0; --i) {
                FatDirectoryEntry entry = dir.dir.getEntry(i + offset);
                name.append(entry.getLfnPart());
            }
            fileName = name.toString().trim();
        }
        return new FatLfnDirectoryEntry(dir, realEntry, fileName);
    }

    public boolean isHiddenFlag() {
        return this.realEntry.isHiddenFlag();
    }

    public boolean isSystemFlag() {
        return this.realEntry.isSystemFlag();
    }

    public boolean isReadOnlyFlag() {
        return this.realEntry.isReadonlyFlag();
    }

    public boolean isArchiveFlag() {
        return this.realEntry.isArchiveFlag();
    }

    public String getName() {
        return this.fileName;
    }

    public String getShortName() {
        return this.realEntry.getShortName().asSimpleString();
    }

    public FatLfnDirectory getDirectory() throws IOException {
        return this.parent.getDirectory(this.realEntry);
    }

    public String toString() {
        return "LFN = " + this.fileName + " / SFN = " + this.realEntry.getShortName();
    }

    public boolean isFile() {
        return this.realEntry.isFile();
    }

    public boolean isDirectory() {
        return this.realEntry.isDirectory();
    }
}

