/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.dbgl.gui.BrowseArchiveDialog;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class BrowseButton {
    private final Button button;
    private Settings settings = Settings.getInstance();

    public BrowseButton(Composite composite, int style) {
        this.button = GeneralPurposeGUI.createIconButton(composite, style, this.settings, this.settings.msg("button.browse"), "folder.png");
    }

    public void connect(Shell shell, Text control, Text altControl, BrowseType browse, CanonicalType canon, boolean save, Combo combo) {
        this.button.addSelectionListener((SelectionListener)new Sa(shell, control, altControl, browse, canon, save, combo));
    }

    public void setLayoutData(Object arg0) {
        this.button.setLayoutData(arg0);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    private class Sa
    extends SelectionAdapter {
        private final Text field;
        private final Text alt;
        private final BrowseType browse;
        private final CanonicalType canon;
        private final boolean save;
        private final Combo combo;
        private final Shell shell;

        public Sa(Shell shell, Text control, Text altControl, BrowseType browse, CanonicalType canon, boolean save, Combo combo) {
            this.shell = shell;
            this.field = control;
            this.alt = altControl;
            this.browse = browse;
            this.canon = canon;
            this.save = save;
            this.combo = combo;
        }

        private String filterPath() {
            String path = this.field.getText();
            CanonicalType fileType = this.canon;
            if (path.equals("") && this.alt != null) {
                path = this.alt.getText();
                if (fileType == CanonicalType.DOC) {
                    fileType = CanonicalType.DOSROOT;
                }
            } else if (this.browse == BrowseType.DIR && fileType == CanonicalType.NONE) {
                fileType = CanonicalType.DOSROOT;
            }
            switch (fileType) {
                case DOC: 
                case DBGLZIP: 
                case NATIVE_EXE: {
                    return FileUtils.canonicalToData(path).getPath();
                }
                case EXE: 
                case INSTALLER: 
                case ZIP: 
                case BOOTER: 
                case DOSROOT: {
                    return FileUtils.canonicalToDosroot(path).getPath();
                }
                case DOSBOX: 
                case DOSBOXCONF: {
                    return FileUtils.canonicalToDosbox(path).getPath();
                }
                case DFEND: {
                    return PlatformUtils.DFEND_PATH;
                }
                case CDIMAGE: {
                    String[] fPaths = StringRelatedUtils.textAreaToStringArray(this.field.getText(), this.field.getLineDelimiter());
                    if (fPaths.length > 0) {
                        return FileUtils.canonicalToDosroot(fPaths[0]).getPath();
                    }
                    return FileUtils.getDosRoot();
                }
            }
            return "";
        }

        private String getResult(String result, File filterPath, String[] filenames) {
            switch (this.canon) {
                case DOC: 
                case DBGLZIP: 
                case NATIVE_EXE: {
                    return FileUtils.makeRelativeToData(new File(result)).getPath();
                }
                case EXE: 
                case INSTALLER: {
                    if (FileUtils.isArchive(result) || FileUtils.isIsoFile(result) || FileUtils.isFatImage(result)) {
                        BrowseArchiveDialog dialog = new BrowseArchiveDialog(this.shell, 4096);
                        dialog.setFileToBrowse(result);
                        String choice = (String)dialog.open();
                        return choice == null ? null : FileUtils.makeRelativeToDosroot(new File(choice)).getPath();
                    }
                }
                case ZIP: 
                case BOOTER: 
                case DOSROOT: {
                    return FileUtils.makeRelativeToDosroot(new File(result)).getPath();
                }
                case DOSBOX: 
                case DOSBOXCONF: {
                    return FileUtils.makeRelativeToDosbox(new File(result)).getPath();
                }
                case CDIMAGE: {
                    File path = FileUtils.makeRelativeToDosroot(filterPath);
                    StringBuffer images = new StringBuffer();
                    for (String file : filenames) {
                        images.append(new File(path, file)).append(this.field.getLineDelimiter());
                    }
                    return images.toString();
                }
            }
            return result;
        }

        public void widgetSelected(SelectionEvent event) {
            String result = null;
            File filterPath = null;
            String[] filenames = null;
            this.shell.setEnabled(false);
            String rawFilterPath = this.filterPath();
            File fpath = new File(rawFilterPath);
            if (fpath != null && !fpath.isDirectory()) {
                fpath = fpath.getParentFile();
            }
            if (this.browse == BrowseType.DIR) {
                DirectoryDialog dialog = new DirectoryDialog(this.shell);
                if (fpath != null) {
                    dialog.setFilterPath(fpath.getPath());
                }
                result = dialog.open();
            } else if (this.browse == BrowseType.FILE && (this.canon == CanonicalType.EXE || this.canon == CanonicalType.INSTALLER) && (FileUtils.isArchive(rawFilterPath) || FileUtils.isIsoFile(rawFilterPath) || FileUtils.isFatImage(rawFilterPath))) {
                result = rawFilterPath;
            } else if (this.browse == BrowseType.FILE) {
                int style;
                int n = style = this.canon == CanonicalType.CDIMAGE ? 4098 : 4096;
                if (this.save) {
                    style = 8192;
                }
                FileDialog dialog = new FileDialog(this.shell, style);
                if (fpath != null) {
                    dialog.setFilterPath(fpath.getPath());
                }
                String[] filterNames = null;
                String[] filterExts = null;
                switch (this.canon) {
                    case DOC: {
                        filterNames = new String[]{"*"};
                        filterExts = new String[]{"*"};
                        break;
                    }
                    case EXE: 
                    case INSTALLER: {
                        boolean supportsPhysFS = this.combo != null && this.combo.isEnabled();
                        ArrayList<String> fNames = new ArrayList<String>();
                        ArrayList<String> fExts = new ArrayList<String>();
                        fNames.add(BrowseButton.this.settings.msg("filetype.applicable"));
                        fExts.add("*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;" + (supportsPhysFS ? ";*.zip;*.ZIP;*.7z;*.7Z" : ""));
                        Collections.addAll(fNames, BrowseButton.this.settings.msg("filetype.exe"), BrowseButton.this.settings.msg("filetype.cdimage"), BrowseButton.this.settings.msg("filetype.floppyimage"), BrowseButton.this.settings.msg("filetype.archive"), "*");
                        Collections.addAll(fExts, "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*.zip;*.ZIP;*.7z;*.7Z", "*");
                        filterNames = fNames.toArray(new String[0]);
                        filterExts = fExts.toArray(new String[0]);
                        break;
                    }
                    case NATIVE_EXE: {
                        String defFilterTitleNative = BrowseButton.this.settings.msg("filetype.native_exe");
                        String defaultFilterNative = PlatformUtils.NATIVE_EXE_FILTER;
                        filterNames = new String[]{defFilterTitleNative, "*"};
                        filterExts = new String[]{defaultFilterNative, "*"};
                        break;
                    }
                    case ZIP: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.archive"), "*"};
                        filterExts = new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*"};
                        break;
                    }
                    case DBGLZIP: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.gamepack"), "*"};
                        filterExts = new String[]{"*.dbgl.zip;*.DBGL.ZIP", "*"};
                        break;
                    }
                    case BOOTER: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.booterimage"), "*"};
                        filterExts = new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"};
                        break;
                    }
                    case DFEND: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.dfendprofile")};
                        filterExts = new String[]{"Profiles.dat"};
                        break;
                    }
                    case CDIMAGE: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.applicable"), BrowseButton.this.settings.msg("filetype.cdimage"), BrowseButton.this.settings.msg("filetype.floppyimage"), "*"};
                        filterExts = new String[]{"*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*"};
                        break;
                    }
                    case DOSBOXCONF: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.conf"), "*"};
                        filterExts = new String[]{"*.conf;*.CONF", "*"};
                        break;
                    }
                }
                if (filterNames != null) {
                    dialog.setFilterNames(filterNames);
                }
                if (filterExts != null) {
                    dialog.setFilterExtensions(filterExts);
                }
                if (this.canon == CanonicalType.DFEND) {
                    dialog.setFileName("Profiles.dat");
                }
                result = dialog.open();
                if (this.canon == CanonicalType.CDIMAGE) {
                    filterPath = new File(dialog.getFilterPath());
                    filenames = dialog.getFileNames();
                }
            }
            if (result != null && (result = this.getResult(result, filterPath, filenames)) != null) {
                String dir;
                this.field.setText(result);
                if (this.canon == CanonicalType.DOSBOX && this.alt != null) {
                    this.alt.setText(FileUtils.constructRelativeDBConfLocation(result).getPath());
                } else if (this.canon == CanonicalType.CDIMAGE && this.combo != null) {
                    if (FileUtils.isIsoFile((String)filenames[0])) {
                        this.combo.setText("iso");
                    } else if (FileUtils.isFatImage((String)filenames[0])) {
                        this.combo.setText("floppy");
                    }
                } else if (this.canon == CanonicalType.NATIVE_EXE && this.alt != null && (dir = FileUtils.makeRelativeToData(FileUtils.canonicalToData(result).getParentFile()).getPath()) != null) {
                    this.alt.setText(dir);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (this.shell.getDisplay().readAndDispatch()) {
            }
            this.shell.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CanonicalType {
        DOSROOT,
        DFEND,
        CDIMAGE,
        ZIP,
        DBGLZIP,
        DOSBOX,
        DOSBOXCONF,
        DOC,
        BOOTER,
        EXE,
        INSTALLER,
        NATIVE_EXE,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BrowseType {
        DIR,
        FILE;

    }
}

