/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GalleryItemRenderer;
import org.dbgl.gui.MainWindow;
import org.dbgl.gui.listeners.MeasureListener;
import org.dbgl.gui.listeners.PaintListener;
import org.dbgl.gui.listeners.ToolTipListener;
import org.dbgl.interfaces.ReOrderable;
import org.dbgl.model.ThumbInfo;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ProfilesList {
    private final Image topdog;
    private ProfilesListType type;
    private Gallery gallery;
    private GalleryItem group;
    private Color bgColor;
    private Table table;
    private static final Listener paintListener = new PaintListener();
    private static final Listener measureListener = new MeasureListener();
    private static final Listener toolTipOpenListener = new ToolTipListener();
    private static final SectionsWrapper ssettings = Settings.getInstance().getSettings();

    public ProfilesList(Composite composite, ProfilesListType type) {
        this(composite, type, null, null, null);
    }

    public ProfilesList(Composite composite, ProfilesListType type, ReOrderable reOrderable, int[] columnIds, String[] columnNames) {
        this.type = type;
        this.topdog = SWTImageManager.getResourceImage(composite.getShell().getDisplay(), "topdog.png");
        if (type == ProfilesListType.TABLE) {
            int i;
            this.table = new Table(composite, 67586);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            for (i = 0; i < columnIds.length; ++i) {
                this.addProfileColumn(reOrderable, columnIds, columnNames[columnIds[i]], i);
            }
            this.table.setSortColumn(this.table.getColumn(this.findColumnById(columnIds, ssettings.getIntValues("gui", "sortcolumn")[0])));
            this.table.setSortDirection(ssettings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
            this.table.setColumnOrder(ssettings.getIntValues("gui", "columnorder"));
            for (i = 0; i < columnIds.length; ++i) {
                if (columnIds[i] != 20) continue;
                this.table.setData((Object)i);
                this.table.addListener(42, paintListener);
                this.table.addListener(41, measureListener);
            }
        } else {
            this.gallery = new Gallery(composite, 2562);
            this.gallery.setAntialias(0);
            this.gallery.setLowQualityOnUserAction(true);
            this.gallery.setHigherQualityDelay(100);
            int[] rgb = ssettings.getIntValues("gui", "gallerybackgroundcolor");
            if (rgb.length == 3) {
                this.bgColor = new Color((Device)composite.getShell().getDisplay(), rgb[0], rgb[1], rgb[2]);
                this.gallery.setBackground(this.bgColor);
            }
            NoGroupRenderer gr = new NoGroupRenderer();
            switch (type) {
                case LARGE_TILES: {
                    gr.setItemSize(ssettings.getIntValue("gui", "large_tile_width"), ssettings.getIntValue("gui", "large_tile_height"));
                    break;
                }
                case MEDIUM_TILES: {
                    gr.setItemSize(ssettings.getIntValue("gui", "medium_tile_width"), ssettings.getIntValue("gui", "medium_tile_height"));
                    break;
                }
                case SMALL_TILES: {
                    gr.setItemSize(ssettings.getIntValue("gui", "small_tile_width"), ssettings.getIntValue("gui", "small_tile_height"));
                    break;
                }
                case LARGE_BOXES: {
                    gr.setItemSize(ssettings.getIntValue("gui", "large_box_width"), ssettings.getIntValue("gui", "large_box_height"));
                    break;
                }
                case MEDIUM_BOXES: {
                    gr.setItemSize(ssettings.getIntValue("gui", "medium_box_width"), ssettings.getIntValue("gui", "medium_box_height"));
                    break;
                }
                case SMALL_BOXES: {
                    gr.setItemSize(ssettings.getIntValue("gui", "small_box_width"), ssettings.getIntValue("gui", "small_box_height"));
                    break;
                }
            }
            gr.setAutoMargin(true);
            gr.setMinMargin(1);
            this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
            GalleryItemRenderer ir = new GalleryItemRenderer(ssettings.getValue("gui", "tile_title_trunc_pos"));
            this.gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
            this.group = new GalleryItem(this.gallery, 0);
            this.gallery.addListener(12, toolTipOpenListener);
            this.gallery.addListener(1, toolTipOpenListener);
            this.gallery.addListener(5, toolTipOpenListener);
            this.gallery.addListener(37, toolTipOpenListener);
            this.gallery.addListener(32, toolTipOpenListener);
            this.gallery.addListener(42, paintListener);
        }
    }

    private int findColumnById(int[] columnIds, int id) {
        for (int i = 0; i < columnIds.length; ++i) {
            if (columnIds[i] != id) continue;
            return i;
        }
        return -1;
    }

    private void addProfileColumn(final ReOrderable reOrderable, int[] columnIds, String title, final int colIndex) {
        final String width = "column" + (columnIds[colIndex] + 1) + "width";
        final TableColumn column = new TableColumn(this.table, 0);
        column.setWidth(ssettings.getIntValue("gui", width));
        column.setMoveable(true);
        column.setText(title);
        if (columnIds[colIndex] == 8 || columnIds[colIndex] == 9 || columnIds[colIndex] == 18 || columnIds[colIndex] == 19) {
            column.setAlignment(131072);
        }
        if (columnIds[colIndex] == 20) {
            column.setAlignment(0x1000000);
        }
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableColumn sortColumn = ProfilesList.this.table.getSortColumn();
                TableColumn currentColumn = (TableColumn)event.widget;
                int dir = ProfilesList.this.table.getSortDirection();
                if (sortColumn.equals(currentColumn)) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    ProfilesList.this.table.setSortColumn(currentColumn);
                    dir = 128;
                }
                ProfilesList.this.table.setSortDirection(dir);
                reOrderable.doReorder(colIndex, dir);
            }
        });
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ssettings.setIntValue("gui", width, column.getWidth());
            }

            public void controlMoved(ControlEvent event) {
                if (event.time != 0) {
                    ssettings.setIntValues("gui", "columnorder", ProfilesList.this.table.getColumnOrder());
                }
            }
        });
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addMouseListener((MouseListener)mouseAdapter);
        } else {
            this.gallery.addMouseListener((MouseListener)mouseAdapter);
        }
    }

    public void addKeyListener(KeyAdapter keyAdapter) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addKeyListener((KeyListener)keyAdapter);
        } else {
            this.gallery.addKeyListener((KeyListener)keyAdapter);
        }
    }

    public void addTraverseListener(TraverseListener travListener) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addTraverseListener(travListener);
        } else {
            this.gallery.addTraverseListener(travListener);
        }
    }

    public void addSelectionListener(SelectionAdapter selectProfAdapter) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addSelectionListener((SelectionListener)selectProfAdapter);
        } else {
            this.gallery.addSelectionListener((SelectionListener)selectProfAdapter);
        }
    }

    public void setFocus() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setFocus();
        } else {
            this.gallery.setFocus();
        }
    }

    public void setRedraw(boolean b) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setRedraw(b);
        } else {
            this.gallery.setRedraw(b);
        }
    }

    public void redraw() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.redraw();
        } else {
            this.gallery.redraw();
        }
    }

    public void setMenu(Menu menu) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setMenu(menu);
        } else {
            this.gallery.setMenu(menu);
        }
    }

    public int getSelectionCount() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getSelectionCount();
        }
        return this.gallery.getSelectionCount();
    }

    public int getSelectionIndex() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getSelectionIndex();
        }
        GalleryItem[] items = this.gallery.getSelection();
        if (items.length == 0) {
            return -1;
        }
        return this.group.indexOf(items[0]);
    }

    public int[] getSelectionIndices() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getSelectionIndices();
        }
        GalleryItem[] items = this.gallery.getSelection();
        if (items.length == 0) {
            return new int[0];
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (GalleryItem i : items) {
            int index = this.group.indexOf(i);
            if (index == -1) continue;
            indices.add(index);
        }
        return ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0]));
    }

    public void setSelection(int index) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setSelection(index);
        } else {
            GalleryItem item = this.group.getItem(index);
            if (item != null) {
                this.gallery.setSelection(new GalleryItem[]{item});
            }
        }
    }

    public void setSelection(int[] indices) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setSelection(indices);
        } else {
            ArrayList<GalleryItem> items = new ArrayList<GalleryItem>();
            for (int index : indices) {
                GalleryItem item = this.group.getItem(index);
                if (item == null) continue;
                items.add(item);
            }
            this.gallery.setSelection(items.toArray(new GalleryItem[0]));
        }
    }

    public int getItemCount() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getItemCount();
        }
        return this.group.getItemCount();
    }

    public ProfilesListItem getItem(int index) {
        if (this.type == ProfilesListType.TABLE) {
            return new ProfilesListItem(this.table.getItem(index));
        }
        return new ProfilesListItem(this.group.getItem(index));
    }

    public void removeAll() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.removeAll();
        } else {
            this.gallery.removeAll();
            this.group = new GalleryItem(this.gallery, 0);
        }
    }

    public void remove(int index) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.remove(index);
        } else {
            this.group.remove(index);
        }
    }

    public void selectAll() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.selectAll();
        } else {
            this.group.selectAll();
        }
    }

    public ProfilesListItem[] getItems() {
        if (this.type == ProfilesListType.TABLE) {
            ArrayList<ProfilesListItem> items = new ArrayList<ProfilesListItem>();
            for (TableItem item : this.table.getItems()) {
                items.add(new ProfilesListItem(item));
            }
            return items.toArray(new ProfilesListItem[0]);
        }
        ArrayList<ProfilesListItem> items = new ArrayList<ProfilesListItem>();
        for (GalleryItem item : this.group.getItems()) {
            items.add(new ProfilesListItem(item));
        }
        return items.toArray(new ProfilesListItem[0]);
    }

    public Control getControl() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table;
        }
        return this.gallery;
    }

    public void dispose() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.removeListener(42, paintListener);
            this.table.removeListener(41, measureListener);
            this.table.dispose();
        } else {
            this.gallery.removeListener(1, toolTipOpenListener);
            this.gallery.removeListener(5, toolTipOpenListener);
            this.gallery.removeListener(37, toolTipOpenListener);
            this.gallery.removeListener(32, toolTipOpenListener);
            this.gallery.removeListener(42, paintListener);
            this.gallery.dispose();
            if (this.bgColor != null) {
                this.bgColor.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfilesListType {
        TABLE,
        SMALL_TILES,
        MEDIUM_TILES,
        LARGE_TILES,
        SMALL_BOXES,
        MEDIUM_BOXES,
        LARGE_BOXES;

    }

    public class ProfilesListItem {
        GalleryItem gItem;
        TableItem tItem;

        public ProfilesListItem(ProfilesList list) {
            if (list.type == ProfilesListType.TABLE) {
                this.tItem = new TableItem(list.table, 2048);
            } else {
                this.gItem = new GalleryItem(list.group, 0);
            }
        }

        public ProfilesListItem(TableItem item) {
            this.tItem = item;
        }

        public ProfilesListItem(GalleryItem item) {
            this.gItem = item;
        }

        public Object getData() {
            if (this.tItem != null) {
                return this.tItem.getData();
            }
            return this.gItem.getData();
        }

        public void setData(Object obj) {
            if (this.tItem != null) {
                this.tItem.setData(obj);
            } else {
                this.gItem.setData(obj);
            }
        }

        public void resetCachedInfo() {
            ThumbInfo thumbInfo = (ThumbInfo)this.getData();
            thumbInfo.resetCachedInfo();
            this.setData(thumbInfo);
            if (this.gItem != null) {
                this.gItem.setImage(null);
            }
        }

        public void setText(int i, int columnId, String value) {
            if (this.tItem != null) {
                this.tItem.setText(i, value);
            } else {
                if (i == 0) {
                    this.gItem.setText(1, "");
                }
                if (columnId == 0) {
                    this.gItem.setText(value);
                }
                if (columnId == 7) {
                    this.gItem.setData("org.eclipse.nebula.widget.gallery.bottomLeftOverlay", value.equals(Settings.getInstance().msg("general.yes")) ? ProfilesList.this.topdog : null);
                }
                if (StringUtils.isEmpty((CharSequence)value)) {
                    return;
                }
                StringBuffer s = new StringBuffer(this.gItem.getText(1));
                if (!StringUtils.isEmpty((CharSequence)s)) {
                    s.append('\n');
                }
                s.append(MainWindow.columnNames[columnId]).append(": ").append(value);
                this.gItem.setText(1, s.toString());
            }
        }
    }
}

