/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.List;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpTemplate
extends Template
implements Configurable {
    private Conf conf;
    private String importedFullConfig;
    private String importedIncrConfig;
    private List<NativeCommand> nativeCommandsList;

    public ExpTemplate(Conf conf, List<NativeCommand> nativeCommands) {
        super(-1, null, -1, false);
        this.conf = conf;
        this.nativeCommandsList = nativeCommands;
    }

    public ExpTemplate(int id, Conf conf, Template template) {
        super(id, template);
        this.conf = conf;
    }

    public ExpTemplate(Element n, int dbversionIndex) {
        super(-1, XmlUtils.getTextValue(n, "title"), dbversionIndex, false);
        this.importedFullConfig = XmlUtils.getTextValue(n, "full-configuration");
        this.importedIncrConfig = XmlUtils.getTextValue(n, "incremental-configuration");
    }

    public void setDbversionId(int id) {
        this.dbversionId = id;
    }

    public String getImportedFullConfig() {
        return this.importedFullConfig;
    }

    public String getImportedIncrConfig() {
        return this.importedIncrConfig;
    }

    @Override
    public Conf getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Conf conf) {
        this.conf = conf;
    }

    public Element getXml(Document xmldoc, List<DosboxVersion> dbversionsList) {
        Element profEmt = xmldoc.createElement("template");
        XmlUtils.addCDataElement(xmldoc, profEmt, "title", this.getTitle());
        if (this.conf != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "full-configuration", XmlUtils.cleanEolnForXml(this.conf.toFullConfString(false)));
            XmlUtils.addCDataElement(xmldoc, profEmt, "incremental-configuration", XmlUtils.cleanEolnForXml(this.conf.toIncrConfString(false)));
        }
        DosboxVersion dbv = DosboxVersion.findById(dbversionsList, this.getDbversionId());
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addCDataElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        profEmt.appendChild(dosbox);
        return profEmt;
    }

    @Override
    public List<NativeCommand> getNativeCommandsList() {
        return this.nativeCommandsList;
    }

    @Override
    public void setNativeCommandsList(List<NativeCommand> nativeCommandsList) {
        this.nativeCommandsList = nativeCommandsList;
    }
}

