/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeCommand {
    private File command;
    private String parameters;
    private File cwd;
    private boolean waitFor;
    private int orderNr;

    public NativeCommand(File command, String parameters, File cwd, boolean waitFor, int orderNr) {
        this.command = command;
        this.parameters = parameters;
        this.cwd = cwd;
        this.waitFor = waitFor;
        this.orderNr = orderNr;
    }

    public File getCommand() {
        return this.command;
    }

    public String getParameters() {
        return this.parameters;
    }

    public File getCwd() {
        return this.cwd;
    }

    public File getCwdCanToData() {
        return FileUtils.canonicalToData(this.cwd.getPath());
    }

    public boolean isWaitFor() {
        return this.waitFor;
    }

    public int getOrderNr() {
        return this.orderNr;
    }

    public List<String> getExecCommandsCanToData() {
        ArrayList<String> execCommands = new ArrayList<String>();
        execCommands.add(FileUtils.canonicalToData(this.command.getPath()).getPath());
        if (this.parameters.length() > 0) {
            for (String p : this.parameters.split(" ")) {
                execCommands.add(p);
            }
        }
        return execCommands;
    }

    public String toString() {
        if (this.command == null) {
            return "-- DOSBox --";
        }
        StringBuilder s = new StringBuilder(this.command.getPath());
        if (StringUtils.isNotEmpty((CharSequence)this.parameters)) {
            s.append(' ').append(this.parameters);
        }
        if (!this.cwd.getPath().equals(this.command.getParent())) {
            s.append(", ").append(this.cwd.getPath());
        }
        if (this.waitFor) {
            s.append(", ").append(Settings.getInstance().msg("dialog.nativecommand.waitfor"));
        }
        return s.toString();
    }

    public static void insertDosboxCommand(List<NativeCommand> nativeCommandsList) {
        int dosboxNr = 0;
        for (int i = 0; i < nativeCommandsList.size(); ++i) {
            if (nativeCommandsList.get(i).getOrderNr() != i) continue;
            ++dosboxNr;
        }
        nativeCommandsList.add(dosboxNr, new NativeCommand(null, null, null, true, dosboxNr));
    }
}

