/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class MigrateThread
extends UIThread {
    private final File from;

    public MigrateThread(Text log, ProgressBar progressBar, Label status, File from) throws SQLException {
        super(log, progressBar, status);
        this.from = from;
        this.objects = this.dbase.readProfilesList(" ORDER BY LOWER(GAM.TITLE)", null);
        this.progressBar.setMaximum(this.objects.size());
    }

    public void doFancyStuff(Object obj, StringBuffer messageLog) throws IOException, SQLException {
        File newFile;
        Profile prof = (Profile)obj;
        this.displayTitle(this.settings.msg("dialog.migration.migrating", new Object[]{prof.getTitle()}));
        File file = prof.getCanonicalConfFile();
        DosboxVersion assocDBVersion = (DosboxVersion)DosboxVersion.findById(this.dbversions, prof.getDbversionId());
        Conf profileConf = new Conf(prof, assocDBVersion, this.ps);
        profileConf.getAutoexec().migrateToDosroot(this.from, false);
        profileConf.save();
        String newConfigPath = prof.getConfPathAndFile();
        if (new File(prof.getConfPathAndFile()).isAbsolute() && !(newFile = FileUtils.makeRelativeTo(file, this.from)).isAbsolute()) {
            newConfigPath = FileUtils.DOSROOT_DIR + newFile.getPath();
        }
        this.dbase.updateProfileConf(newConfigPath, prof.getCaptures(), prof.getId());
        String[] setup = prof.getSetup();
        for (int i = 0; i < setup.length; ++i) {
            if (setup[i].length() <= 0) continue;
            setup[i] = FileUtils.makeRelativeTo(new File(setup[i]), this.from).getPath();
        }
        String[] links = prof.getLinks();
        for (int i = 0; i < links.length; ++i) {
            File newFile2;
            if (links[i].toLowerCase().startsWith("file://")) {
                links[i] = links[i].substring(7);
            }
            if (links[i].equals("") || links[i].contains("://") || (newFile2 = FileUtils.makeRelativeTo(new File(links[i]), this.from)).isAbsolute() || newFile2.getPath().startsWith(FileUtils.DOSROOT_DIR)) continue;
            links[i] = FileUtils.DOSROOT_DIR + newFile2.getPath();
        }
        this.dbase.updateProfileSetupAndLinks(setup, links, prof.getId());
    }

    public String getTitle(Object obj) {
        return ((Profile)obj).getTitle();
    }

    public void preFinish() {
    }
}

