/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.StreamGobbler;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.SearchResult;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.program.Program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformUtils {
    private static final String DEFAULT_DOSBOX_DIR = "DOSBox-" + DosboxVersion.LATEST;
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JVM_ARCH = System.getProperty("sun.arch.data.model");
    public static final String JVM_VERSION = System.getProperty("java.version");
    public static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean IS_LINUX = OS_NAME.startsWith("Linux");
    public static final boolean IS_OSX = OS_NAME.startsWith("Mac OS");
    public static final String OSX_COCOA = "cocoa";
    public static final String DB_EXECUTABLE = IS_WINDOWS ? "DOSBox.exe" : (IS_OSX ? "DOSBox" : "dosbox");
    public static final String EOLN = System.getProperty("line.separator");
    public static final String NATIVE_EXE_FILTER = IS_WINDOWS ? "*.exe;*.EXE" : (IS_OSX ? "*.app" : "*");
    public static final boolean USE_USER_HOME_DIR = Boolean.valueOf(System.getProperty("dbgl.data.localappdata")) != false || Boolean.valueOf(System.getProperty("dbgl.data.userhome")) != false;
    public static final String DFEND_PATH = System.getenv("ProgramFiles") + "\\D-Fend\\";
    public static final String DFEND_PROFILES = "Profiles.dat";
    public static final File DFEND_RELOADED_PATH = new File(System.getProperty("user.home"), "D-Fend Reloaded");
    public static final File USER_DATA_DIR_FILE = IS_WINDOWS ? new File(System.getenv("LOCALAPPDATA"), "/DBGL") : (IS_LINUX || IS_OSX ? new File(System.getProperty("user.home"), "/.dbgl") : new File("."));

    public static String toNativePath(String dbFileLocation) {
        return dbFileLocation.replace('\\', File.separatorChar);
    }

    public static String toDosboxPath(String hostFileLocation) {
        return hostFileLocation.replace(File.separatorChar, '\\');
    }

    public static String archiveToNativePath(String archiveEntry) {
        return archiveEntry.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String toArchivePath(String archiveFileEntry) {
        return PlatformUtils.toArchivePath(new File(archiveFileEntry), false);
    }

    public static String toArchivePath(File archiveEntry, boolean isDirectory) {
        String result = archiveEntry.getPath().replace('\\', '/');
        if (isDirectory) {
            result = result + "/";
        }
        return result;
    }

    public static String pathToNativePath(String path) {
        if (path != null && path.indexOf("://") == -1) {
            return PlatformUtils.archiveToNativePath(path);
        }
        return path;
    }

    public static void openForEditing(File file) {
        Program prog = Program.findProgram((String)".conf");
        if (prog == null) {
            prog = Program.findProgram((String)".txt");
        }
        if (prog == null) {
            prog = Program.findProgram((String)".inf");
        }
        if (prog == null) {
            prog = Program.findProgram((String)".ini");
        }
        if (prog == null) {
            prog = Program.findProgram((String)".cfg");
        }
        if (prog == null) {
            prog = Program.findProgram((String)".java");
        }
        if (prog == null) {
            prog = Program.findProgram((String)".doc");
        }
        if (prog == null) {
            System.err.println(Settings.getInstance().msg("general.error.openfile", new Object[]{file}));
        } else {
            prog.execute(file.getPath());
        }
    }

    public static void openForBrowsing(String url) {
        if (IS_WINDOWS) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            }
            catch (IOException e) {
                System.err.println(Settings.getInstance().msg("general.error.openurl", new Object[]{url}));
            }
        } else {
            Program prog = Program.findProgram((String)".html");
            if (prog == null) {
                System.err.println(Settings.getInstance().msg("general.error.openurl", new Object[]{url}));
            } else {
                prog.execute(url);
            }
        }
    }

    public static void openDirForViewing(File file) {
        try {
            if (IS_WINDOWS) {
                Runtime.getRuntime().exec(new String[]{"explorer", file.getPath()}, null, null);
            } else if (IS_LINUX) {
                try {
                    Runtime.getRuntime().exec(new String[]{"nautilus", file.getPath()}, null, null);
                }
                catch (IOException e) {
                    Runtime.getRuntime().exec(new String[]{"kfmclient", file.getPath()}, null, null);
                }
            } else if (IS_OSX) {
                Runtime.getRuntime().exec(new String[]{"open", file.getPath()}, null, null);
            }
        }
        catch (IOException e) {
            System.err.println(Settings.getInstance().msg("general.error.opendir", new Object[]{file}));
        }
    }

    public static void createShortcut(Profile profile, List<DosboxVersion> dbversionsList) throws IOException {
        DosboxVersion dbversion = DosboxVersion.findById(dbversionsList, profile.getDbversionId());
        String strictFilename = profile.getTitle().replaceAll("[\\/:*?\"<>|]", " ").trim();
        StringBuffer params = new StringBuffer(128);
        if (dbversion.isMultiConfig()) {
            params.append("-conf \"\"").append(dbversion.getCanonicalConfFile()).append("\"\" ");
        }
        params.append("-conf \"\"").append(profile.getCanonicalConfFile()).append("\"\"");
        if (Settings.getInstance().getSettings().getBooleanValue("dosbox", "hideconsole")) {
            params.append(" -noconsole");
        }
        if (IS_WINDOWS) {
            File desktopDir = FileSystemView.getFileSystemView().getHomeDirectory();
            File lnkFile = new File(desktopDir, strictFilename + ".lnk");
            File vbsFile = FileUtils.canonicalToData("shortcut.vbs");
            BufferedWriter vbsWriter = new BufferedWriter(new FileWriter(vbsFile));
            vbsWriter.write("Set oWS = WScript.CreateObject(\"WScript.Shell\")" + EOLN);
            vbsWriter.write("Set oLink = oWS.CreateShortcut(\"" + lnkFile.getCanonicalPath() + "\")" + EOLN);
            vbsWriter.write("oLink.TargetPath = \"" + dbversion.getCanonicalExecutable().getPath() + "\"" + EOLN);
            vbsWriter.write("oLink.Arguments = \"" + params.toString() + "\"" + EOLN);
            vbsWriter.write("oLink.Description = \"" + Settings.getInstance().msg("general.shortcut.title", new Object[]{strictFilename}) + "\"" + EOLN);
            vbsWriter.write("oLink.WorkingDirectory = \"" + FileUtils.getDosRoot() + "\"" + EOLN);
            vbsWriter.write("oLink.Save" + EOLN);
            vbsWriter.close();
            Process proc = Runtime.getRuntime().exec(new String[]{"CSCRIPT", vbsFile.getCanonicalPath()}, null, vbsFile.getParentFile());
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "CSCRIPT stderr");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "CSCRIPT stdout");
            outputGobbler.start();
            errorGobbler.start();
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            FileUtils.removeFile(vbsFile);
        } else if (IS_LINUX) {
            File desktopDir = new File(System.getProperty("user.home"), "/Desktop");
            File desktopFile = new File(desktopDir, strictFilename + ".desktop");
            BufferedWriter desktopWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(desktopFile), "UTF-8"));
            desktopWriter.write("[Desktop Entry]" + EOLN);
            desktopWriter.write("Version=1.0" + EOLN);
            desktopWriter.write("Type=Application" + EOLN);
            desktopWriter.write("Name=" + strictFilename + EOLN);
            desktopWriter.write("Comment=" + Settings.getInstance().msg("general.shortcut.title", new Object[]{strictFilename}) + EOLN);
            desktopWriter.write("Icon=" + new File(dbversion.getCanonicalExecutable().getParent(), "dosbox.ico").getPath() + EOLN);
            desktopWriter.write("TryExec=" + dbversion.getCanonicalExecutable().getPath() + EOLN);
            desktopWriter.write("Exec=" + dbversion.getCanonicalExecutable().getPath() + " " + StringUtils.replace((String)params.toString(), (String)"\"\"", (String)"\"") + EOLN);
            desktopWriter.write("Path=" + FileUtils.getDosRoot() + EOLN);
            desktopWriter.close();
            desktopFile.setExecutable(true);
        }
    }

    public static boolean isDirectoryWritable(File dir) {
        try {
            File.createTempFile("chkperm", null, dir).delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static SearchResult findDosbox() {
        File exe;
        File canExePath = null;
        File canConf = null;
        File canConfSuggestion = null;
        String version = null;
        if (FileUtils.isExistingDirectory(FileUtils.canonicalToDosbox(DEFAULT_DOSBOX_DIR)) && FileUtils.isExistingFile(exe = FileUtils.constructCanonicalDBExeLocation(DEFAULT_DOSBOX_DIR))) {
            canExePath = exe.getParentFile();
            version = DosboxVersion.LATEST;
        }
        if (canExePath == null) {
            File exePF;
            if (IS_WINDOWS) {
                File exePF2;
                String programFiles = System.getenv("ProgramFiles(x86)");
                if (programFiles == null) {
                    programFiles = System.getenv("ProgramFiles");
                }
                if (FileUtils.isExistingFile(exePF2 = new File(new File(programFiles, DEFAULT_DOSBOX_DIR), DB_EXECUTABLE))) {
                    canExePath = exePF2.getParentFile();
                    version = DosboxVersion.LATEST;
                }
            } else if (IS_LINUX) {
                exePF = new File("/usr/bin", DB_EXECUTABLE);
                if (FileUtils.isExistingFile(exePF)) {
                    canExePath = exePF.getParentFile();
                }
            } else if (IS_OSX && FileUtils.isExistingFile(exePF = new File("/Applications/DOSBox.app/Contents/MacOS", DB_EXECUTABLE))) {
                canExePath = exePF.getParentFile();
            }
        }
        if (canExePath != null) {
            File confLAD;
            File conf = new File(canExePath, "dosbox.conf");
            if (FileUtils.isExistingFile(conf)) {
                canConf = conf;
            } else if (IS_WINDOWS) {
                confLAD = new File(new File(System.getenv("LOCALAPPDATA"), "DOSBox"), "dosbox-" + DosboxVersion.LATEST + ".conf");
                if (FileUtils.isExistingFile(confLAD)) {
                    canConf = confLAD;
                    version = DosboxVersion.LATEST;
                } else {
                    canConfSuggestion = confLAD;
                }
            } else if (IS_LINUX) {
                confLAD = new File(new File(System.getProperty("user.home"), ".dosbox"), "dosbox-" + DosboxVersion.LATEST + ".conf");
                if (FileUtils.isExistingFile(confLAD)) {
                    canConf = confLAD;
                    version = DosboxVersion.LATEST;
                } else {
                    canConfSuggestion = confLAD;
                }
            } else if (IS_OSX) {
                confLAD = new File(new File(System.getProperty("user.home"), "Library/Preferences"), "DOSBox " + DosboxVersion.LATEST + " Preferences");
                if (FileUtils.isExistingFile(confLAD)) {
                    canConf = confLAD;
                    version = DosboxVersion.LATEST;
                } else {
                    canConfSuggestion = confLAD;
                }
            }
        }
        DosboxVersion db = new DosboxVersion(-1, "DOSBox " + (version != null ? version : DosboxVersion.LATEST), canExePath != null ? FileUtils.makeRelativeToDosbox(canExePath).getPath() : "", canConf != null ? FileUtils.makeRelativeToDosbox(canConf).getPath() : (canConfSuggestion != null ? FileUtils.makeRelativeToDosbox(canConfSuggestion).getPath() : ""), true, false, true, "", version != null ? version : DosboxVersion.LATEST);
        SearchResult.ResultType res = SearchResult.ResultType.NOTFOUND;
        if (canExePath != null) {
            res = SearchResult.ResultType.EXEONLY;
            if (canConf != null && version != null) {
                res = SearchResult.ResultType.COMPLETE;
            }
        }
        return new SearchResult(res, db);
    }
}

