/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.searchengine.WebSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyGamesSearchEngine
extends WebSearchEngine {
    private static final String IMG_ALT_MARKER = "\"alt\":";
    private static final String IMG_SRC_MARKER = "\"src\":";
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<div class='specs'>Showing ";
    private static final String HTML_GAME_START = "<div class='list-info";
    private static final String HTML_GAME_TITLE_START = "<h3 class='list'>";
    private static final String MOBY_GAMES_HOST_NAME = "www.mobygames.com";
    private static final int RESULTS_PER_PAGE = 25;

    private MobyGamesSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "moby.png";
    }

    @Override
    public String getName() {
        return "MobyGames";
    }

    @Override
    public String getSimpleName() {
        return "mobygames";
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        int pages = 1;
        LinkedHashSet<WebProfile> allEntries = new LinkedHashSet<WebProfile>();
        for (int pageIdx = 0; pageIdx < pages; ++pageIdx) {
            String content = MobyGamesSearchEngine.getResponseContent("http://www.mobygames.com/search/quick?ajax=1&sFilter=1&p=-1&sG=on&q=" + URLEncoder.encode(title.replaceAll("/", " "), "UTF-8") + "&offset=" + pageIdx * 25, "UTF-8");
            if (pageIdx == 0) {
                pages = MobyGamesSearchEngine.getPages(content);
            }
            allEntries.addAll(MobyGamesSearchEngine.extractEntries(content));
        }
        return MobyGamesSearchEngine.filterEntries(platforms, allEntries);
    }

    private static int getPages(String htmlChunk) {
        int i = htmlChunk.indexOf("\"name\":\"Games (");
        int j = htmlChunk.indexOf(")\"", i);
        if (i == -1 || j == -1) {
            return 0;
        }
        int entries = Integer.parseInt(htmlChunk.substring(i + 15, j));
        return (entries + 25 - 1) / 25;
    }

    private static List<WebProfile> extractEntries(String html) {
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        int gameMatchEntryIndex = (html = html.replaceAll("\\\\\"", "\"")).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex = html.indexOf(HTML_GAME_START, gameMatchEntryIndex);
        }
        while (gameMatchEntryIndex != -1) {
            int gameTitleIdx = html.indexOf(HTML_GAME_TITLE_START, gameMatchEntryIndex);
            String gameTitle = MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.extractNextContent(html, gameTitleIdx + HTML_GAME_TITLE_START.length(), "<a ", "</a>"));
            String url = MobyGamesSearchEngine.extractNextHrefContent(html, gameTitleIdx + HTML_GAME_TITLE_START.length());
            gameMatchEntryIndex = html.indexOf("<span style=\"white-space: nowrap\">", gameMatchEntryIndex);
            int gameEndMatchEntryIndex = html.indexOf("</div>", gameMatchEntryIndex);
            String details = html.substring(gameMatchEntryIndex, gameEndMatchEntryIndex);
            int platformIdx = details.indexOf("<span ");
            while (platformIdx != -1) {
                String platform = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<span ", "</span>");
                if (platform.indexOf("<a ") != -1) {
                    platform = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<a ", "</a>");
                    url = MobyGamesSearchEngine.extractNextHrefContent(details, platformIdx);
                } else {
                    int yrIdx = platform.indexOf(" (");
                    if (yrIdx != -1) {
                        platform = platform.substring(0, yrIdx);
                    }
                }
                url = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, url);
                String year = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<em>", "</em>");
                WebProfile gameEntry = new WebProfile();
                gameEntry.setTitle(gameTitle);
                gameEntry.setUrl(url);
                gameEntry.setPlatform(platform);
                gameEntry.setPublisherName("");
                gameEntry.setYear(year);
                allEntries.add(gameEntry);
                platformIdx = details.indexOf("<span ", platformIdx + 1);
            }
            gameMatchEntryIndex = html.indexOf(HTML_GAME_START, gameEndMatchEntryIndex + "</div>".length());
        }
        return allEntries;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws UnknownHostException, IOException {
        WebProfile result = new WebProfile();
        result.setTitle(entry.getTitle());
        result.setPlatform(entry.getPlatform());
        result.setYear(entry.getYear());
        result.setUrl(entry.getUrl());
        String responseEntry = MobyGamesSearchEngine.getResponseContent(entry.getUrl(), "UTF-8");
        result.setDeveloperName(MobyGamesSearchEngine.extractCategory(responseEntry, ">Developed by</div>"));
        result.setPublisherName(MobyGamesSearchEngine.extractCategory(responseEntry, ">Published by</div>"));
        result.setGenre(MobyGamesSearchEngine.extractCategory(responseEntry, ">Genre</div>"));
        result.setNotes(MobyGamesSearchEngine.extractDescription(responseEntry));
        result.setRank(MobyGamesSearchEngine.extractRank(responseEntry, result.getPlatform()));
        result.setCoreGameCoverUrl(MobyGamesSearchEngine.extractCoreGameCoverUrl(responseEntry));
        if (StringUtils.isEmpty((CharSequence)result.getDeveloperName())) {
            result.setDeveloperName(this.extractCredits(responseEntry, "<div class='detail credit-list'>"));
        }
        return result;
    }

    private String extractCredits(String htmlChunk, String marker) {
        String result;
        String credits;
        int endIndex;
        int startIndex = htmlChunk.indexOf(marker);
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf("<h2>Screenshots</h2>", startIndex + marker.length())) != -1 && MobyGamesSearchEngine.idxNextHrefContent(credits = htmlChunk.substring(startIndex + marker.length(), endIndex), (startIndex = MobyGamesSearchEngine.idxNextHrefContent(credits, 0)) + (result = MobyGamesSearchEngine.extractNextContent(credits, startIndex, "<a ", "</a>")).length()) == -1) {
            return MobyGamesSearchEngine.unescapeHtml(result);
        }
        return "";
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        if (coverArtMax > 0) {
            result.addAll(this.getEntryCoverArtInformation(entry, coverArtMax, forceAllRegionsCoverArt));
        }
        if (screenshotsMax > 0) {
            result.addAll(this.getEntryScreenshotInformation(entry, screenshotsMax));
        }
        entry.setWebImages(result.toArray(new SearchEngineImageInformation[0]));
        return entry.getWebImages();
    }

    private static String extractCoreGameCoverUrl(String htmlChunk) {
        int primIndex = htmlChunk.indexOf("<div class='game-nav'>");
        int secIndex = htmlChunk.indexOf("<div class='text-center'><a href", primIndex);
        if (primIndex == -1 || secIndex == -1) {
            return null;
        }
        return MobyGamesSearchEngine.extractNextHrefContent(htmlChunk, secIndex + 25);
    }

    private static String extractCategory(String htmlChunk, String marker) {
        int startIndex = htmlChunk.indexOf(marker);
        if (startIndex != -1) {
            int endIndex = htmlChunk.indexOf("</div>", startIndex + marker.length());
            return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(htmlChunk.substring(startIndex + marker.length(), endIndex + "</div>".length())));
        }
        return "";
    }

    private static String extractDescription(String htmlChunk) {
        int endIndex = htmlChunk.indexOf("<a class=\"edit\" href=");
        int startIndex = htmlChunk.lastIndexOf("</div>", endIndex);
        return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(htmlChunk.substring(startIndex + "</div>".length(), endIndex)));
    }

    private static Integer extractRank(String htmlChunk, String platform) {
        int primIndex = htmlChunk.indexOf("<div class='scores moby-scores'>");
        int secIndex = htmlChunk.indexOf("<div class='platform'>" + platform + "</div>", primIndex);
        int terIndex = htmlChunk.indexOf("<div class='score'>", secIndex);
        if (primIndex == -1 || secIndex == -1 || terIndex == -1) {
            return 0;
        }
        try {
            String rank = MobyGamesSearchEngine.extractNextContent(htmlChunk, terIndex, "<div", "</div>");
            return (int)(Double.parseDouble(rank) * 20.0);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private List<SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile entry, int max) throws IOException {
        int endIndex;
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        String htmlChunk = MobyGamesSearchEngine.getResponseContent(entry.getScreenshotsUrl(), "UTF-8");
        int startIndex = htmlChunk.indexOf("var screenshots");
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf("</script>", startIndex)) != -1) {
            int srcIndex;
            htmlChunk = htmlChunk.substring(startIndex, endIndex);
            startIndex = htmlChunk.indexOf("\"thumbs\":");
            for (int found = 0; found < max && startIndex != -1 && (srcIndex = htmlChunk.indexOf(IMG_SRC_MARKER, startIndex)) != -1; ++found) {
                String imgUrl = MobyGamesSearchEngine.extractNextDoubleQuotedContent(htmlChunk, srcIndex + IMG_SRC_MARKER.length());
                imgUrl = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, imgUrl.replaceAll("/images/shots/s/", "/images/shots/l/"));
                srcIndex = htmlChunk.indexOf(IMG_ALT_MARKER, startIndex);
                String imgDescription = MobyGamesSearchEngine.extractNextDoubleQuotedContent(htmlChunk, srcIndex + IMG_ALT_MARKER.length()).replace("<br>", " ").replace("<br/>", " ").replace("<br />", " ");
                if (imgDescription.startsWith(entry.getTitle())) {
                    imgDescription = imgDescription.substring(entry.getTitle().length()).trim();
                }
                if (imgDescription.startsWith(entry.getPlatform())) {
                    imgDescription = imgDescription.substring(entry.getPlatform().length()).trim();
                }
                result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, imgUrl, imgDescription));
                startIndex = htmlChunk.indexOf("},{", startIndex + 1);
            }
        }
        return result;
    }

    private List<SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile entry, int max, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        int maxAmountCoverArtInRegion = max;
        String htmlChunk = MobyGamesSearchEngine.getResponseContent(entry.getCoverArtUrl(), "UTF-8");
        int startIndex = htmlChunk.indexOf("<div class='game-info'>");
        if (startIndex != -1) {
            int endIndex;
            if (entry.getCoreGameCoverUrl() != null && !forceAllRegionsCoverArt) {
                startIndex = htmlChunk.indexOf(entry.getCoreGameCoverUrl(), startIndex);
                endIndex = htmlChunk.indexOf("</div></div>", startIndex);
                maxAmountCoverArtInRegion = Math.min(StringUtils.countMatches((CharSequence)htmlChunk.substring(startIndex, endIndex), (CharSequence)"<div class='thumb'") + 1, maxAmountCoverArtInRegion);
            }
            if ((startIndex = htmlChunk.indexOf("var screenshots")) != -1 && (endIndex = htmlChunk.indexOf("</script>", startIndex)) != -1) {
                int srcIndex;
                htmlChunk = htmlChunk.substring(startIndex, endIndex);
                startIndex = htmlChunk.indexOf("\"thumbs\":");
                if (entry.getCoreGameCoverUrl() != null && !forceAllRegionsCoverArt) {
                    String imgId = StringUtils.chop((String)entry.getCoreGameCoverUrl().substring(entry.getCoreGameCoverUrl().lastIndexOf(44) + 1));
                    startIndex = htmlChunk.indexOf("\"shotId\":\"" + imgId + "\"");
                    startIndex = htmlChunk.lastIndexOf(123, startIndex);
                }
                for (int found = 0; found < maxAmountCoverArtInRegion && startIndex != -1 && (srcIndex = htmlChunk.indexOf(IMG_SRC_MARKER, startIndex)) != -1; ++found) {
                    String imgUrl = MobyGamesSearchEngine.extractNextDoubleQuotedContent(htmlChunk, srcIndex + IMG_SRC_MARKER.length());
                    imgUrl = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, imgUrl.replaceAll("/images/covers/small/", "/images/covers/large/"));
                    srcIndex = htmlChunk.indexOf(IMG_ALT_MARKER, startIndex);
                    String imgDescription = MobyGamesSearchEngine.extractNextDoubleQuotedContent(htmlChunk, srcIndex + IMG_ALT_MARKER.length()).replace("<br>", " ").replace("<br/>", " ").replace("<br />", " ");
                    if (imgDescription.startsWith(entry.getTitle())) {
                        imgDescription = imgDescription.substring(entry.getTitle().length()).trim();
                    }
                    if (imgDescription.startsWith(entry.getPlatform())) {
                        imgDescription = imgDescription.substring(entry.getPlatform().length()).trim();
                    }
                    result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.CoverArt, imgUrl, imgDescription));
                    startIndex = htmlChunk.indexOf("},{", startIndex + 1);
                }
            }
        }
        return result;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new MobyGamesSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

