/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FatType {
    FAT12(4080, 4095L, 1.5f){

        public long readEntry(byte[] data, int index) {
            int idx = (int)((double)index * 1.5);
            int b1 = data[idx] & 0xFF;
            int b2 = data[idx + 1] & 0xFF;
            int v = b2 << 8 | b1;
            if (index % 2 == 0) {
                return v & 0xFFF;
            }
            return v >> 4;
        }
    }
    ,
    FAT16(65520, 65535L, 2.0f){

        public long readEntry(byte[] data, int index) {
            int idx = index << 1;
            int b1 = data[idx] & 0xFF;
            int b2 = data[idx + 1] & 0xFF;
            return b2 << 8 | b1;
        }
    }
    ,
    FAT32(0xFFFFFF0, 0xFFFFFFFFL, 4.0f){

        public long readEntry(byte[] data, int index) {
            int idx = index * 4;
            long l1 = data[idx] & 0xFF;
            long l2 = data[idx + 1] & 0xFF;
            long l3 = data[idx + 2] & 0xFF;
            long l4 = data[idx + 3] & 0xFF;
            return l4 << 24 | l3 << 16 | l2 << 8 | l1;
        }
    };

    private final long eofCluster;
    private final float entrySize;

    private FatType(int maxClusters, long bitMask, float entrySize) {
        this.eofCluster = 0xFFFFFF8L & bitMask;
        this.entrySize = entrySize;
    }

    public boolean isEofCluster(long entry) {
        return entry >= this.eofCluster;
    }

    public float getEntrySize() {
        return this.entrySize;
    }

    public abstract long readEntry(byte[] var1, int var2);
}

