/*
 * Decompiled with CFR 0.152.
 */
package exodos;

import exodos.model.GameData;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Convert {
    private static final String GAMES_DIR = "games";
    private static final String UTIL_DIR = "util";
    private static final String MEAGRE_DIR = "Meagre";
    private static final String INIFILE_DIR = "IniFile";
    private static final String ABOUT_DIR = "About";
    private static final String EXTRAS_DIR = "Extras";
    private static final String MANUAL_DIR = "Manual";
    private static final String FRONT_DIR = "Front";
    private static final String BACK_DIR = "Back";
    private static final String MEDIA_DIR = "Media";
    private static final String ADVERT_DIR = "Advert";
    private static final String TITLE_DIR = "Title";
    private static final String SCREEN_DIR = "Screen";
    private static final String[] CAP_DIRS = new String[]{"Title", "Screen", "Front", "Back", "Media", "Advert"};
    private static final String GPA_TITLE = "eXoDOS conversion";
    private static final String GPA_NOTES = "";
    private static final String GPA_AUTHOR = "";
    private static final long MAX_PART_SIZE = 0x80000000L;
    private static final String[] CDIMAGES = new String[]{".iso", ".cue", ".bin", ".img", ".gog"};
    private static final Settings settings = Settings.getInstance();
    private static boolean verboseOutput = false;

    public static void main(String[] stringArray) {
        System.out.println("Converts eXoDOS game packages into DBGL GamePackArchives (v0.2)\n");
        if (stringArray.length < 2 || stringArray.length > 5) {
            Convert.displaySyntax();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-a")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-k")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-v")) {
                    verboseOutput = true;
                    continue;
                }
                Convert.displaySyntax();
            }
        }
        File file3 = Convert.validateParameters(file, file2);
        File file4 = new File(file, GAMES_DIR);
        List<DosboxVersion> list = null;
        try {
            list = Database.getInstance().readDosboxVersionsList();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.exit(1);
        }
        if (bl) {
            System.out.println("* Analyze only");
        }
        if (bl2) {
            System.out.println("* Keeping extracted data after processing");
        }
        if (verboseOutput) {
            System.out.println("* Verbose output");
        }
        File file5 = Convert.extractMeagreMetaData(file3, file2);
        List<GameData> list2 = Convert.analyzeMeagreMetaData(file4, file5, list);
        if (!bl) {
            Convert.generateGamePackArchives(list2, file2, FilenameUtils.removeExtension((String)file3.getName()), list);
        }
        if (!bl2) {
            Convert.cleanup(file5);
        }
    }

    private static void displaySyntax() {
        System.out.println("Use: Convert <inputexodosdir> <dstdir> [-a] [-v]");
        System.out.println("-a\t\tAnalyze only, don't generate gamepackarchives");
        System.out.println("-k\t\tKeep extracted meta data files after processing");
        System.out.println("-v\t\tVerbose output");
        System.exit(1);
    }

    private static File validateParameters(File file, File file2) {
        File file3;
        File file4;
        File file5;
        if (!file.exists()) {
            System.out.println("The directory [" + file + "] does not exist, exiting.");
            System.exit(1);
        }
        if (!(file5 = new File(file, GAMES_DIR)).exists()) {
            System.out.println("The directory [" + file + "] does not contain the [" + GAMES_DIR + "] directory, exiting.");
            System.exit(1);
        }
        if (!(file4 = new File(file, UTIL_DIR)).exists()) {
            System.out.println("The directory [" + file + "] does not contain the [" + UTIL_DIR + "] directory, exiting.");
            System.exit(1);
        }
        if (!FileUtils.isExistingFile(file3 = new File(file5, "GamesSTR.zip"))) {
            file3 = new File(file5, "GamesSIM.zip");
        }
        if (!FileUtils.isExistingFile(file3)) {
            file3 = new File(file5, "GamesRPG.zip");
        }
        if (!FileUtils.isExistingFile(file3)) {
            file3 = new File(file5, "GamesADV.zip");
        }
        if (!FileUtils.isExistingFile(file3)) {
            file3 = new File(file5, "GamesACT.zip");
        }
        if (!FileUtils.isExistingFile(file3)) {
            file3 = new File(file5, "Games.zip");
        }
        if (!FileUtils.isExistingFile(file3)) {
            System.out.println("The file [" + file3 + "] does not exist, exiting.");
            System.exit(1);
        }
        if (!file2.exists()) {
            System.out.println("The directory [" + file2 + "] does not exist, exiting.");
            System.exit(1);
        }
        return file3;
    }

    private static File extractMeagreMetaData(File file, File file2) {
        System.out.println();
        System.out.println("===========================================");
        System.out.println(" Phase 1 of 3: Extracting Meagre meta-data");
        System.out.println("===========================================");
        System.out.println("Reading from: [" + file + "]");
        System.out.println("Writing to:   [" + file2 + "]");
        try {
            File file3;
            String string = Convert.findMainFolder(file);
            if (string == null) {
                System.out.println("The file [" + file + "] does not seem to have an inner games directory, exiting.");
                System.exit(1);
            }
            if (!(file3 = new File(file2, string)).exists()) {
                Convert.unzip(file, file2);
            } else {
                System.out.println("Skipping extraction of [" + file + "] since [" + file3 + "] already exists");
            }
            return file3;
        }
        catch (IOException iOException) {
            System.out.println("The file [" + file + "] did not fully extract into the [" + file2 + "] directory, exiting.");
            iOException.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static List<GameData> analyzeMeagreMetaData(File file, File file2, List<DosboxVersion> list) {
        System.out.println();
        System.out.println("==========================================");
        System.out.println(" Phase 2 of 3: Analyzing Meagre meta-data");
        System.out.println("==========================================");
        System.out.println("Reading from: [" + file2 + "]");
        PrintStream printStream = new PrintStream(System.out);
        ArrayList<GameData> arrayList = new ArrayList<GameData>();
        File[] fileArray = file2.listFiles();
        Arrays.sort(fileArray, new FileIgnoreCaseComparator());
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            File file4 = new File(file3, MEAGRE_DIR);
            File file5 = new File(file4, INIFILE_DIR);
            File[] fileArray2 = file5.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".ini");
                }
            });
            if (fileArray2.length != 1) {
                System.out.println("SKIPPED " + file3.getName() + ": Not exactly 1 ini file found (" + fileArray2.length + ")");
                continue;
            }
            File file6 = fileArray2[0];
            try {
                boolean bl;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Conf conf = new Conf(file6, printStream);
                SectionsWrapper sectionsWrapper = conf.getSettings();
                String string = sectionsWrapper.getValue("Main", "name");
                String string2 = Convert.join(new String[]{sectionsWrapper.getValue("Main", "developer"), sectionsWrapper.getValue("Main", "designer"), sectionsWrapper.getValue("Main", "designer2")}, ", ");
                String string3 = sectionsWrapper.getValue("Main", "publisher");
                String string4 = Convert.join(new String[]{sectionsWrapper.getValue("Main", "genre"), sectionsWrapper.getValue("Main", "subgenre"), sectionsWrapper.getValue("Main", "subgenre2")}, ", ");
                String string5 = sectionsWrapper.getValue("Main", "year");
                String string6 = "";
                String string7 = sectionsWrapper.getValue("Main", "about");
                String string8 = StringUtils.isBlank((CharSequence)string7) ? "" : org.apache.commons.io.FileUtils.readFileToString((File)new File(file4, ABOUT_DIR + File.separatorChar + string7));
                boolean bl2 = false;
                String[] stringArray = new String[]{"", "", ""};
                String[] stringArray2 = new String[]{"", "", ""};
                String string9 = new File(file3, "dosbox.conf").getPath();
                String string10 = FileUtils.constructCapturesDir(i);
                int n = 0;
                String[] stringArray3 = new String[]{sectionsWrapper.getValue("Main", "extralink1"), sectionsWrapper.getValue("Main", "manual"), sectionsWrapper.getValue("Main", "extralink2"), sectionsWrapper.getValue("Main", "extralink3"), sectionsWrapper.getValue("Main", "extralink4"), sectionsWrapper.getValue("Main", "extralink5"), sectionsWrapper.getValue("Main", "extralink6"), sectionsWrapper.getValue("Main", "extralink7")};
                String[] stringArray4 = new String[]{sectionsWrapper.getValue("Main", "extra1"), MANUAL_DIR, sectionsWrapper.getValue("Main", "extra2"), sectionsWrapper.getValue("Main", "extra3"), sectionsWrapper.getValue("Main", "extra4"), sectionsWrapper.getValue("Main", "extra5"), sectionsWrapper.getValue("Main", "extra6"), sectionsWrapper.getValue("Main", "extra7")};
                String[] stringArray5 = new String[]{"", "", "", "", "", "", "", ""};
                int[] nArray = new int[]{0, 0};
                String[] stringArray6 = new String[]{sectionsWrapper.getValue("Main", "title01"), sectionsWrapper.getValue("Main", "screen01"), sectionsWrapper.getValue("Main", "front01"), sectionsWrapper.getValue("Main", "back01"), sectionsWrapper.getValue("Main", "media01"), sectionsWrapper.getValue("Main", "adv01")};
                ArrayList<File> arrayList2 = new ArrayList<File>();
                for (int j = 0; j < stringArray6.length; ++j) {
                    if (!StringUtils.isNotEmpty((CharSequence)stringArray6[j])) continue;
                    object5 = new File(file4, CAP_DIRS[j] + File.separatorChar + stringArray6[j]);
                    if (FileUtils.isExistingFile((File)object5)) {
                        arrayList2.add((File)object5);
                        continue;
                    }
                    System.out.println("WARNING: " + file3.getName() + ": capture [" + object5 + "] not found, skipped");
                }
                ArrayList<File> arrayList3 = new ArrayList<File>();
                for (int j = 0; j < stringArray3.length; ++j) {
                    object4 = stringArray3[j];
                    if (!StringUtils.isNotEmpty((CharSequence)object4) || ((String)object4).toLowerCase().startsWith("http")) continue;
                    object3 = new File(file4, (j == 1 ? MANUAL_DIR : EXTRAS_DIR) + File.separatorChar + (String)object4);
                    if (FileUtils.isExistingFile((File)object3)) {
                        arrayList3.add((File)object3);
                        stringArray3[j] = FileUtils.DOSROOT_DIR + file3.getName() + File.separatorChar + EXTRAS_DIR + File.separatorChar + ((File)object3).getName();
                        continue;
                    }
                    System.out.println("WARNING: " + file3.getName() + ": linked file [" + object3 + "] not found, skipped");
                }
                object5 = new Profile(i, string, string2, string3, string4, string5, string6, string8, bl2, stringArray, stringArray2, string9, string10, n, stringArray3, stringArray4, stringArray5, nArray);
                object4 = new Conf((Profile)object5, DosboxVersion.findById(list, ((Profile)object5).getDbversionId()), printStream);
                object3 = ((Conf)object4).getAutoexec();
                if (((Autoexec)object3).isIncomplete()) {
                    System.out.println("WARNING: " + file3.getName() + ": This profile's autoexec section seems incomplete");
                }
                ((Autoexec)object3).migrateToDosroot(FileUtils.canonicalToDosroot(GAMES_DIR), true);
                File file7 = new File(file, FilenameUtils.getBaseName((String)sectionsWrapper.getValue("Main", "executable")) + ".zip");
                if (!FileUtils.isExistingFile(file7)) {
                    if (verboseOutput) {
                        System.out.println("Zip file " + file7 + " not found, reverting to Install.bat to determine game zip");
                    }
                    if (FileUtils.isExistingFile((File)(object2 = new File(file3, "Install.bat")))) {
                        object = org.apache.commons.io.FileUtils.readLines((File)object2);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            int n2;
                            String string11 = (String)iterator.next();
                            if (!string11.startsWith("unzip \"") || (n2 = string11.lastIndexOf(34)) == -1) continue;
                            file7 = new File(file, string11.substring(7, n2));
                            if (!verboseOutput) break;
                            System.out.println("Zip file " + file7 + " referenced in Install.bat, using that file instead");
                            break;
                        }
                    }
                }
                if (!Convert.fixupFileLocations(object2 = Convert.readFilesInZip(file7), (Autoexec)object3) && StringUtils.isNotEmpty((CharSequence)(object = ((Autoexec)object3).getActualMain()))) {
                    System.out.println("WARNING: " + file3.getName() + ": Main file [" + (String)object + "] not found inside [" + file7 + "]");
                }
                if (bl = Convert.isMultipleRootEntries((List<File>)object2)) {
                    ((Autoexec)object3).updateForTargetImportBaseDir(file3);
                    if (verboseOutput) {
                        System.out.println("INFO: " + file3.getName() + " is moved one directory level deeper");
                    }
                }
                arrayList.add(new GameData(new ExpProfile(i, (Conf)object4, new File(file3.getName()), null, (Profile)object5), arrayList2, arrayList3, file7, bl));
                continue;
            }
            catch (IOException iOException) {
                System.out.println("SKIPPED " + file3.getName() + " " + iOException.toString());
            }
        }
        Collections.sort(arrayList);
        System.out.println("Analysis done");
        return arrayList;
    }

    private static void generateGamePackArchives(List<GameData> list, File file, String string, List<DosboxVersion> list2) {
        try {
            System.out.println();
            System.out.println("===========================================");
            System.out.println(" Phase 3 of 3: Generating GamePackArchives");
            System.out.println("===========================================");
            while (!list.isEmpty()) {
                Object object32;
                Object object2;
                long l = 0L;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                boolean bl = false;
                while (!list.isEmpty() && !bl) {
                    object2 = list.get(0);
                    try {
                        long l2 = Convert.determineSize((GameData)object2);
                        if (arrayList.isEmpty() || l + l2 < 0x80000000L) {
                            arrayList.add(object2);
                            list.remove(0);
                            l += l2;
                            continue;
                        }
                        bl = true;
                    }
                    catch (IOException iOException) {
                        System.out.println("skipping " + ((GameData)object2).getExpProfile().getTitle() + ", " + iOException.toString());
                        list.remove(0);
                    }
                }
                object2 = new ArrayList();
                for (Object object32 : arrayList) {
                    object2.add(((GameData)object32).getExpProfile());
                }
                File file2 = new File(file, string + "__" + FileUtils.fileSystemSafe(((GameData)arrayList.get(0)).getExpProfile().getTitle()) + " - " + FileUtils.fileSystemSafe(((GameData)arrayList.get(arrayList.size() - 1)).getExpProfile().getTitle()) + ".dbgl.zip");
                object32 = new ZipOutputStream(new FileOutputStream(file2));
                for (GameData gameData : arrayList) {
                    boolean bl2 = false;
                    try {
                        Object object4;
                        Object object5;
                        ExpProfile expProfile = gameData.getExpProfile();
                        System.out.print("Exporting " + expProfile.getTitle() + " ");
                        File file3 = new File(FileUtils.constructCapturesDir(expProfile.getId()));
                        try {
                            object5 = gameData.getCapturesList();
                            for (int i = 0; i < object5.size(); ++i) {
                                object4 = object5.get(i);
                                FileUtils.zipEntry((File)object4, new File(file3, String.valueOf(i) + "_" + ((File)object4).getName()), (ZipOutputStream)object32);
                            }
                        }
                        catch (IOException iOException) {
                            throw new IOException(settings.msg("dialog.export.error.exportcaptures", new Object[]{expProfile.getTitle(), StringRelatedUtils.toString(iOException)}), iOException);
                        }
                        object5 = new File(FileUtils.DOSROOT_DIR, String.valueOf(expProfile.getId()));
                        File file4 = new File(new File((File)object5, expProfile.getGameDir().getPath()), EXTRAS_DIR);
                        try {
                            object4 = gameData.getExtrasList();
                            for (int i = 0; i < object4.size(); ++i) {
                                File file5 = (File)object4.get(i);
                                FileUtils.zipEntry(file5, new File(file4, file5.getName()), (ZipOutputStream)object32);
                            }
                            if (bl2) {
                                object5 = new File((File)object5, expProfile.getGameDir().getPath());
                            }
                            Convert.copyZipData(gameData.getZipFile(), (File)object5, (ZipOutputStream)object32);
                        }
                        catch (IOException iOException) {
                            throw new IOException(settings.msg("dialog.export.error.exportgamedata", new Object[]{expProfile.getTitle(), StringRelatedUtils.toString(iOException)}), iOException);
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("WARNING: The file [" + gameData.getZipFile() + "] could not be copied (completely) properly into the [" + file2 + "], this game may be corrupt");
                        iOException.printStackTrace();
                    }
                }
                Document document = XmlUtils.getFullProfilesXML((List<ExpProfile>)object2, list2, GPA_TITLE, "", "", true, false, false, true);
                XmlUtils.domToZipOutputStream(document, new File("profiles.xml"), (ZipOutputStream)object32);
                ((ZipOutputStream)object32).close();
                System.out.println("DBGL GamePackArchive " + file2 + " succesfully generated.");
            }
            System.out.println("Finished.");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void cleanup(File file) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static boolean isMultipleRootEntries(List<File> list) {
        int n = 0;
        for (File file : list) {
            if (file.getParentFile() != null) continue;
            ++n;
        }
        return n >= 1;
    }

    private static boolean fixupFileLocations(List<File> list, Autoexec autoexec) {
        File file;
        int n;
        String string = autoexec.getActualMain();
        File file2 = new File(string);
        int n2 = Convert.containsIso(file2.getPath());
        if (n2 != -1) {
            file2 = new File(file2.getPath().substring(0, n2));
        }
        if ((n = FileUtils.containsFatImage(file2.getPath())) != -1) {
            file2 = new File(file2.getPath().substring(0, n));
        }
        if (list.contains(file2)) {
            return true;
        }
        File file3 = Convert.findSuitableExtension(file2, list);
        if (file3 != null) {
            autoexec.setActualMain(file3);
            if (verboseOutput) {
                System.out.println("Main file [" + file2 + "] was using wrong file extension, changed to [" + file3.getPath() + "].");
            }
            return true;
        }
        File file4 = file2.getParentFile();
        if (file4 != null && (file = file4.getParentFile()) != null) {
            file3 = new File(file, file2.getName());
            if (list.contains(file3)) {
                autoexec.setActualMainPath(file);
                if (verboseOutput) {
                    System.out.println("Main file [" + file2 + "] redirected to parent directory [" + file.getPath() + "].");
                }
                return true;
            }
            if ((file3 = Convert.findSuitableExtension(file3, list)) != null) {
                autoexec.setActualMain(file3);
                if (verboseOutput) {
                    System.out.println("Main file [" + file2 + "] was using wrong file extension and dir, changed to [" + file3.getPath() + "].");
                }
                return true;
            }
        }
        return false;
    }

    private static int containsIso(String string) {
        for (String string2 : CDIMAGES) {
            int n = string.toLowerCase().indexOf(string2 + File.separatorChar);
            if (n == -1) continue;
            return n + string2.length();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> readFilesInZip(File file) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory()) continue;
                    arrayList.add(new File(PlatformUtils.archiveToNativePath(string)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("WARNING: Zip file [" + file + "] contains an entry with problematic characters in its filename");
                }
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return arrayList;
    }

    private static long determineSize(GameData gameData) throws IOException {
        try {
            long l = org.apache.commons.io.FileUtils.sizeOf((File)gameData.getZipFile());
            for (File file : gameData.getExtrasList()) {
                l += org.apache.commons.io.FileUtils.sizeOf((File)file);
            }
            for (File file : gameData.getCapturesList()) {
                l += org.apache.commons.io.FileUtils.sizeOf((File)file);
            }
            return l += 4096L;
        }
        catch (Exception exception) {
            throw new IOException("Could not determine game size " + exception.toString());
        }
    }

    private static int sizeInKB(ZipFile zipFile) throws IOException {
        int n = 0;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            try {
                ZipEntry zipEntry = enumeration.nextElement();
                n = (int)((long)n + zipEntry.getSize() / 1024L);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("WARNING: Zip file [" + zipFile.getName() + "] contains an entry with problematic characters in its filename");
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findMainFolder(File file) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (!zipEntry.isDirectory()) continue;
                    String string = zipEntry.getName();
                    return string;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("WARNING: Zip file [" + file + "] contains an entry with problematic characters in its filename");
                }
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(final File file, File file2) throws IOException {
        ProgressNotifyable progressNotifyable = new ProgressNotifyable(){
            private int tot = 0;
            private int prog = 0;

            public void setTotal(int n) {
                this.tot = n;
            }

            public void incrProgress(int n) {
                this.prog += n;
                System.out.printf("\rExtracting %s: %3.1f%%", file, (double)this.prog * 100.0 / (double)this.tot);
            }

            public void setProgress(int n) {
            }
        };
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            progressNotifyable.setTotal(Convert.sizeInKB(zipFile));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    File file3 = new File(file2, zipEntry.getName());
                    FileUtils.extractEntry(zipFile, zipEntry, file3, progressNotifyable);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("WARNING: Zip file [" + file + "] contains an entry with problematic characters in its filename");
                }
            }
            System.out.printf("\rExtracting %s: Done  \n", file);
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyZipData(File file, File file2, ZipOutputStream zipOutputStream) throws ZipException, IOException {
        ZipFile zipFile = null;
        int n = 0;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    File file3 = new File(file2, zipEntry.getName());
                    ZipEntry zipEntry2 = new ZipEntry(PlatformUtils.toArchivePath(file3, zipEntry.isDirectory()));
                    zipEntry2.setComment(zipEntry.getComment());
                    zipEntry2.setTime(zipEntry.getTime());
                    zipEntry2.setExtra(zipEntry.getExtra());
                    zipOutputStream.putNextEntry(zipEntry2);
                    if (!zipEntry.isDirectory()) {
                        IOUtils.copyLarge((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                    if (n++ % 4 != 0) continue;
                    System.out.print(".");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("WARNING: Zip file [" + file + "] contains an entry with problematic characters in its filename");
                }
            }
            System.out.println(" done.");
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static File findSuitableExtension(File file, List<File> list) {
        for (int i = 0; i < FileUtils.EXECUTABLES.length; ++i) {
            File file2 = new File(FilenameUtils.removeExtension((String)file.getPath()) + FileUtils.EXECUTABLES[i]);
            if (!list.contains(file2)) continue;
            return file2;
        }
        return null;
    }

    public static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string2 : stringArray) {
            if (!StringUtils.isNotEmpty((CharSequence)string2)) continue;
            if (!bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
            bl = false;
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileIgnoreCaseComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            return file.getPath().compareToIgnoreCase(file2.getPath());
        }
    }
}

