/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.connect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.dbgl.gui.MainWindow;
import org.dbgl.model.conf.Settings;

public final class Messaging
extends Thread {
    private final transient int port;
    private final transient Object obj;
    private transient ServerSocket server = null;
    private transient boolean cont = true;
    private Settings settings;

    public Messaging(int n, Object object) {
        this.port = n;
        this.obj = object;
        this.settings = Settings.getInstance();
    }

    public void close() {
        this.cont = false;
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            System.err.println(this.settings.msg("communication.error.closesocket"));
        }
    }

    public void run() {
        try {
            this.server = new ServerSocket(this.port);
            System.out.println(this.settings.msg("communication.notice.listening", new Object[]{this.port}));
        }
        catch (IOException iOException) {
            this.cont = false;
            System.err.println(this.settings.msg("communication.error.createsocket", new Object[]{this.port}));
        }
        while (this.cont) {
            try {
                Socket socket = this.server.accept();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                System.out.print(this.settings.msg("communication.notice.receivingmessage"));
                String string = bufferedReader.readLine();
                System.out.println(' ' + string);
                socket.close();
                if (string == null || !string.startsWith("sendtoprofile ")) continue;
                ((MainWindow)this.obj).addProfile(string.substring(14));
            }
            catch (IOException iOException) {
                if (!this.cont) continue;
                System.err.println(this.settings.msg("communication.error.io"));
            }
        }
    }
}

