/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Filter;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static Connection con = null;
    private static boolean initializedNewDatabase = false;
    private static final String GET_IDENTITY_QRY = "CALL IDENTITY()";
    private static final String GAME_LIST_QRY = "SELECT GAM.ID, GAM.TITLE, DEV.NAME, PUBL.NAME, GEN.NAME, YR.YEAR, STAT.STAT, GAM.NOTES, GAM.FAVORITE, GAM.SETUP, GAM.SETUP_PARAMS, GAM.ALT1, GAM.ALT1_PARAMS, GAM.ALT2, GAM.ALT2_PARAMS, GAM.CONFFILE, GAM.CAPTURES, GAM.DBVERSION_ID, GAM.LINK1, GAM.LINK2, GAM.LINK3, GAM.LINK4, GAM.LINK5, GAM.LINK6, GAM.LINK7, GAM.LINK8, GAM.LINK1_TITLE, GAM.LINK2_TITLE, GAM.LINK3_TITLE, GAM.LINK4_TITLE, GAM.LINK5_TITLE, GAM.LINK6_TITLE, GAM.LINK7_TITLE, GAM.LINK8_TITLE, CUST1.VALUE, CUST2.VALUE, CUST3.VALUE, CUST4.VALUE, GAM.CUSTOM5, GAM.CUSTOM6, GAM.CUSTOM7, GAM.CUSTOM8, GAM.CUSTOM9, GAM.CUSTOM10 FROM GAMES GAM, DEVELOPERS DEV, PUBLISHERS PUBL, GENRES GEN, PUBLYEARS YR, STATUS STAT, CUSTOM1 CUST1, CUSTOM2 CUST2, CUSTOM3 CUST3, CUSTOM4 CUST4 WHERE GAM.DEV_ID=DEV.ID AND GAM.PUBL_ID=PUBL.ID AND GAM.GENRE_ID=GEN.ID AND GAM.YEAR_ID=YR.ID AND GAM.STAT_ID=STAT.ID AND   GAM.CUST1_ID=CUST1.ID AND GAM.CUST2_ID=CUST2.ID AND GAM.CUST3_ID=CUST3.ID AND GAM.CUST4_ID=CUST4.ID";
    private static final String DUPL_GAME_QRY = "INSERT INTO GAMES(TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, STAT_ID, NOTES, FAVORITE, SETUP, SETUP_PARAMS, ALT1, ALT1_PARAMS, ALT2, ALT2_PARAMS,CONFFILE, CAPTURES, DBVERSION_ID, LINK1, LINK2, LINK3, LINK4, LINK5, LINK6, LINK7, LINK8,LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE, LINK5_TITLE, LINK6_TITLE, LINK7_TITLE, LINK8_TITLE,CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10) (SELECT TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, STAT_ID, NOTES, FAVORITE,SETUP, SETUP_PARAMS, ALT1, ALT1_PARAMS, ALT2, ALT2_PARAMS, NULL, NULL, DBVERSION_ID,LINK1, LINK2, LINK3, LINK4, LINK5, LINK6, LINK7, LINK8, LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE, LINK5_TITLE, LINK6_TITLE, LINK7_TITLE, LINK8_TITLE,CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10 FROM GAMES WHERE ID = ?)";
    private static final String DUPL_TEMPLATE_QRY = "INSERT INTO TEMPLATES(TITLE, DBVERSION_ID, ISDEFAULT) (SELECT TITLE, DBVERSION_ID, FALSE FROM TEMPLATES WHERE ID = ?)";
    private static final String DEV_LIST_QRY = "SELECT ID, NAME FROM DEVELOPERS ORDER BY NAME";
    private static final String PUBL_LIST_QRY = "SELECT ID, NAME FROM PUBLISHERS ORDER BY NAME";
    private static final String GENRE_LIST_QRY = "SELECT ID, NAME FROM GENRES ORDER BY NAME";
    private static final String PUBLYEAR_LIST_QRY = "SELECT ID, YEAR FROM PUBLYEARS ORDER BY YEAR";
    private static final String DBVERS_LIST_QRY = "SELECT ID, TITLE, PATH, CONFFILE, MULTICONF, USINGCURSES, ISDEFAULT, PARAMETERS, VERSION FROM DOSBOXVERSIONS ORDER BY TITLE";
    private static final String FLTRS_LIST_QRY = "SELECT ID, TITLE, FILTER FROM FILTERS";
    private static final String TEMPL_LIST_QRY = "SELECT ID, TITLE, DBVERSION_ID, ISDEFAULT FROM TEMPLATES ORDER BY ID";
    private static final String STATUS_LIST_QRY = "SELECT ID, STAT FROM STATUS ORDER BY STAT";
    private static final String[] CUSTOM_LIST_QRY = new String[]{"SELECT ID, VALUE FROM CUSTOM1 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM2 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM3 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM4 ORDER BY VALUE"};
    private static final String DBV_USE_QRY = "SELECT TITLE FROM GAMES WHERE DBVERSION_ID = ? UNION ALL SELECT TITLE FROM TEMPLATES WHERE DBVERSION_ID = ?";
    private static final String NTVCMD_LIST_QRY_TEMPLATE = "SELECT COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR FROM NATIVECOMMANDS WHERE GAME_ID IS NULL AND TEMPLATE_ID = ? ORDER BY ORDERNR";
    private static final String NTVCMD_LIST_QRY_GAME = "SELECT COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR FROM NATIVECOMMANDS WHERE GAME_ID = ? AND TEMPLATE_ID IS NULL ORDER BY ORDERNR";
    private static final String ADD_GAME_QRY = "INSERT INTO GAMES(TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, STAT_ID, NOTES, FAVORITE,SETUP, SETUP_PARAMS, ALT1, ALT1_PARAMS, ALT2, ALT2_PARAMS, CONFFILE, CAPTURES, DBVERSION_ID,LINK1, LINK2, LINK3, LINK4, LINK5, LINK6, LINK7, LINK8,LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE, LINK5_TITLE, LINK6_TITLE, LINK7_TITLE, LINK8_TITLE,CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_DEVELOPER_QRY = "INSERT INTO DEVELOPERS(NAME) VALUES (?)";
    private static final String ADD_PUBLISHER_QRY = "INSERT INTO PUBLISHERS(NAME) VALUES (?)";
    private static final String ADD_GENRE_QRY = "INSERT INTO GENRES(NAME) VALUES (?)";
    private static final String ADD_YEAR_QRY = "INSERT INTO PUBLYEARS(YEAR) VALUES (?)";
    private static final String ADD_DBVERSION_QRY = "INSERT INTO DOSBOXVERSIONS(TITLE, PATH, CONFFILE, MULTICONF, USINGCURSES, ISDEFAULT, PARAMETERS, VERSION) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_TEMPLATE_QRY = "INSERT INTO TEMPLATES(TITLE, DBVERSION_ID, ISDEFAULT) VALUES (?, ?, ?)";
    private static final String ADD_FILTER_QRY = "INSERT INTO FILTERS(TITLE, FILTER, CONF_FILTER) VALUES (?, ?, '')";
    private static final String ADD_STATUS_QRY = "INSERT INTO STATUS(STAT) VALUES (?)";
    private static final String[] ADD_CUSTOM_QRY = new String[]{"INSERT INTO CUSTOM1(VALUE) VALUES (?)", "INSERT INTO CUSTOM2(VALUE) VALUES (?)", "INSERT INTO CUSTOM3(VALUE) VALUES (?)", "INSERT INTO CUSTOM4(VALUE) VALUES (?)"};
    private static final String ADD_NATIVECOMMAND_QRY = "INSERT INTO NATIVECOMMANDS(COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR, GAME_ID, TEMPLATE_ID) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String UPD_GAME_QRY = "UPDATE GAMES SET TITLE = ?, DEV_ID = ?, PUBL_ID = ?, GENRE_ID = ?, YEAR_ID = ?, STAT_ID = ?, NOTES = ?, FAVORITE = ?, SETUP = ?, SETUP_PARAMS = ?, ALT1 = ?, ALT1_PARAMS = ?, ALT2 = ?, ALT2_PARAMS = ?,DBVERSION_ID = ?, LINK1 = ?, LINK2 = ?, LINK3 = ?, LINK4 = ?, LINK5 = ?, LINK6 = ?, LINK7 = ?, LINK8 = ?, LINK1_TITLE = ?, LINK2_TITLE = ?, LINK3_TITLE = ?, LINK4_TITLE = ?, LINK5_TITLE = ?, LINK6_TITLE = ?, LINK7_TITLE = ?, LINK8_TITLE = ?,CUST1_ID = ?, CUST2_ID = ?, CUST3_ID = ?, CUST4_ID = ?, CUSTOM5 = ?, CUSTOM6 = ?, CUSTOM7 = ?, CUSTOM8 = ?, CUSTOM9 = ?, CUSTOM10 = ? WHERE ID = ?";
    private static final String UPD_GAME_CONF_QRY = "UPDATE GAMES SET CONFFILE = ?, CAPTURES = ? WHERE ID = ?";
    private static final String UPD_STPLNKS_QRY = "UPDATE GAMES SET SETUP = ?, ALT1 = ?, ALT2 = ?, LINK1 = ?, LINK2 = ?, LINK3 = ?, LINK4 = ?, LINK5 = ?, LINK6 = ?, LINK7 = ?, LINK8 = ? WHERE ID = ?";
    private static final String UPD_DBV_NODEFAULT = "UPDATE DOSBOXVERSIONS SET ISDEFAULT = FALSE";
    private static final String UPD_DBVERSION_QRY = "UPDATE DOSBOXVERSIONS SET TITLE = ?, PATH = ?, CONFFILE = ?, MULTICONF = ?, USINGCURSES = ?, ISDEFAULT = ?, PARAMETERS = ?, VERSION = ? WHERE ID = ?";
    private static final String UPD_TEMPLATE_QRY = "UPDATE TEMPLATES SET TITLE = ?, DBVERSION_ID = ?, ISDEFAULT = ? WHERE ID = ?";
    private static final String UPD_FILTER_QRY = "UPDATE FILTERS SET TITLE = ?, FILTER = ? WHERE ID = ?";
    private static final String UPD_TEMPL_NODFLT = "UPDATE TEMPLATES SET ISDEFAULT = FALSE";
    private static final String REMOVE_GAME_QRY = "DELETE FROM GAMES WHERE ID = ?";
    private static final String REMOVE_DBV_QRY = "DELETE FROM DOSBOXVERSIONS WHERE ID = ?";
    private static final String REMOVE_TEMPL_QRY = "DELETE FROM TEMPLATES WHERE ID = ?";
    private static final String REMOVE_FLTR_QRY = "DELETE FROM FILTERS WHERE ID = ?";
    private static final String REMOVE_NTVCMD_QRY_TEMPLATE = "DELETE FROM NATIVECOMMANDS WHERE GAME_ID IS NULL AND TEMPLATE_ID = ?";
    private static final String REMOVE_NTVCMD_QRY_GAME = "DELETE FROM NATIVECOMMANDS WHERE GAME_ID = ? AND TEMPLATE_ID IS NULL";
    private static final String TOGGLE_FAV_QRY = "UPDATE GAMES SET FAVORITE = NOT FAVORITE WHERE ID = ?";
    private static final String GET_VERSION = "SELECT MAJORVERSION, MINORVERSION FROM VERSION";
    private static final String UP_TO_V050_QRY = "ALTER TABLE GAMES ADD COLUMN CONFFILE VARCHAR(256);ALTER TABLE GAMES ADD COLUMN CAPTURES VARCHAR(256);CREATE TABLE VERSION(MAJORVERSION INTEGER NOT NULL, MINORVERSION INTEGER NOT NULL);INSERT INTO VERSION VALUES(0, 50);UPDATE GAMES SET CAPTURES = '" + FileUtils.CAPTURES_DIR + "' || GAMES.ID," + " CONFFILE = '" + FileUtils.PROFILES_DIR + "' || GAMES.ID || '" + ".conf" + "';";
    private static final String UP_TO_V051_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN PARAMETERS VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 51;";
    private static final String UP_TO_V056_QRY = "ALTER TABLE GAMES ADD COLUMN LINK3 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK4 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUST1_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST2_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST3_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST4_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM5 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM6 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM7 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM8 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM9  INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM10 INTEGER DEFAULT 0;CREATE TABLE CUSTOM1(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM2(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM3(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM4(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);INSERT INTO CUSTOM1(VALUE) VALUES('');INSERT INTO CUSTOM2(VALUE) VALUES('');INSERT INTO CUSTOM3(VALUE) VALUES('');INSERT INTO CUSTOM4(VALUE) VALUES('');UPDATE VERSION SET MINORVERSION = 56;";
    private static final String UP_TO_V062_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN VERSION VARCHAR(256) DEFAULT '0.72' NOT NULL;UPDATE VERSION SET MINORVERSION = 62;";
    private static final String UP_TO_V065_QRY = "ALTER TABLE GAMES ADD COLUMN LINK1_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK2_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK3_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK4_TITLE VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 65;";
    private static final String UP_TO_V067_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN USINGCURSES BOOLEAN;UPDATE VERSION SET MINORVERSION = 67;";
    private static final String UP_TO_V068_QRY = "CREATE MEMORY TABLE FILTERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,FILTER VARCHAR(256) NOT NULL,CONF_FILTER VARCHAR(256) NOT NULL);UPDATE VERSION SET MINORVERSION = 68;";
    private static final String UP_TO_V072_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN CONFFILE VARCHAR(256) DEFAULT '' NOT NULL;UPDATE DOSBOXVERSIONS SET CONFFILE = CONCAT(PATH, '" + File.separatorChar + "dosbox.conf" + "');" + "UPDATE VERSION SET MINORVERSION = 72;";
    private static final String UP_TO_V073_QRY = "ALTER TABLE GAMES ADD COLUMN ALT1 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN ALT1_PARAMS VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN ALT2 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN ALT2_PARAMS VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK5 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK6 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK7 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK8 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK5_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK6_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK7_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK8_TITLE VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 73;";
    private static final String UP_TO_V074_QRY = "ALTER TABLE DOSBOXVERSIONS ALTER COLUMN DEFAULT RENAME TO ISDEFAULT;ALTER TABLE TEMPLATES ALTER COLUMN DEFAULT RENAME TO ISDEFAULT;UPDATE VERSION SET MINORVERSION = 74;";
    private static final String UP_TO_V075_QRY = "CREATE MEMORY TABLE NATIVECOMMANDS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,COMMAND VARCHAR(256) NOT NULL,PARAMETERS VARCHAR(256) NOT NULL,CWD VARCHAR(256) NOT NULL,WAITFOR BOOLEAN,ORDERNR INTEGER,GAME_ID INTEGER,TEMPLATE_ID INTEGER,CONSTRAINT SYS_FK_180 FOREIGN KEY(GAME_ID) REFERENCES GAMES(ID),CONSTRAINT SYS_FK_181 FOREIGN KEY(TEMPLATE_ID) REFERENCES TEMPLATES(ID));UPDATE VERSION SET MINORVERSION = 75;";
    private static final String CREATE_INITIAL_DB = "SET WRITE_DELAY 1;CREATE MEMORY TABLE VERSION(MAJORVERSION INTEGER NOT NULL,MINORVERSION INTEGER NOT NULL);CREATE MEMORY TABLE DEVELOPERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE PUBLISHERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE GENRES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE PUBLYEARS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,YEAR CHAR(4) NOT NULL);CREATE MEMORY TABLE STATUS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,STAT VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM1(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM2(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM3(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM4(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE DOSBOXVERSIONS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,PATH VARCHAR(256) NOT NULL,CONFFILE VARCHAR(256) NOT NULL,MULTICONF BOOLEAN,ISDEFAULT BOOLEAN,PARAMETERS VARCHAR(256) DEFAULT '',VERSION VARCHAR(256) NOT NULL,USINGCURSES BOOLEAN);CREATE MEMORY TABLE TEMPLATES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,DBVERSION_ID INTEGER,ISDEFAULT BOOLEAN,CONSTRAINT SYS_FK_185 FOREIGN KEY(DBVERSION_ID) REFERENCES DOSBOXVERSIONS(ID));CREATE MEMORY TABLE GAMES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,DEV_ID INTEGER,PUBL_ID INTEGER,GENRE_ID INTEGER,YEAR_ID INTEGER,STAT_ID INTEGER,NOTES LONGVARCHAR,FAVORITE BOOLEAN,SETUP VARCHAR(256),SETUP_PARAMS VARCHAR(256),ALT1 VARCHAR(256) DEFAULT '',ALT1_PARAMS VARCHAR(256) DEFAULT '',ALT2 VARCHAR(256) DEFAULT '',ALT2_PARAMS VARCHAR(256) DEFAULT '',CONFFILE VARCHAR(256),CAPTURES VARCHAR(256),DBVERSION_ID INTEGER,LINK1 VARCHAR(256),LINK2 VARCHAR(256),LINK3 VARCHAR(256) DEFAULT '',LINK4 VARCHAR(256) DEFAULT '',LINK5 VARCHAR(256) DEFAULT '',LINK6 VARCHAR(256) DEFAULT '',LINK7 VARCHAR(256) DEFAULT '',LINK8 VARCHAR(256) DEFAULT '',LINK1_TITLE VARCHAR(256) DEFAULT '',LINK2_TITLE VARCHAR(256) DEFAULT '',LINK3_TITLE VARCHAR(256) DEFAULT '',LINK4_TITLE VARCHAR(256) DEFAULT '',LINK5_TITLE VARCHAR(256) DEFAULT '',LINK6_TITLE VARCHAR(256) DEFAULT '',LINK7_TITLE VARCHAR(256) DEFAULT '',LINK8_TITLE VARCHAR(256) DEFAULT '',CUST1_ID INTEGER DEFAULT 0,CUST2_ID INTEGER DEFAULT 0,CUST3_ID INTEGER DEFAULT 0,CUST4_ID INTEGER DEFAULT 0,CUSTOM5 VARCHAR(256) DEFAULT '',CUSTOM6 VARCHAR(256) DEFAULT '',CUSTOM7 VARCHAR(256) DEFAULT '',CUSTOM8 VARCHAR(256) DEFAULT '',CUSTOM9 INTEGER DEFAULT 0,CUSTOM10 INTEGER DEFAULT 0,CONSTRAINT SYS_FK_165 FOREIGN KEY(DEV_ID) REFERENCES DEVELOPERS(ID),CONSTRAINT SYS_FK_166 FOREIGN KEY(PUBL_ID) REFERENCES PUBLISHERS(ID),CONSTRAINT SYS_FK_167 FOREIGN KEY(GENRE_ID) REFERENCES GENRES(ID),CONSTRAINT SYS_FK_168 FOREIGN KEY(YEAR_ID) REFERENCES PUBLYEARS(ID),CONSTRAINT SYS_FK_169 FOREIGN KEY(DBVERSION_ID) REFERENCES DOSBOXVERSIONS(ID),CONSTRAINT SYS_FK_170 FOREIGN KEY(STAT_ID) REFERENCES STATUS(ID));CREATE MEMORY TABLE FILTERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,FILTER VARCHAR(256) NOT NULL,CONF_FILTER VARCHAR(256) NOT NULL);CREATE MEMORY TABLE NATIVECOMMANDS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,COMMAND VARCHAR(256) NOT NULL,PARAMETERS VARCHAR(256) NOT NULL,CWD VARCHAR(256) NOT NULL,WAITFOR BOOLEAN,ORDERNR INTEGER,GAME_ID INTEGER,TEMPLATE_ID INTEGER,CONSTRAINT SYS_FK_180 FOREIGN KEY(GAME_ID) REFERENCES GAMES(ID),CONSTRAINT SYS_FK_181 FOREIGN KEY(TEMPLATE_ID) REFERENCES TEMPLATES(ID));INSERT INTO CUSTOM1(VALUE) VALUES(''); INSERT INTO CUSTOM2(VALUE) VALUES('');INSERT INTO CUSTOM3(VALUE) VALUES(''); INSERT INTO CUSTOM4(VALUE) VALUES('');INSERT INTO VERSION VALUES(0,75);";
    private static final String TEST_QRY = "SELECT TOP 1 ID FROM GAMES";
    private static final String CLEANUP_QRY = "DELETE FROM DEVELOPERS WHERE ID NOT IN (SELECT DISTINCT DEV_ID FROM GAMES);DELETE FROM PUBLISHERS WHERE ID NOT IN (SELECT DISTINCT PUBL_ID FROM GAMES);DELETE FROM GENRES WHERE ID NOT IN (SELECT DISTINCT GENRE_ID FROM GAMES);DELETE FROM PUBLYEARS WHERE ID NOT IN (SELECT DISTINCT YEAR_ID FROM GAMES);DELETE FROM STATUS WHERE ID NOT IN (SELECT DISTINCT STAT_ID FROM GAMES);DELETE FROM CUSTOM1 WHERE ID NOT IN (SELECT DISTINCT CUST1_ID FROM GAMES);DELETE FROM CUSTOM2 WHERE ID NOT IN (SELECT DISTINCT CUST2_ID FROM GAMES);DELETE FROM CUSTOM3 WHERE ID NOT IN (SELECT DISTINCT CUST3_ID FROM GAMES);DELETE FROM CUSTOM4 WHERE ID NOT IN (SELECT DISTINCT CUST4_ID FROM GAMES)";
    private static final String FIND_INVALID_PROFILES = "SELECT GAM.ID, GAM.TITLE, DEV.NAME, PUBL.NAME, GEN.NAME, YR.YEAR, STAT.STAT, GAM.NOTES, GAM.FAVORITE, GAM.SETUP, GAM.SETUP_PARAMS, GAM.ALT1, GAM.ALT1_PARAMS, GAM.ALT2, GAM.ALT2_PARAMS, GAM.CONFFILE, GAM.CAPTURES, GAM.DBVERSION_ID, GAM.LINK1, GAM.LINK2, GAM.LINK3, GAM.LINK4, GAM.LINK5, GAM.LINK6, GAM.LINK7, GAM.LINK8, GAM.LINK1_TITLE, GAM.LINK2_TITLE, GAM.LINK3_TITLE, GAM.LINK4_TITLE, GAM.LINK5_TITLE, GAM.LINK6_TITLE, GAM.LINK7_TITLE, GAM.LINK8_TITLE, CUST1.VALUE, CUST2.VALUE, CUST3.VALUE, CUST4.VALUE, GAM.CUSTOM5, GAM.CUSTOM6, GAM.CUSTOM7, GAM.CUSTOM8, GAM.CUSTOM9, GAM.CUSTOM10 FROM GAMES GAM, DEVELOPERS DEV, PUBLISHERS PUBL, GENRES GEN, PUBLYEARS YR, STATUS STAT, CUSTOM1 CUST1, CUSTOM2 CUST2, CUSTOM3 CUST3, CUSTOM4 CUST4 WHERE GAM.DEV_ID=DEV.ID AND GAM.PUBL_ID=PUBL.ID AND GAM.GENRE_ID=GEN.ID AND GAM.YEAR_ID=YR.ID AND GAM.STAT_ID=STAT.ID AND   GAM.CUST1_ID=CUST1.ID AND GAM.CUST2_ID=CUST2.ID AND GAM.CUST3_ID=CUST3.ID AND GAM.CUST4_ID=CUST4.ID AND (GAM.CONFFILE IS NULL OR GAM.CAPTURES IS NULL)";
    private static final int COMPLEX_STRINGS = CUSTOM_LIST_QRY.length;
    private static final int SIMPLE_STRINGS = 4;

    private Database() {
        this.init();
    }

    public static Database getInstance() {
        return DatabaseHolder.instance;
    }

    public static boolean isInitializedNewDatabase() {
        return initializedNewDatabase;
    }

    private void closeAll(Statement statement, ResultSet resultSet) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                System.err.println(Settings.getInstance().msg("database.error.statementclose"));
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                System.err.println(Settings.getInstance().msg("database.error.resultsetclose"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getVersion() {
        int[] nArray = new int[2];
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(GET_VERSION);
            if (resultSet != null && resultSet.next()) {
                nArray[0] = resultSet.getInt(1);
                nArray[1] = resultSet.getInt(2);
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                nArray[0] = 0;
                nArray[1] = 0;
                this.closeAll(statement, resultSet);
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return nArray;
    }

    private void upgradeToVersion(String string, int n) throws SQLException {
        System.out.println(Settings.getInstance().msg("database.notice.upgrade", new Object[]{0, n}));
        Statement statement = null;
        try {
            statement = con.createStatement();
            for (String string2 : string.split(";")) {
                statement.addBatch(string2);
            }
            statement.executeBatch();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.upgrade", new Object[]{0, n}));
        }
        finally {
            this.closeAll(statement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary() throws SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.executeQuery(TEST_QRY);
        }
        catch (SQLException sQLException) {
            Statement statement2 = null;
            try {
                statement2 = con.createStatement();
                for (String string : CREATE_INITIAL_DB.split(";")) {
                    statement2.addBatch(string);
                }
                statement2.executeBatch();
                initializedNewDatabase = true;
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"create initial tables"}));
            }
            finally {
                this.closeAll(statement2, null);
            }
        }
        finally {
            this.closeAll(statement, null);
        }
    }

    private void upgradeIfNecessary() throws SQLException {
        int[] nArray = this.getVersion();
        if (nArray[0] <= 0 && nArray[1] < 50) {
            this.upgradeToVersion(UP_TO_V050_QRY, 50);
        }
        if (nArray[0] <= 0 && nArray[1] < 51) {
            this.upgradeToVersion(UP_TO_V051_QRY, 51);
        }
        if (nArray[0] <= 0 && nArray[1] < 56) {
            this.upgradeToVersion(UP_TO_V056_QRY, 56);
        }
        if (nArray[0] <= 0 && nArray[1] < 62) {
            this.upgradeToVersion(UP_TO_V062_QRY, 62);
        }
        if (nArray[0] <= 0 && nArray[1] < 65) {
            this.upgradeToVersion(UP_TO_V065_QRY, 65);
        }
        if (nArray[0] <= 0 && nArray[1] < 67) {
            this.upgradeToVersion(UP_TO_V067_QRY, 67);
        }
        if (nArray[0] <= 0 && nArray[1] < 68) {
            this.upgradeToVersion(UP_TO_V068_QRY, 68);
        }
        if (nArray[0] <= 0 && nArray[1] < 72) {
            this.upgradeToVersion(UP_TO_V072_QRY, 72);
        }
        if (nArray[0] <= 0 && nArray[1] < 73) {
            this.upgradeToVersion(UP_TO_V073_QRY, 73);
        }
        if (nArray[0] <= 0 && nArray[1] < 74) {
            this.upgradeToVersion(UP_TO_V074_QRY, 74);
        }
        if (nArray[0] <= 0 && nArray[1] < 75) {
            this.upgradeToVersion(UP_TO_V075_QRY, 75);
        }
    }

    private void init() {
        Settings settings = Settings.getInstance();
        System.out.println(settings.msg("database.notice.startup"));
        String string = settings.getSettings().getValue("database", "connectionstring");
        if (string.contains("file:")) {
            int n = string.indexOf("file:") + 5;
            int n2 = string.indexOf(59, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = FileUtils.getDatabaseFile(string).getPath();
            string = string.substring(0, n) + string2 + string.substring(n2);
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            con = DriverManager.getConnection(string, settings.getSettings().getValue("database", "username"), settings.getSettings().getValue("database", "password"));
            this.initializeIfNecessary();
            this.upgradeIfNecessary();
        }
        catch (SQLException sQLException) {
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, settings.msg("database.error.initconnection", new Object[]{StringRelatedUtils.toString(sQLException)}), sQLException);
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sQLException2) {
                GeneralPurposeDialogs.warningMessage(shell, settings.msg("database.error.connectionclose", new Object[]{StringRelatedUtils.toString(sQLException2)}), sQLException2);
            }
            throw new RuntimeException();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, settings.msg("database.error.registerdriver", new Object[]{StringRelatedUtils.toString(classNotFoundException)}), classNotFoundException);
            throw new RuntimeException();
        }
    }

    private int identity() throws SQLException {
        int n = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(GET_IDENTITY_QRY);
            if (resultSet != null && resultSet.next()) {
                n = resultSet.getInt(1);
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"get identity"}));
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return n;
    }

    private int addSomething(String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(string);
            preparedStatement.setString(1, string2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add " + string2}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
        return this.identity();
    }

    private void removeSomething(String string, String string2, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"remove " + string2}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
    }

    private List<KeyValuePair> readKeyValuePairList(String string) throws SQLException {
        ArrayList<KeyValuePair> arrayList = new ArrayList<KeyValuePair>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet != null) {
                while (resultSet.next()) {
                    arrayList.add(new KeyValuePair(resultSet.getInt(1), resultSet.getString(2)));
                }
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read KeyValuePairs"}));
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    public void shutdown() throws SQLException {
        System.out.println(Settings.getInstance().msg("database.notice.shutdown"));
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.execute("SHUTDOWN");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.shutdown"));
        }
        finally {
            this.closeAll(statement, null);
            con.close();
        }
    }

    public List<Profile> readProfilesList(String string, String string2) throws SQLException {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            StringBuffer stringBuffer = new StringBuffer(GAME_LIST_QRY);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(" AND (").append(string2).append(")");
            }
            stringBuffer.append(string);
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    arrayList.add(new Profile(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getBoolean(9), new String[]{resultSet.getString(10), resultSet.getString(12), resultSet.getString(14)}, new String[]{resultSet.getString(11), resultSet.getString(13), resultSet.getString(15)}, resultSet.getString(16), resultSet.getString(17), resultSet.getInt(18), new String[]{resultSet.getString(19), resultSet.getString(20), resultSet.getString(21), resultSet.getString(22), resultSet.getString(23), resultSet.getString(24), resultSet.getString(25), resultSet.getString(26)}, new String[]{resultSet.getString(27), resultSet.getString(28), resultSet.getString(29), resultSet.getString(30), resultSet.getString(31), resultSet.getString(32), resultSet.getString(33), resultSet.getString(34)}, new String[]{resultSet.getString(35), resultSet.getString(36), resultSet.getString(37), resultSet.getString(38), resultSet.getString(39), resultSet.getString(40), resultSet.getString(41), resultSet.getString(42)}, new int[]{resultSet.getInt(43), resultSet.getInt(44)}));
                }
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                if (string.length() > 0) {
                    sQLException.printStackTrace();
                }
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read profiles"}));
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    public List<KeyValuePair> readDevelopersList() throws SQLException {
        return this.readKeyValuePairList(DEV_LIST_QRY);
    }

    public List<KeyValuePair> readPublishersList() throws SQLException {
        return this.readKeyValuePairList(PUBL_LIST_QRY);
    }

    public List<KeyValuePair> readGenresList() throws SQLException {
        return this.readKeyValuePairList(GENRE_LIST_QRY);
    }

    public List<KeyValuePair> readYearsList() throws SQLException {
        return this.readKeyValuePairList(PUBLYEAR_LIST_QRY);
    }

    public List<KeyValuePair> readStatusList() throws SQLException {
        return this.readKeyValuePairList(STATUS_LIST_QRY);
    }

    public List<KeyValuePair> readCustomList(int n) throws SQLException {
        return this.readKeyValuePairList(CUSTOM_LIST_QRY[n]);
    }

    public List<DosboxVersion> readDosboxVersionsList() throws SQLException {
        ArrayList<DosboxVersion> arrayList = new ArrayList<DosboxVersion>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(DBVERS_LIST_QRY);
            if (resultSet != null) {
                while (resultSet.next()) {
                    arrayList.add(new DosboxVersion(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getBoolean(5), resultSet.getBoolean(6), resultSet.getBoolean(7), resultSet.getString(8), resultSet.getString(9)));
                }
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read dosboxversions"}));
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    public List<Template> readTemplatesList() throws SQLException {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(TEMPL_LIST_QRY);
            if (resultSet != null) {
                while (resultSet.next()) {
                    arrayList.add(new Template(resultSet.getInt(1), resultSet.getString(2), resultSet.getInt(3), resultSet.getBoolean(4)));
                }
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read templates"}));
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    public List<Filter> readFiltersList() throws SQLException {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(FLTRS_LIST_QRY);
            if (resultSet != null) {
                while (resultSet.next()) {
                    arrayList.add(new Filter(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3)));
                }
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read filters"}));
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    public List<NativeCommand> readNativeCommandsList(int n, int n2) throws SQLException {
        ArrayList<NativeCommand> arrayList = new ArrayList<NativeCommand>();
        if (n != -1 || n2 != -1) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                if (n != -1) {
                    preparedStatement = con.prepareStatement(NTVCMD_LIST_QRY_GAME);
                    preparedStatement.setInt(1, n);
                } else if (n2 != -1) {
                    preparedStatement = con.prepareStatement(NTVCMD_LIST_QRY_TEMPLATE);
                    preparedStatement.setInt(1, n2);
                }
                resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        arrayList.add(new NativeCommand(new File(resultSet.getString(1)), resultSet.getString(2), new File(resultSet.getString(3)), resultSet.getBoolean(4), resultSet.getInt(5)));
                    }
                }
                this.closeAll(preparedStatement, resultSet);
            }
            catch (SQLException sQLException) {
                try {
                    sQLException.printStackTrace();
                    throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read native commands"}));
                }
                catch (Throwable throwable) {
                    this.closeAll(preparedStatement, resultSet);
                    throw throwable;
                }
            }
        }
        NativeCommand.insertDosboxCommand(arrayList);
        return arrayList;
    }

    public void saveNativeCommands(List<NativeCommand> list, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            this.removeNativeCommands(n, n2);
            for (int i = 0; i < list.size(); ++i) {
                NativeCommand nativeCommand = list.get(i);
                if (nativeCommand.getCommand() == null) continue;
                preparedStatement = con.prepareStatement(ADD_NATIVECOMMAND_QRY);
                preparedStatement.setString(1, nativeCommand.getCommand().getPath());
                preparedStatement.setString(2, nativeCommand.getParameters());
                preparedStatement.setString(3, nativeCommand.getCwd().getPath());
                preparedStatement.setBoolean(4, nativeCommand.isWaitFor());
                preparedStatement.setInt(5, i);
                if (n == -1) {
                    preparedStatement.setNull(6, 4);
                } else {
                    preparedStatement.setInt(6, n);
                }
                if (n2 == -1) {
                    preparedStatement.setNull(7, 4);
                } else {
                    preparedStatement.setInt(7, n2);
                }
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"save native commands"}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
    }

    public void removeNativeCommands(int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            if (n != -1) {
                preparedStatement = con.prepareStatement(REMOVE_NTVCMD_QRY_GAME);
                preparedStatement.setInt(1, n);
            } else if (n2 != -1) {
                preparedStatement = con.prepareStatement(REMOVE_NTVCMD_QRY_TEMPLATE);
                preparedStatement.setInt(1, n2);
            }
            preparedStatement.executeUpdate();
            this.closeAll(preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"remove native commands"}));
            }
            catch (Throwable throwable) {
                this.closeAll(preparedStatement, null);
                throw throwable;
            }
        }
    }

    public void removeProfile(int n) throws SQLException {
        this.removeSomething(REMOVE_GAME_QRY, "profile", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDosboxVersion(int n) throws SQLException {
        try {
            this.removeSomething(REMOVE_DBV_QRY, "dosboxversion", n);
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer = new StringBuffer();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            int n2 = 0;
            try {
                preparedStatement = con.prepareStatement(DBV_USE_QRY);
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        if (n2++ >= 10) continue;
                        if (n2 > 1) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(resultSet.getString(1));
                    }
                }
                this.closeAll(preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.closeAll(preparedStatement, resultSet);
                throw throwable;
            }
            throw new SQLException(Settings.getInstance().msg("general.error.profilesandtemplatesusingdbversion", new Object[]{StringRelatedUtils.toString(sQLException), n2, stringBuffer}));
        }
    }

    public void removeTemplate(int n) throws SQLException {
        this.removeSomething(REMOVE_TEMPL_QRY, "template", n);
    }

    public void removeFilter(int n) throws SQLException {
        this.removeSomething(REMOVE_FLTR_QRY, "filter", n);
    }

    public int addOrEditProfile(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray3, String[] stringArray4, String[] stringArray5, int[] nArray, int[] nArray2, int n7) throws SQLException {
        int n8 = -1;
        PreparedStatement preparedStatement = null;
        try {
            int n9;
            preparedStatement = con.prepareStatement(n7 == -1 ? ADD_GAME_QRY : UPD_GAME_QRY);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n == -1 ? this.addSomething(ADD_DEVELOPER_QRY, string2) : n);
            preparedStatement.setInt(3, n2 == -1 ? this.addSomething(ADD_PUBLISHER_QRY, string3) : n2);
            preparedStatement.setInt(4, n3 == -1 ? this.addSomething(ADD_GENRE_QRY, string4) : n3);
            preparedStatement.setInt(5, n4 == -1 ? this.addSomething(ADD_YEAR_QRY, string5) : n4);
            preparedStatement.setInt(6, n5 == -1 ? this.addSomething(ADD_STATUS_QRY, string6) : n5);
            preparedStatement.setString(7, string7);
            preparedStatement.setBoolean(8, bl);
            for (n9 = 0; n9 < stringArray.length; ++n9) {
                preparedStatement.setString(n9 * 2 + 9, stringArray[n9]);
                preparedStatement.setString(n9 * 2 + 10, stringArray2[n9]);
            }
            preparedStatement.setInt(15, n6);
            for (n9 = 0; n9 < stringArray3.length; ++n9) {
                preparedStatement.setString(n9 + 16, stringArray3[n9]);
            }
            for (n9 = 0; n9 < stringArray4.length; ++n9) {
                preparedStatement.setString(n9 + 16 + stringArray3.length, stringArray4[n9]);
            }
            for (n9 = 0; n9 < nArray2.length; ++n9) {
                preparedStatement.setInt(n9 + 16 + stringArray3.length + stringArray4.length, nArray2[n9] == -1 ? this.addSomething(ADD_CUSTOM_QRY[n9], stringArray5[n9]) : nArray2[n9]);
            }
            for (n9 = 0; n9 < 4; ++n9) {
                preparedStatement.setString(n9 + 16 + stringArray3.length + stringArray4.length + nArray2.length, stringArray5[n9 + nArray2.length]);
            }
            for (n9 = 0; n9 < nArray.length; ++n9) {
                preparedStatement.setInt(n9 + 16 + stringArray3.length + stringArray4.length + nArray2.length + 4, nArray[n9]);
            }
            if (n7 == -1) {
                preparedStatement.executeUpdate();
                n8 = this.identity();
            } else {
                preparedStatement.setInt(16 + stringArray3.length + stringArray4.length + nArray2.length + 4 + nArray.length, n7);
                preparedStatement.executeUpdate();
                n8 = n7;
            }
            this.closeAll(preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit profile"}));
            }
            catch (Throwable throwable) {
                this.closeAll(preparedStatement, null);
                throw throwable;
            }
        }
        return n8;
    }

    public synchronized int addOrEditProfile(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String[] stringArray, String[] stringArray2, int n, String[] stringArray3, String[] stringArray4, String[] stringArray5, int[] nArray, int n2) throws SQLException {
        int n3 = KeyValuePair.findIdByValue(this.readDevelopersList(), string2);
        int n4 = KeyValuePair.findIdByValue(this.readPublishersList(), string3);
        int n5 = KeyValuePair.findIdByValue(this.readGenresList(), string4);
        int n6 = KeyValuePair.findIdByValue(this.readYearsList(), string5);
        int n7 = KeyValuePair.findIdByValue(this.readStatusList(), string6);
        int[] nArray2 = new int[COMPLEX_STRINGS];
        for (int i = 0; i < COMPLEX_STRINGS; ++i) {
            nArray2[i] = KeyValuePair.findIdByValue(this.readCustomList(i), stringArray5[i]);
        }
        return this.addOrEditProfile(string, string2, string3, string4, string5, string6, string7, bl, stringArray, stringArray2, n3, n4, n5, n6, n7, n, stringArray3, stringArray4, stringArray5, nArray, nArray2, n2);
    }

    public void updateProfileConf(String string, String string2, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(UPD_GAME_CONF_QRY);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"update profile conf"}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
    }

    public void updateProfileSetupAndLinks(String[] stringArray, String[] stringArray2, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = con.prepareStatement(UPD_STPLNKS_QRY);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                preparedStatement.setString(n2 + 1, stringArray[n2]);
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                preparedStatement.setString(n2 + 4, stringArray2[n2]);
            }
            preparedStatement.setInt(4 + stringArray2.length, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"update profile setup and links"}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
    }

    public void toggleFavorite(int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(TOGGLE_FAV_QRY);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"toggle favorite"}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
    }

    public int duplicateProfile(int n) throws SQLException {
        int n2 = -1;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(DUPL_GAME_QRY);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            n2 = this.identity();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"duplicate profile"}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
        return n2;
    }

    public int duplicateTemplate(int n) throws SQLException {
        int n2 = -1;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(DUPL_TEMPLATE_QRY);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            n2 = this.identity();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"duplicate template"}));
        }
        finally {
            this.closeAll(preparedStatement, null);
        }
        return n2;
    }

    public int addOrEditDosboxVersion(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4, String string5, int n) throws SQLException {
        int n2 = -1;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        try {
            if (bl3) {
                statement = con.createStatement();
                statement.executeUpdate(UPD_DBV_NODEFAULT);
            }
            if (n == -1) {
                preparedStatement = con.prepareStatement(ADD_DBVERSION_QRY);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setBoolean(4, bl);
                preparedStatement.setBoolean(5, bl2);
                preparedStatement.setBoolean(6, bl3);
                preparedStatement.setString(7, string4);
                preparedStatement.setString(8, string5);
                preparedStatement.executeUpdate();
                n2 = this.identity();
            } else {
                preparedStatement = con.prepareStatement(UPD_DBVERSION_QRY);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setBoolean(4, bl);
                preparedStatement.setBoolean(5, bl2);
                preparedStatement.setBoolean(6, bl3);
                preparedStatement.setString(7, string4);
                preparedStatement.setString(8, string5);
                preparedStatement.setInt(9, n);
                preparedStatement.executeUpdate();
                n2 = n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit dosboxversion"}));
        }
        finally {
            this.closeAll(statement, null);
            this.closeAll(preparedStatement, null);
        }
        return n2;
    }

    public int addOrEditTemplate(String string, int n, boolean bl, int n2) throws SQLException {
        int n3 = -1;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        try {
            if (bl) {
                statement = con.createStatement();
                statement.executeUpdate(UPD_TEMPL_NODFLT);
            }
            if (n2 == -1) {
                preparedStatement = con.prepareStatement(ADD_TEMPLATE_QRY);
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                preparedStatement.setBoolean(3, bl);
                preparedStatement.executeUpdate();
                n3 = this.identity();
            } else {
                preparedStatement = con.prepareStatement(UPD_TEMPLATE_QRY);
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                preparedStatement.setBoolean(3, bl);
                preparedStatement.setInt(4, n2);
                preparedStatement.executeUpdate();
                n3 = n2;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit template"}));
        }
        finally {
            this.closeAll(statement, null);
            this.closeAll(preparedStatement, null);
        }
        return n3;
    }

    public int addOrEditFilter(String string, String string2, int n) throws SQLException {
        int n2 = -1;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        try {
            if (n == -1) {
                preparedStatement = con.prepareStatement(ADD_FILTER_QRY);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.executeUpdate();
                n2 = this.identity();
            } else {
                preparedStatement = con.prepareStatement(UPD_FILTER_QRY);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
                n2 = n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit filter"}));
        }
        finally {
            this.closeAll(statement, null);
            this.closeAll(preparedStatement, null);
        }
        return n2;
    }

    public void startTransaction() {
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void rollbackTransaction() throws SQLException {
        con.rollback();
    }

    public void commitTransaction() throws SQLException {
        con.commit();
    }

    public void finishTransaction() {
        try {
            con.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int cleanup() throws SQLException {
        int n = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            for (String string : CLEANUP_QRY.split(";")) {
                statement.addBatch(string);
            }
            int[] sQLException = statement.executeBatch();
            n = 0;
            for (int n2 : sQLException) {
                n += n2;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"cleanup"}));
        }
        finally {
            this.closeAll(statement, resultSet);
        }
        return n;
    }

    public List<Profile> findInvalidProfiles() throws SQLException {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(FIND_INVALID_PROFILES);
            if (resultSet != null) {
                while (resultSet.next()) {
                    arrayList.add(new Profile(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getBoolean(9), new String[]{resultSet.getString(10), resultSet.getString(12), resultSet.getString(14)}, new String[]{resultSet.getString(11), resultSet.getString(13), resultSet.getString(15)}, resultSet.getString(16), resultSet.getString(17), resultSet.getInt(18), new String[]{resultSet.getString(19), resultSet.getString(20), resultSet.getString(21), resultSet.getString(22), resultSet.getString(23), resultSet.getString(24), resultSet.getString(25), resultSet.getString(26)}, new String[]{resultSet.getString(27), resultSet.getString(28), resultSet.getString(29), resultSet.getString(30), resultSet.getString(31), resultSet.getString(32), resultSet.getString(33), resultSet.getString(34)}, new String[]{resultSet.getString(35), resultSet.getString(36), resultSet.getString(37), resultSet.getString(38), resultSet.getString(39), resultSet.getString(40), resultSet.getString(41), resultSet.getString(42)}, new int[]{resultSet.getInt(43), resultSet.getInt(44)}));
                }
            }
            this.closeAll(statement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"remove invalid profiles"}));
            }
            catch (Throwable throwable) {
                this.closeAll(statement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    private static class DatabaseHolder {
        private static Database instance = new Database();

        private DatabaseHolder() {
        }
    }
}

