/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.DFendImportThread;
import org.dbgl.util.DFendReloadedImportThread;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class DFendImportDialog
extends Dialog {
    private ExpandItem orginalExpandItem;
    private ExpandItem reloadedExpandItem;
    private Text location;
    private Text dfrLocation;
    private Text dfrConfsLocation;
    private Text logText;
    private DosboxVersion defaultDbversion;
    private UIThread importThread;
    private Button cancelButton;
    private Label profileLabel;
    private Shell shell;
    private Settings settings;

    public DFendImportDialog(Shell shell, int n) {
        super(shell, n);
    }

    public DFendImportDialog(Shell shell) {
        this(shell, 0);
    }

    public void setDefaultDosboxVersion(DosboxVersion dosboxVersion) {
        this.defaultDbversion = dosboxVersion;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.importThread != null && !this.importThread.isAlive() && !this.cancelButton.getText().equals(this.settings.msg("button.finish"))) {
                if (this.importThread.isEverythingOk()) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.dfendimport.notice.importok"));
                } else {
                    GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.dfendimport.error.problem"));
                }
                this.profileLabel.setText(this.settings.msg("dialog.dfendimport.reviewlog"));
                this.profileLabel.pack();
                this.cancelButton.setText(this.settings.msg("button.finish"));
                this.cancelButton.setEnabled(true);
                this.shell.setDefaultButton(this.cancelButton);
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.importThread;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "dfendimportdialog"));
        this.shell.setText(this.settings.msg("dialog.dfendimport.title"));
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.dfendimport.options"));
        group.setLayout((Layout)new GridLayout(3, false));
        final ExpandBar expandBar = new ExpandBar((Composite)group, 512);
        expandBar.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite composite = new Composite((Composite)expandBar, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Composite composite2 = new Composite((Composite)expandBar, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.dfendimport.dfendpath"));
        this.location = new Text(composite, 2048);
        this.location.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.location.setText(PlatformUtils.DFEND_PATH + "Profiles.dat");
        final BrowseButton browseButton = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.location, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DFEND, false, null);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.dfendimport.cleanup"));
        final Button button = new Button(composite, 32);
        button.setText(this.settings.msg("dialog.dfendimport.removesections"));
        button.setSelection(true);
        new Label(composite, 0);
        Label label3 = new Label(composite2, 0);
        label3.setText(this.settings.msg("dialog.dfendimport.reloaded.path"));
        this.dfrLocation = new Text(composite2, 2048);
        this.dfrLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dfrLocation.setText(PlatformUtils.DFEND_RELOADED_PATH.getPath());
        BrowseButton browseButton2 = new BrowseButton(composite2, 0);
        browseButton2.connect(this.shell, this.dfrLocation, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Label label4 = new Label(composite2, 0);
        label4.setText(this.settings.msg("dialog.dfendimport.reloaded.exportedconfspath"));
        this.dfrConfsLocation = new Text(composite2, 2048);
        this.dfrConfsLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton3 = new BrowseButton(composite2, 0);
        browseButton3.connect(this.shell, this.dfrConfsLocation, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Label label5 = new Label(composite2, 0);
        label5.setText(this.settings.msg("dialog.dfendimport.cleanup"));
        final Button button2 = new Button(composite2, 32);
        button2.setText(this.settings.msg("dialog.dfendimport.reloaded.removesections"));
        new Label(composite2, 0);
        this.orginalExpandItem = new ExpandItem(expandBar, 0, 0);
        this.orginalExpandItem.setText(this.settings.msg("dialog.dfendimport.original.title"));
        this.orginalExpandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        this.orginalExpandItem.setControl((Control)composite);
        this.reloadedExpandItem = new ExpandItem(expandBar, 0, 1);
        this.reloadedExpandItem.setText(this.settings.msg("dialog.dfendimport.reloaded.title"));
        this.reloadedExpandItem.setHeight(composite2.computeSize((int)-1, (int)-1).y);
        this.reloadedExpandItem.setControl((Control)composite2);
        this.reloadedExpandItem.setExpanded(true);
        expandBar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent expandEvent) {
                expandBar.getItem(((ExpandItem)expandEvent.item).getText().equals(DFendImportDialog.this.settings.msg("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(true);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        DFendImportDialog.this.shell.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent expandEvent) {
                expandBar.getItem(((ExpandItem)expandEvent.item).getText().equals(DFendImportDialog.this.settings.msg("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        DFendImportDialog.this.shell.layout();
                    }
                });
            }
        });
        final Button button3 = new Button((Composite)group, 0);
        this.shell.setDefaultButton(button3);
        button3.setLayoutData((Object)new GridData(120, -1));
        button3.setText(this.settings.msg("dialog.dfendimport.startimport"));
        this.cancelButton = new Button((Composite)group, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DFendImportDialog.this.shell.close();
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(80, -1));
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        new Label((Composite)group, 0);
        Group group2 = new Group((Composite)this.shell, 0);
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        group2.setText(this.settings.msg("dialog.dfendimport.progress"));
        group2.setLayout((Layout)new GridLayout());
        final ProgressBar progressBar = new ProgressBar((Composite)group2, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label((Composite)group2, 0);
        this.logText = new Text((Composite)group2, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    if (!DFendImportDialog.this.isValid()) {
                        return;
                    }
                    if (DFendImportDialog.this.orginalExpandItem.getExpanded()) {
                        DFendImportDialog.this.importThread = new DFendImportThread(DFendImportDialog.this.logText, progressBar, DFendImportDialog.this.profileLabel, new File(DFendImportDialog.this.location.getText()), button.getSelection(), DFendImportDialog.this.defaultDbversion);
                    } else {
                        DFendImportDialog.this.importThread = new DFendReloadedImportThread(DFendImportDialog.this.logText, progressBar, DFendImportDialog.this.profileLabel, new File(DFendImportDialog.this.dfrLocation.getText()), new File(DFendImportDialog.this.dfrConfsLocation.getText()), button2.getSelection(), DFendImportDialog.this.defaultDbversion);
                    }
                    DFendImportDialog.this.location.setEnabled(false);
                    DFendImportDialog.this.dfrLocation.setEnabled(false);
                    DFendImportDialog.this.dfrConfsLocation.setEnabled(false);
                    browseButton.setEnabled(false);
                    button.setEnabled(false);
                    button3.setEnabled(false);
                    DFendImportDialog.this.cancelButton.setEnabled(false);
                    DFendImportDialog.this.importThread.start();
                }
                catch (Exception exception) {
                    GeneralPurposeDialogs.warningMessage(DFendImportDialog.this.shell, exception);
                    DFendImportDialog.this.importThread = null;
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.orginalExpandItem.getExpanded()) {
            if (StringUtils.isBlank((CharSequence)this.location.getText())) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dfendimport.required.location"), (Control)this.location);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)this.dfrLocation.getText())) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dfendimport.reloaded.required.location"), (Control)this.dfrLocation);
            }
            if (StringUtils.isBlank((CharSequence)this.dfrConfsLocation.getText())) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dfendimport.reloaded.required.confslocation"), (Control)this.dfrConfsLocation);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

