/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteProfilesDialog
extends Dialog {
    private List<Profile> profs;
    private List<DosboxVersion> dbversions;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;

    public DeleteProfilesDialog(Shell shell) {
        super(shell, 0);
    }

    public void setProfilesToBeDeleted(List<Profile> list, List<DosboxVersion> list2) {
        this.profs = list;
        this.dbversions = list2;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "profiledeletedialog"));
        this.shell.setText(this.settings.msg("dialog.deleteprofiles.title", new Object[]{this.profs.size()}));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.deleteprofiles.options"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        tabItem.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.deleteprofiles.confirm.removedatabaseentry"));
        Button button = new Button(composite, 32);
        button.setSelection(true);
        button.setEnabled(false);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.deleteprofiles.confirm.removeprofileconf"));
        final Button button2 = new Button(composite, 32);
        button2.setSelection(true);
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.deleteprofiles.confirm.removemapperfile"));
        final Button button3 = new Button(composite, 32);
        button3.setSelection(true);
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.deleteprofiles.confirm.removeprofilecaptures"));
        final Button button4 = new Button(composite, 32);
        button4.setSelection(true);
        Composite composite2 = new Composite((Composite)this.shell, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        composite2.setLayoutData((Object)"South");
        Button button5 = new Button(composite2, 0);
        this.shell.setDefaultButton(button5);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        button5.setLayoutData((Object)gridData);
        button5.setText(this.settings.msg("button.ok"));
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GeneralPurposeDialogs.confirmMessage(DeleteProfilesDialog.this.shell, DeleteProfilesDialog.this.settings.msg("dialog.deleteprofiles.confirm.removal", new Object[]{DeleteProfilesDialog.this.profs.size()}))) {
                    for (Profile profile : DeleteProfilesDialog.this.profs) {
                        try {
                            Conf conf;
                            File file;
                            DeleteProfilesDialog.this.dbase.startTransaction();
                            DeleteProfilesDialog.this.dbase.removeNativeCommands(profile.getId(), -1);
                            DeleteProfilesDialog.this.dbase.removeProfile(profile.getId());
                            DeleteProfilesDialog.this.dbase.commitTransaction();
                            if (button3.getSelection() && (file = (conf = new Conf(profile, (DosboxVersion)DosboxVersion.findById(DeleteProfilesDialog.this.dbversions, profile.getDbversionId()), System.err)).getCustomMapperFile()) != null) {
                                FileUtils.removeFile(file);
                            }
                            if (button2.getSelection()) {
                                FileUtils.removeFile(profile.getCanonicalConfFile());
                            }
                            if (!button4.getSelection()) continue;
                            FileUtils.removeFilesInDirAndDir(profile.getCanonicalCaptures());
                        }
                        catch (IOException iOException) {
                            GeneralPurposeDialogs.warningMessage(DeleteProfilesDialog.this.shell, iOException);
                        }
                        catch (SQLException sQLException) {
                            try {
                                DeleteProfilesDialog.this.dbase.rollbackTransaction();
                            }
                            catch (SQLException sQLException2) {
                                GeneralPurposeDialogs.warningMessage(DeleteProfilesDialog.this.shell, sQLException2);
                            }
                            GeneralPurposeDialogs.warningMessage(DeleteProfilesDialog.this.shell, sQLException);
                        }
                        finally {
                            DeleteProfilesDialog.this.dbase.finishTransaction();
                        }
                    }
                    DeleteProfilesDialog.this.result = DeleteProfilesDialog.this.profs;
                }
                DeleteProfilesDialog.this.shell.close();
            }
        });
        Button button6 = new Button(composite2, 0);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        button6.setLayoutData((Object)gridData2);
        button6.setText(this.settings.msg("button.cancel"));
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeleteProfilesDialog.this.result = null;
                DeleteProfilesDialog.this.shell.close();
            }
        });
    }
}

