/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.dbgl.db.Database;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public final class EditDosboxVersionDialog
extends Dialog {
    private Text title;
    private Text path;
    private Text conf;
    private Text parameters;
    private Button usingCurses;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;
    private boolean isDefault;

    public EditDosboxVersionDialog(Shell shell, boolean bl) {
        super(shell, 0);
        this.isDefault = bl;
    }

    public void setDosboxVersion(DosboxVersion dosboxVersion) {
        this.result = dosboxVersion;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "dosboxdialog"));
        if (this.result == null || ((DosboxVersion)this.result).getId() == -1) {
            this.shell.setText(this.settings.msg("dialog.dosboxversion.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.dosboxversion.title.edit", new Object[]{((DosboxVersion)this.result).getTitle(), ((DosboxVersion)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.dosboxversion.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        tabItem.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.dosboxversion.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.dosboxversion.path"));
        this.path = new Text(composite, 2048);
        this.path.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton(composite, 0);
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.profile.configfile"));
        this.conf = new Text(composite, 2048);
        this.conf.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton2 = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.path, this.conf, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.DOSBOX, false, null);
        browseButton2.connect(this.shell, this.conf, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOSBOXCONF, false, null);
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.dosboxversion.parameters"));
        this.parameters = new Text(composite, 2048);
        this.parameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Label label5 = new Label(composite, 0);
        label5.setText(this.settings.msg("dialog.dosboxversion.version"));
        final Combo combo = new Combo(composite, 2056);
        combo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        combo.setItems(DosboxVersion.SUPP_RELEASES);
        combo.setVisibleItemCount(15);
        combo.select(combo.getItemCount() - 1);
        new Label(composite, 0);
        Label label6 = new Label(composite, 0);
        label6.setText(this.settings.msg("dialog.dosboxversion.multiconfsupport"));
        final Button button = new Button(composite, 32);
        button.setSelection(true);
        new Label(composite, 0);
        Label label7 = new Label(composite, 0);
        label7.setText(this.settings.msg("dialog.dosboxversion.altstartup"));
        this.usingCurses = new Button(composite, 32);
        this.usingCurses.setText(this.settings.msg("dialog.dosboxversion.altstartupexplanation"));
        this.usingCurses.setSelection(false);
        this.usingCurses.setEnabled(PlatformUtils.IS_WINDOWS);
        this.usingCurses.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        Label label8 = new Label(composite, 0);
        label8.setText(this.settings.msg("dialog.dosboxversion.default"));
        final Button button2 = new Button(composite, 32);
        button2.setSelection(this.isDefault);
        new Label(composite, 0);
        Composite composite2 = new Composite((Composite)this.shell, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        composite2.setLayoutData((Object)"South");
        Button button3 = new Button(composite2, 0);
        this.shell.setDefaultButton(button3);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        button3.setLayoutData((Object)gridData);
        button3.setText(this.settings.msg("button.ok"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EditDosboxVersionDialog.this.isValid()) {
                    return;
                }
                try {
                    int n = EditDosboxVersionDialog.this.dbase.addOrEditDosboxVersion(EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), EditDosboxVersionDialog.this.conf.getText(), button.getSelection(), EditDosboxVersionDialog.this.usingCurses.getSelection(), button2.getSelection(), EditDosboxVersionDialog.this.parameters.getText(), combo.getText(), EditDosboxVersionDialog.this.result == null ? -1 : ((DosboxVersion)EditDosboxVersionDialog.this.result).getId());
                    EditDosboxVersionDialog.this.result = new DosboxVersion(n, EditDosboxVersionDialog.this.title.getText(), EditDosboxVersionDialog.this.path.getText(), EditDosboxVersionDialog.this.conf.getText(), button.getSelection(), EditDosboxVersionDialog.this.usingCurses.getSelection(), button2.getSelection(), EditDosboxVersionDialog.this.parameters.getText(), combo.getText());
                }
                catch (SQLException sQLException) {
                    GeneralPurposeDialogs.warningMessage(EditDosboxVersionDialog.this.shell, sQLException);
                }
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        Button button4 = new Button(composite2, 0);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        button4.setLayoutData((Object)gridData2);
        button4.setText(this.settings.msg("button.cancel"));
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditDosboxVersionDialog.this.result = null;
                EditDosboxVersionDialog.this.shell.close();
            }
        });
        if (this.result != null) {
            this.title.setText(((DosboxVersion)this.result).getTitle());
            this.path.setText(((DosboxVersion)this.result).getPath());
            this.conf.setText(((DosboxVersion)this.result).getConf());
            this.parameters.setText(((DosboxVersion)this.result).getParameters());
            combo.setText(((DosboxVersion)this.result).getVersion());
            button2.setSelection(((DosboxVersion)this.result).isDefault().booleanValue());
            button.setSelection(((DosboxVersion)this.result).isMultiConfig());
            this.usingCurses.setSelection(((DosboxVersion)this.result).isUsingCurses());
        }
        this.title.setFocus();
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.required.title"), (Control)this.title);
        }
        if (this.path.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.required.path"), (Control)this.path);
        }
        if (this.conf.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.required.conf"), (Control)this.conf);
        }
        if (!GeneralPurposeDialogs.hasErrors()) {
            DosboxVersion dosboxVersion = new DosboxVersion(-1, "", this.path.getText(), this.conf.getText(), false, this.usingCurses.getSelection(), false, this.parameters.getText(), "");
            File file = dosboxVersion.getCanonicalExecutable();
            File file2 = dosboxVersion.getCanonicalConfFile();
            boolean bl = FileUtils.isReadableFile(file);
            if (!bl) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.error.dosboxexemissing", new Object[]{file}), (Control)this.path);
            }
            if (!FileUtils.isReadableFile(file2) && bl && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.dosboxversion.confirm.createmissingdosboxconf", new Object[]{file2}))) {
                try {
                    FileUtils.doCreateDosboxConf(dosboxVersion);
                }
                catch (IOException iOException) {
                    GeneralPurposeDialogs.warningMessage(this.shell, iOException);
                }
            }
            if (!this.usingCurses.getSelection() && !FileUtils.isReadableFile(file2)) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dosboxversion.error.dosboxconfmissing", new Object[]{file2}), (Control)this.path);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

