/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.MainWindow;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Filter;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditFilterDialog
extends Dialog {
    private static final String EMPTY_FIELD = "[ ]";
    private Text filter;
    private Text title;
    private String prevTitle;
    private Set<Integer> selectedProfileIds;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;

    public EditFilterDialog(Shell shell) {
        super(shell, 0);
    }

    public void setFilter(Filter filter) {
        this.result = filter;
    }

    public void setIds(Set<Integer> set) {
        this.selectedProfileIds = set;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        String string;
        GridData gridData;
        Text text;
        TreeItem treeItem;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "filterdialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.filter.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.filter.title.edit", new Object[]{((Filter)this.result).getTitle(), ((Filter)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.filter.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        tabItem.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.filter.title"));
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        sashForm.setLayout((Layout)new FillLayout());
        Composite composite2 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.title = new Text(composite2, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Tree tree = new Tree((Composite)sashForm, 2080);
        tree.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        sashForm.setWeights(new int[]{60, 40});
        try {
            this.profilesList = this.dbase.readProfilesList("", "");
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
        }
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class TreeNodeItem
            implements Comparable<TreeNodeItem> {
                String value;
                String subQuery;
                String likeQuery;

                public TreeNodeItem(String string, String string2, String string3) {
                    this.value = StringUtils.isEmpty((CharSequence)string) ? EditFilterDialog.EMPTY_FIELD : string;
                    this.subQuery = string2;
                    this.likeQuery = string3;
                }

                @Override
                public int compareTo(TreeNodeItem treeNodeItem) {
                    int n;
                    int n2 = this.value.equals(EditFilterDialog.EMPTY_FIELD) ? 1 : 0;
                    int n3 = n = treeNodeItem.value.equals(EditFilterDialog.EMPTY_FIELD) ? 1 : 0;
                    if (n2 + n > 0) {
                        return n - n2;
                    }
                    return this.value.compareToIgnoreCase(treeNodeItem.value);
                }
            }
            if (i == 20) continue;
            treeItem = new TreeItem(tree, 0);
            treeItem.setText(MainWindow.columnNames[i]);
            text = new TreeSet();
            switch (i) {
                case 0: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.getTitle(), "GAM.TITLE='" + profile.getTitle() + "'", "GAM.TITLE"));
                    }
                    break;
                }
                case 1: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.hasSetupString(), profile.hasSetup(0) ? "GAM.SETUP<>''" : "(GAM.SETUP IS NULL OR GAM.SETUP='')", null));
                    }
                    break;
                }
                case 2: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.getDeveloperName(), "DEV.NAME='" + profile.getDeveloperName() + "'", "DEV.NAME"));
                    }
                    break;
                }
                case 3: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.getPublisherName(), "PUBL.NAME='" + profile.getPublisherName() + "'", "PUBL.NAME"));
                    }
                    break;
                }
                case 4: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.getGenre(), "GEN.NAME='" + profile.getGenre() + "'", "GEN.NAME"));
                    }
                    break;
                }
                case 5: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.getYear(), "YR.YEAR='" + profile.getYear() + "'", null));
                    }
                    break;
                }
                case 6: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.getStatus(), "STAT.STAT='" + profile.getStatus() + "'", "STAT.STAT"));
                    }
                    break;
                }
                case 7: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(profile.isDefaultString(), "GAM.FAVORITE=" + profile.isDefault(), null));
                    }
                    break;
                }
                case 8: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(String.valueOf(profile.getId()), "GAM.ID=" + profile.getId(), null));
                    }
                    break;
                }
                case 9: {
                    for (Profile profile : this.profilesList) {
                        text.add(new TreeNodeItem(String.valueOf(profile.getDbversionId()), "GAM.DBVERSION_ID=" + profile.getDbversionId(), null));
                    }
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    for (Profile profile : this.profilesList) {
                        int n = i - 10;
                        text.add(new TreeNodeItem(String.valueOf(profile.getCustomString(n)), "CUST" + (n + 1) + ".VALUE='" + profile.getCustomString(n) + "'", "CUST" + (n + 1) + ".VALUE"));
                    }
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    for (Profile profile : this.profilesList) {
                        int n = i - 10;
                        text.add(new TreeNodeItem(String.valueOf(profile.getCustomString(n)), "GAM.CUSTOM" + (n + 1) + "='" + profile.getCustomString(n) + "'", "GAM.CUSTOM" + (n + 1)));
                    }
                    break;
                }
                case 18: 
                case 19: {
                    for (Profile profile : this.profilesList) {
                        int n = i - 10 - 8;
                        text.add(new TreeNodeItem(String.valueOf(profile.getCustomInt(n)), "GAM.CUSTOM" + (n + 9) + "=" + profile.getCustomInt(n), null));
                    }
                    break;
                }
                case 21: {
                    for (Profile profile : this.profilesList) {
                        String string2 = DosboxVersion.findById(this.dbversionsList, profile.getDbversionId()).getTitle();
                        text.add(new TreeNodeItem(string2, "GAM.DBVERSION_ID=" + profile.getDbversionId(), null));
                    }
                    break;
                }
            }
            for (TreeNodeItem treeNodeItem : text) {
                TreeItem treeItem2 = new TreeItem(treeItem, 0);
                treeItem2.setText(treeNodeItem.value);
                treeItem2.setData((Object)treeNodeItem.subQuery);
                treeItem2.setGrayed(true);
                if (treeNodeItem.likeQuery == null || ((String[])(gridData = (string = treeNodeItem.value.replaceAll("\\p{Punct}", " ")).split("\\s+"))).length <= 1) continue;
                for (String string3 : gridData) {
                    TreeItem treeItem3 = new TreeItem(treeItem2, 0);
                    treeItem3.setText(string3);
                    treeItem3.setData((Object)("UPPER(" + treeNodeItem.likeQuery + ") LIKE '%" + string3.toUpperCase() + "%'"));
                }
            }
        }
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem treeItem = (TreeItem)event.item;
                    int n = EditFilterDialog.this.depth(treeItem);
                    if (n == 0) {
                        if (treeItem.getChecked()) {
                            if (treeItem.getGrayed() || EditFilterDialog.this.getAllCheckedItems(treeItem).isEmpty()) {
                                treeItem.setChecked(false);
                            }
                        } else if (treeItem.getGrayed()) {
                            treeItem.setGrayed(false);
                        } else {
                            treeItem.setGrayed(true);
                            treeItem.setChecked(true);
                        }
                    } else if (n == 1) {
                        TreeItem treeItem2;
                        treeItem2.setChecked(!EditFilterDialog.this.getAllCheckedItems(treeItem2 = treeItem.getParentItem()).isEmpty());
                    } else {
                        TreeItem treeItem3;
                        if (treeItem.getChecked()) {
                            if (treeItem.getGrayed()) {
                                treeItem.setChecked(false);
                            }
                        } else if (treeItem.getGrayed()) {
                            treeItem.setGrayed(false);
                        } else {
                            treeItem.setGrayed(true);
                            treeItem.setChecked(true);
                        }
                        treeItem3.setChecked(!EditFilterDialog.this.getAllCheckedItems(treeItem3 = treeItem.getParentItem().getParentItem()).isEmpty());
                    }
                }
            }
        });
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object object;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string = null;
                for (TreeItem bl : tree.getItems()) {
                    Object object22;
                    if (!bl.getChecked()) continue;
                    object = new ArrayList();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    for (Object object22 : EditFilterDialog.this.getAllCheckedItems(bl)) {
                        TreeItem treeItem = object22.getParentItem();
                        TreeItem treeItem2 = null;
                        if (treeItem == null) continue;
                        if (string == null) {
                            treeItem2 = treeItem.getParentItem();
                            string = treeItem2 != null ? treeItem2.getText() + ": " + object22.getText() : treeItem.getText() + ": " + object22.getText();
                        } else if (!string.endsWith("...")) {
                            string = string + "...";
                        }
                        if (object22.getGrayed()) {
                            arrayList3.add((String)object22.getData());
                            continue;
                        }
                        object.add((String)object22.getData());
                    }
                    String string2 = StringUtils.join((Iterable)object, (String)"\n\tAND ");
                    object22 = StringUtils.join(arrayList3, (String)"\n\tOR ");
                    boolean treeItem2 = StringUtils.isNotBlank((CharSequence)string2);
                    boolean treeItem3 = StringUtils.isNotBlank((CharSequence)object22);
                    String string3 = null;
                    if (treeItem2 && treeItem3) {
                        string3 = "(" + (String)string2 + ")\nAND\n(" + (String)object22 + ")";
                    } else if (treeItem2) {
                        string3 = string2;
                    } else if (treeItem3) {
                        string3 = object22;
                    }
                    if (bl.getGrayed()) {
                        arrayList2.add("(" + (String)string3 + ")");
                        continue;
                    }
                    arrayList.add("(" + (String)string3 + ")");
                }
                String string4 = StringUtils.join(arrayList, (String)"\nAND\n");
                String string5 = StringUtils.join(arrayList2, (String)"\nOR\n");
                int n = StringUtils.isNotBlank((CharSequence)string4) ? 1 : 0;
                boolean bl = StringUtils.isNotBlank((CharSequence)string5);
                object = null;
                if (n != 0 && bl) {
                    object = "(" + string4 + ")\nAND\n(" + string5 + ")";
                } else if (n != 0) {
                    object = string4;
                } else if (bl) {
                    object = string5;
                }
                if (StringUtils.isNotBlank(string)) {
                    EditFilterDialog.this.title.setText(string);
                }
                if (StringUtils.isNotBlank((CharSequence)object)) {
                    EditFilterDialog.this.filter.setText((String)object);
                }
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.filter.filter"));
        this.filter = new Text(composite2, 2818);
        this.filter.setLayoutData((Object)new GridData(4, 4, true, true));
        treeItem = new Label(composite, 0);
        treeItem.setText(this.settings.msg("dialog.filter.result"));
        text = new Text(composite, 2056);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Iterator<Object> iterator = new Composite((Composite)this.shell, 0);
        iterator.setLayout((Layout)new GridLayout(2, true));
        iterator.setLayoutData("South");
        final Button button = new Button(iterator, 0);
        this.shell.setDefaultButton(button);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.widthHint = 80;
        button.setLayoutData((Object)gridData2);
        button.setText(this.settings.msg("button.ok"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EditFilterDialog.this.isValid()) {
                    return;
                }
                try {
                    int n = EditFilterDialog.this.dbase.addOrEditFilter(EditFilterDialog.this.title.getText(), EditFilterDialog.this.filter.getText(), EditFilterDialog.this.result == null ? -1 : ((Filter)EditFilterDialog.this.result).getId());
                    EditFilterDialog.this.result = new Filter(n, EditFilterDialog.this.title.getText(), EditFilterDialog.this.filter.getText());
                }
                catch (SQLException sQLException) {
                    GeneralPurposeDialogs.warningMessage(EditFilterDialog.this.shell, sQLException);
                }
                EditFilterDialog.this.shell.close();
            }
        });
        string = new Button(iterator, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        string.setLayoutData((Object)gridData);
        string.setText(this.settings.msg("button.cancel"));
        string.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditFilterDialog.this.result = null;
                EditFilterDialog.this.shell.close();
            }
        });
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (EditFilterDialog.this.filter.getText().equals("") || EditFilterDialog.this.filter.getText().equals("UPPER(GAM.TITLE) LIKE '%" + EditFilterDialog.this.prevTitle.toUpperCase() + "%'")) {
                    if (EditFilterDialog.this.title.getText().length() == 0) {
                        EditFilterDialog.this.filter.setText("");
                    } else {
                        EditFilterDialog.this.filter.setText("UPPER(GAM.TITLE) LIKE '%" + EditFilterDialog.this.title.getText().toUpperCase() + "%'");
                    }
                }
                EditFilterDialog.this.prevTitle = EditFilterDialog.this.title.getText();
            }
        });
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                try {
                    List<Profile> list = EditFilterDialog.this.dbase.readProfilesList("", EditFilterDialog.this.filter.getText());
                    text.setText(EditFilterDialog.this.settings.msg("dialog.filter.notice.results", new Object[]{list.size()}));
                    button.setEnabled(true);
                }
                catch (SQLException sQLException) {
                    text.setText(EditFilterDialog.this.settings.msg("dialog.filter.error.invalidcondition"));
                    button.setEnabled(false);
                }
            }
        });
        if (this.result != null) {
            this.title.setText(((Filter)this.result).getTitle());
            this.filter.setText(((Filter)this.result).getFilter());
        } else {
            this.prevTitle = "";
            if (this.selectedProfileIds != null) {
                this.filter.setText("GAM.ID IN (" + StringUtils.join(this.selectedProfileIds, (char)',') + ")");
            }
        }
        this.title.setFocus();
    }

    private int depth(TreeItem treeItem) {
        int n = 0;
        while ((treeItem = treeItem.getParentItem()) != null) {
            ++n;
        }
        return n;
    }

    private List<TreeItem> getAllCheckedItems(TreeItem treeItem) {
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        for (TreeItem treeItem2 : treeItem.getItems()) {
            if (treeItem2.getChecked()) {
                arrayList.add(treeItem2);
            }
            arrayList.addAll(this.getAllCheckedItems(treeItem2));
        }
        return arrayList;
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.filter.required.title"), (Control)this.title);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

