/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.util.List;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.Wizard;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.ExportThread;
import org.dbgl.util.FileUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDialog
extends Wizard {
    private Text logText;
    private Button settingsOnly;
    private Button fullGames;
    private Button exportCapturesButton;
    private Button exportMapperfilesButton;
    private Button exportNativeCommandsButton;
    private Table profilesTable;
    private Text title;
    private Text notes;
    private Text author;
    private Text filename;
    private ProgressBar progressBar;
    private Label profileLabel;
    private List<DosboxVersion> dbversionsList;
    private List<ExpProfile> expProfileList;

    public ExportDialog(Shell shell, List<DosboxVersion> list, List<ExpProfile> list2) {
        super(shell, 0, Settings.getInstance().msg("dialog.export.title", new Object[]{list2.size()}), "export", true);
        this.dbversionsList = list;
        this.expProfileList = list2;
    }

    @Override
    protected int stepSize(boolean bl) {
        if ((this.stepNr == 0 && bl || this.stepNr == 2 && !bl) && this.settingsOnly.getSelection()) {
            return 2;
        }
        return super.stepSize(bl);
    }

    @Override
    protected boolean actionAfterNext() {
        if (this.stepNr == 3) {
            try {
                Document document = XmlUtils.getFullProfilesXML(this.expProfileList, this.dbversionsList, this.title.getText(), this.notes.getText(), this.author.getText(), this.exportCapturesButton.getSelection(), this.exportMapperfilesButton.getSelection(), this.exportNativeCommandsButton.getSelection(), this.fullGames.getSelection());
                this.extensiveJobThread = new ExportThread(this.logText, this.progressBar, this.profileLabel, this.expProfileList, document, this.exportCapturesButton.getSelection(), this.exportMapperfilesButton.getSelection(), this.fullGames.getSelection(), FileUtils.canonicalToData(this.filename.getText()));
            }
            catch (Exception exception) {
                GeneralPurposeDialogs.warningMessage(this.shell, exception);
                this.extensiveJobThread = null;
                return false;
            }
        } else if (this.stepNr == 4) {
            if (this.extensiveJobThread.isEverythingOk()) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.export.notice.exportok"));
            } else {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.export.error.problem"));
            }
            this.profileLabel.setText(this.settings.msg("dialog.export.reviewlog"));
            this.profileLabel.pack();
        }
        return true;
    }

    @Override
    protected boolean isValidInput() {
        if (this.stepNr == 1) {
            return this.isValidGameDirs();
        }
        if (this.stepNr == 2) {
            return this.isValidTargetZip();
        }
        return true;
    }

    private boolean isValidTargetZip() {
        String string;
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.required.title"), (Control)this.title);
        }
        if ((string = this.filename.getText()).equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.required.filename"), (Control)this.filename);
        } else if (FileUtils.isExistingFile(FileUtils.canonicalToData(string))) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.fileexists", new Object[]{FileUtils.canonicalToData(string)}), (Control)this.filename);
        } else {
            File file = FileUtils.canonicalToData(string).getParentFile();
            if (file == null || !file.exists()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.exportdirmissing", new Object[]{FileUtils.canonicalToData(string)}), (Control)this.filename);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean isValidGameDirs() {
        GeneralPurposeDialogs.initErrorDialog();
        for (ExpProfile expProfile : this.expProfileList) {
            if (!FileUtils.canonicalToDosroot(expProfile.getGameDir().getPath()).exists()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.gamedirmissing", new Object[]{expProfile.getGameDir()}), (Control)this.profilesTable);
            }
            if (expProfile.getGameDir().isAbsolute()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.gamedirnotrelative", new Object[]{expProfile.getGameDir()}), (Control)this.profilesTable);
            }
            for (ExpProfile expProfile2 : this.expProfileList) {
                if (expProfile == expProfile2 || !FileUtils.areRelated(expProfile.getGameDir(), expProfile2.getGameDir())) continue;
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.export.error.gamedirsconflict", new Object[]{expProfile.getGameDir(), expProfile.getTitle(), expProfile2.getGameDir(), expProfile2.getTitle()}), (Control)this.profilesTable);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    @Override
    protected void fillPages() {
        this.addStep(this.page1());
        this.addStep(this.page2());
        this.addStep(this.page3());
        this.addStep(this.page4());
    }

    private Control page1() {
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.export.step1"));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.export.export"));
        this.settingsOnly = new Button((Composite)group, 16);
        this.settingsOnly.setText(this.settings.msg("dialog.export.export.profiles"));
        this.settingsOnly.setSelection(true);
        new Label((Composite)group, 0);
        this.fullGames = new Button((Composite)group, 16);
        this.fullGames.setText(this.settings.msg("dialog.export.export.games"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        this.exportCapturesButton = new Button((Composite)group, 32);
        this.exportCapturesButton.setText(this.settings.msg("dialog.template.captures"));
        this.exportCapturesButton.setSelection(true);
        new Label((Composite)group, 0);
        this.exportMapperfilesButton = new Button((Composite)group, 32);
        this.exportMapperfilesButton.setText(this.settings.msg("dialog.template.mapperfile"));
        new Label((Composite)group, 0);
        this.exportNativeCommandsButton = new Button((Composite)group, 32);
        this.exportNativeCommandsButton.setText(this.settings.msg("dialog.export.nativecommands"));
        return group;
    }

    private Control page2() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.export.step2"));
        group.setLayout((Layout)new GridLayout());
        this.profilesTable = new Table((Composite)group, 67584);
        this.profilesTable.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true, 1, 2);
        gridData.heightHint = 80;
        this.profilesTable.setLayoutData((Object)gridData);
        this.profilesTable.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.profilesTable, 0);
        tableColumn.setWidth(260);
        tableColumn.setText(this.settings.msg("dialog.main.profiles.column.title"));
        TableColumn tableColumn2 = new TableColumn(this.profilesTable, 0);
        tableColumn2.setWidth(120);
        tableColumn2.setText(this.settings.msg("dialog.export.column.gamedir"));
        for (ExpProfile expProfile : this.expProfileList) {
            TableItem tableItem = new TableItem(this.profilesTable, 0);
            tableItem.setText(expProfile.getTitle());
            tableItem.setText(1, expProfile.getGameDir().getPath());
        }
        this.profilesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                int n = ExportDialog.this.profilesTable.getSelectionIndex();
                ExpProfile expProfile = (ExpProfile)ExportDialog.this.expProfileList.get(n);
                DirectoryDialog directoryDialog = new DirectoryDialog(ExportDialog.this.shell);
                directoryDialog.setFilterPath(FileUtils.canonicalToDosroot(expProfile.getGameDir().getPath()).getPath());
                String string = directoryDialog.open();
                if (string != null) {
                    File file = FileUtils.makeRelativeToDosroot(new File(string));
                    expProfile.setGameDir(file);
                    ExportDialog.this.profilesTable.getSelection()[0].setText(1, file.getPath());
                }
            }
        });
        return group;
    }

    private Control page3() {
        Group group = new Group((Composite)this.shell, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(this.settings.msg("dialog.export.step3"));
        group.setLayoutData((Object)"North");
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.export.exporttitle"));
        this.title = new Text((Composite)group, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.export.author"));
        this.author = new Text((Composite)group, 2048);
        this.author.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.export.notes"));
        this.notes = new Text((Composite)group, 2882);
        GridData gridData = new GridData(4, 4, true, true, 2, 2);
        gridData.heightHint = 40;
        this.notes.setLayoutData((Object)gridData);
        StringBuffer stringBuffer = new StringBuffer();
        for (ExpProfile object2 : this.expProfileList) {
            stringBuffer.append(object2.getTitle()).append(this.notes.getLineDelimiter());
        }
        this.notes.setText(stringBuffer.toString());
        new Label((Composite)group, 0);
        Label label4 = new Label((Composite)group, 0);
        label4.setText(this.settings.msg("dialog.export.file"));
        this.filename = new Text((Composite)group, 2048);
        this.filename.setText(FileUtils.EXPORT_DIR + "games.dbgl.zip");
        this.filename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton((Composite)group, 0);
        browseButton.connect(this.shell, this.filename, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DBGLZIP, true, null);
        return group;
    }

    private Control page4() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.export.step4"));
        group.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar((Composite)group, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.profileLabel = new Label((Composite)group, 0);
        this.profileLabel.setText(this.settings.msg("dialog.export.start"));
        this.logText = new Text((Composite)group, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        return group;
    }
}

