/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportListDialog
extends Dialog {
    private Text filename;
    private File[] files;
    private List<Profile> profs;
    private List<DosboxVersion> dbversionsList;
    private Shell shell;
    private Settings settings;

    public ExportListDialog(Shell shell, int n) {
        super(shell, n);
    }

    public ExportListDialog(Shell shell, List<DosboxVersion> list, List<Profile> list2) {
        this(shell, 0);
        this.dbversionsList = list;
        this.profs = list2;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return null;
    }

    protected boolean init() {
        File file = FileUtils.canonicalToData(FileUtils.XSL_DIR);
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".xsl");
            }
        };
        this.files = file.listFiles(filenameFilter);
        if (this.files == null) {
            GeneralPurposeDialogs.fatalMessage(this.getParent(), this.settings.msg("dialog.exportlist.error.noxsldir"));
            return false;
        }
        if (this.files.length == 0) {
            GeneralPurposeDialogs.fatalMessage(this.getParent(), this.settings.msg("dialog.exportlist.error.noxslfiles"));
            return false;
        }
        return true;
    }

    protected void createContents() {
        File file2;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "exportlistdialog"));
        this.shell.setText(this.settings.msg("dialog.exportlist.title"));
        Group group = new Group((Composite)this.shell, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(this.settings.msg("dialog.exportlist.options"));
        group.setLayoutData((Object)"North");
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.exportlist.exportfiletype"));
        final Combo combo = new Combo((Composite)group, 8);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        for (File file2 : this.files) {
            combo.add(file2.getName().substring(0, file2.getName().length() - 4));
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                String string = ExportListDialog.this.filename.getText();
                String string2 = combo.getItem(combo.getSelectionIndex());
                int n2 = string2.lastIndexOf(95);
                if (n2 != -1) {
                    string2 = string2.substring(n2 + 1);
                }
                if ((n = string.lastIndexOf(46)) == -1) {
                    ExportListDialog.this.filename.setText(string + '.' + string2);
                } else {
                    ExportListDialog.this.filename.setText(string.substring(0, n + 1) + string2);
                }
            }
        });
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.exportlist.filename"));
        this.filename = new Text((Composite)group, 2048);
        this.filename.setText(FileUtils.EXPORT_DIR + "dbgllist");
        this.filename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.select(0);
        combo.notifyListeners(13, new Event());
        BrowseButton browseButton = new BrowseButton((Composite)group, 0);
        browseButton.connect(this.shell, this.filename, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, true, null);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.exportlist.exportintermediatexml"));
        file2 = new Button((Composite)group, 32);
        new Label((Composite)group, 0);
        Button button = new Button((Composite)group, 0);
        this.shell.setDefaultButton(button);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText(this.settings.msg("dialog.exportlist.startexport"));
        Button button2 = new Button((Composite)group, 0);
        button2.setLayoutData((Object)new GridData(120, -1));
        button2.setText(this.settings.msg("button.cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportListDialog.this.shell.close();
            }
        });
        new Label((Composite)group, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter((Button)file2, combo){
            final /* synthetic */ Button val$saveXml;
            final /* synthetic */ Combo val$fileTypes;
            {
                this.val$saveXml = button;
                this.val$fileTypes = combo;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ExportListDialog.this.isValid()) {
                    return;
                }
                try {
                    DOMSource dOMSource = new DOMSource(XmlUtils.getProfilesXML(ExportListDialog.this.profs, ExportListDialog.this.dbversionsList));
                    if (this.val$saveXml.getSelection()) {
                        XmlUtils.saveDomSource(dOMSource, FileUtils.canonicalToData(ExportListDialog.this.filename.getText() + ".xml"), null);
                    }
                    XmlUtils.saveDomSource(dOMSource, FileUtils.canonicalToData(ExportListDialog.this.filename.getText()), FileUtils.canonicalToData(FileUtils.XSL_DIR + this.val$fileTypes.getItem(this.val$fileTypes.getSelectionIndex()) + ".xsl"));
                    if (GeneralPurposeDialogs.confirmMessage(ExportListDialog.this.shell, ExportListDialog.this.settings.msg("dialog.exportlist.confirm.viewexport"))) {
                        PlatformUtils.openForBrowsing(FileUtils.canonicalToData(ExportListDialog.this.filename.getText()).getPath());
                    }
                }
                catch (IOException iOException) {
                    GeneralPurposeDialogs.warningMessage(ExportListDialog.this.shell, iOException);
                }
                catch (TransformerException transformerException) {
                    GeneralPurposeDialogs.warningMessage(ExportListDialog.this.shell, transformerException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    GeneralPurposeDialogs.warningMessage(ExportListDialog.this.shell, parserConfigurationException);
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        String string = this.filename.getText();
        if ("".equals(string)) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.exportlist.required.filename"), (Control)this.filename);
        } else if (FileUtils.isExistingFile(FileUtils.canonicalToData(string))) {
            if (!GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.exportlist.confirm.overwrite", new Object[]{FileUtils.canonicalToData(string)}))) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.exportlist.notice.anotherfilename"), (Control)this.filename);
            }
        } else {
            File file = FileUtils.canonicalToData(string).getParentFile();
            if (file == null || !file.exists()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.exportlist.error.dirmissing"), (Control)this.filename);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

