/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GalleryItemRenderer;
import org.dbgl.gui.MainWindow;
import org.dbgl.gui.listeners.MeasureListener;
import org.dbgl.gui.listeners.PaintListener;
import org.dbgl.gui.listeners.ToolTipListener;
import org.dbgl.interfaces.ReOrderable;
import org.dbgl.model.ThumbInfo;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ProfilesList {
    private final Image topdog;
    private ProfilesListType type;
    private Gallery gallery;
    private GalleryItem group;
    private Color bgColor;
    private Table table;
    private static final Listener paintListener = new PaintListener();
    private static final Listener measureListener = new MeasureListener();
    private static final Listener toolTipOpenListener = new ToolTipListener();
    private static final SectionsWrapper ssettings = Settings.getInstance().getSettings();

    public ProfilesList(Composite composite, ProfilesListType profilesListType) {
        this(composite, profilesListType, null, null, null);
    }

    public ProfilesList(Composite composite, ProfilesListType profilesListType, ReOrderable reOrderable, int[] nArray, String[] stringArray) {
        this.type = profilesListType;
        this.topdog = SWTImageManager.getResourceImage(composite.getShell().getDisplay(), "topdog.png");
        if (profilesListType == ProfilesListType.TABLE) {
            int n;
            this.table = new Table(composite, 67586);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            for (n = 0; n < nArray.length; ++n) {
                this.addProfileColumn(reOrderable, nArray, stringArray[nArray[n]], n);
            }
            this.table.setSortColumn(this.table.getColumn(this.findColumnById(nArray, ssettings.getIntValues("gui", "sortcolumn")[0])));
            this.table.setSortDirection(ssettings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
            this.table.setColumnOrder(ssettings.getIntValues("gui", "columnorder"));
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != 20) continue;
                this.table.setData((Object)n);
                this.table.addListener(42, paintListener);
                this.table.addListener(41, measureListener);
            }
        } else {
            this.gallery = new Gallery(composite, 2562);
            this.gallery.setAntialias(0);
            this.gallery.setLowQualityOnUserAction(true);
            this.gallery.setHigherQualityDelay(100);
            int[] nArray2 = ssettings.getIntValues("gui", "gallerybackgroundcolor");
            if (nArray2.length == 3) {
                this.bgColor = new Color((Device)composite.getShell().getDisplay(), nArray2[0], nArray2[1], nArray2[2]);
                this.gallery.setBackground(this.bgColor);
            }
            NoGroupRenderer noGroupRenderer = new NoGroupRenderer();
            switch (profilesListType) {
                case LARGE_TILES: {
                    noGroupRenderer.setItemSize(ssettings.getIntValue("gui", "large_tile_width"), ssettings.getIntValue("gui", "large_tile_height"));
                    break;
                }
                case MEDIUM_TILES: {
                    noGroupRenderer.setItemSize(ssettings.getIntValue("gui", "medium_tile_width"), ssettings.getIntValue("gui", "medium_tile_height"));
                    break;
                }
                case SMALL_TILES: {
                    noGroupRenderer.setItemSize(ssettings.getIntValue("gui", "small_tile_width"), ssettings.getIntValue("gui", "small_tile_height"));
                    break;
                }
                case LARGE_BOXES: {
                    noGroupRenderer.setItemSize(ssettings.getIntValue("gui", "large_box_width"), ssettings.getIntValue("gui", "large_box_height"));
                    break;
                }
                case MEDIUM_BOXES: {
                    noGroupRenderer.setItemSize(ssettings.getIntValue("gui", "medium_box_width"), ssettings.getIntValue("gui", "medium_box_height"));
                    break;
                }
                case SMALL_BOXES: {
                    noGroupRenderer.setItemSize(ssettings.getIntValue("gui", "small_box_width"), ssettings.getIntValue("gui", "small_box_height"));
                    break;
                }
            }
            noGroupRenderer.setAutoMargin(true);
            noGroupRenderer.setMinMargin(1);
            this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)noGroupRenderer);
            GalleryItemRenderer galleryItemRenderer = new GalleryItemRenderer(ssettings.getValue("gui", "tile_title_trunc_pos"));
            this.gallery.setItemRenderer((AbstractGalleryItemRenderer)galleryItemRenderer);
            this.group = new GalleryItem(this.gallery, 0);
            this.gallery.getShell().addListener(27, toolTipOpenListener);
            this.gallery.addListener(12, toolTipOpenListener);
            this.gallery.addListener(1, toolTipOpenListener);
            this.gallery.addListener(5, toolTipOpenListener);
            this.gallery.addListener(37, toolTipOpenListener);
            this.gallery.addListener(4, toolTipOpenListener);
            this.gallery.addListener(32, toolTipOpenListener);
            this.gallery.addListener(42, paintListener);
        }
    }

    private int findColumnById(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void addProfileColumn(final ReOrderable reOrderable, int[] nArray, String string, final int n) {
        final String string2 = "column" + (nArray[n] + 1) + "width";
        final TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(ssettings.getIntValue("gui", string2));
        tableColumn.setMoveable(true);
        tableColumn.setText(string);
        if (nArray[n] == 8 || nArray[n] == 9 || nArray[n] == 18 || nArray[n] == 19) {
            tableColumn.setAlignment(131072);
        }
        if (nArray[n] == 20) {
            tableColumn.setAlignment(0x1000000);
        }
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = ProfilesList.this.table.getSortColumn();
                TableColumn tableColumn2 = (TableColumn)selectionEvent.widget;
                int n2 = ProfilesList.this.table.getSortDirection();
                if (tableColumn.equals(tableColumn2)) {
                    n2 = n2 == 128 ? 1024 : 128;
                } else {
                    ProfilesList.this.table.setSortColumn(tableColumn2);
                    n2 = 128;
                }
                ProfilesList.this.table.setSortDirection(n2);
                reOrderable.doReorder(n, n2);
            }
        });
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                ssettings.setIntValue("gui", string2, tableColumn.getWidth());
            }

            public void controlMoved(ControlEvent controlEvent) {
                if (controlEvent.time != 0) {
                    ssettings.setIntValues("gui", "columnorder", ProfilesList.this.table.getColumnOrder());
                }
            }
        });
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addMouseListener((MouseListener)mouseAdapter);
        } else {
            this.gallery.addMouseListener((MouseListener)mouseAdapter);
        }
    }

    public void addKeyListener(KeyAdapter keyAdapter) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addKeyListener((KeyListener)keyAdapter);
        } else {
            this.gallery.addKeyListener((KeyListener)keyAdapter);
        }
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addTraverseListener(traverseListener);
        } else {
            this.gallery.addTraverseListener(traverseListener);
        }
    }

    public void addSelectionListener(SelectionAdapter selectionAdapter) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.addSelectionListener((SelectionListener)selectionAdapter);
        } else {
            this.gallery.addSelectionListener((SelectionListener)selectionAdapter);
        }
    }

    public void setFocus() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setFocus();
        } else {
            this.gallery.setFocus();
        }
    }

    public void setRedraw(boolean bl) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setRedraw(bl);
        } else {
            this.gallery.setRedraw(bl);
        }
    }

    public void redraw() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.redraw();
        } else {
            this.gallery.redraw();
        }
    }

    public void setMenu(Menu menu) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setMenu(menu);
        } else {
            this.gallery.setMenu(menu);
        }
    }

    public int getSelectionCount() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getSelectionCount();
        }
        return this.gallery.getSelectionCount();
    }

    public int getSelectionIndex() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getSelectionIndex();
        }
        GalleryItem[] galleryItemArray = this.gallery.getSelection();
        if (galleryItemArray.length == 0) {
            return -1;
        }
        return this.group.indexOf(galleryItemArray[0]);
    }

    public int[] getSelectionIndices() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getSelectionIndices();
        }
        GalleryItem[] galleryItemArray = this.gallery.getSelection();
        if (galleryItemArray.length == 0) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (GalleryItem galleryItem : galleryItemArray) {
            int n = this.group.indexOf(galleryItem);
            if (n == -1) continue;
            arrayList.add(n);
        }
        return ArrayUtils.toPrimitive((Integer[])arrayList.toArray(new Integer[0]));
    }

    public void setSelection(int n) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setSelection(n);
        } else {
            GalleryItem galleryItem = this.group.getItem(n);
            if (galleryItem != null) {
                this.gallery.setSelection(new GalleryItem[]{galleryItem});
            }
        }
    }

    public void setSelection(int[] nArray) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.setSelection(nArray);
        } else {
            ArrayList<GalleryItem> arrayList = new ArrayList<GalleryItem>();
            for (int n : nArray) {
                GalleryItem galleryItem = this.group.getItem(n);
                if (galleryItem == null) continue;
                arrayList.add(galleryItem);
            }
            this.gallery.setSelection(arrayList.toArray(new GalleryItem[0]));
        }
    }

    public int getItemCount() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table.getItemCount();
        }
        return this.group.getItemCount();
    }

    public ProfilesListItem getItem(int n) {
        if (this.type == ProfilesListType.TABLE) {
            return new ProfilesListItem(this.table.getItem(n));
        }
        return new ProfilesListItem(this.group.getItem(n));
    }

    public void removeAll() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.removeAll();
        } else {
            this.gallery.removeAll();
            this.group = new GalleryItem(this.gallery, 0);
        }
    }

    public void remove(int n) {
        if (this.type == ProfilesListType.TABLE) {
            this.table.remove(n);
        } else {
            this.group.remove(n);
        }
    }

    public void selectAll() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.selectAll();
        } else {
            this.group.selectAll();
        }
    }

    public ProfilesListItem[] getItems() {
        if (this.type == ProfilesListType.TABLE) {
            ArrayList<ProfilesListItem> arrayList = new ArrayList<ProfilesListItem>();
            for (TableItem tableItem : this.table.getItems()) {
                arrayList.add(new ProfilesListItem(tableItem));
            }
            return arrayList.toArray(new ProfilesListItem[0]);
        }
        ArrayList<ProfilesListItem> arrayList = new ArrayList<ProfilesListItem>();
        for (GalleryItem galleryItem : this.group.getItems()) {
            arrayList.add(new ProfilesListItem(galleryItem));
        }
        return arrayList.toArray(new ProfilesListItem[0]);
    }

    public Control getControl() {
        if (this.type == ProfilesListType.TABLE) {
            return this.table;
        }
        return this.gallery;
    }

    public void dispose() {
        if (this.type == ProfilesListType.TABLE) {
            this.table.removeListener(42, paintListener);
            this.table.removeListener(41, measureListener);
            this.table.dispose();
        } else {
            this.gallery.getShell().removeListener(27, toolTipOpenListener);
            this.gallery.removeListener(1, toolTipOpenListener);
            this.gallery.removeListener(5, toolTipOpenListener);
            this.gallery.removeListener(37, toolTipOpenListener);
            this.gallery.removeListener(4, toolTipOpenListener);
            this.gallery.removeListener(32, toolTipOpenListener);
            this.gallery.removeListener(42, paintListener);
            this.gallery.dispose();
            if (this.bgColor != null) {
                this.bgColor.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfilesListType {
        TABLE,
        SMALL_TILES,
        MEDIUM_TILES,
        LARGE_TILES,
        SMALL_BOXES,
        MEDIUM_BOXES,
        LARGE_BOXES;

    }

    public class ProfilesListItem {
        GalleryItem gItem;
        TableItem tItem;

        public ProfilesListItem(ProfilesList profilesList2) {
            if (profilesList2.type == ProfilesListType.TABLE) {
                this.tItem = new TableItem(profilesList2.table, 2048);
            } else {
                this.gItem = new GalleryItem(profilesList2.group, 0);
            }
        }

        public ProfilesListItem(TableItem tableItem) {
            this.tItem = tableItem;
        }

        public ProfilesListItem(GalleryItem galleryItem) {
            this.gItem = galleryItem;
        }

        public Object getData() {
            if (this.tItem != null) {
                return this.tItem.getData();
            }
            return this.gItem.getData();
        }

        public void setData(Object object) {
            if (this.tItem != null) {
                this.tItem.setData(object);
            } else {
                this.gItem.setData(object);
            }
        }

        public void resetCachedInfo() {
            ThumbInfo thumbInfo = (ThumbInfo)this.getData();
            thumbInfo.resetCachedInfo();
            this.setData(thumbInfo);
            if (this.gItem != null) {
                this.gItem.setImage(null);
            }
        }

        public void setText(int n, int n2, String string) {
            if (this.tItem != null) {
                this.tItem.setText(n, string);
            } else {
                if (n == 0) {
                    this.gItem.setText(1, "");
                }
                if (n2 == 0) {
                    this.gItem.setText(string);
                }
                if (n2 == 7) {
                    this.gItem.setData("org.eclipse.nebula.widget.gallery.bottomLeftOverlay", string.equals(Settings.getInstance().msg("general.yes")) ? ProfilesList.this.topdog : null);
                }
                if (StringUtils.isEmpty((CharSequence)string)) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer(this.gItem.getText(1));
                if (!StringUtils.isEmpty((CharSequence)stringBuffer)) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(MainWindow.columnNames[n2]).append(": ").append(string);
                this.gItem.setText(1, stringBuffer.toString());
            }
        }
    }
}

