/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.MainWindow;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class SettingsDialog
extends Dialog {
    public static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("ar", "da", "de", "en", "es", "es__Capitalizado", "fr", "it", "ko", "nl", "pl", "ru", "sv", "zh", "zh_TW");
    private static int NR_OF_ENGINES = EditProfileDialog.webSearchEngines.size();
    private static final SortedMap<String, Locale> allLocales = new TreeMap<String, Locale>();
    private static final int EDITABLE_COLUMN = 0;
    static final String[] confLocations;
    static final String[] confFilenames;
    static final String[] buttonDisplayOptions;
    private List<Integer> allColumnIDs;
    private Table visible_columns;
    private boolean changedVisColumns = false;
    private TableItem[] visibleColumns;
    private TabItem columnsTabItem;
    private Combo confFilename;
    private Combo confLocation;
    private Combo localeCombo;
    private Combo buttonDisplay;
    private Text port;
    private Text values;
    private Text envValues;
    private Label heightValue;
    private Label columnHeightValue;
    private Scale screenshotsHeight;
    private Scale screenshotsColumnHeight;
    private int previousSelection = -1;
    private Button[] setTitle;
    private Button[] setDev;
    private Button[] setPub;
    private Button[] setYear;
    private Button[] setGenre;
    private Button[] setLink;
    private Button[] setDescr;
    private Button[] setRank;
    private Button[] chooseCoverArt;
    private Button[] allRegionsCoverArt;
    private Button[] chooseScreenshot;
    private Text[] platformFilterValues;
    private Spinner[] maxCoverArt;
    private Spinner[] maxScreenshots;
    private SectionsWrapper conf;
    private org.eclipse.swt.widgets.List options;
    protected Shell shell;
    private Settings settings;

    public SettingsDialog(Shell shell, int n) {
        super(shell, n);
    }

    public SettingsDialog(Shell shell) {
        this(shell, 0);
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.conf = new SectionsWrapper(this.settings.getSettings());
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.changedVisColumns;
    }

    /*
     * WARNING - void declaration
     */
    protected void createContents() {
        GridData gridData;
        Button button;
        GridData gridData2;
        Label label;
        Label label2;
        Label label3;
        GridData gridData3;
        Group group;
        Composite composite;
        TabItem tabItem;
        WebSearchEngine webSearchEngine;
        String string5;
        int n;
        Object object;
        CharSequence charSequence;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "settingsdialog"));
        this.shell.setText(this.settings.msg("dialog.settings.title"));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(this.settings.msg("dialog.settings.tab.general"));
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        composite2.setLayout((Layout)new GridLayout());
        tabItem2.setControl((Control)composite2);
        Group group2 = new Group(composite2, 0);
        group2.setText(this.settings.msg("dialog.settings.dosbox"));
        group2.setLayout((Layout)new GridLayout(2, false));
        Label label4 = new Label((Composite)group2, 0);
        label4.setText(this.settings.msg("dialog.settings.hidestatuswindow"));
        final Button button2 = new Button((Composite)group2, 32);
        button2.setSelection(this.conf.getBooleanValue("dosbox", "hideconsole"));
        Group group3 = new Group(composite2, 0);
        group3.setText(this.settings.msg("dialog.settings.sendto"));
        group3.setLayout((Layout)new GridLayout(2, false));
        Label label5 = new Label((Composite)group3, 0);
        label5.setText(this.settings.msg("dialog.settings.enableport"));
        final Button button3 = new Button((Composite)group3, 32);
        button3.setSelection(this.conf.getBooleanValue("communication", "port_enabled"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsDialog.this.port.setEnabled(button3.getSelection());
            }
        });
        Label label6 = new Label((Composite)group3, 0);
        label6.setText(this.settings.msg("dialog.settings.port"));
        this.port = new Text((Composite)group3, 2048);
        this.port.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.port.setText(this.conf.getValue("communication", "port"));
        this.port.setEnabled(button3.getSelection());
        Group group4 = new Group(composite2, 0);
        group4.setText(this.settings.msg("dialog.settings.profiledefaults"));
        group4.setLayout((Layout)new GridLayout(3, false));
        Label label7 = new Label((Composite)group4, 0);
        label7.setText(this.settings.msg("dialog.settings.configfile"));
        this.confLocation = new Combo((Composite)group4, 8);
        this.confLocation.setItems(confLocations);
        this.confLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.confLocation.select(this.conf.getIntValue("profiledefaults", "confpath"));
        this.confFilename = new Combo((Composite)group4, 8);
        this.confFilename.setItems(confFilenames);
        this.confFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.confFilename.select(this.conf.getIntValue("profiledefaults", "conffile"));
        Group group5 = new Group(composite2, 0);
        group5.setText(this.settings.msg("dialog.settings.i18n"));
        group5.setLayout((Layout)new GridLayout(2, false));
        Label label8 = new Label((Composite)group5, 0);
        label8.setText(this.settings.msg("dialog.settings.languagecountry"));
        this.localeCombo = new Combo((Composite)group5, 8);
        Locale locale = new Locale(this.conf.getValue("locale", "language"), this.conf.getValue("locale", "country"), this.conf.getValue("locale", "variant"));
        final TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
        String string2 = "";
        ArrayList<String> arrayList2 = new ArrayList<String>(SUPPORTED_LANGUAGES);
        File[] fileArray = new File("./plugins/i18n").listFiles();
        if (fileArray != null) {
            for (File arrayList3 : fileArray) {
                charSequence = arrayList3.getName();
                if (!((String)charSequence).startsWith("MessagesBundle_") || !((String)charSequence).endsWith(".properties") || ((String)(object = ((String)charSequence).substring("MessagesBundle_".length(), ((String)charSequence).indexOf(".properties")))).length() <= 0) continue;
                arrayList2.add((String)object);
            }
        }
        for (String string3 : arrayList2) {
            void var23_32;
            Locale locale2 = (Locale)allLocales.get(string3);
            Object var23_30 = null;
            if (locale2 == null && StringUtils.countMatches((CharSequence)string3, (CharSequence)"_") == 2) {
                charSequence = StringUtils.removeEnd((String)StringUtils.substringBeforeLast((String)string3, (String)"_"), (String)"_");
                String string4 = StringUtils.substringAfterLast((String)string3, (String)"_");
                locale2 = (Locale)allLocales.get(charSequence);
            }
            if (locale2 == null) continue;
            charSequence = new StringBuffer(locale2.getDisplayLanguage(Locale.getDefault()));
            if (locale2.getCountry().length() > 0) {
                ((StringBuffer)charSequence).append(" - ").append(locale2.getDisplayCountry(Locale.getDefault()));
            }
            if (var23_32 != null) {
                ((StringBuffer)charSequence).append(" (").append((String)var23_32).append(')');
                locale2 = new Locale(locale2.getLanguage(), locale2.getCountry(), (String)var23_32);
            }
            treeMap.put(((StringBuffer)charSequence).toString(), locale2);
            if (!locale2.equals(locale)) continue;
            string2 = ((StringBuffer)charSequence).toString();
        }
        for (String string4 : treeMap.keySet()) {
            this.localeCombo.add(string4);
        }
        this.localeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.localeCombo.setText(string2);
        this.localeCombo.setVisibleItemCount(20);
        this.columnsTabItem = new TabItem(tabFolder, 0);
        this.columnsTabItem.setText(this.settings.msg("dialog.settings.tab.profiletable"));
        Composite composite3 = new Composite((Composite)tabFolder, 0);
        composite3.setLayout((Layout)new BorderLayout(0, 0));
        this.columnsTabItem.setControl((Control)composite3);
        Group group6 = new Group(composite3, 0);
        group6.setLayout((Layout)new FillLayout());
        group6.setText(this.settings.msg("dialog.settings.visiblecolunms"));
        this.visible_columns = new Table((Composite)group6, 67616);
        this.visible_columns.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.visible_columns, 0);
        tableColumn.setWidth(350);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.conf.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            arrayList.add(i);
        }
        ArrayList arrayList3 = new ArrayList();
        object = this.conf.getIntValues("gui", "columnorder");
        for (int i = 0; i < ((Object)object).length; ++i) {
            arrayList3.add(arrayList.get((int)object[i]));
        }
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (n = 0; n < MainWindow.columnNames.length; ++n) {
            if (arrayList3.contains(n)) continue;
            arrayList4.add(n);
        }
        this.allColumnIDs = new ArrayList<Integer>(arrayList3);
        this.allColumnIDs.addAll(arrayList4);
        this.visibleColumns = new TableItem[MainWindow.columnNames.length];
        for (n = 0; n < MainWindow.columnNames.length; ++n) {
            this.visibleColumns[n] = new TableItem(this.visible_columns, 2048);
            this.visibleColumns[n].setText(MainWindow.columnNames[this.allColumnIDs.get(n)]);
            this.visibleColumns[n].setChecked(this.conf.getBooleanValue("gui", "column" + (this.allColumnIDs.get(n) + 1) + "visible"));
        }
        final TableEditor tableEditor = new TableEditor(this.visible_columns);
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.visible_columns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem;
                Control control = tableEditor.getEditor();
                if (control != null) {
                    control.dispose();
                }
                if ((tableItem = (TableItem)selectionEvent.item) == null) {
                    return;
                }
                int n = tableItem.getParent().getSelectionIndex();
                if (n == -1) {
                    return;
                }
                int n2 = (Integer)SettingsDialog.this.allColumnIDs.get(n);
                if (n2 < 10 || n2 == 20 || n2 == 21) {
                    return;
                }
                Text text = new Text((Composite)SettingsDialog.this.visible_columns, 0);
                text.setText(tableItem.getText(0));
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent modifyEvent) {
                        Text text = (Text)tableEditor.getEditor();
                        tableEditor.getItem().setText(0, text.getText());
                    }
                });
                text.selectAll();
                text.setFocus();
                tableEditor.setEditor((Control)text, tableItem, 0);
            }
        });
        Group group7 = new Group(composite3, 0);
        group7.setLayout((Layout)new GridLayout(2, false));
        group7.setText(this.settings.msg("dialog.settings.addeditduplicateprofile"));
        group7.setLayoutData((Object)"South");
        Label label9 = new Label((Composite)group7, 0);
        label9.setText(this.settings.msg("dialog.settings.autosort"));
        final Button button4 = new Button((Composite)group7, 32);
        button4.setSelection(this.conf.getBooleanValue("gui", "autosortonupdate"));
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(this.settings.msg("dialog.settings.tab.dynamicoptions"));
        Composite composite4 = new Composite((Composite)tabFolder, 0);
        composite4.setLayout((Layout)new FillLayout());
        tabItem3.setControl((Control)composite4);
        Group group8 = new Group(composite4, 0);
        group8.setLayout((Layout)new GridLayout(2, false));
        group8.setText(this.settings.msg("dialog.settings.dynamicoptions"));
        Label label10 = new Label((Composite)group8, 0);
        label10.setText(this.settings.msg("dialog.settings.options"));
        Label label11 = new Label((Composite)group8, 0);
        label11.setText(this.settings.msg("dialog.settings.values"));
        this.options = new org.eclipse.swt.widgets.List((Composite)group8, 2560);
        this.options.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsDialog.this.storeValues();
                SettingsDialog.this.previousSelection = SettingsDialog.this.options.getSelectionIndex();
                if (SettingsDialog.this.previousSelection != -1) {
                    SettingsDialog.this.values.setText(SettingsDialog.this.conf.getMultilineValues("profile", SettingsDialog.this.options.getItem(SettingsDialog.this.previousSelection), SettingsDialog.this.values.getLineDelimiter()));
                }
            }
        });
        this.options.setLayoutData((Object)new GridData(4, 4, true, true));
        for (String string5 : this.conf.getAllItemNames("profile")) {
            this.options.add(string5);
        }
        this.values = new Text((Composite)group8, 2818);
        this.values.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem tabItem4 = new TabItem(tabFolder, 0);
        tabItem4.setText(this.settings.msg("dialog.settings.tab.gui"));
        final Composite composite5 = new Composite((Composite)tabFolder, 0);
        composite5.setLayout((Layout)new GridLayout(2, false));
        tabItem4.setControl((Control)composite5);
        Group group9 = new Group(composite5, 0);
        group9.setLayout((Layout)new GridLayout(3, false));
        string5 = new GridData();
        ((GridData)string5).grabExcessHorizontalSpace = true;
        ((GridData)string5).horizontalAlignment = 4;
        ((GridData)string5).horizontalSpan = 2;
        group9.setLayoutData((Object)string5);
        group9.setText(this.settings.msg("dialog.settings.screenshots"));
        Label label12 = new Label((Composite)group9, 0);
        label12.setText(this.settings.msg("dialog.settings.height"));
        GridData gridData4 = new GridData();
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalAlignment = 4;
        this.screenshotsHeight = new Scale((Composite)group9, 0);
        this.screenshotsHeight.setMaximum(750);
        this.screenshotsHeight.setMinimum(50);
        this.screenshotsHeight.setLayoutData((Object)gridData4);
        this.screenshotsHeight.setIncrement(25);
        this.screenshotsHeight.setPageIncrement(100);
        this.screenshotsHeight.setSelection(this.conf.getIntValue("gui", "screenshotsheight"));
        this.screenshotsHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsDialog.this.heightValue.setText(SettingsDialog.this.screenshotsHeight.getSelection() + SettingsDialog.this.settings.msg("dialog.settings.px"));
                SettingsDialog.this.heightValue.pack();
            }
        });
        this.heightValue = new Label((Composite)group9, 0);
        this.heightValue.setText(this.screenshotsHeight.getSelection() + this.settings.msg("dialog.settings.px"));
        Label label13 = new Label((Composite)group9, 0);
        label13.setText(this.settings.msg("dialog.settings.screenshotsfilename"));
        final Button button5 = new Button((Composite)group9, 32);
        button5.setSelection(this.conf.getBooleanValue("gui", "screenshotsfilename"));
        Group group10 = new Group(composite5, 0);
        group10.setLayout((Layout)new GridLayout(3, false));
        GridData gridData5 = new GridData();
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.horizontalAlignment = 4;
        gridData5.horizontalSpan = 2;
        group10.setLayoutData((Object)gridData5);
        group10.setText(this.settings.msg("dialog.settings.screenshotscolumn"));
        Label label14 = new Label((Composite)group10, 0);
        label14.setText(this.settings.msg("dialog.settings.height"));
        this.screenshotsColumnHeight = new Scale((Composite)group10, 0);
        this.screenshotsColumnHeight.setMaximum(200);
        this.screenshotsColumnHeight.setMinimum(16);
        GridData gridData6 = new GridData();
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.horizontalAlignment = 4;
        this.screenshotsColumnHeight.setLayoutData((Object)gridData6);
        this.screenshotsColumnHeight.setIncrement(4);
        this.screenshotsColumnHeight.setPageIncrement(16);
        this.screenshotsColumnHeight.setSelection(this.conf.getIntValue("gui", "screenshotscolumnheight"));
        this.screenshotsColumnHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsDialog.this.columnHeightValue.setText(SettingsDialog.this.screenshotsColumnHeight.getSelection() + SettingsDialog.this.settings.msg("dialog.settings.px"));
                SettingsDialog.this.columnHeightValue.pack();
            }
        });
        this.columnHeightValue = new Label((Composite)group10, 0);
        this.columnHeightValue.setText(this.screenshotsColumnHeight.getSelection() + this.settings.msg("dialog.settings.px"));
        Label label15 = new Label((Composite)group10, 0);
        label15.setText(this.settings.msg("dialog.settings.screenshotscolumnstretch"));
        final Button button6 = new Button((Composite)group10, 32);
        button6.setSelection(this.conf.getBooleanValue("gui", "screenshotscolumnstretch"));
        new Label((Composite)group10, 0);
        Label label16 = new Label((Composite)group10, 0);
        label16.setText(this.settings.msg("dialog.settings.screenshotscolumnkeepaspectratio"));
        final Button button7 = new Button((Composite)group10, 32);
        button7.setSelection(this.conf.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"));
        new Label((Composite)group10, 0);
        button7.setEnabled(button6.getSelection());
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                button7.setEnabled(button6.getSelection());
            }
        });
        Group group11 = new Group(composite5, 0);
        group11.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        group11.setLayout((Layout)new GridLayout(2, false));
        group11.setText(this.settings.msg("dialog.settings.buttons"));
        Label label17 = new Label((Composite)group11, 0);
        label17.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label17.setText(this.settings.msg("dialog.settings.display"));
        this.buttonDisplay = new Combo((Composite)group11, 8);
        this.buttonDisplay.setItems(buttonDisplayOptions);
        this.buttonDisplay.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonDisplay.select(this.conf.getIntValue("gui", "buttondisplay"));
        final Group group12 = new Group(composite5, 0);
        group12.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group12.setLayout((Layout)new GridLayout(2, false));
        group12.setText(this.settings.msg("dialog.profile.notes"));
        Label label18 = new Label((Composite)group12, 0);
        label18.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label18.setText(this.settings.msg("dialog.settings.font"));
        final Button button8 = new Button((Composite)group12, 8);
        button8.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Font font = GeneralPurposeGUI.stringToFont((Device)this.shell.getDisplay(), this.port.getFont(), this.conf.getValues("gui", "notesfont"));
        button8.setText(font.getFontData()[0].getName());
        button8.setFont(font);
        button8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontDialog fontDialog = new FontDialog(SettingsDialog.this.shell, 0);
                fontDialog.setFontList(button8.getFont().getFontData());
                FontData fontData = fontDialog.open();
                if (fontData != null) {
                    button8.setText(fontData.getName());
                    button8.setFont(new Font((Device)SettingsDialog.this.shell.getDisplay(), fontData));
                    group12.setSize(group12.computeSize(-1, -1));
                    composite5.layout();
                }
            }
        });
        TabItem tabItem5 = new TabItem(tabFolder, 0);
        tabItem5.setText(this.settings.msg("dialog.settings.tab.engines"));
        Composite composite6 = new Composite((Composite)tabFolder, 0);
        composite6.setLayout((Layout)new FillLayout());
        tabItem5.setControl((Control)composite6);
        TabFolder tabFolder2 = new TabFolder(composite6, 0);
        this.setTitle = new Button[NR_OF_ENGINES];
        this.setDev = new Button[NR_OF_ENGINES];
        this.setPub = new Button[NR_OF_ENGINES];
        this.setYear = new Button[NR_OF_ENGINES];
        this.setGenre = new Button[NR_OF_ENGINES];
        this.setLink = new Button[NR_OF_ENGINES];
        this.setRank = new Button[NR_OF_ENGINES];
        this.setDescr = new Button[NR_OF_ENGINES];
        this.allRegionsCoverArt = new Button[NR_OF_ENGINES];
        this.chooseCoverArt = new Button[NR_OF_ENGINES];
        this.chooseScreenshot = new Button[NR_OF_ENGINES];
        this.maxCoverArt = new Spinner[NR_OF_ENGINES];
        this.maxScreenshots = new Spinner[NR_OF_ENGINES];
        this.platformFilterValues = new Text[NR_OF_ENGINES];
        for (int i = 0; i < NR_OF_ENGINES; ++i) {
            Label label19;
            webSearchEngine = EditProfileDialog.webSearchEngines.get(i);
            tabItem = new TabItem(tabFolder2, 0);
            tabItem.setText(this.settings.msg("dialog.settings.tab." + webSearchEngine.getSimpleName()));
            composite = new Composite((Composite)tabFolder2, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            tabItem.setControl((Control)composite);
            group = new Group(composite, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            gridData3 = new GridData();
            gridData3.grabExcessHorizontalSpace = true;
            gridData3.horizontalAlignment = 4;
            gridData3.grabExcessVerticalSpace = true;
            gridData3.verticalAlignment = 4;
            group.setLayoutData((Object)gridData3);
            group.setText(this.settings.msg("dialog.settings.consult", new String[]{webSearchEngine.getName()}));
            label3 = new Label((Composite)group, 0);
            label3.setText(this.settings.msg("dialog.settings.settitle"));
            this.setTitle[i] = new Button((Composite)group, 32);
            this.setTitle[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_title"));
            label2 = new Label((Composite)group, 0);
            label2.setText(this.settings.msg("dialog.settings.setdeveloper"));
            this.setDev[i] = new Button((Composite)group, 32);
            this.setDev[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_developer"));
            if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("hotud") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                label = new Label((Composite)group, 0);
                label.setText(this.settings.msg("dialog.settings.setpublisher"));
                this.setPub[i] = new Button((Composite)group, 32);
                this.setPub[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_publisher"));
            }
            label = new Label((Composite)group, 0);
            label.setText(this.settings.msg("dialog.settings.setyear"));
            this.setYear[i] = new Button((Composite)group, 32);
            this.setYear[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_year"));
            gridData2 = new Label((Composite)group, 0);
            gridData2.setText(this.settings.msg("dialog.settings.setgenre"));
            this.setGenre[i] = new Button((Composite)group, 32);
            this.setGenre[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_genre"));
            button = new Label((Composite)group, 0);
            button.setText(this.settings.msg("dialog.settings.setlink", new String[]{webSearchEngine.getName()}));
            this.setLink[i] = new Button((Composite)group, 32);
            this.setLink[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_link"));
            gridData = new Label((Composite)group, 0);
            gridData.setText(this.settings.msg("dialog.settings.setrank", new Object[]{MainWindow.columnNames[18]}));
            this.setRank[i] = new Button((Composite)group, 32);
            this.setRank[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_rank"));
            if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("hotud") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                label19 = new Label((Composite)group, 0);
                label19.setText(this.settings.msg("dialog.settings.setdescription"));
                this.setDescr[i] = new Button((Composite)group, 32);
                this.setDescr[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "set_description"));
            }
            if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                label19 = new Label((Composite)group, 0);
                label19.setText(this.settings.msg("dialog.settings.choosecoverart"));
                Composite composite7 = new Composite((Composite)group, 0);
                GridLayout gridLayout = new GridLayout(3, false);
                gridLayout.marginWidth = 0;
                composite7.setLayout((Layout)gridLayout);
                this.chooseCoverArt[i] = new Button(composite7, 32);
                this.chooseCoverArt[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "choose_coverart"));
                if (webSearchEngine.getSimpleName().equals("mobygames")) {
                    Label label20 = new Label(composite7, 0);
                    label20.setText(this.settings.msg("dialog.settings.allregionscoverart"));
                    GridData gridData7 = new GridData();
                    gridData7.horizontalIndent = 40;
                    label20.setLayoutData((Object)gridData7);
                    this.allRegionsCoverArt[i] = new Button(composite7, 32);
                    this.allRegionsCoverArt[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "force_all_regions_coverart"));
                }
            }
            if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("pouet") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                label19 = new Label((Composite)group, 0);
                label19.setText(this.settings.msg("dialog.settings.choosescreenshot"));
                this.chooseScreenshot[i] = new Button((Composite)group, 32);
                this.chooseScreenshot[i].setSelection(this.conf.getBooleanValue(webSearchEngine.getSimpleName(), "choose_screenshot"));
            }
            if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                label19 = new Label((Composite)group, 0);
                label19.setText(this.settings.msg("dialog.settings.multieditmaxcoverart"));
                this.maxCoverArt[i] = new Spinner((Composite)group, 2048);
                this.maxCoverArt[i].setLayoutData((Object)new GridData(100, -1));
                this.maxCoverArt[i].setMinimum(0);
                this.maxCoverArt[i].setMaximum(Integer.MAX_VALUE);
                this.maxCoverArt[i].setSelection(this.conf.getIntValue(webSearchEngine.getSimpleName(), "multi_max_coverart"));
            }
            if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("pouet") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                label19 = new Label((Composite)group, 0);
                label19.setText(this.settings.msg("dialog.settings.multieditmaxscreenshot"));
                this.maxScreenshots[i] = new Spinner((Composite)group, 2048);
                this.maxScreenshots[i].setLayoutData((Object)new GridData(100, -1));
                this.maxScreenshots[i].setMinimum(0);
                this.maxScreenshots[i].setMaximum(Integer.MAX_VALUE);
                this.maxScreenshots[i].setSelection(this.conf.getIntValue(webSearchEngine.getSimpleName(), "multi_max_screenshot"));
            }
            label19 = new Label((Composite)group, 0);
            label19.setText(this.settings.msg("dialog.settings.platformfilter"));
            if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("pouet")) {
                this.platformFilterValues[i] = new Text((Composite)group, 2818);
                this.platformFilterValues[i].setLayoutData((Object)new GridData(4, 4, true, true));
                this.platformFilterValues[i].setText(this.conf.getMultilineValues(webSearchEngine.getSimpleName(), "platform_filter", this.platformFilterValues[i].getLineDelimiter()));
                continue;
            }
            this.platformFilterValues[i] = new Text((Composite)group, 2048);
            this.platformFilterValues[i].setLayoutData((Object)new GridData(4, 4, true, false));
            this.platformFilterValues[i].setText(this.conf.getValue(webSearchEngine.getSimpleName(), "platform_filter"));
        }
        TabItem tabItem6 = new TabItem(tabFolder, 0);
        tabItem6.setText(this.settings.msg("dialog.settings.tab.environment"));
        webSearchEngine = new Composite((Composite)tabFolder, 0);
        webSearchEngine.setLayout((Layout)new GridLayout(1, true));
        tabItem6.setControl((Control)webSearchEngine);
        tabItem = new Group((Composite)webSearchEngine, 0);
        tabItem.setLayout((Layout)new GridLayout(2, false));
        composite = new GridData();
        composite.grabExcessHorizontalSpace = true;
        composite.horizontalAlignment = 4;
        composite.grabExcessVerticalSpace = true;
        composite.verticalAlignment = 4;
        tabItem.setLayoutData((Object)composite);
        tabItem.setText(this.settings.msg("dialog.settings.environment"));
        group = new Label((Composite)tabItem, 0);
        group.setText(this.settings.msg("dialog.settings.enableenvironment"));
        gridData3 = new Button((Composite)tabItem, 32);
        gridData3.setSelection(this.conf.getBooleanValue("environment", "use"));
        gridData3.addSelectionListener((SelectionListener)new SelectionAdapter((Button)gridData3){
            final /* synthetic */ Button val$enableEnv;
            {
                this.val$enableEnv = button;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsDialog.this.envValues.setEnabled(this.val$enableEnv.getSelection());
            }
        });
        label3 = new Label((Composite)tabItem, 0);
        label3.setText(this.settings.msg("dialog.settings.environmentvariables"));
        this.envValues = new Text((Composite)tabItem, 2818);
        this.envValues.setLayoutData((Object)new GridData(4, 4, true, true));
        this.envValues.setText(this.conf.getMultilineValues("environment", "value", this.envValues.getLineDelimiter()));
        this.envValues.setEnabled(gridData3.getSelection());
        label2 = new Composite((Composite)this.shell, 0);
        label2.setLayout((Layout)new GridLayout(2, true));
        label2.setLayoutData((Object)"South");
        label = new Button((Composite)label2, 0);
        label.addSelectionListener((SelectionListener)new SelectionAdapter((Button)gridData3){
            final /* synthetic */ Button val$enableEnv;
            {
                this.val$enableEnv = button82;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                if (!SettingsDialog.this.isValid()) {
                    return;
                }
                SettingsDialog.this.changedVisColumns = this.haveColumnsBeenChanged();
                if (SettingsDialog.this.changedVisColumns) {
                    SettingsDialog.this.updateColumnSettings();
                }
                SettingsDialog.this.conf.setBooleanValue("dosbox", "hideconsole", button2.getSelection());
                SettingsDialog.this.conf.setBooleanValue("communication", "port_enabled", button3.getSelection());
                SettingsDialog.this.conf.setValue("communication", "port", SettingsDialog.this.port.getText());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "confpath", SettingsDialog.this.confLocation.getSelectionIndex());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "conffile", SettingsDialog.this.confFilename.getSelectionIndex());
                SettingsDialog.this.conf.setValue("locale", "language", ((Locale)treeMap.get(SettingsDialog.this.localeCombo.getText())).getLanguage());
                SettingsDialog.this.conf.setValue("locale", "country", ((Locale)treeMap.get(SettingsDialog.this.localeCombo.getText())).getCountry());
                SettingsDialog.this.conf.setValue("locale", "variant", ((Locale)treeMap.get(SettingsDialog.this.localeCombo.getText())).getVariant());
                for (n = 0; n < MainWindow.columnNames.length; ++n) {
                    SettingsDialog.this.conf.setBooleanValue("gui", "column" + (n + 1) + "visible", SettingsDialog.this.visibleColumns[SettingsDialog.this.allColumnIDs.indexOf(n)].getChecked());
                }
                SettingsDialog.this.conf.setBooleanValue("gui", "autosortonupdate", button4.getSelection());
                for (n = 0; n < 10; ++n) {
                    SettingsDialog.this.conf.setValue("gui", "custom" + (n + 1), SettingsDialog.this.visibleColumns[SettingsDialog.this.allColumnIDs.indexOf(n + 10)].getText());
                }
                SettingsDialog.this.conf.setIntValue("gui", "screenshotsheight", SettingsDialog.this.screenshotsHeight.getSelection());
                SettingsDialog.this.conf.setBooleanValue("gui", "screenshotsfilename", button5.getSelection());
                SettingsDialog.this.conf.setIntValue("gui", "screenshotscolumnheight", SettingsDialog.this.screenshotsColumnHeight.getSelection());
                SettingsDialog.this.conf.setBooleanValue("gui", "screenshotscolumnstretch", button6.getSelection());
                SettingsDialog.this.conf.setBooleanValue("gui", "screenshotscolumnkeepaspectratio", button7.getSelection());
                Rectangle rectangle = SettingsDialog.this.shell.getBounds();
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_width", rectangle.width);
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_height", rectangle.height);
                SettingsDialog.this.conf.setIntValue("gui", "buttondisplay", SettingsDialog.this.buttonDisplay.getSelectionIndex());
                SettingsDialog.this.conf.setMultilineValues("gui", "notesfont", GeneralPurposeGUI.fontToString((Device)SettingsDialog.this.shell.getDisplay(), button8.getFont()), "|");
                for (int i = 0; i < NR_OF_ENGINES; ++i) {
                    WebSearchEngine webSearchEngine = EditProfileDialog.webSearchEngines.get(i);
                    SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_title", SettingsDialog.this.setTitle[i].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_developer", SettingsDialog.this.setDev[i].getSelection());
                    if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("hotud") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                        SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_publisher", SettingsDialog.this.setPub[i].getSelection());
                        SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_description", SettingsDialog.this.setDescr[i].getSelection());
                    }
                    SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_year", SettingsDialog.this.setYear[i].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_genre", SettingsDialog.this.setGenre[i].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_link", SettingsDialog.this.setLink[i].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "set_rank", SettingsDialog.this.setRank[i].getSelection());
                    if (webSearchEngine.getSimpleName().equals("mobygames")) {
                        SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "force_all_regions_coverart", SettingsDialog.this.allRegionsCoverArt[i].getSelection());
                    }
                    if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                        SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "choose_coverart", SettingsDialog.this.chooseCoverArt[i].getSelection());
                        SettingsDialog.this.conf.setIntValue(webSearchEngine.getSimpleName(), "multi_max_coverart", SettingsDialog.this.maxCoverArt[i].getSelection());
                    }
                    if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("pouet") || webSearchEngine.getSimpleName().equals("thegamesdb")) {
                        SettingsDialog.this.conf.setBooleanValue(webSearchEngine.getSimpleName(), "choose_screenshot", SettingsDialog.this.chooseScreenshot[i].getSelection());
                        SettingsDialog.this.conf.setIntValue(webSearchEngine.getSimpleName(), "multi_max_screenshot", SettingsDialog.this.maxScreenshots[i].getSelection());
                    }
                    if (webSearchEngine.getSimpleName().equals("mobygames") || webSearchEngine.getSimpleName().equals("pouet")) {
                        SettingsDialog.this.conf.setMultilineValues(webSearchEngine.getSimpleName(), "platform_filter", SettingsDialog.this.platformFilterValues[i].getText(), SettingsDialog.this.platformFilterValues[i].getLineDelimiter());
                        continue;
                    }
                    SettingsDialog.this.conf.setValue(webSearchEngine.getSimpleName(), "platform_filter", SettingsDialog.this.platformFilterValues[i].getText());
                }
                SettingsDialog.this.conf.setBooleanValue("environment", "use", this.val$enableEnv.getSelection());
                SettingsDialog.this.conf.setMultilineValues("environment", "value", SettingsDialog.this.envValues.getText(), SettingsDialog.this.envValues.getLineDelimiter());
                SettingsDialog.this.storeValues();
                SettingsDialog.this.settings.getSettings().injectValuesFrom(SettingsDialog.this.conf);
                SettingsDialog.this.shell.close();
            }

            private boolean haveColumnsBeenChanged() {
                for (int i = 0; i < MainWindow.columnNames.length; ++i) {
                    if (SettingsDialog.this.conf.getBooleanValue("gui", "column" + ((Integer)SettingsDialog.this.allColumnIDs.get(i) + 1) + "visible") == SettingsDialog.this.visibleColumns[i].getChecked() && MainWindow.columnNames[(Integer)SettingsDialog.this.allColumnIDs.get(i)].equals(SettingsDialog.this.visibleColumns[i].getText())) continue;
                    return true;
                }
                return false;
            }
        });
        this.shell.setDefaultButton((Button)label);
        gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.widthHint = 80;
        label.setLayoutData((Object)gridData2);
        label.setText(this.settings.msg("button.ok"));
        button = new Button((Composite)label2, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        button.setText(this.settings.msg("button.cancel"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsDialog.this.shell.close();
            }
        });
    }

    private void storeValues() {
        if (this.previousSelection != -1) {
            this.conf.setMultilineValues("profile", this.options.getItem(this.previousSelection), this.values.getText(), this.values.getLineDelimiter());
        }
    }

    private int countVisibleColumns() {
        int n = 0;
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            ++n;
        }
        return n;
    }

    private int getFirstVisibleColumn() {
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            return i;
        }
        return -1;
    }

    private void updateColumnSettings() {
        int[] nArray = this.conf.getIntValues("gui", "sortcolumn");
        boolean[] blArray = this.conf.getBooleanValues("gui", "sortascending");
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.visibleColumns[this.allColumnIDs.indexOf(nArray[i])].getChecked()) continue;
            arrayList.add(nArray[i]);
            arrayList2.add(blArray[i]);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this.allColumnIDs.get(this.getFirstVisibleColumn()));
            arrayList2.add(true);
        }
        this.conf.setIntValues("gui", "sortcolumn", ArrayUtils.toPrimitive((Integer[])arrayList.toArray(new Integer[0])));
        this.conf.setBooleanValues("gui", "sortascending", ArrayUtils.toPrimitive((Boolean[])arrayList2.toArray(new Boolean[0])));
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            arrayList3.add(this.allColumnIDs.get(i));
        }
        ArrayList arrayList4 = new ArrayList(arrayList3);
        Collections.sort(arrayList4);
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            arrayList5.add(arrayList4.indexOf(n));
        }
        this.conf.setValue("gui", "columnorder", StringUtils.join(arrayList5, (char)' '));
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.countVisibleColumns() == 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.settings.required.onevisiblecolumn"), (Control)this.visible_columns, this.columnsTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    static {
        for (Locale locale : Locale.getAvailableLocales()) {
            allLocales.put(locale.toString(), locale);
        }
        confLocations = new String[]{Settings.getInstance().msg("dialog.settings.confindbgldir"), Settings.getInstance().msg("dialog.settings.confingamedir")};
        confFilenames = new String[]{Settings.getInstance().msg("dialog.settings.conffilebyid"), Settings.getInstance().msg("dialog.settings.conffilebytitle")};
        buttonDisplayOptions = new String[]{Settings.getInstance().msg("dialog.settings.displaybuttonimageandtext"), Settings.getInstance().msg("dialog.settings.displaybuttontextonly"), Settings.getInstance().msg("dialog.settings.displaybuttonimageonly")};
    }
}

