/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.loopy.iso9660;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.Enumeration;
import org.dbgl.loopy.iso9660.EntryEnumeration;
import org.dbgl.loopy.iso9660.ISO9660FileEntry;
import org.dbgl.loopy.iso9660.ISO9660VolumeDescriptorSet;
import org.dbgl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISO9660FileSystem {
    public static final int COOKED_SECTOR_SIZE = 2048;
    public static final int VCD_SECTOR_SIZE = 2336;
    public static final int RAW_SECTOR_SIZE = 2352;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final int RESERVED_SECTORS = 16;
    private int blockSize;
    private boolean mode2;
    private ISO9660VolumeDescriptorSet volumeDescriptorSet;
    private RandomAccessFile channel;

    public ISO9660FileSystem(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (file.getName().toLowerCase().endsWith(FileUtils.CDIMAGES[1])) {
            File file2 = ISO9660FileSystem.parseCueSheet(file);
            if (file2 == null) {
                throw new IOException("Couldn't parse cue sheet");
            }
            file = file2;
        }
        this.channel = new RandomAccessFile(file, "r");
        this.volumeDescriptorSet = new ISO9660VolumeDescriptorSet(this);
        if (!(this.canReadVolumeDescriptors(2048, false) || this.canReadVolumeDescriptors(2352, false) || this.canReadVolumeDescriptors(2336, true) || this.canReadVolumeDescriptors(2352, true))) {
            throw new IOException("Couldn't find volume descriptor, the cd-image doesn't seem to be in ISO9660 file format");
        }
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            throw new IOException("Couldn't close file channel");
        }
        finally {
            this.channel = null;
        }
    }

    public Enumeration<ISO9660FileEntry> getEntries() {
        this.ensureOpen();
        return new EntryEnumeration(this, this.volumeDescriptorSet.getRootEntry());
    }

    public String getEncoding() {
        return this.volumeDescriptorSet.getEncoding();
    }

    byte[] getBytes(ISO9660FileEntry iSO9660FileEntry) throws IOException {
        int n = iSO9660FileEntry.getSize();
        int n2 = (n + 2048 - 1) / 2048;
        byte[] byArray = new byte[n2 * 2048];
        for (int i = 0; i < n2; ++i) {
            this.readBlock(iSO9660FileEntry.getStartBlock() + (long)i, byArray, i * 2048);
        }
        return byArray;
    }

    public static File parseCueSheet(File file) throws IOException {
        String string;
        File file2 = null;
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || !string.startsWith("FILE")) continue;
            int n = string.indexOf(34, 5);
            int n2 = string.lastIndexOf(34);
            if (n == -1 || n2 == -1 || n >= n2) continue;
            String string2 = string.substring(n + 1, n2);
            if (new File(string2).isAbsolute()) {
                file2 = new File(string2);
                break;
            }
            file2 = new File(file.getParent(), string2);
            break;
        }
        bufferedReader.close();
        ((Reader)fileReader).close();
        return file2;
    }

    private boolean canReadVolumeDescriptors(int n, boolean bl) {
        this.blockSize = n;
        this.mode2 = bl;
        byte[] byArray = new byte[2048];
        try {
            int n2 = 16;
            while (this.readBlock(n2, byArray, 0) && !this.volumeDescriptorSet.deserialize(byArray)) {
                ++n2;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return this.volumeDescriptorSet.getRootEntry() != null;
    }

    private boolean readBlock(long l, byte[] byArray, int n) throws IOException {
        int n2 = this.readData(l * (long)this.blockSize, byArray, n, 2048);
        if (n2 <= 0) {
            return false;
        }
        if (2048 != n2) {
            throw new IOException("Could not deserialize a complete block");
        }
        return true;
    }

    private int readData(long l, byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        long l2 = l;
        if (this.blockSize == 2352 && !this.mode2) {
            l2 += 16L;
        }
        if (this.mode2) {
            l2 += 24L;
        }
        this.channel.seek(l2);
        return this.channel.read(byArray, n, n2);
    }

    private boolean isClosed() {
        return this.channel == null;
    }

    private void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }
}

