/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.exception.InvalidHostfileException;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mount {
    private MountingType mountingType;
    private String mountAs;
    private char driveletter;
    private String label;
    private File[] path;
    private File write;
    private String lowlevelCD;
    private String useCD;
    private String freesize;
    private boolean unmounted;

    public Mount(MountingType mountingType, String string, String string2, String[] stringArray, String string3, String string4, String string5, String string6, String string7) {
        this.mountingType = mountingType;
        this.mountAs = string.toLowerCase();
        this.driveletter = Character.toUpperCase(string2.charAt(0));
        this.path = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.path[i] = new File(stringArray[i]);
        }
        this.write = string6 == null ? null : new File(string6);
        this.label = string3;
        this.lowlevelCD = string4;
        this.useCD = string5;
        this.freesize = string7;
        this.unmounted = false;
    }

    public Mount(Mount mount) {
        this.mountingType = mount.mountingType;
        this.mountAs = mount.mountAs;
        this.driveletter = mount.driveletter;
        this.label = mount.label;
        this.path = (File[])mount.path.clone();
        this.write = mount.write;
        this.lowlevelCD = mount.lowlevelCD;
        this.useCD = mount.useCD;
        this.freesize = mount.freesize;
        this.unmounted = mount.unmounted;
    }

    private void init() {
        this.mountingType = MountingType.DIR;
        this.mountAs = "";
        this.driveletter = '\u0000';
        this.label = "";
        this.path = new File[0];
        this.write = null;
        this.lowlevelCD = "";
        this.useCD = "";
        this.freesize = "";
        this.unmounted = false;
    }

    private void initForPhysFS(String string) {
        this.mountingType = MountingType.PHYSFS;
        int n = string.indexOf(58);
        if (n == 1) {
            n = string.indexOf(":", n + 1);
        }
        int n2 = string.lastIndexOf(":");
        this.path = new File[1];
        if (n == n2) {
            this.path[0] = new File(string.substring(0, n2));
        } else {
            this.write = new File(string.substring(0, n));
            this.path[0] = new File(string.substring(n + 1, n2));
        }
    }

    private void initForIso(String string) {
        this.mountingType = MountingType.IMAGE;
        this.mountAs = "iso";
        this.path = new File[1];
        this.path[0] = new File(string.substring(0, FileUtils.containsIso(string)));
    }

    private void initForFat(String string) {
        this.mountingType = MountingType.IMAGE;
        this.mountAs = "floppy";
        this.path = new File[1];
        this.path[0] = new File(string.substring(0, FileUtils.containsFatImage(string)));
    }

    public Mount(boolean bl, String string, Set<Character> set) throws InvalidHostfileException, DrivelettersExhaustedException {
        this.init();
        if ("".equals(string)) {
            throw new InvalidHostfileException();
        }
        this.driveletter = Mount.getFreeDriveletter(bl, set);
        if (FileUtils.containsPhysFS(string) != -1) {
            this.initForPhysFS(string);
        } else if (FileUtils.containsIso(string) != -1) {
            this.initForIso(string);
        } else if (FileUtils.containsFatImage(string) != -1) {
            this.driveletter = Mount.getFreeDriveletter(true, set);
            this.initForFat(string);
        } else {
            File file = new File(string);
            this.path = new File[1];
            this.path[0] = file.getParentFile();
            if (this.path[0] == null) {
                this.path[0] = new File(".");
            }
            if (FileUtils.isStoredOnFloppyDrive(file)) {
                this.mountAs = "floppy";
            } else if (FileUtils.isStoredOnCDRomDrive(file)) {
                this.mountAs = "cdrom";
            }
        }
    }

    public Mount(String string, Set<Character> set, File[] fileArray) throws InvalidHostfileException, DrivelettersExhaustedException {
        this(false, string, set);
        if (fileArray != null && fileArray.length > 0) {
            this.path = fileArray;
        }
    }

    public Mount(String string) throws InvalidMountstringException {
        int n;
        this.init();
        if ("".equals(string)) {
            throw new InvalidMountstringException();
        }
        int n2 = string.indexOf(32);
        this.driveletter = Character.toUpperCase(string.charAt(n2 + 1));
        boolean bl = true;
        int n3 = string.indexOf(34);
        int n4 = string.lastIndexOf(34);
        if (n3 == -1 && n4 == -1) {
            bl = false;
            n3 = string.indexOf(32, n2 + 1);
            n4 = string.indexOf(" -t", n3 + 1);
        }
        if (n4 == -1 || n3 == n4) {
            n4 = string.length();
        }
        String string2 = PlatformUtils.toNativePath(string.substring(n3 + 1, n4));
        String[] stringArray = StringRelatedUtils.mountToStringArray(string2, bl);
        this.path = new File[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.path[n] = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(stringArray[n]));
        }
        if (string.toLowerCase().startsWith("mount ")) {
            int n5;
            String[] stringArray2;
            if (FileUtils.isPhysFS(string2)) {
                this.initForPhysFS(string2);
            }
            if ((n = string.indexOf("-u ")) != -1) {
                this.unmounted = true;
                this.driveletter = Character.toUpperCase(string.charAt(n + 3));
                return;
            }
            this.readMountType(string);
            int n6 = string.indexOf("-label ");
            if (n6 != -1) {
                int n7 = string.indexOf(" ", n6 + 7);
                if (n7 == -1) {
                    n7 = string.length();
                }
                this.label = string.substring(n6 + 7, n7);
            }
            String[] stringArray3 = stringArray2 = Settings.getInstance().getSettings().getValues("profile", "lowlevelcd_type");
            int n8 = stringArray3.length;
            for (n5 = 0; n5 < n8; ++n5) {
                String string3 = stringArray3[n5];
                if (string.indexOf(" -" + string3) == -1) continue;
                this.lowlevelCD = string3;
            }
            int n9 = string.indexOf("-usecd ");
            if (n9 != -1) {
                n8 = string.indexOf(" ", n9 + 7);
                if (n8 == -1) {
                    n8 = string.length();
                }
                this.useCD = string.substring(n9 + 7, n8);
            }
            if ((n8 = string.indexOf("-freesize ")) != -1) {
                n5 = string.indexOf(" ", n8 + 10);
                if (n5 == -1) {
                    n5 = string.length();
                }
                this.freesize = string.substring(n8 + 10, n5);
            }
        } else if (string.toLowerCase().startsWith("imgmount ")) {
            this.mountingType = MountingType.IMAGE;
            this.readMountType(string);
            if (this.mountAs.equalsIgnoreCase("cdrom")) {
                this.mountAs = "iso";
            }
        }
    }

    private void readMountType(String string) {
        int n = string.indexOf("-t ");
        if (n != -1) {
            int n2 = string.indexOf(" ", n + 3);
            if (n2 == -1) {
                n2 = string.length();
            }
            this.mountAs = string.substring(n + 3, n2);
        }
    }

    public static char getFreeDriveletter(boolean bl, Set<Character> set) throws DrivelettersExhaustedException {
        char c;
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (char c2 = c = bl ? (char)'A' : 'C'; c2 < 'Z'; c2 = (char)(c2 + '\u0001')) {
            arrayList.add(Character.valueOf(c2));
        }
        if (!bl) {
            arrayList.add(Character.valueOf('A'));
            arrayList.add(Character.valueOf('B'));
        }
        for (Character c3 : set) {
            arrayList.remove(c3);
        }
        if (arrayList.isEmpty()) {
            throw new DrivelettersExhaustedException();
        }
        return ((Character)arrayList.get(0)).charValue();
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.mountingType) {
            case DIR: {
                stringBuffer.append("mount ").append(this.driveletter).append(" \"").append(this.getPathAsString()).append('\"');
                if (this.lowlevelCD.length() > 0) {
                    stringBuffer.append(" -").append(this.lowlevelCD);
                }
                if (this.useCD.length() <= 0) break;
                stringBuffer.append(" -usecd ").append(this.useCD);
                break;
            }
            case PHYSFS: {
                stringBuffer.append("mount ").append(this.driveletter).append(" \"");
                if (this.write != null) {
                    stringBuffer.append(this.write.getPath()).append(':');
                }
                stringBuffer.append(this.path[0].getPath()).append(":\\\"");
                break;
            }
            case IMAGE: {
                stringBuffer.append("imgmount ").append(this.driveletter);
                for (int i = 0; i < this.path.length; ++i) {
                    stringBuffer.append(" \"").append(this.path[i].getPath()).append('\"');
                }
                break;
            }
        }
        if (!"".equals(this.label)) {
            stringBuffer.append(" -label ").append(this.label);
        }
        if (!"".equals(this.mountAs)) {
            stringBuffer.append(" -t ").append(this.mountAs);
        }
        if (!"".equals(this.freesize)) {
            stringBuffer.append(" -freesize ").append(this.freesize);
        }
        if (this.unmounted) {
            if (bl) {
                stringBuffer.append(" (UNMOUNTED)");
            } else {
                stringBuffer = new StringBuffer("mount -u ").append(this.driveletter);
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public void toggleMount() {
        this.unmounted = !this.unmounted;
    }

    public char getDriveletter() {
        return this.driveletter;
    }

    public String getDriveletterString() {
        return String.valueOf(this.driveletter);
    }

    public String getLowlevelCD() {
        return this.lowlevelCD;
    }

    public String getUseCD() {
        return this.useCD;
    }

    public boolean isUnmounted() {
        return this.unmounted;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPathAsString() {
        if (this.path.length <= 0) {
            return "";
        }
        return this.path[0].getPath();
    }

    public File getWrite() {
        return this.write;
    }

    public char getDriveletterFromPath() {
        return Character.toUpperCase(this.path[0].getAbsolutePath().charAt(0));
    }

    public String getImgMountAsString(String string) {
        String[] stringArray = new String[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            stringArray[i] = this.path[i].getPath();
        }
        return StringRelatedUtils.stringArrayToString(stringArray, string);
    }

    public File[] getPath() {
        return this.path;
    }

    public String getHostPathAsString() {
        return this.mountingType == MountingType.PHYSFS ? this.getPathAsString() + ':' : this.getPathAsString();
    }

    public MountingType getMountingType() {
        return this.mountingType;
    }

    public String getMountAs() {
        return this.mountAs;
    }

    public String getFreesize() {
        return this.freesize;
    }

    public File canBeUsedFor(File file) {
        if (!this.unmounted) {
            File file2 = FileUtils.getCanMainFile(file);
            File file3 = FileUtils.canonicalToDosroot(this.getPathAsString());
            if (this.mountingType != MountingType.DIR && (FileUtils.isIsoFile(file2.getPath()) || FileUtils.isArchive(file2.getPath()) || FileUtils.isFatImage(file2.getPath()))) {
                return file3.equals(file2) ? FileUtils.makeRelativeTo(FileUtils.canonicalToDosroot(file.getPath()), FileUtils.canonicalToDosroot(this.getHostPathAsString())) : null;
            }
            if (FileUtils.areRelated(file3, file2)) {
                if (file.getPath().indexOf(126) > 0) {
                    file2 = file.isAbsolute() ? file : new File(FileUtils.getDosRoot(), file.getPath());
                }
                return FileUtils.makeRelativeTo(file2, file3);
            }
        }
        return null;
    }

    public void migrateToDosroot(File file, boolean bl) {
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = FileUtils.makeRelativeTo(bl ? FileUtils.canonicalToDosroot(this.path[i].getPath()) : this.path[i], file);
        }
        if (this.write != null) {
            this.write = FileUtils.makeRelativeTo(bl ? FileUtils.canonicalToDosroot(this.write.getPath()) : this.write, file);
        }
    }

    public void migrateTo(File file, File file2) {
        File file3 = FileUtils.makeRelativeToDosroot(file);
        File file4 = FileUtils.makeRelativeToDosroot(file2);
        for (int i = 0; i < this.path.length; ++i) {
            if (!this.path[i].getPath().equals(file3.getPath())) continue;
            this.path[i] = file4;
        }
        if (this.write != null && this.write.getPath().equals(file3.getPath())) {
            this.write = file4;
        }
    }

    public void updateForTargetImportBaseDir(File file) {
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = FileUtils.prefixAndSanitizeToDosroot(file, this.path[i]);
        }
        if (this.write != null) {
            this.write = FileUtils.prefixAndSanitizeToDosroot(file, this.write);
        }
    }

    public int hashCode() {
        return this.toString(false).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Mount mount = (Mount)object;
        return this.driveletter == mount.driveletter && this.unmounted == mount.unmounted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MountingType {
        DIR,
        IMAGE,
        PHYSFS;

    }
}

