/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeCommand {
    private File command;
    private String parameters;
    private File cwd;
    private boolean waitFor;
    private int orderNr;

    public NativeCommand(File file, String string, File file2, boolean bl, int n) {
        this.command = file;
        this.parameters = string;
        this.cwd = file2;
        this.waitFor = bl;
        this.orderNr = n;
    }

    public File getCommand() {
        return this.command;
    }

    public String getParameters() {
        return this.parameters;
    }

    public File getCwd() {
        return this.cwd;
    }

    public File getCwdCanToData() {
        return FileUtils.canonicalToData(this.cwd.getPath());
    }

    public boolean isWaitFor() {
        return this.waitFor;
    }

    public int getOrderNr() {
        return this.orderNr;
    }

    public List<String> getExecCommandsCanToData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(FileUtils.canonicalToData(this.command.getPath()).getPath());
        if (this.parameters.length() > 0) {
            for (String string : this.parameters.split(" ")) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public String toString() {
        if (this.command == null) {
            return "-- DOSBox --";
        }
        StringBuilder stringBuilder = new StringBuilder(this.command.getPath());
        if (StringUtils.isNotEmpty((CharSequence)this.parameters)) {
            stringBuilder.append(' ').append(this.parameters);
        }
        if (!this.cwd.getPath().equals(this.command.getParent())) {
            stringBuilder.append(", ").append(this.cwd.getPath());
        }
        if (this.waitFor) {
            stringBuilder.append(", ").append(Settings.getInstance().msg("dialog.nativecommand.waitfor"));
        }
        return stringBuilder.toString();
    }

    public static void insertDosboxCommand(List<NativeCommand> list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getOrderNr() != i) continue;
            ++n;
        }
        list.add(n, new NativeCommand(null, null, null, true, n));
    }
}

