/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.Mount;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Autoexec {
    private static final String[] CUSTOM_SECTION_MARKERS = new String[]{"@REM START", "@REM /START", "@REM PRE-LAUNCH", "@REM /PRE-LAUNCH", "@REM POST-LAUNCH", "@REM /POST-LAUNCH", "@REM FINISH", "@REM /FINISH"};
    public static final int SECTIONS = CUSTOM_SECTION_MARKERS.length / 2;
    List<Mount> mountingpoints;
    Boolean loadfix;
    Boolean loadhigh;
    int loadfixValue;
    String main;
    String img1;
    String img2;
    String img3;
    Boolean exit;
    String params;
    String mixer;
    String keyb;
    String ipxnet;
    Boolean pause;
    String[] customSections;

    Autoexec() {
        this.init();
    }

    Autoexec(Autoexec autoexec) {
        this.mountingpoints = new ArrayList<Mount>();
        for (Mount mount : autoexec.mountingpoints) {
            this.mountingpoints.add(new Mount(mount));
        }
        this.loadfix = autoexec.loadfix;
        this.loadhigh = autoexec.loadhigh;
        this.loadfixValue = autoexec.loadfixValue;
        this.main = autoexec.main;
        this.img1 = autoexec.img1;
        this.img2 = autoexec.img2;
        this.img3 = autoexec.img3;
        this.exit = autoexec.exit;
        this.params = autoexec.params;
        this.mixer = autoexec.mixer;
        this.keyb = autoexec.keyb;
        this.ipxnet = autoexec.ipxnet;
        this.pause = autoexec.pause;
        this.customSections = new String[SECTIONS];
        for (int i = 0; i < SECTIONS; ++i) {
            this.customSections[i] = autoexec.customSections[i];
        }
    }

    void init() {
        this.mountingpoints = new ArrayList<Mount>();
        this.loadfix = false;
        this.loadhigh = false;
        this.loadfixValue = 0;
        this.main = "";
        this.img1 = "";
        this.img2 = "";
        this.img3 = "";
        this.exit = false;
        this.params = "";
        this.mixer = "";
        this.keyb = "";
        this.ipxnet = "";
        this.pause = false;
        this.customSections = new String[SECTIONS];
        for (int i = 0; i < SECTIONS; ++i) {
            this.customSections[i] = "";
        }
    }

    static List<Mount> getUniqueMountingpoints(Autoexec autoexec, Autoexec autoexec2) {
        int n;
        ArrayList<Mount> arrayList = new ArrayList<Mount>();
        for (int i = n = autoexec == null ? 0 : autoexec.mountingpoints.size(); i < autoexec2.mountingpoints.size(); ++i) {
            arrayList.add(new Mount(autoexec2.mountingpoints.get(i)));
        }
        return arrayList;
    }

    void parseLines(List<String> list) {
        int n;
        char c = '\u0000';
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n2 = -1;
        String string6 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = -1;
        block2: for (String string7 : list) {
            int n4;
            string7 = string7.trim();
            for (n = 0; n < SECTIONS; ++n) {
                if (!string7.startsWith(CUSTOM_SECTION_MARKERS[n * 2])) continue;
                n3 = n;
                continue block2;
            }
            if (n3 > -1) {
                if (string7.startsWith(CUSTOM_SECTION_MARKERS[n3 * 2 + 1])) {
                    n3 = -1;
                    continue;
                }
                int n5 = n3;
                this.customSections[n5] = this.customSections[n5] + string7 + PlatformUtils.EOLN;
                continue;
            }
            while (string7.startsWith("@")) {
                string7 = string7.substring(1);
            }
            String string8 = (string7 = string7.trim()).toLowerCase();
            if (string8.startsWith("loadhigh ") || string8.startsWith("lh ")) {
                this.loadhigh = true;
                n4 = string8.indexOf(32);
                string7 = StringUtils.stripStart((String)string7.substring(n4), (String)" ");
                string8 = string7.toLowerCase();
            }
            if (string8.startsWith("loadfix")) {
                if (!this.loadfix.booleanValue()) {
                    this.loadfixValue = 64;
                    this.loadfix = true;
                }
                if (StringUtils.isEmpty((CharSequence)(string8 = (string7 = StringUtils.stripStart((String)string7.substring(7), (String)" ")).toLowerCase())) || string8.startsWith("-f")) continue;
                if (string8.startsWith("-")) {
                    n4 = string8.indexOf(32);
                    if (n4 == -1) {
                        n4 = string8.length();
                    }
                    try {
                        this.loadfixValue = Integer.parseInt(string8.substring(1, n4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    string7 = StringUtils.stripStart((String)string7.substring(n4), (String)" ");
                    string8 = string7.toLowerCase();
                }
            }
            if (StringUtils.isEmpty((CharSequence)string8)) continue;
            if (string8.startsWith("mount") || string8.startsWith("imgmount")) {
                this.addMount(string7);
                continue;
            }
            if (string8.endsWith(":") && string8.length() == 2 || string8.endsWith(":\\") && string8.length() == 3) {
                c = Character.toUpperCase(string8.charAt(0));
                string = "";
                continue;
            }
            if (string8.startsWith("cd\\")) {
                if (c == '\u0000') continue;
                String string9 = PlatformUtils.toNativePath(string7).substring(2);
                if (string9.startsWith("\\")) {
                    string = string9;
                    continue;
                }
                string = new File(string, string9).getPath();
                continue;
            }
            if (string8.startsWith("cd ")) {
                if (c == '\u0000') continue;
                String string10 = PlatformUtils.toNativePath(string7).substring(3);
                if (string10.startsWith("\\")) {
                    string = string10;
                    continue;
                }
                string = new File(string, string10).getPath();
                continue;
            }
            if (string8.startsWith("keyb ") || string8.startsWith("keyb.com ")) {
                this.keyb = string7.substring(string8.indexOf(32) + 1);
                continue;
            }
            if (string8.startsWith("mixer ") || string8.startsWith("mixer.com ")) {
                this.mixer = string7.substring(string8.indexOf(32) + 1);
                continue;
            }
            if (string8.startsWith("ipxnet ") || string8.startsWith("ipxnet.com ")) {
                this.ipxnet = string7.substring(string8.indexOf(32) + 1);
                continue;
            }
            if (string8.equals("pause")) {
                this.pause = true;
                continue;
            }
            if (string8.startsWith("z:\\config.com")) continue;
            n2 = StringUtils.indexOfAny((CharSequence)string8, (CharSequence[])FileUtils.EXECUTABLES);
            if (n2 != -1) {
                int n6;
                string2 = string7;
                n4 = string2.lastIndexOf(32, n2);
                if (n4 != -1) {
                    string2 = string2.substring(n4 + 1);
                }
                if ((n6 = string2.indexOf(32)) == -1) continue;
                this.params = string7.substring(n4 + n6 + 2);
                string2 = string2.substring(0, n6);
                continue;
            }
            if (string8.startsWith("boot ")) {
                String string11;
                n4 = string8.indexOf(" -l ");
                if (n4 != -1) {
                    string7 = string7.substring(0, n4);
                    string8 = string7.toLowerCase();
                }
                boolean bl = true;
                int n7 = string8.indexOf(34);
                int n8 = string8.lastIndexOf(34);
                if (n7 == -1 && n8 == -1) {
                    bl = false;
                    n7 = string8.indexOf(32, 4);
                    n8 = string8.length();
                }
                if (n8 == -1 || n7 == n8) {
                    n8 = string8.length();
                }
                if (n7 != -1 && n8 > n7) {
                    string11 = PlatformUtils.toNativePath(string7.substring(n7 + 1, n8));
                    String[] stringArray = StringRelatedUtils.mountToStringArray(string11, bl);
                    if (stringArray != null) {
                        if (stringArray.length >= 1) {
                            string3 = stringArray[0];
                        }
                        if (stringArray.length >= 2) {
                            string4 = stringArray[1];
                        }
                        if (stringArray.length >= 3) {
                            string5 = stringArray[2];
                        }
                    }
                } else {
                    string11 = this.findFirstFloppyImagePath();
                    if (string11 != null) {
                        string3 = string11;
                    }
                }
                if (!"\\file".equals(string3)) continue;
                this.img1 = "file";
                continue;
            }
            if (string8.equals("exit") || string8.startsWith("exit ")) {
                this.exit = true;
                continue;
            }
            if (string8.equals("echo off")) continue;
            if (string8.equals("echo") || string8.startsWith("echo ") || string8.startsWith("echo.")) {
                string6 = string6 + string7 + PlatformUtils.EOLN;
                continue;
            }
            if (string8.startsWith(":") || string8.equals("cd") || string8.equals("cls") || string8.startsWith("cls ") || string8.startsWith("cls\\") || string8.equals("rem") || string8.startsWith("rem ") || string8.startsWith("goto ") || string8.startsWith("if errorlevel ")) continue;
            arrayList.add(string7);
        }
        if (StringUtils.isNotEmpty((CharSequence)string6) && !string6.equalsIgnoreCase("echo." + PlatformUtils.EOLN)) {
            this.customSections[1] = this.customSections[1] + "@echo off" + PlatformUtils.EOLN + string6;
            this.customSections[1] = this.customSections[1] + "pause" + PlatformUtils.EOLN;
        }
        if (string2.equals("") && !arrayList.isEmpty()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                string2 = ((String)arrayList.get(i)).trim();
                if (i == arrayList.size() - 1) {
                    boolean bl = string2.toLowerCase().startsWith("call ");
                    if (bl) {
                        string2 = string2.substring(5);
                    }
                    if ((n = string2.indexOf(32)) != -1) {
                        this.params = string2.substring(n + '\u0001');
                        string2 = string2.substring(0, n);
                    }
                    string2 = string2 + (bl ? FileUtils.EXECUTABLES[2] : FileUtils.EXECUTABLES[0]);
                    continue;
                }
                this.customSections[1] = this.customSections[1] + string2 + PlatformUtils.EOLN;
            }
        }
        for (Mount mount : this.mountingpoints) {
            n = mount.getDriveletter();
            String string12 = mount.getHostPathAsString();
            if (this.driveMatches(string2, (char)n, c)) {
                this.main = this.splitInThree(string2, string12, string);
                continue;
            }
            if (this.driveMatches(string3, (char)n, c)) {
                this.img1 = this.splitInThree(string3, string12, string);
                continue;
            }
            if (this.driveMatches(string4, (char)n, c)) {
                this.img2 = this.splitInThree(string4, string12, string);
                continue;
            }
            if (!this.driveMatches(string5, (char)n, c)) continue;
            this.img3 = this.splitInThree(string5, string12, string);
        }
        if (this.exit == null) {
            this.exit = false;
        }
    }

    private String findFirstFloppyImagePath() {
        for (Mount mount : this.mountingpoints) {
            if (mount.getMountingType() != Mount.MountingType.IMAGE || !mount.getMountAs().equals("floppy")) continue;
            return mount.getPathAsString();
        }
        return null;
    }

    private boolean driveMatches(String string, char c, char c2) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (string.length() > 2 && string.charAt(1) == ':') {
            return Character.toUpperCase(string.charAt(0)) == c;
        }
        return c2 == c;
    }

    private String splitInThree(String string, String string2, String string3) {
        String[] stringArray = new String[]{null, null};
        if (string.length() > 2 && string.charAt(1) == ':') {
            string = string.substring(2);
        }
        File file = new File(string);
        String string4 = file.getParent();
        File file2 = new File(string2);
        stringArray[0] = string.charAt(0) == '\\' ? (string4 == null ? string2 : new File(file2, string4).getPath()) : (string4 == null ? new File(file2, string3).getPath() : new File(new File(file2, string3), string4).getPath());
        stringArray[1] = file.getName();
        if (string3.indexOf(126) > 0) {
            String string5 = FileUtils.makeRelativeToDosroot(new File(stringArray[0], stringArray[1])).getPath();
            if (string5.startsWith("./") || string5.startsWith(".\\")) {
                string5 = string5.substring(2);
            }
            return string5;
        }
        return FileUtils.sanitizeToDosroot(new File(stringArray[0], stringArray[1]).getPath());
    }

    public String toString() {
        return this.toString(null, false);
    }

    public String toString(Autoexec autoexec, Boolean bl) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        this.insertCustomSection(stringBuffer, 0);
        if (!("".equals(this.keyb) || autoexec != null && autoexec.keyb.equals(this.keyb))) {
            stringBuffer.append("keyb.com ").append(this.keyb).append(PlatformUtils.EOLN);
        }
        if (!("".equals(this.ipxnet) || autoexec != null && autoexec.ipxnet.equals(this.ipxnet))) {
            stringBuffer.append("ipxnet.com ").append(this.ipxnet).append(PlatformUtils.EOLN);
        }
        List<Mount> list = null;
        if (autoexec == null) {
            list = this.mountingpoints;
        } else {
            list = new ArrayList<Mount>();
            for (int i = 0; i < this.mountingpoints.size(); ++i) {
                if (i < autoexec.mountingpoints.size() && this.mountingpoints.get(i).equals(autoexec.mountingpoints.get(i))) continue;
                list.add(this.mountingpoints.get(i));
            }
        }
        for (Mount mount : list) {
            stringBuffer.append(mount.toString()).append(PlatformUtils.EOLN);
        }
        if (!("".equals(this.mixer) || autoexec != null && autoexec.mixer.equals(this.mixer))) {
            stringBuffer.append("mixer.com ").append(this.mixer).append(PlatformUtils.EOLN);
        }
        if (!"".equals(this.main)) {
            stringArray = this.convertToDosboxPath(this.main);
            stringBuffer.append(stringArray[0] + PlatformUtils.EOLN);
            stringBuffer.append("cd \\" + stringArray[1] + PlatformUtils.EOLN);
            if (this.loadfix.booleanValue()) {
                stringBuffer.append("loadfix -").append(this.loadfixValue > 0 ? this.loadfixValue : 64).append(PlatformUtils.EOLN);
            }
            this.insertCustomSection(stringBuffer, 1);
            if (!bl.booleanValue()) {
                if (this.loadhigh.booleanValue()) {
                    stringBuffer.append("loadhigh ");
                }
                if (stringArray[2].toLowerCase().endsWith(FileUtils.EXECUTABLES[2])) {
                    stringBuffer.append("call ");
                }
                stringBuffer.append(stringArray[2]);
                if (!"".equals(this.params)) {
                    stringBuffer.append(' ').append(this.params);
                }
                stringBuffer.append(PlatformUtils.EOLN);
                this.insertCustomSection(stringBuffer, 2);
            }
        } else if (!"".equals(this.img1)) {
            if (this.loadfix.booleanValue()) {
                stringBuffer.append("loadfix -").append(this.loadfixValue > 0 ? this.loadfixValue : 64).append(PlatformUtils.EOLN);
            }
            this.insertCustomSection(stringBuffer, 1);
            if (!bl.booleanValue()) {
                stringArray = this.convertToDosboxPath(this.img1);
                stringBuffer.append("boot ").append(stringArray[0]).append('\\').append(stringArray[1]);
                if (!stringArray[1].equals("")) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(stringArray[2]);
                if (!"".equals(this.img2)) {
                    stringArray = this.convertToDosboxPath(this.img2);
                    stringBuffer.append(' ').append(stringArray[0]).append('\\').append(stringArray[1]);
                    if (!stringArray[1].equals("")) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(stringArray[2]);
                }
                if (!"".equals(this.img3)) {
                    stringArray = this.convertToDosboxPath(this.img3);
                    stringBuffer.append(' ').append(stringArray[0]).append('\\').append(stringArray[1]);
                    if (!stringArray[1].equals("")) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(stringArray[2]);
                }
                stringBuffer.append(PlatformUtils.EOLN);
                this.insertCustomSection(stringBuffer, 2);
            }
        } else {
            this.insertCustomSection(stringBuffer, 1);
            this.insertCustomSection(stringBuffer, 2);
        }
        if (!bl.booleanValue()) {
            if (this.loadfix.booleanValue()) {
                stringBuffer.append("loadfix -f").append(PlatformUtils.EOLN);
            }
            this.insertCustomSection(stringBuffer, 3);
            if (this.pause.booleanValue()) {
                stringBuffer.append("pause").append(PlatformUtils.EOLN);
            }
            if (this.exit.booleanValue()) {
                stringBuffer.append("exit").append(PlatformUtils.EOLN);
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "[autoexec]" + PlatformUtils.EOLN);
        }
        return stringBuffer.toString();
    }

    private void insertCustomSection(StringBuffer stringBuffer, int n) {
        if (StringUtils.isNotEmpty((CharSequence)this.customSections[n])) {
            stringBuffer.append(CUSTOM_SECTION_MARKERS[n * 2 + 0]).append(PlatformUtils.EOLN);
            stringBuffer.append(StringUtils.chomp((String)this.customSections[n])).append(PlatformUtils.EOLN);
            stringBuffer.append(CUSTOM_SECTION_MARKERS[n * 2 + 1]).append(PlatformUtils.EOLN);
        }
    }

    String[] convertToDosboxPath(String string) {
        File file = new File(string);
        String[] stringArray = new String[]{"", "", file.getName()};
        int n = 0;
        for (Mount mount : this.mountingpoints) {
            File file2 = mount.canBeUsedFor(file);
            if (file2 == null || mount.getPathAsString().length() <= n) continue;
            stringArray[0] = mount.getDriveletter() + ":";
            stringArray[1] = file2.getParent() == null ? "" : file2.getParent();
            n = mount.getPathAsString().length();
        }
        stringArray[1] = PlatformUtils.toDosboxPath(stringArray[1]);
        return stringArray;
    }

    void addMount(String string) {
        block4: {
            try {
                Mount mount = new Mount(string);
                if (mount.isUnmounted()) {
                    for (Mount mount2 : this.mountingpoints) {
                        if (mount2.getDriveletter() != mount.getDriveletter()) continue;
                        mount2.toggleMount();
                        break block4;
                    }
                    break block4;
                }
                this.mountingpoints.add(mount);
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
    }

    public void setMainExecutable(String string, String string2) {
        this.main = string;
        this.params = string2;
    }

    public File getCanonicalMainDir() {
        if (this.isBooter()) {
            return FileUtils.getCanMainFile(new File(this.img1)).getParentFile();
        }
        return FileUtils.getCanMainFile(new File(this.main)).getParentFile();
    }

    public String getActualMain() {
        return this.isBooter() ? this.img1 : this.main;
    }

    public void setActualMainPath(File file) {
        if (this.isBooter()) {
            this.img1 = new File(file, new File(this.img1).getName()).getPath();
            if (StringUtils.isNotEmpty((CharSequence)this.img2)) {
                this.img2 = new File(file, new File(this.img2).getName()).getPath();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.img3)) {
                this.img3 = new File(file, new File(this.img3).getName()).getPath();
            }
        } else {
            this.main = new File(file, new File(this.main).getName()).getPath();
        }
    }

    public void setActualMain(File file) {
        if (this.isBooter()) {
            this.img1 = file.getPath();
        } else {
            this.main = file.getPath();
        }
    }

    public void migrateToDosroot(File file, boolean bl) {
        Object object;
        for (Mount object2 : this.mountingpoints) {
            object2.migrateToDosroot(file, bl);
        }
        if (this.isBooter()) {
            String string;
            String string2;
            object = FileUtils.makeRelativeTo(bl ? FileUtils.canonicalToDosroot(this.img1) : new File(this.img1), file).getPath();
            if (this.convertToDosboxPath((String)object)[0].length() > 0) {
                this.img1 = object;
            }
            if (this.convertToDosboxPath(string2 = FileUtils.makeRelativeTo(bl ? FileUtils.canonicalToDosroot(this.img2) : new File(this.img2), file).getPath())[0].length() > 0) {
                this.img2 = string2;
            }
            if (this.convertToDosboxPath(string = FileUtils.makeRelativeTo(bl ? FileUtils.canonicalToDosroot(this.img3) : new File(this.img3), file).getPath())[0].length() > 0) {
                this.img3 = string;
            }
        } else {
            object = FileUtils.makeRelativeTo(bl ? FileUtils.canonicalToDosroot(this.main) : new File(this.main), file).getPath();
            if (this.convertToDosboxPath((String)object)[0].length() > 0) {
                this.main = object;
            }
        }
    }

    public void migrateMountsTo(File file, File file2) {
        for (Mount mount : this.mountingpoints) {
            mount.migrateTo(file, file2);
        }
    }

    public void migrateTo(File file, File file2) {
        this.migrateMountsTo(file, file2);
        String string = FileUtils.makeRelativeTo(FileUtils.canonicalToDosroot(this.main), file).getPath();
        if (!new File(string).isAbsolute() && this.convertToDosboxPath(string = FileUtils.makeRelativeToDosroot(new File(file2, string)).getPath())[0].length() > 0) {
            this.main = string;
        }
    }

    public void updateForTargetImportBaseDir(File file) {
        for (Mount mount : this.mountingpoints) {
            mount.updateForTargetImportBaseDir(file);
        }
        if (this.isBooter()) {
            this.img1 = FileUtils.prefixAndSanitizeToDosroot(file, new File(this.img1)).getPath();
            if (StringUtils.isNotBlank((CharSequence)this.img2)) {
                this.img2 = FileUtils.prefixAndSanitizeToDosroot(file, new File(this.img2)).getPath();
            }
            if (StringUtils.isNotBlank((CharSequence)this.img3)) {
                this.img3 = FileUtils.prefixAndSanitizeToDosroot(file, new File(this.img3)).getPath();
            }
        } else {
            this.main = FileUtils.prefixAndSanitizeToDosroot(file, new File(this.main)).getPath();
        }
    }

    void updateMountingPoints(Autoexec autoexec, List<Mount> list) {
        this.mountingpoints = new ArrayList<Mount>();
        for (Mount mount : autoexec.mountingpoints) {
            this.mountingpoints.add(new Mount(mount));
        }
        for (Mount mount : list) {
            this.mountingpoints.add(new Mount(mount));
        }
    }

    public boolean isIncomplete() {
        if (this.img1.length() == 0 && this.main.length() == 0) {
            return true;
        }
        return this.isBooter() ? this.convertToDosboxPath(this.img1)[0].length() == 0 : this.convertToDosboxPath(this.main)[0].length() == 0;
    }

    public Boolean isExit() {
        return this.exit;
    }

    public boolean isBooter() {
        return this.img1.length() > 0;
    }

    public Boolean isLoadfix() {
        return this.loadfix;
    }

    public Boolean isLoadhigh() {
        return this.loadhigh;
    }

    public int getLoadfixValue() {
        return this.loadfixValue;
    }

    public String getMixer() {
        return this.mixer;
    }

    public String getKeyb() {
        return this.keyb;
    }

    public String getIpxnet() {
        return this.ipxnet;
    }

    public String getImg1() {
        if ("file".equals(this.img1)) {
            return "";
        }
        return this.img1;
    }

    public String getImg2() {
        return this.img2;
    }

    public String getImg3() {
        return this.img3;
    }

    public String getMain() {
        return this.main;
    }

    public String getMainParameters() {
        return this.params;
    }

    public String[] getMountingpoints() {
        String[] stringArray = new String[this.mountingpoints.size()];
        int n = 0;
        for (Mount mount : this.mountingpoints) {
            stringArray[n++] = mount.toString(true);
        }
        return stringArray;
    }

    public String getCustomSection(int n) {
        return this.customSections[n];
    }

    static Autoexec createCombination(Autoexec autoexec, Autoexec autoexec2) {
        Autoexec autoexec3 = new Autoexec();
        autoexec3.mountingpoints = new ArrayList<Mount>();
        for (Mount mount : autoexec.mountingpoints) {
            for (Mount mount2 : autoexec2.mountingpoints) {
                if (!mount.toString(false).equals(mount2.toString(false))) continue;
                autoexec3.mountingpoints.add(new Mount(mount));
            }
        }
        autoexec3.loadfix = autoexec.loadfix != Conf.CONFLICTING_BOOL_SETTING && autoexec2.loadfix != Conf.CONFLICTING_BOOL_SETTING && autoexec.loadfix.equals(autoexec2.loadfix) ? autoexec.loadfix : Conf.CONFLICTING_BOOL_SETTING;
        autoexec3.loadfixValue = autoexec.loadfixValue == autoexec2.loadfixValue ? autoexec.loadfixValue : Integer.MIN_VALUE;
        autoexec3.main = autoexec.main.equals(autoexec2.main) ? autoexec.main : "CONFLICTING_SETTING";
        autoexec3.img1 = autoexec.img1.equals(autoexec2.img1) ? autoexec.img1 : "CONFLICTING_SETTING";
        autoexec3.img2 = autoexec.img2.equals(autoexec2.img2) ? autoexec.img2 : "CONFLICTING_SETTING";
        autoexec3.img3 = autoexec.img3.equals(autoexec2.img3) ? autoexec.img3 : "CONFLICTING_SETTING";
        autoexec3.exit = autoexec.exit != Conf.CONFLICTING_BOOL_SETTING && autoexec2.exit != Conf.CONFLICTING_BOOL_SETTING && autoexec.exit.equals(autoexec2.exit) ? autoexec.exit : Conf.CONFLICTING_BOOL_SETTING;
        autoexec3.params = autoexec.params.equals(autoexec2.params) ? autoexec.params : "CONFLICTING_SETTING";
        autoexec3.mixer = autoexec.mixer.equals(autoexec2.mixer) ? autoexec.mixer : "CONFLICTING_SETTING";
        autoexec3.keyb = autoexec.keyb.equals(autoexec2.keyb) ? autoexec.keyb : "CONFLICTING_SETTING";
        autoexec3.ipxnet = autoexec.ipxnet.equals(autoexec2.ipxnet) ? autoexec.ipxnet : "CONFLICTING_SETTING";
        autoexec3.pause = autoexec.pause != Conf.CONFLICTING_BOOL_SETTING && autoexec2.pause != Conf.CONFLICTING_BOOL_SETTING && autoexec.pause.equals(autoexec2.pause) ? autoexec.pause : Conf.CONFLICTING_BOOL_SETTING;
        for (int i = 0; i < autoexec.customSections.length; ++i) {
            autoexec3.customSections[i] = autoexec.customSections[i].equals(autoexec2.customSections[i]) ? autoexec.customSections[i] : "CONFLICTING_SETTING";
        }
        return autoexec3;
    }

    Map<Character, Mount> nettoMounts() {
        return this.nettoMounts(new LinkedHashMap<Character, Mount>());
    }

    Map<Character, Mount> nettoMounts(Map<Character, Mount> map) {
        LinkedHashMap<Character, Mount> linkedHashMap = new LinkedHashMap<Character, Mount>();
        for (Map.Entry<Character, Mount> object : map.entrySet()) {
            linkedHashMap.put(object.getKey(), object.getValue());
        }
        for (Mount mount : this.mountingpoints) {
            if (linkedHashMap.containsKey(Character.valueOf(mount.getDriveletter()))) {
                if (!mount.isUnmounted()) continue;
                linkedHashMap.remove(Character.valueOf(mount.getDriveletter()));
                continue;
            }
            if (mount.isUnmounted()) continue;
            linkedHashMap.put(Character.valueOf(mount.getDriveletter()), mount);
        }
        return linkedHashMap;
    }

    void removeFloppyMounts() {
        Iterator<Mount> iterator = this.mountingpoints.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getMountAs().equals("floppy")) continue;
            iterator.remove();
        }
    }

    void setUnmountsFor(Autoexec autoexec) {
        Map<Character, Mount> map = autoexec.nettoMounts();
        ArrayList<Mount> arrayList = new ArrayList<Mount>();
        for (Map.Entry<Character, Mount> entry : map.entrySet()) {
            Mount mount = new Mount(entry.getValue());
            mount.toggleMount();
            arrayList.add(mount);
        }
        this.mountingpoints = arrayList;
    }

    void removeUnnecessaryMounts(Autoexec autoexec) {
        Mount mount;
        Map<Character, Mount> map = autoexec.nettoMounts();
        Map<Character, Mount> map2 = this.nettoMounts(map);
        ArrayList<Mount> arrayList = new ArrayList<Mount>();
        for (Map.Entry<Character, Mount> entry : map.entrySet()) {
            Mount mount2;
            mount = entry.getValue();
            if (!map2.containsKey(entry.getKey())) {
                mount2 = new Mount(mount);
                mount2.toggleMount();
                arrayList.add(mount2);
                continue;
            }
            if (mount.toString().equals(map2.get(entry.getKey()).toString())) {
                arrayList.add(mount);
                continue;
            }
            mount2 = new Mount(mount);
            mount2.toggleMount();
            arrayList.add(mount2);
            Mount mount3 = new Mount(map2.get(entry.getKey()));
            arrayList.add(mount3);
        }
        for (Map.Entry<Character, Mount> entry : map2.entrySet()) {
            mount = entry.getValue();
            if (map.containsKey(entry.getKey())) continue;
            arrayList.add(mount);
        }
        this.mountingpoints = arrayList;
    }
}

