/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.exception.InvalidHostfileException;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Mount;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conf {
    public static final String CONFLICTING_STRING_SETTING = "CONFLICTING_SETTING";
    public static final int CONFLICTING_INT_SETTING = Integer.MIN_VALUE;
    public static final Boolean CONFLICTING_BOOL_SETTING = null;
    private ConfType confType = null;
    private PrintStream warningsLog = null;
    private File extendedFile = null;
    private DosboxVersion dbversion = null;
    private SectionsWrapper dosboxSections = null;
    private Autoexec dosboxAutoexec = null;
    private SectionsWrapper extendedSections = null;
    private Autoexec extendedAutoexec = null;

    protected Conf() {
    }

    public Conf(Conf conf) {
        this.confType = conf.confType;
        this.warningsLog = conf.warningsLog;
        this.extendedFile = conf.extendedFile;
        this.dbversion = conf.dbversion;
        this.dosboxSections = new SectionsWrapper(conf.dosboxSections);
        this.dosboxAutoexec = new Autoexec(conf.dosboxAutoexec);
        this.extendedSections = new SectionsWrapper(conf.extendedSections);
        this.extendedAutoexec = new Autoexec(conf.extendedAutoexec);
    }

    private void initBaseData(ConfType confType, PrintStream printStream, File file) {
        this.confType = confType;
        this.warningsLog = printStream;
        this.extendedFile = file;
    }

    private void initDosboxData(DosboxVersion dosboxVersion) throws IOException {
        this.dbversion = dosboxVersion;
        this.dosboxSections = new SectionsWrapper();
        this.dosboxAutoexec = new Autoexec();
        Conf.parseInto(this.dosboxSections, this.dosboxAutoexec, new FileReader(dosboxVersion.getCanonicalConfFile()), dosboxVersion.getCanonicalConfFile().getPath(), this.warningsLog);
    }

    public Conf(Template template, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.TEMPLATE, printStream, template == null ? null : FileUtils.constructCanonicalTemplateFileLocation(template.getId()));
        this.initDosboxData(dosboxVersion);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        if (template == null) {
            this.extendedAutoexec.exit = true;
        } else {
            Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
        }
    }

    public Conf(Template template, File file, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this(template, dosboxVersion, printStream);
        this.extendedFile = file;
        this.extendedAutoexec.img1 = "";
        this.extendedAutoexec.exit = false;
    }

    public Conf(Profile profile, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.PROFILE, printStream, profile.getCanonicalConfFile());
        this.initDosboxData(dosboxVersion);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
    }

    public Conf(File file, Template template, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.PROFILE, printStream, null);
        this.initDosboxData(dosboxVersion);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        if (file != null) {
            Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(file), file.getPath(), this.warningsLog);
        } else if (template != null) {
            File file2 = FileUtils.constructCanonicalTemplateFileLocation(template.getId());
            Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(file2), file2.getPath(), this.warningsLog);
        } else {
            this.extendedAutoexec.exit = true;
        }
    }

    public Conf(File file, String string, int n, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.PROFILE, printStream, file);
        this.initDosboxData(dosboxVersion);
        this.extendedSections = new SectionsWrapper();
        this.extendedAutoexec = new Autoexec();
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
        this.extendedAutoexec.removeUnnecessaryMounts(this.dosboxAutoexec);
        this.extendedFile = FileUtils.canonicalToData(FileUtils.constructUniqueConfigFileString(n, string, this.extendedAutoexec.isIncomplete() ? null : this.extendedAutoexec.getCanonicalMainDir()));
    }

    public Conf(String string, String string2, boolean bl, String string3, ExpProfile expProfile, int n, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.PROFILE, printStream, null);
        this.initDosboxData(dosboxVersion);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new StringReader(bl ? string : string2), string3, this.warningsLog);
        this.extendedFile = FileUtils.canonicalToData(FileUtils.constructUniqueConfigFileString(n, expProfile.getTitle(), this.extendedAutoexec.isIncomplete() ? null : this.extendedAutoexec.getCanonicalMainDir()));
        File file = expProfile.getBaseDir();
        this.extendedAutoexec.updateForTargetImportBaseDir(file);
        SectionsWrapper sectionsWrapper = new SectionsWrapper();
        Autoexec autoexec = new Autoexec();
        Conf.parseInto(sectionsWrapper, autoexec, new StringReader(string), string3, this.warningsLog);
        this.extendedSections.alterToDosboxVersionGeneration(this.dosboxSections, sectionsWrapper.detectDosboxVersionGeneration(), this.dosboxSections.detectDosboxVersionGeneration());
    }

    public Conf(String string, String string2, boolean bl, String string3, int n, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.TEMPLATE, printStream, FileUtils.constructCanonicalTemplateFileLocation(n));
        this.initDosboxData(dosboxVersion);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new StringReader(bl ? string : string2), string3, this.warningsLog);
        SectionsWrapper sectionsWrapper = new SectionsWrapper();
        Autoexec autoexec = new Autoexec();
        Conf.parseInto(sectionsWrapper, autoexec, new StringReader(string), string3, this.warningsLog);
        this.extendedSections.alterToDosboxVersionGeneration(this.dosboxSections, sectionsWrapper.detectDosboxVersionGeneration(), this.dosboxSections.detectDosboxVersionGeneration());
    }

    public Conf(Profile profile, String string, String string2, File file, DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this(profile, dosboxVersion, printStream);
        this.extendedFile = file;
        if (string != null && string2 != null) {
            this.extendedAutoexec.setMainExecutable(string, string2);
        }
    }

    public Conf(Conf conf, File file) throws IOException {
        this(conf);
        this.extendedFile = file;
        this.extendedAutoexec.pause = true;
        this.extendedAutoexec.exit = true;
    }

    Conf(SectionsWrapper sectionsWrapper, File file, PrintStream printStream) {
        this.initBaseData(ConfType.SETTINGS, printStream, file);
        this.extendedSections = new SectionsWrapper(sectionsWrapper);
        if (this.extendedFile.isFile() && this.extendedFile.canRead()) {
            try {
                Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Conf(File file, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.SINGULAR, printStream, file);
        this.extendedSections = new SectionsWrapper();
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
    }

    public Conf(DosboxVersion dosboxVersion, PrintStream printStream) throws IOException {
        this.initBaseData(ConfType.SINGULAR, printStream, null);
        this.initDosboxData(dosboxVersion);
    }

    public void injectOrUpdateProfile(Profile profile) {
        this.extendedFile = profile.getCanonicalConfFile();
        this.extendedSections.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(profile.getId(), this.extendedFile.getParentFile(), this.extendedSections.detectDosboxVersionGeneration()));
    }

    public void injectOrUpdateTemplate(Template template) {
        this.extendedFile = FileUtils.constructCanonicalTemplateFileLocation(template.getId());
    }

    public static Conf extractDBVersionConf(Conf conf) {
        Conf conf2 = new Conf();
        conf2.initBaseData(ConfType.SINGULAR, conf.warningsLog, null);
        conf2.dbversion = conf.dbversion;
        conf2.dosboxSections = conf.dosboxSections;
        conf2.dosboxAutoexec = conf.dosboxAutoexec;
        return conf2;
    }

    public Conf(Conf conf, Conf conf2, boolean bl) {
        this.confType = conf.confType;
        this.warningsLog = conf.warningsLog;
        if (bl) {
            this.dbversion = conf.dbversion;
            this.dosboxSections = conf.dosboxSections;
            this.dosboxAutoexec = conf.dosboxAutoexec;
        }
        this.extendedSections = SectionsWrapper.createCombination(conf.extendedSections, conf2.extendedSections);
        this.extendedAutoexec = Autoexec.createCombination(conf.extendedAutoexec, conf2.extendedAutoexec);
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(Boolean bl) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.extendedFile));
        bufferedWriter.write(this.toString(bl));
        bufferedWriter.close();
    }

    public File getConfFile() {
        return this.extendedFile;
    }

    public SectionsWrapper getDosboxSettings() {
        return this.dosboxSections;
    }

    public SectionsWrapper getSettings() {
        return this.extendedSections;
    }

    public Autoexec getAutoexec() {
        return this.extendedAutoexec;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(Boolean bl) {
        if (this.confType == ConfType.SETTINGS) {
            return this.extendedSections.toString();
        }
        if (this.confType == ConfType.PROFILE) {
            if (this.dbversion == null || !this.dbversion.isMultiConfig()) {
                return this.toFullConfString(bl);
            }
            return this.toIncrConfString(bl);
        }
        if (this.confType == ConfType.TEMPLATE) {
            return this.toIncrConfString(bl);
        }
        return "";
    }

    public String toFullConfString(Boolean bl) {
        return this.extendedSections.toString() + this.extendedAutoexec.toString(null, bl);
    }

    public String toIncrConfString(Boolean bl) {
        return new SectionsWrapper(this.dosboxSections, this.extendedSections).toString() + this.extendedAutoexec.toString(this.dosboxAutoexec, bl);
    }

    public void unmountDosboxMounts() {
        this.extendedAutoexec.setUnmountsFor(this.dosboxAutoexec);
    }

    public void removeFloppyMounts() {
        this.extendedAutoexec.removeFloppyMounts();
    }

    public void removeUnnecessaryMounts() {
        this.extendedAutoexec.removeUnnecessaryMounts(this.dosboxAutoexec);
    }

    public void updateValue(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.extendedSections.updateValue(string, string2, string3);
        }
    }

    public void updateValue(String string, String string2, String string3, String string4, boolean bl) {
        if (bl && this.dbversion != null && this.dosboxSections != null) {
            if (this.dosboxSections.hasValue(string, string3)) {
                this.extendedSections.updateValue(string, string3, string4);
            } else {
                this.extendedSections.updateValue(string, string2, string4);
            }
        }
    }

    public void updateScalerValue(String string, boolean bl, boolean bl2) {
        if (bl2 && this.dbversion != null && this.dosboxSections != null && !string.equals("")) {
            String string2 = string;
            if (bl && !string.endsWith("forced")) {
                string2 = string2 + " forced";
            }
            this.extendedSections.updateValue("render", "scaler", string2);
        }
    }

    public void updateMidiValue(String string, boolean bl) {
        if (bl && this.dbversion != null && this.dosboxSections != null) {
            if (this.dosboxSections.hasValue("midi", "intelligent")) {
                this.extendedSections.updateValue("midi", "mpu401", String.valueOf(!string.equalsIgnoreCase("none")));
                if (string.equalsIgnoreCase("none")) {
                    this.extendedSections.updateValue("midi", "intelligent", String.valueOf(true));
                } else {
                    this.extendedSections.updateValue("midi", "intelligent", String.valueOf(string.equalsIgnoreCase("intelligent")));
                }
            } else {
                this.extendedSections.updateValue("midi", "mpu401", string);
            }
        }
    }

    public void updateJoystickValue(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        if (this.dbversion != null && this.dosboxSections != null) {
            if (this.dosboxSections.hasValue("joystick", "joysticktype")) {
                this.updateValue("joystick", "joysticktype", string, bl5);
                this.updateValue("joystick", "timed", String.valueOf(bl), bl6);
                this.updateValue("joystick", "autofire", String.valueOf(bl2), bl7);
                this.updateValue("joystick", "swap34", String.valueOf(bl3), bl8);
                this.updateValue("joystick", "buttonwrap", String.valueOf(bl4), bl9);
            } else {
                this.updateValue("bios", "joysticktype", string, bl5);
            }
        }
    }

    public void setAutoexecSettingsForTemplate(Boolean bl, String string, String string2, String string3, Boolean bl2, String[] stringArray) {
        this.extendedAutoexec.exit = bl;
        this.extendedAutoexec.mixer = string;
        this.extendedAutoexec.keyb = string2;
        this.extendedAutoexec.ipxnet = string3;
        this.extendedAutoexec.img1 = bl2 != false ? "file" : "";
        this.extendedAutoexec.customSections = stringArray;
    }

    public void setAutoexecSettingsForProfile(Boolean bl, Boolean bl2, String string, String string2, String string3, String string4, String string5, String string6) {
        this.extendedAutoexec.main = string2;
        this.extendedAutoexec.params = string3;
        this.extendedAutoexec.loadhigh = bl;
        this.extendedAutoexec.loadfix = bl2;
        try {
            this.extendedAutoexec.loadfixValue = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.extendedAutoexec.img1 = string4;
        this.extendedAutoexec.img2 = string5;
        this.extendedAutoexec.img3 = string6;
    }

    public void setAutoexecSettingsForProfileMultiEdit(Boolean bl, Boolean bl2, String string, Boolean bl3, String string2, String string3, String string4, String[] stringArray) {
        if (bl != null) {
            this.extendedAutoexec.loadhigh = bl;
        }
        if (bl2 != null) {
            this.extendedAutoexec.loadfix = bl2;
        }
        try {
            if (string != null) {
                this.extendedAutoexec.loadfixValue = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl3 != null) {
            this.extendedAutoexec.exit = bl3;
        }
        if (string2 != null) {
            this.extendedAutoexec.mixer = string2;
        }
        if (string3 != null) {
            this.extendedAutoexec.keyb = string3;
        }
        if (string4 != null) {
            this.extendedAutoexec.ipxnet = string4;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.extendedAutoexec.customSections[i] = stringArray[i];
        }
    }

    public void alterToDosboxVersionGeneration(Conf conf) {
        this.dbversion = conf.dbversion;
        this.extendedSections.alterToDosboxVersionGeneration(conf.dosboxSections);
    }

    public void setToDosboxVersion(Conf conf) {
        if (this.dbversion != null && this.dbversion.getId() == conf.getDbversion().getId()) {
            return;
        }
        List<Mount> list = Autoexec.getUniqueMountingpoints(this.dosboxAutoexec, this.extendedAutoexec);
        this.dbversion = conf.dbversion;
        this.dosboxSections = conf.dosboxSections;
        this.dosboxAutoexec = conf.dosboxAutoexec;
        this.extendedSections.alterToDosboxVersionGeneration(conf.dosboxSections);
        this.extendedAutoexec.updateMountingPoints(this.dosboxAutoexec, list);
    }

    public void switchToDosboxVersion(Conf conf) {
        if (this.dbversion != null && this.dbversion.getId() == conf.getDbversion().getId()) {
            return;
        }
        List<Mount> list = Autoexec.getUniqueMountingpoints(this.dosboxAutoexec, this.extendedAutoexec);
        this.dbversion = conf.dbversion;
        this.dosboxAutoexec = conf.dosboxAutoexec;
        this.extendedSections.switchToDosboxVersionGeneration(this.dosboxSections, conf.dosboxSections);
        this.extendedAutoexec.updateMountingPoints(this.dosboxAutoexec, list);
        this.dosboxSections = conf.dosboxSections;
    }

    public void reloadDosboxVersion(Conf conf) {
        List<Mount> list = Autoexec.getUniqueMountingpoints(this.dosboxAutoexec, this.extendedAutoexec);
        Boolean bl = this.extendedAutoexec.exit;
        String string = this.extendedAutoexec.main;
        String string2 = this.extendedAutoexec.params;
        String string3 = this.extendedAutoexec.img1;
        String string4 = this.extendedAutoexec.img2;
        String string5 = this.extendedAutoexec.img3;
        this.dbversion = conf.dbversion;
        this.dosboxSections = conf.dosboxSections;
        this.dosboxAutoexec = conf.dosboxAutoexec;
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        this.extendedAutoexec.updateMountingPoints(this.dosboxAutoexec, list);
        this.extendedAutoexec.exit = bl;
        this.extendedAutoexec.main = string;
        this.extendedAutoexec.params = string2;
        this.extendedAutoexec.img1 = string3;
        this.extendedAutoexec.img2 = string4;
        this.extendedAutoexec.img3 = string5;
    }

    public void reloadTemplate(Conf conf) {
        Autoexec autoexec = new Autoexec(this.extendedAutoexec);
        String string = this.extendedAutoexec.main;
        String string2 = this.extendedAutoexec.params;
        String string3 = this.extendedAutoexec.img1;
        String string4 = this.extendedAutoexec.img2;
        String string5 = this.extendedAutoexec.img3;
        this.dbversion = conf.dbversion;
        this.dosboxSections = conf.dosboxSections;
        this.dosboxAutoexec = conf.dosboxAutoexec;
        this.extendedSections = conf.extendedSections;
        this.extendedAutoexec = conf.extendedAutoexec;
        this.extendedAutoexec.main = string;
        this.extendedAutoexec.params = string2;
        if (StringUtils.isNotEmpty((CharSequence)string3)) {
            this.extendedAutoexec.img1 = string3;
            this.extendedAutoexec.img2 = string4;
            this.extendedAutoexec.img3 = string5;
        }
        if (autoexec.mountingpoints.size() > 0) {
            this.extendedAutoexec.mountingpoints = autoexec.mountingpoints;
        }
    }

    public String[] addMount(String string) {
        this.extendedAutoexec.addMount(string);
        return this.extendedAutoexec.getMountingpoints();
    }

    public String[] editMount(int n, String string) {
        if (n < this.dosboxAutoexec.mountingpoints.size()) {
            Mount mount = this.extendedAutoexec.mountingpoints.get(n);
            if (!mount.isUnmounted()) {
                mount.toggleMount();
            }
            this.extendedAutoexec.addMount(string);
        } else {
            try {
                this.extendedAutoexec.mountingpoints.set(n, new Mount(string));
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
        return this.extendedAutoexec.getMountingpoints();
    }

    public String[] removeMount(int n) {
        if (n < this.dosboxAutoexec.mountingpoints.size()) {
            this.extendedAutoexec.mountingpoints.get(n).toggleMount();
        } else {
            this.extendedAutoexec.mountingpoints.remove(n);
        }
        return this.extendedAutoexec.getMountingpoints();
    }

    private Map<Character, Mount> nettoMounts() {
        return this.extendedAutoexec.nettoMounts(this.dosboxAutoexec.nettoMounts());
    }

    public Set<Character> nettoMountedDriveLetters() {
        return this.nettoMounts().keySet();
    }

    public String getRequiredMount(boolean bl, String string) {
        if (this.extendedAutoexec.convertToDosboxPath(string)[0].length() > 0) {
            return null;
        }
        try {
            return new Mount(bl, string, this.nettoMountedDriveLetters()).getPathAsString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] addRequiredMount(boolean bl, String string) {
        try {
            if (FileUtils.containsIso(string) != -1) {
                Mount mount = new Mount(bl, ".", this.nettoMountedDriveLetters());
                if (mount.getDriveletter() == 'C') {
                    this.addMount(mount.toString());
                }
                return this.addMount(new Mount(bl, string, this.nettoMountedDriveLetters()).toString());
            }
            return this.addMount(new Mount(bl, string, this.nettoMountedDriveLetters()).toString());
        }
        catch (InvalidHostfileException invalidHostfileException) {
            return this.extendedAutoexec.getMountingpoints();
        }
        catch (DrivelettersExhaustedException drivelettersExhaustedException) {
            return this.extendedAutoexec.getMountingpoints();
        }
    }

    public String[] addRequiredMountForInstaller(String string) {
        try {
            File[] fileArray = FileUtils.findFileSequence(FileUtils.getCanMainFile(new File(string)));
            if (fileArray.length > 1) {
                return this.addMount(new Mount(string, this.nettoMountedDriveLetters(), fileArray).toString());
            }
            return this.addMount(new Mount(string, this.nettoMountedDriveLetters(), null).toString());
        }
        catch (InvalidHostfileException invalidHostfileException) {
            return this.extendedAutoexec.getMountingpoints();
        }
        catch (DrivelettersExhaustedException drivelettersExhaustedException) {
            return this.extendedAutoexec.getMountingpoints();
        }
    }

    public DosboxVersion getDbversion() {
        return this.dbversion;
    }

    public static boolean isConflictingValue(String string) {
        return string.equals(CONFLICTING_STRING_SETTING);
    }

    public static boolean isConflictingValue(int n) {
        return n == Integer.MIN_VALUE;
    }

    public static boolean isConflictingValue(Boolean bl) {
        return bl == CONFLICTING_BOOL_SETTING;
    }

    public File getCustomMapperFile() {
        if (this.confType == ConfType.PROFILE) {
            File file;
            String string = this.dosboxSections.getValue("sdl", "mapperfile");
            String string2 = this.extendedSections.getValue("sdl", "mapperfile");
            if (this.extendedSections.hasValue("sdl", "mapperfile") && !string2.equals(string) && FileUtils.isExistingFile(file = new File(this.extendedFile.getParentFile(), string2))) {
                return file;
            }
        }
        return null;
    }

    private static void parseInto(SectionsWrapper sectionsWrapper, Autoexec autoexec, Reader reader, String string, PrintStream printStream) throws IOException {
        String string2;
        Settings settings = Settings.getInstance();
        BufferedReader bufferedReader = new BufferedReader(reader);
        int n = 1;
        String string3 = null;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).length() > 0 && string2.charAt(0) != '#') {
                int n2;
                if (string2.charAt(0) == '[') {
                    n2 = string2.indexOf(91);
                    int n3 = string2.lastIndexOf(93);
                    if (n3 == -1) {
                        printStream.println(settings.msg("general.error.parseconf", new Object[]{string, n, string2}));
                    } else {
                        string3 = string2.substring(n2 + 1, n3);
                    }
                } else if (string3 == null) {
                    if (!bl) {
                        printStream.println(settings.msg("general.error.sectionmissing", new Object[]{string, n, string2}));
                    }
                    bl = true;
                } else {
                    if ("autoexec".equals(string3)) {
                        arrayList.add(string2);
                    } else {
                        n2 = string2.indexOf(61);
                        if (n2 == -1) {
                            printStream.println(settings.msg("general.error.parseconf", new Object[]{string, n, string2}));
                        } else {
                            String string4 = string2.substring(0, n2).trim();
                            String string5 = string2.substring(n2 + 1).trim();
                            sectionsWrapper.setValue(string3, string4.toLowerCase(), string5);
                        }
                    }
                    bl = false;
                }
            }
            ++n;
        }
        bufferedReader.close();
        if (arrayList.size() > 0) {
            autoexec.parseLines(arrayList);
        }
    }

    public boolean hasDifferentBaseMountsThan(Conf conf) {
        return !Arrays.equals(this.dosboxAutoexec.getMountingpoints(), conf.dosboxAutoexec.getMountingpoints());
    }

    public int countImageMounts() {
        int n = 0;
        for (Mount mount : this.extendedAutoexec.mountingpoints) {
            if (mount.getMountingType() != Mount.MountingType.IMAGE || mount.isUnmounted()) continue;
            ++n;
        }
        return n;
    }

    public File[] getFirstImageMountPath() {
        for (Mount mount : this.extendedAutoexec.mountingpoints) {
            if (mount.getMountingType() != Mount.MountingType.IMAGE || mount.isUnmounted()) continue;
            return mount.getPath();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConfType {
        PROFILE,
        TEMPLATE,
        SINGULAR,
        SETTINGS;

    }
}

