/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.dbgl.model.conf.Section;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionsWrapper {
    private Map<String, Section> sections = new LinkedHashMap<String, Section>();

    SectionsWrapper() {
    }

    public SectionsWrapper(SectionsWrapper sectionsWrapper) {
        this();
        for (String string : sectionsWrapper.sections.keySet()) {
            this.sections.put(string, new Section(sectionsWrapper.sections.get(string)));
        }
    }

    public SectionsWrapper(SectionsWrapper sectionsWrapper, SectionsWrapper sectionsWrapper2) {
        this();
        for (String string : sectionsWrapper2.sections.keySet()) {
            for (String string2 : sectionsWrapper2.sections.get((Object)string).items.keySet()) {
                if (sectionsWrapper != null && sectionsWrapper.hasValue(string, string2) && sectionsWrapper.getValue(string, string2).equals(sectionsWrapper2.getValue(string, string2))) continue;
                this.setValue(string, string2, sectionsWrapper2.getValue(string, string2));
            }
        }
    }

    public static SectionsWrapper createCombination(SectionsWrapper sectionsWrapper, SectionsWrapper sectionsWrapper2) {
        SectionsWrapper sectionsWrapper3 = new SectionsWrapper();
        for (String string : sectionsWrapper.sections.keySet()) {
            for (String string2 : sectionsWrapper.sections.get((Object)string).items.keySet()) {
                String string3 = sectionsWrapper.getValue(string, string2);
                if (!sectionsWrapper2.hasValue(string, string2)) continue;
                String string4 = sectionsWrapper2.getValue(string, string2);
                if (string3.equals(string4)) {
                    sectionsWrapper3.setValue(string, string2, string3);
                    continue;
                }
                sectionsWrapper3.setValue(string, string2, "CONFLICTING_SETTING");
            }
        }
        return sectionsWrapper3;
    }

    public Set<String> getAllSectionNames() {
        return this.sections.keySet();
    }

    public String[] getAllItemNames(String string) {
        return new TreeMap<String, String>(this.sections.get((Object)string).items).keySet().toArray(new String[0]);
    }

    public boolean hasValue(String string, String string2) {
        return this.sections.containsKey(string) && this.sections.get((Object)string).items.containsKey(string2);
    }

    public String getValue(String string, String string2) {
        String string3 = null;
        if (this.sections.containsKey(string)) {
            string3 = this.sections.get((Object)string).items.get(string2);
        }
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    public boolean isConflictingValue(String string, String string2) {
        return this.hasValue(string, string2) && this.getValue(string, string2).equals("CONFLICTING_SETTING");
    }

    public String[] getValues(String string, String string2) {
        String string3 = this.getValue(string, string2);
        if (string3.length() <= 0) {
            return new String[0];
        }
        String[] stringArray = string3.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replaceAll("<space>", " ");
        }
        return stringArray;
    }

    public String[] getCommonValues(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getValues(string, string2);
        Object[] objectArray = this.getValues(string, string3);
        for (String string4 : stringArray) {
            if (!ArrayUtils.contains((Object[])objectArray, (Object)string4)) continue;
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[0]);
    }

    public String getMultilineValues(String string, String string2, String string3) {
        return StringRelatedUtils.stringArrayToString(this.getValues(string, string2), string3);
    }

    public int getIntValue(String string, String string2) {
        try {
            return Integer.parseInt(this.getValue(string, string2));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int[] getIntValues(String string, String string2) {
        return StringRelatedUtils.stringToIntArray(this.getValue(string, string2));
    }

    public boolean getBooleanValue(String string, String string2) {
        return Boolean.valueOf(this.getValue(string, string2));
    }

    public boolean[] getBooleanValues(String string, String string2) {
        return StringRelatedUtils.stringToBooleanArray(this.getValue(string, string2));
    }

    public void setValue(String string, String string2, String string3) {
        Section section = this.createSection(string);
        section.items.put(string2, string3);
    }

    public void setMultilineValues(String string, String string2, String string3, String string4) {
        this.setValue(string, string2, string3.replaceAll(" ", "<space>").replace(string4, " ").trim());
    }

    public void setIntValue(String string, String string2, int n) {
        this.setValue(string, string2, String.valueOf(n));
    }

    public void setIntValues(String string, String string2, int[] nArray) {
        this.setValue(string, string2, StringRelatedUtils.join(nArray));
    }

    public void setBooleanValue(String string, String string2, boolean bl) {
        this.setValue(string, string2, String.valueOf(bl));
    }

    public void setBooleanValues(String string, String string2, boolean[] blArray) {
        this.setValue(string, string2, StringRelatedUtils.join(blArray));
    }

    public void updateValue(String string, String string2, String string3) {
        if (this.hasValue(string, string2)) {
            this.sections.get((Object)string).items.put(string2, string3);
        }
    }

    public void setMissingValue(String string, String string2, String string3) {
        if (!this.hasValue(string, string2)) {
            this.setValue(string, string2, string3);
        }
    }

    public void removeSection(String string) {
        this.sections.remove(string);
    }

    public void removeValue(String string, String string2) {
        if (this.sections.containsKey(string)) {
            Section section = this.sections.get(string);
            section.items.remove(string2);
            if (section.items.isEmpty()) {
                this.sections.remove(string);
            }
        }
    }

    public void injectValuesFrom(SectionsWrapper sectionsWrapper) {
        for (String string : sectionsWrapper.sections.keySet()) {
            for (String string2 : sectionsWrapper.sections.get((Object)string).items.keySet()) {
                this.setValue(string, string2, sectionsWrapper.getValue(string, string2));
            }
        }
    }

    public void addMissingValuesFrom(SectionsWrapper sectionsWrapper) {
        for (String string : sectionsWrapper.sections.keySet()) {
            for (String string2 : sectionsWrapper.sections.get((Object)string).items.keySet()) {
                this.setMissingValue(string, string2, sectionsWrapper.getValue(string, string2));
            }
        }
    }

    public void removeValuesThatAreNotIn(SectionsWrapper sectionsWrapper) {
        SectionsWrapper sectionsWrapper2 = new SectionsWrapper(this);
        for (String string : sectionsWrapper2.sections.keySet()) {
            for (String string2 : sectionsWrapper2.sections.get((Object)string).items.keySet()) {
                if (sectionsWrapper.hasValue(string, string2)) continue;
                this.removeValue(string, string2);
            }
        }
    }

    public int detectDosboxVersionGeneration() {
        if (this.hasValue("cpu", "cputype") && this.hasValue("midi", "mididevice") && this.hasValue("midi", "midiconfig") && this.hasValue("sblaster", "sbmixer") && this.hasValue("sblaster", "oplemu") && this.hasValue("gus", "gusirq") && this.hasValue("gus", "gusdma")) {
            return 3;
        }
        if (this.hasValue("joystick", "joysticktype") && this.hasValue("joystick", "timed") && this.hasValue("joystick", "autofire") && this.hasValue("joystick", "swap34") && this.hasValue("joystick", "buttonwrap") && this.hasValue("dos", "keyboardlayout")) {
            return 2;
        }
        if (this.hasValue("sdl", "windowresolution") && this.hasValue("sdl", "usescancodes") && this.hasValue("sblaster", "sbtype") && this.hasValue("sblaster", "sbbase") && this.hasValue("gus", "gusrate") && this.hasValue("gus", "gusbase") && this.hasValue("speaker", "tandy") && this.hasValue("bios", "joysticktype") && this.hasValue("serial", "serial1") && this.hasValue("dos", "umb")) {
            return 1;
        }
        return 0;
    }

    public void alterToDosboxVersionGeneration(SectionsWrapper sectionsWrapper) {
        int n = this.detectDosboxVersionGeneration();
        int n2 = sectionsWrapper.detectDosboxVersionGeneration();
        this.alterToDosboxVersionGeneration(sectionsWrapper, n, n2);
    }

    public void switchToDosboxVersionGeneration(SectionsWrapper sectionsWrapper, SectionsWrapper sectionsWrapper2) {
        int n = this.detectDosboxVersionGeneration();
        int n2 = sectionsWrapper2.detectDosboxVersionGeneration();
        SectionsWrapper sectionsWrapper3 = new SectionsWrapper(sectionsWrapper, this);
        this.sections = sectionsWrapper3.sections;
        this.alterToDosboxVersionGeneration(sectionsWrapper2, n, n2);
    }

    public void alterToDosboxVersionGeneration(SectionsWrapper sectionsWrapper, int n, int n2) {
        int n3;
        if (n > n2) {
            for (n3 = 0; n3 < n - n2; ++n3) {
                this.downgradeOneGeneration(n - n3);
            }
        }
        if (n < n2) {
            for (n3 = 0; n3 < n2 - n; ++n3) {
                this.upgradeOneGeneration(n + n3);
            }
        }
        this.addMissingValuesFrom(sectionsWrapper);
        this.removeValuesThatAreNotIn(sectionsWrapper);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.sections.keySet()) {
            stringBuffer.append("[" + string + "]" + PlatformUtils.EOLN);
            stringBuffer.append(this.sections.get(string).toString(bl)).append(PlatformUtils.EOLN);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    private Section createSection(String string) {
        if (this.sections.containsKey(string)) {
            return this.sections.get(string);
        }
        Section section = new Section();
        this.sections.put(string, section);
        return section;
    }

    private void upgradeOneGeneration(int n) {
        switch (n) {
            case 0: {
                boolean bl;
                boolean bl2 = !this.hasValue("midi", "mpu401") || this.getBooleanValue("midi", "mpu401");
                boolean bl3 = bl = !this.hasValue("midi", "intelligent") || this.getBooleanValue("midi", "intelligent");
                this.setValue("midi", "mpu401", bl2 ? (bl ? "intelligent" : "uart") : "none");
                this.removeValue("midi", "intelligent");
                this.switchSetting("sblaster", "type", "sblaster", "sbtype");
                this.switchSetting("sblaster", "base", "sblaster", "sbbase");
                this.switchSetting("gus", "rate", "gus", "gusrate");
                this.switchSetting("gus", "base", "gus", "gusbase");
                break;
            }
            case 1: {
                this.switchSetting("bios", "joysticktype", "joystick", "joysticktype");
                break;
            }
            case 2: {
                this.switchSetting("gus", "irq1", "gus", "gusirq");
                this.removeValue("gus", "irq2");
                this.switchSetting("gus", "dma1", "gus", "gusdma");
                this.removeValue("gus", "dma2");
                if (this.getValue("dosbox", "machine").equalsIgnoreCase("vga")) {
                    this.removeValue("dosbox", "machine");
                }
                if (this.getValue("dos", "keyboardlayout").equalsIgnoreCase("none")) {
                    this.removeValue("dos", "keyboardlayout");
                }
                this.switchSetting("midi", "device", "midi", "mididevice");
                this.switchSetting("midi", "config", "midi", "midiconfig");
                this.switchSetting("sblaster", "mixer", "sblaster", "sbmixer");
                break;
            }
        }
    }

    private void downgradeOneGeneration(int n) {
        switch (n) {
            case 3: {
                String string;
                this.switchSetting("gus", "gusirq", "gus", "irq1");
                if (this.hasValue("gus", "irq1")) {
                    this.setValue("gus", "irq2", this.getValue("gus", "irq1"));
                }
                this.switchSetting("gus", "gusdma", "gus", "dma1");
                if (this.hasValue("gus", "dma1")) {
                    this.setValue("gus", "dma2", this.getValue("gus", "dma1"));
                }
                if (!((string = this.getValue("dosbox", "machine")).equalsIgnoreCase("cga") || string.equalsIgnoreCase("hercules") || string.equalsIgnoreCase("pcjr") || string.equalsIgnoreCase("tandy"))) {
                    this.removeValue("dosbox", "machine");
                }
                if (this.getValue("dos", "keyboardlayout").equalsIgnoreCase("auto")) {
                    this.removeValue("dos", "keyboardlayout");
                }
                this.switchSetting("midi", "mididevice", "midi", "device");
                this.switchSetting("midi", "midiconfig", "midi", "config");
                this.switchSetting("sblaster", "sbmixer", "sblaster", "mixer");
                break;
            }
            case 2: {
                this.switchSetting("joystick", "joysticktype", "bios", "joysticktype");
                break;
            }
            case 1: {
                if (this.hasValue("midi", "mpu401")) {
                    String string = this.getValue("midi", "mpu401");
                    this.setBooleanValue("midi", "mpu401", !string.equalsIgnoreCase("none"));
                    this.setBooleanValue("midi", "intelligent", string.equalsIgnoreCase("intelligent"));
                }
                this.switchSetting("sblaster", "sbtype", "sblaster", "type");
                this.switchSetting("sblaster", "sbbase", "sblaster", "base");
                this.switchSetting("gus", "gusrate", "gus", "rate");
                this.switchSetting("gus", "gusbase", "gus", "base");
                break;
            }
        }
    }

    private void switchSetting(String string, String string2, String string3, String string4) {
        if (this.hasValue(string, string2)) {
            this.setValue(string3, string4, this.getValue(string, string2));
        }
        this.removeValue(string, string2);
    }

    public boolean hasFullResolutionDesktopSupport() {
        return this.hasValue("dosbox", "vmemsize");
    }

    public boolean hasOutputDirect3DSupport() {
        return this.hasValue("sdl", "pixelshader");
    }

    public boolean hasAmstradSupport() {
        return this.hasValue("speaker", "ps1audio");
    }

    public boolean hasHardwareScalerSupport() {
        return this.hasOutputDirect3DSupport();
    }

    public boolean hasMT32Support() {
        return this.hasValue("midi", "mt32.dac");
    }

    public boolean hasSoundBlaster16VibraSupport() {
        return this.hasValue("sblaster", "goldplay");
    }

    public boolean hasHardwareOPLSupport() {
        return this.hasValue("sblaster", "hardwarebase");
    }

    public boolean hasAdditionalCPUTypesSupport() {
        return this.hasValue("parallel", "dongle");
    }
}

