/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.dbgl.model.ExpProfile;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.UIThread;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportThread
extends UIThread {
    private Document xmlDoc;
    private boolean exportCaptures;
    private boolean exportMapperfiles;
    private boolean exportGameData;
    private File target;
    private ZipOutputStream zos;

    public ExportThread(Text text, ProgressBar progressBar, Label label, List<ExpProfile> list, Document document, boolean bl, boolean bl2, boolean bl3, File file) throws IOException, SQLException {
        super(text, progressBar, label);
        this.xmlDoc = document;
        this.exportCaptures = bl;
        this.exportMapperfiles = bl2;
        this.exportGameData = bl3;
        this.target = file;
        this.objects = list;
        this.progressBar.setMaximum(this.objects.size());
        this.zos = new ZipOutputStream(new FileOutputStream(this.target));
        try {
            XmlUtils.domToZipOutputStream(this.xmlDoc, new File("profiles.xml"), this.zos);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException);
        }
    }

    @Override
    public void doFancyStuff(Object object, StringBuffer stringBuffer) throws IOException {
        File file;
        ExpProfile expProfile = (ExpProfile)object;
        this.displayTitle(this.settings.msg("dialog.export.exporting", new Object[]{expProfile.getTitle()}));
        File file2 = expProfile.getGameDir();
        File file3 = new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(expProfile.getId()), file2.getPath()).getPath());
        if (this.exportCaptures) {
            file = new File(FileUtils.constructCapturesDir(expProfile.getId()));
            try {
                FileUtils.zipDir(expProfile.getCanonicalCaptures(), this.zos, file);
            }
            catch (IOException iOException) {
                throw new IOException(this.settings.msg("dialog.export.error.exportcaptures", new Object[]{expProfile.getTitle(), StringRelatedUtils.toString(iOException)}), iOException);
            }
        }
        if (this.exportMapperfiles && (file = expProfile.getConf().getCustomMapperFile()) != null) {
            File file4 = new File(FileUtils.constructMapperFile(expProfile.getId()));
            FileUtils.zipEntry(file, file4, this.zos);
        }
        if (this.exportGameData) {
            boolean bl = true;
            for (Object e : this.objects) {
                ExpProfile expProfile2 = (ExpProfile)e;
                if (expProfile == expProfile2 || !expProfile.getGameDir().equals(expProfile2.getGameDir()) || expProfile.getId() <= expProfile2.getId()) continue;
                bl = false;
            }
            if (bl) {
                try {
                    FileUtils.zipDir(FileUtils.canonicalToDosroot(file2.getPath()), this.zos, file3);
                }
                catch (IOException iOException) {
                    throw new IOException(this.settings.msg("dialog.export.error.exportgamedata", new Object[]{expProfile.getTitle(), StringRelatedUtils.toString(iOException)}), iOException);
                }
            }
        }
    }

    @Override
    public String getTitle(Object object) {
        return ((ExpProfile)object).getTitle();
    }

    @Override
    public void preFinish() throws IOException {
        this.zos.close();
    }
}

