/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoaderThread
extends UIThread {
    private Conf targetDBConf = null;
    private boolean combine;
    private ExpProfile multiProfileCombined = null;
    private List<ExpProfile> result = new ArrayList<ExpProfile>();
    private int index;

    public LoaderThread(Text text, ProgressBar progressBar, Label label, List<Profile> list, boolean bl) throws SQLException {
        super(text, progressBar, label);
        this.objects = list;
        this.combine = bl;
        this.index = 0;
        this.progressBar.setMaximum(this.objects.size());
    }

    @Override
    public void doFancyStuff(Object object, StringBuffer stringBuffer) throws IOException {
        Profile profile = (Profile)object;
        this.displayTitle(this.settings.msg("dialog.profileloader.reading", new Object[]{profile.getTitle()}));
        List<NativeCommand> list = null;
        try {
            list = this.dbase.readNativeCommandsList(profile.getId(), -1);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        Conf conf = new Conf(profile, (DosboxVersion)DosboxVersion.findById(this.dbversions, profile.getDbversionId()), this.ps);
        if (conf.getAutoexec().isIncomplete()) {
            throw new IOException(this.settings.msg("dialog.multiprofile.error.profileincomplete"));
        }
        if (this.combine) {
            ExpProfile expProfile = new ExpProfile(profile.getId(), conf, FileUtils.makeRelativeToDosroot(conf.getAutoexec().getCanonicalMainDir()), list, profile);
            if (this.result.isEmpty()) {
                this.multiProfileCombined = expProfile;
                this.targetDBConf = Conf.extractDBVersionConf(this.multiProfileCombined.getConf());
                this.result.add(expProfile);
            } else {
                Conf conf2 = new Conf(expProfile.getConf());
                boolean bl = true;
                if (this.multiProfileCombined.getDbversionId() != expProfile.getDbversionId()) {
                    conf2.alterToDosboxVersionGeneration(this.targetDBConf);
                    bl = false;
                }
                conf2 = new Conf(this.multiProfileCombined.getConf(), conf2, bl);
                this.multiProfileCombined = new ExpProfile(this.multiProfileCombined, expProfile, conf2);
                if (this.bos.size() == 0) {
                    this.result.add(expProfile);
                }
            }
        } else {
            this.result.add(new ExpProfile(this.index++, conf, FileUtils.makeRelativeToDosroot(conf.getAutoexec().getCanonicalMainDir()), list, profile));
        }
    }

    @Override
    public String getTitle(Object object) {
        return ((Profile)object).getTitle();
    }

    @Override
    public void preFinish() {
    }

    public List<ExpProfile> getResult() {
        return this.result;
    }

    public ExpProfile getMultiProfileCombined() {
        return this.multiProfileCombined;
    }
}

