/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public abstract class UIThread
extends Thread
implements ProgressNotifyable {
    protected static final String PREFIX_OK = "  + ";
    protected static final String PREFIX_ERR = "  - ";
    protected final Settings settings = Settings.getInstance();
    protected List<?> objects;
    protected List<DosboxVersion> dbversions;
    protected ProgressBar progressBar;
    protected ByteArrayOutputStream bos;
    protected PrintStream ps;
    protected Database dbase;
    protected boolean extensiveLogging = false;
    private boolean everythingOk = true;
    private Text log;
    private Label status;
    private Display display;

    public UIThread(Text text, ProgressBar progressBar, Label label) throws SQLException {
        this.log = text;
        this.progressBar = progressBar;
        this.status = label;
        this.display = text.getShell().getDisplay();
        this.bos = new ByteArrayOutputStream();
        this.ps = new PrintStream(this.bos);
        this.dbase = Database.getInstance();
        this.dbversions = this.dbase.readDosboxVersionsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        for (Object obj : this.objects) {
            final StringBuffer stringBuffer = new StringBuffer();
            try {
                if (this.extensiveLogging) {
                    stringBuffer.append(this.getTitle(obj)).append(":\n");
                }
                this.dbase.startTransaction();
                this.doFancyStuff(obj, stringBuffer);
                if (this.bos.size() > 0) {
                    if (!this.extensiveLogging) {
                        stringBuffer.append(this.getTitle(obj));
                    }
                    stringBuffer.append(PREFIX_ERR).append(this.bos.toString());
                    this.bos.reset();
                }
                this.dbase.commitTransaction();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.extensiveLogging) {
                    stringBuffer.append(this.getTitle(obj));
                }
                stringBuffer.append(PREFIX_ERR).append(StringRelatedUtils.toString(exception)).append('\n');
                try {
                    this.dbase.rollbackTransaction();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    if (!this.extensiveLogging) {
                        stringBuffer.append(this.getTitle(obj));
                    }
                    stringBuffer.append(PREFIX_ERR).append(StringRelatedUtils.toString(sQLException)).append('\n');
                }
                this.everythingOk = false;
            }
            finally {
                this.dbase.finishTransaction();
            }
            if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed() || this.status.isDisposed()) break;
            this.display.syncExec(new Runnable(){

                public void run() {
                    if (stringBuffer.length() > 0) {
                        String string = stringBuffer.toString();
                        UIThread.this.log.append(string);
                        System.out.print(string);
                    }
                    UIThread.this.incrProgress(1);
                }
            });
        }
        try {
            this.preFinish();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.completeProgress();
    }

    public void displayTitle(final String string) {
        if (!this.display.isDisposed() && !this.status.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.status.setText(string);
                    UIThread.this.status.pack();
                }
            });
        }
    }

    public void setTotal(final int n) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.progressBar.setMaximum(n + UIThread.this.objects.size());
                }
            });
        }
    }

    public void incrProgress(final int n) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.progressBar.setSelection(UIThread.this.progressBar.getSelection() + n);
                }
            });
        }
    }

    public void setProgress(final int n) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.progressBar.setSelection(n);
                }
            });
        }
    }

    private void completeProgress() {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    UIThread.this.progressBar.setSelection(UIThread.this.progressBar.getMaximum());
                }
            });
        }
    }

    public boolean isEverythingOk() {
        return this.everythingOk;
    }

    public abstract String getTitle(Object var1);

    public abstract void doFancyStuff(Object var1, StringBuffer var2) throws IOException, SQLException;

    public abstract void preFinish() throws IOException;
}

