/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.graphics.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PouetSearchEngine
extends WebSearchEngine {
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<span class='typeiconlist'>";
    private static final String HTML_NEXT_RESULT_MARKER_START = "<span class='typeiconlist'>";
    private static final String HTML_GAME_END_MARKER = "</div></td></tr>";
    private static final String HTML_PLATFORM_MARKER = "<span class='platformi ";
    private static final String HOST_NAME = "www.pouet.net";

    private PouetSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "pouet.png";
    }

    @Override
    public String getName() {
        return "Pou\u00ebt.net";
    }

    @Override
    public String getSimpleName() {
        return "pouet";
    }

    @Override
    public List<WebProfile> getEntries(String string, String[] stringArray) throws IOException {
        int n = 1;
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        for (int i = 0; i < n; ++i) {
            String string2 = PouetSearchEngine.getResponseContent("http://www.pouet.net/search.php?type=prod&what=" + URLEncoder.encode(string.replaceAll("/", " "), "UTF-8") + "&page=" + (i + 1), "UTF-8");
            if (i == 0) {
                n = PouetSearchEngine.getPages(string2);
            }
            if (n > 0) {
                arrayList.addAll(PouetSearchEngine.extractEntries(string2));
                continue;
            }
            if (string2.indexOf("<div id='prodpagecontainer'>") == -1) continue;
            arrayList.addAll(this.extractSingleEntry(string2));
        }
        return PouetSearchEngine.filterEntries(stringArray, arrayList);
    }

    private static int getPages(String string) {
        int n = string.indexOf("<select name='page'>");
        if (n != -1) {
            int n2 = string.indexOf("</select>", n);
            String string2 = string.substring(n, n2);
            int n3 = 0;
            n = 0;
            while ((n = string2.indexOf("<option", n + 7)) != -1) {
                ++n3;
            }
            return n3;
        }
        return 0;
    }

    private static List<WebProfile> extractEntries(String string) {
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        int n = (string = string.replaceAll("\\\\\"", "\"")).indexOf("<span class='typeiconlist'>");
        if (n != -1) {
            n += "<span class='typeiconlist'>".length();
        }
        while (n != -1) {
            String string2;
            String string3 = StringUtils.capitalize((String)PouetSearchEngine.extractNextContent(string, n, "<span ", "</span>"));
            int n2 = string.indexOf("<span class='platformiconlist'>", n);
            int n3 = string.indexOf("<span class='prod'>", n);
            String string4 = PouetSearchEngine.extractNextContent(string, n3, "<a ", "</a>");
            String string5 = StringUtils.capitalize((String)PouetSearchEngine.unescapeHtml(PouetSearchEngine.removeAllTags(string4)));
            String string6 = PouetSearchEngine.extractNextHrefContentSingleQuotes(string, n3);
            string6 = PouetSearchEngine.absoluteUrl(HOST_NAME, string6);
            n = string.indexOf("<td>", n);
            String string7 = PouetSearchEngine.extractNextContent(string, n + "<td>".length(), "<a ", "</a>");
            string7 = StringUtils.capitalize((String)string7);
            String string8 = StringUtils.right((String)PouetSearchEngine.extractNextContent(string, n, "<td class='date'>", "</td>"), (int)4);
            int n4 = 0;
            try {
                string2 = PouetSearchEngine.extractNextContent(string, n, "<td class='votes'>", "&nbsp;<img");
                n4 = (int)((Double.parseDouble(string2) + 1.0) * 50.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = string.substring(n2, n3);
            int n5 = string2.indexOf(HTML_PLATFORM_MARKER);
            while (n5 != -1) {
                String string9 = PouetSearchEngine.extractNextContent(string2, n5, "<span ", "</span>");
                WebProfile webProfile = new WebProfile();
                webProfile.setTitle(string5);
                webProfile.setUrl(string6);
                webProfile.setPlatform(string9);
                webProfile.setPublisherName("");
                webProfile.setDeveloperName(string7);
                webProfile.setYear(string8);
                webProfile.setGenre(string3);
                webProfile.setRank(n4);
                webProfile.setNotes("");
                arrayList.add(webProfile);
                n5 = string2.indexOf(HTML_PLATFORM_MARKER, n5 + 1);
            }
            int n6 = string.indexOf(HTML_GAME_END_MARKER, n3);
            n = string.indexOf("<span class='typeiconlist'>", n6 + HTML_GAME_END_MARKER.length());
            if (n == -1) continue;
            n += "<span class='typeiconlist'>".length();
        }
        return arrayList;
    }

    private List<WebProfile> extractSingleEntry(String string) {
        String string2;
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        int n = string.indexOf("<link rel=\"canonical\"");
        String string3 = PouetSearchEngine.extractNextHrefContent(string, n);
        int n2 = string.indexOf("<span id='title'>", n);
        String string4 = PouetSearchEngine.extractNextContent(string, n2, "<big>", "</big>");
        String string5 = StringUtils.capitalize((String)PouetSearchEngine.unescapeHtml(PouetSearchEngine.removeAllTags(string4)));
        String string6 = string.indexOf("</big> by ", n2) != -1 ? StringUtils.capitalize((String)PouetSearchEngine.extractNextContent(string, n2, "<a ", "</a>")) : "";
        int n3 = string.indexOf("<td>platform :</td>", n2);
        int n4 = string.indexOf("<td>type :</td>", n3);
        String string7 = StringUtils.capitalize((String)PouetSearchEngine.extractNextContent(string, n4, "<span ", "</span>"));
        int n5 = string.indexOf("<td>release date :</td>", n4);
        String string8 = PouetSearchEngine.extractNextContent(string, n5 + 24, "<td>", "</td>");
        String string9 = !string8.contains("n/a") ? StringUtils.right((String)string8, (int)4) : "";
        int n6 = string.indexOf("<div id='alltimerank'>", n5);
        int n7 = string.lastIndexOf("&nbsp;", n6);
        int n8 = 0;
        try {
            string2 = string.substring(n7 + 6, n6);
            int n9 = string2.indexOf("</li>");
            if (n9 != -1) {
                string2 = string2.substring(0, n9);
            }
            n8 = (int)((Double.parseDouble(string2) + 1.0) * 50.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = string.substring(n3, n4);
        n3 = string2.indexOf("<span class='platform ");
        while (n3 != -1) {
            String string10 = PouetSearchEngine.extractNextContent(string2, n3, "<span ", "</span>");
            WebProfile webProfile = new WebProfile();
            webProfile.setTitle(string5);
            webProfile.setUrl(string3);
            webProfile.setPlatform(string10);
            webProfile.setPublisherName("");
            webProfile.setDeveloperName(string6);
            webProfile.setYear(string9);
            webProfile.setGenre(string7);
            webProfile.setRank(n8);
            webProfile.setNotes("");
            arrayList.add(webProfile);
            n3 = string2.indexOf("<span class='platform ", n3 + 1);
        }
        return arrayList;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile webProfile) throws UnknownHostException, IOException {
        return webProfile;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile webProfile, int n, int n2, boolean bl) throws IOException {
        String string = PouetSearchEngine.getResponseContent(webProfile.getUrl(), "ISO-8859-1");
        int n3 = string.indexOf("<td rowspan='3' id='screenshot'><img src=");
        if (n3 == -1) {
            webProfile.setWebImages(new SearchEngineImageInformation[0]);
        } else {
            String string2 = PouetSearchEngine.absoluteUrl(HOST_NAME, PouetSearchEngine.extractNextSrcContentSingleQuotes(string, n3));
            String string3 = this.getSimpleName();
            if (string2.toLowerCase().endsWith(".gif")) {
                ImageData[] imageDataArray = SWTImageManager.getAnimatedImageData(string2);
                int n4 = Math.min(imageDataArray.length, Math.max(n2, 0));
                SearchEngineImageInformation[] searchEngineImageInformationArray = new SearchEngineImageInformation[n4];
                for (int i = 0; i < n4; ++i) {
                    searchEngineImageInformationArray[i] = new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, string2, string3);
                    searchEngineImageInformationArray[i].setData(imageDataArray[i]);
                }
                webProfile.setWebImages(searchEngineImageInformationArray);
            } else {
                webProfile.setWebImages(new SearchEngineImageInformation[]{new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, string2, string3)});
            }
        }
        return webProfile.getWebImages();
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new PouetSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

